/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.db;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.flyway.action.generation.ed.MyDiffGeneratorHandler;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.liquibase.common.DiffGeneratorErrorDialog;
import com.intellij.liquibase.common.LiquibaseIntellijDiffGenerationHandler;
import com.intellij.liquibase.common.gui.DiffScope;
import com.intellij.liquibase.common.gui.GenerateDdlFromConsoleDialog;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.common.util.NotificationUtilsKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/flyway/db/HibernateValidationFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "AttachInlayResult", "intellij.flyway"})
public final class HibernateValidationFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex regex = new Regex("Caused by: org\\.hibernate\\.tool\\.schema\\.spi\\.SchemaManagementException(.*)\n");

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (regex.matches((CharSequence)line)) {
            MatchResult matchResult = regex.matchEntire((CharSequence)line);
            Intrinsics.checkNotNull((Object)matchResult);
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            IntRange range = matchGroup.getRange();
            int start = entireLength - line.length();
            Object[] objectArray = new Filter.ResultItem[]{new AttachInlayResult(start, start + line.length() - 1), new Filter.ResultItem(start + range.getFirst() + 1, start + range.getLast() + 1, arg_0 -> HibernateValidationFilter.applyFilter$lambda$0(this, arg_0))};
            return new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
        }
        return null;
    }

    public final void invoke(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GenerateDdlFromConsoleDialog creationDialog = new GenerateDdlFromConsoleDialog(project);
        if (creationDialog.showAndGet()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            DbProperties dbProperties = creationDialog.getTargetDbProperties();
            if (dbProperties == null) {
                return;
            }
            DbProperties dbProperties2 = dbProperties;
            try {
                MyDiffGeneratorHandler diffGenerator = new MyDiffGeneratorHandler(null, project, dbProperties2, null, null, 24, null);
                OrmUnit ormUnit = creationDialog.getPersistenceUnit();
                String persistenceUnitName = ormUnit != null ? ormUnit.getName() : null;
                DiffScope diffScope = creationDialog.getDiffScope();
                diffGenerator.setPersistenceUnitName(persistenceUnitName);
                diffGenerator.diffAndShow(() -> HibernateValidationFilter.invoke$lambda$0(project, dbProperties2, persistenceUnitName, diffScope));
            }
            catch (CancellationException e) {
                NotificationUtilsKt.showDiffGenerationGroupNotification((Project)project, (String)LiquibaseResourceBundle.message((String)"generating.diff.canceled", (Object[])new Object[0]), (NotificationType)NotificationType.WARNING);
            }
            catch (Exception e) {
                DiffGeneratorErrorDialog.Companion.show$default((DiffGeneratorErrorDialog.Companion)DiffGeneratorErrorDialog.Companion, (Project)project, (Exception)e, (DbType)dbProperties2.getType(), null, (int)8, null);
            }
        }
    }

    private static final void applyFilter$lambda$0(HibernateValidationFilter this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this$0.invoke(project);
    }

    private static final XmlTag invoke$lambda$0(Project $project, DbProperties $dbProperties, String $persistenceUnitName, DiffScope $diffScope) {
        return new LiquibaseIntellijDiffGenerationHandler($project, $dbProperties, $persistenceUnitName, (OrmFramework)JpaOrmFramework.INSTANCE, $diffScope, new String[0], false, 64, null).run();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/flyway/db/HibernateValidationFilter$AttachInlayResult;", "Lcom/intellij/execution/filters/Filter$ResultItem;", "Lcom/intellij/execution/impl/InlayProvider;", "start", "", "end", "<init>", "(Lcom/intellij/flyway/db/HibernateValidationFilter;II)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.flyway"})
    public final class AttachInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        public AttachInlayResult(int start, int end) {
            super(start, end, null);
        }

        @NotNull
        public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditorImpl editorImpl = (EditorImpl)editor;
            PresentationFactory factory = new PresentationFactory((Editor)editorImpl);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText("Generate DDL")), (arg_0, arg_1) -> AttachInlayResult.createInlayRenderer$lambda$0(editorImpl, HibernateValidationFilter.this, arg_0, arg_1));
            return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
        }

        private static final void createInlayRenderer$lambda$0(EditorImpl $editorImpl, HibernateValidationFilter this$0, MouseEvent mouseEvent, Point point) {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
            Project project = $editorImpl.getProject();
            if (project != null) {
                this$0.invoke(project);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/flyway/db/HibernateValidationFilter$Companion;", "", "<init>", "()V", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "intellij.flyway"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getRegex() {
            return regex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

