/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlImplicitSymbol;
import com.intellij.sql.psi.impl.SqlImplicitTargetBase;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlColumnSymbol
extends SqlImplicitTargetBase
implements SqlImplicitSymbol {
    private final boolean myQuoted;
    private final int myIndex;
    @Nullable
    private final PsiElement myTargetDefinition;
    @Nullable
    private final PsiElement myQualifier;

    protected SqlColumnSymbol(@NotNull String name, boolean quoted, @NotNull PsiElement context, int index, @Nullable PsiElement targetDefinition, @Nullable PsiElement qualifier) {
        if (name == null) {
            SqlColumnSymbol.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlColumnSymbol.$$$reportNull$$$0(1);
        }
        super(context, name);
        this.myQuoted = quoted;
        this.myIndex = index;
        this.myTargetDefinition = targetDefinition;
        this.myQualifier = qualifier;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            SqlColumnSymbol.$$$reportNull$$$0(2);
        }
        return objectKind;
    }

    @Override
    public boolean isQuoted() {
        return this.myQuoted;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    public PsiElement getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public PsiElement getTargetDefinition() {
        return this.myTargetDefinition;
    }

    @NotNull
    public abstract DasType getType();

    @NotNull
    public Casing getCasing(CasingProvider casingProvider) {
        Casing casing = casingProvider.getCasing(ObjectKind.COLUMN, null);
        if (casing == null) {
            SqlColumnSymbol.$$$reportNull$$$0(3);
        }
        return casing;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)this.myTargetDefinition, (Object)this.getContextElement());
        if (psiElement == null) {
            SqlColumnSymbol.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlColumnSymbol symbol = (SqlColumnSymbol)((Object)o);
        return Objects.equals(this.getName(), symbol.getName()) && Objects.equals(this.myTargetDefinition, symbol.myTargetDefinition) && Objects.equals(this.myQualifier, symbol.myQualifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.myTargetDefinition, this.myQualifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlColumnSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlColumnSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

