/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 59305709688346L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(801230910 + (char)-29144, 801230910 + 26558, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(801230910 + (char)-29143, 801230910 + 19865, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 9871731713393L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.t();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1896845040 + 24095, 1896845040 + 25214, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1896845040 + 24094, 1896845040 + 22579, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1896845040 + 24089, 1896845040 + 25301, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 9291339723818L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.t();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19285, 1325510910 - (char)-7256, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19282, 1325379840 + (char)-2477, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19283, -1325510910 - -((char)-12067), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19296, 1325510910 - (char)-11356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19297, -1325379840 + -((char)-11112), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19294, -1325510910 - -((char)-11565), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19296, 1325510910 - (char)-11356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1325510910 - (char)-19295, -1325379840 + -((char)-12536), (int)l2));
            if (ActionTimestamp.t() != 0) {
                SshAgentIpcService.t(new String[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 84347780249681L;
                    stringArray = SshAgentIpcService.t();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 55928132151738L;
                String[] stringArray2 = SshAgentIpcService.t();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5572), -931907700 + -((char)-5825), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5571), 931907700 + (char)-13482, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5574), 931907700 + (char)-17136, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5572), -931907700 + -((char)-5825), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5573), -932038770 - -((char)-14157), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5572), -931907700 + -((char)-5825), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5560), -931907700 + -((char)-8137), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5559), 931907700 + (char)-14718, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5574), 931907700 + (char)-17136, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5572), -931907700 + -((char)-5825), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5568), -932038770 - -((char)-14020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-932038770 - -((char)-5562), 932038770 - (char)-11901, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 118502265143189L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-177468780 + -((char)-10318), 177468780 + (char)-12131, (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 113604284216332L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1895665410 + -((char)-2172), -1895796480 - -((char)-2464), (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "V\u00faq\u00c3@\u0097\u00bc\u008a\u00ce\u00b0\u008e\u0010s\u00c4y\u00a7C-3\u0014\u00c5\u009d\u0003)\u0015\bk\u00fc\u00b6xD\u00dd\u00e8\u0084\u00cb$\u00f8\u009bCN";
                    var4_3 = "V\u00faq\u00c3@\u0097\u00bc\u008a\u00ce\u00b0\u008e\u0010s\u00c4y\u00a7C-3\u0014\u00c5\u009d\u0003)\u0015\bk\u00fc\u00b6xD\u00dd\u00e8\u0084\u00cb$\u00f8\u009bCN".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 16;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 65;
                                    break;
                                }
                                case 1: {
                                    v11 = 73;
                                    break;
                                }
                                case 2: {
                                    v11 = 85;
                                    break;
                                }
                                case 3: {
                                    v11 = 39;
                                    break;
                                }
                                case 4: {
                                    v11 = 33;
                                    break;
                                }
                                case 5: {
                                    v11 = 9;
                                    break;
                                }
                                default: {
                                    v11 = 84;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xD77) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 238;
                        case 1 -> 62;
                        case 2 -> 220;
                        case 3 -> 77;
                        case 4 -> 131;
                        case 5 -> 150;
                        case 6 -> 231;
                        case 7 -> 51;
                        case 8 -> 181;
                        case 9 -> 134;
                        case 10 -> 50;
                        case 11 -> 99;
                        case 12 -> 107;
                        case 13 -> 253;
                        case 14 -> 196;
                        case 15 -> 193;
                        case 16 -> 246;
                        case 17 -> 49;
                        case 18 -> 200;
                        case 19 -> 52;
                        case 20 -> 215;
                        case 21 -> 173;
                        case 22 -> 67;
                        case 23 -> 248;
                        case 24 -> 234;
                        case 25 -> 96;
                        case 26 -> 235;
                        case 27 -> 161;
                        case 28 -> 93;
                        case 29 -> 236;
                        case 30 -> 221;
                        case 31 -> 35;
                        case 32 -> 237;
                        case 33 -> 121;
                        case 34 -> 156;
                        case 35 -> 47;
                        case 36 -> 233;
                        case 37 -> 192;
                        case 38 -> 240;
                        case 39 -> 147;
                        case 40 -> 164;
                        case 41 -> 101;
                        case 42 -> 16;
                        case 43 -> 14;
                        case 44 -> 136;
                        case 45 -> 3;
                        case 46 -> 102;
                        case 47 -> 112;
                        case 48 -> 158;
                        case 49 -> 178;
                        case 50 -> 222;
                        case 51 -> 251;
                        case 52 -> 141;
                        case 53 -> 124;
                        case 54 -> 0;
                        case 55 -> 128;
                        case 56 -> 69;
                        case 57 -> 174;
                        case 58 -> 122;
                        case 59 -> 133;
                        case 60 -> 175;
                        case 61 -> 138;
                        case 62 -> 153;
                        case 63 -> 155;
                        case 64 -> 252;
                        case 65 -> 207;
                        case 66 -> 146;
                        case 67 -> 9;
                        case 68 -> 205;
                        case 69 -> 29;
                        case 70 -> 56;
                        case 71 -> 170;
                        case 72 -> 64;
                        case 73 -> 25;
                        case 74 -> 157;
                        case 75 -> 177;
                        case 76 -> 167;
                        case 77 -> 58;
                        case 78 -> 224;
                        case 79 -> 162;
                        case 80 -> 33;
                        case 81 -> 183;
                        case 82 -> 85;
                        case 83 -> 60;
                        case 84 -> 165;
                        case 85 -> 83;
                        case 86 -> 195;
                        case 87 -> 243;
                        case 88 -> 230;
                        case 89 -> 54;
                        case 90 -> 80;
                        case 91 -> 92;
                        case 92 -> 229;
                        case 93 -> 15;
                        case 94 -> 126;
                        case 95 -> 117;
                        case 96 -> 247;
                        case 97 -> 223;
                        case 98 -> 82;
                        case 99 -> 139;
                        case 100 -> 154;
                        case 101 -> 11;
                        case 102 -> 197;
                        case 103 -> 19;
                        case 104 -> 216;
                        case 105 -> 68;
                        case 106 -> 159;
                        case 107 -> 72;
                        case 108 -> 20;
                        case 109 -> 79;
                        case 110 -> 209;
                        case 111 -> 6;
                        case 112 -> 8;
                        case 113 -> 39;
                        case 114 -> 118;
                        case 115 -> 38;
                        case 116 -> 188;
                        case 117 -> 109;
                        case 118 -> 130;
                        case 119 -> 43;
                        case 120 -> 163;
                        case 121 -> 194;
                        case 122 -> 73;
                        case 123 -> 144;
                        case 124 -> 28;
                        case 125 -> 55;
                        case 126 -> 104;
                        case 127 -> 160;
                        case 128 -> 217;
                        case 129 -> 119;
                        case 130 -> 81;
                        case 131 -> 103;
                        case 132 -> 184;
                        case 133 -> 71;
                        case 134 -> 42;
                        case 135 -> 91;
                        case 136 -> 4;
                        case 137 -> 186;
                        case 138 -> 27;
                        case 139 -> 2;
                        case 140 -> 187;
                        case 141 -> 208;
                        case 142 -> 84;
                        case 143 -> 88;
                        case 144 -> 250;
                        case 145 -> 115;
                        case 146 -> 100;
                        case 147 -> 116;
                        case 148 -> 114;
                        case 149 -> 30;
                        case 150 -> 57;
                        case 151 -> 218;
                        case 152 -> 232;
                        case 153 -> 143;
                        case 154 -> 148;
                        case 155 -> 191;
                        case 156 -> 41;
                        case 157 -> 74;
                        case 158 -> 108;
                        case 159 -> 239;
                        case 160 -> 23;
                        case 161 -> 137;
                        case 162 -> 106;
                        case 163 -> 7;
                        case 164 -> 111;
                        case 165 -> 105;
                        case 166 -> 166;
                        case 167 -> 22;
                        case 168 -> 213;
                        case 169 -> 98;
                        case 170 -> 185;
                        case 171 -> 212;
                        case 172 -> 61;
                        case 173 -> 66;
                        case 174 -> 214;
                        case 175 -> 210;
                        case 176 -> 110;
                        case 177 -> 63;
                        case 178 -> 241;
                        case 179 -> 227;
                        case 180 -> 206;
                        case 181 -> 168;
                        case 182 -> 182;
                        case 183 -> 32;
                        case 184 -> 225;
                        case 185 -> 34;
                        case 186 -> 127;
                        case 187 -> 244;
                        case 188 -> 171;
                        case 189 -> 254;
                        case 190 -> 95;
                        case 191 -> 169;
                        case 192 -> 5;
                        case 193 -> 87;
                        case 194 -> 135;
                        case 195 -> 255;
                        case 196 -> 152;
                        case 197 -> 149;
                        case 198 -> 180;
                        case 199 -> 40;
                        case 200 -> 97;
                        case 201 -> 78;
                        case 202 -> 172;
                        case 203 -> 132;
                        case 204 -> 123;
                        case 205 -> 242;
                        case 206 -> 120;
                        case 207 -> 190;
                        case 208 -> 129;
                        case 209 -> 201;
                        case 210 -> 228;
                        case 211 -> 203;
                        case 212 -> 44;
                        case 213 -> 86;
                        case 214 -> 12;
                        case 215 -> 24;
                        case 216 -> 45;
                        case 217 -> 59;
                        case 218 -> 13;
                        case 219 -> 21;
                        case 220 -> 76;
                        case 221 -> 198;
                        case 222 -> 199;
                        case 223 -> 37;
                        case 224 -> 53;
                        case 225 -> 65;
                        case 226 -> 125;
                        case 227 -> 1;
                        case 228 -> 140;
                        case 229 -> 202;
                        case 230 -> 219;
                        case 231 -> 189;
                        case 232 -> 36;
                        case 233 -> 31;
                        case 234 -> 90;
                        case 235 -> 70;
                        case 236 -> 204;
                        case 237 -> 176;
                        case 238 -> 142;
                        case 239 -> 10;
                        case 240 -> 94;
                        case 241 -> 245;
                        case 242 -> 226;
                        case 243 -> 46;
                        case 244 -> 179;
                        case 245 -> 211;
                        case 246 -> 48;
                        case 247 -> 145;
                        case 248 -> 26;
                        case 249 -> 113;
                        case 250 -> 249;
                        case 251 -> 151;
                        case 252 -> 89;
                        case 253 -> 75;
                        case 254 -> 17;
                        default -> 18;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (stringArray == null) {
            int n3 = ActionTimestamp.t();
            ActionTimestamp.t(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 97960388748102L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.t();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(774623700 + (char)-26270, 774623700 + 13021, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(774623700 + (char)-26274, 774623700 + 30818, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(774623700 + (char)-26283, 774623700 + 21410, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(774623700 + (char)-26270, 774623700 + 13021, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(774623700 + (char)-26274, 774623700 + 30818, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(774623700 + (char)-26278, -774623700 + -((char)-21081), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 2230858244585L;
                        String[] stringArray2 = SshAgentIpcService.t();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1770231420 - 11516, 1770231420 - 6780, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1770231420 - 11513, -1770231420 - -29458, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 113142951328447L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    stringArray = SshAgentIpcService.t();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(627825300 + 22587, 627825300 + (char)-32076, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(627825300 + 22583, 627825300 + 14651, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(627825300 + 22592, 627825300 + 17474, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(627825300 + 22583, 627825300 + 14651, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(627825300 + 22585, -627825300 + -((char)-28949), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(627825300 + 22587, 627825300 + (char)-32076, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(627825300 + 22583, 627825300 + 14651, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(627825300 + 22599, -627825300 + -28265, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(627825300 + 22587, 627825300 + (char)-32076, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(627825300 + 22583, 627825300 + 14651, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(627825300 + 22598, -627825300 + -14563, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(627825300 + 22587, 627825300 + (char)-32076, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(627825300 + 22583, 627825300 + 14651, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(627825300 + 22597, 627825300 + (char)-25504, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 3056924344117L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.t();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30249), -1092337380 + -26714, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30245), -1092337380 + -((char)-21801), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30262), -1092337380 + -((char)-17881), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30265), -1092337380 + -((char)-20128), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30249), -1092337380 + -26714, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30245), -1092337380 + -((char)-21801), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30264), -1092337380 + -((char)-16306), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30249), -1092337380 + -26714, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30245), -1092337380 + -((char)-21801), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30267), -1092337380 + -((char)-27950), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30249), -1092337380 + -26714, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30245), -1092337380 + -((char)-21801), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30266), -1092337380 + -21522, (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30249), -1092337380 + -26714, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30245), -1092337380 + -((char)-21801), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30285), 1092337380 + (char)-26359, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1092337380 + -((char)-30284), -1092337380 + -((char)-19342), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00864=\u00b6+kA}\u0014\u0085&e\u0013\u00deWP\u00e0\u001a\n]\u00ceuZ\u0001d6MX<\u0006\u0011#\u00cfT\u001fv\u0018\u00f4u+I\u0095\u00d9;\u00f1\u00bfU\u00e6Ud\u00d6qw\u0091F\u0082\u00c0\u00e7G\u00f6\u00ff\t#\u00a9Ocr\u0003\u00df\u00e2\u001f\u0005g\u0015\u0001\u0092\u00dc\b\u009d\u00cb^8\u0015\u009c\u0080a\u0014?\u00d2J\u0016V\u00fftb\u00f0\u0087\u00ab\u00cb\u00e1Y(\u00e9\u0001/G2\u0005\u00c8\u00b0\u00f4&b\u001ed\u0014t\u00d6\u00ef\u00ee\u00d6m\u00a7\u00d2\u00ae\"!\u0018{\u00ca1`D\u00f0\u0093nt\u0017\u00c7\u00c8r@5#\u0010\u009e`\u00cf\u009d\u00cf\u00b5$\u00ff\u00842G\u00c3\u001aq\u00b3x\tN\u00bd4\u00f0NV~\u00d7\u00c5\u0010$\u0090\u0098\u0083%vy\u0087/=2\"\u00b4Mf\u00ff?m\u000b]5\u00c7\u009bV\u00af\u00c6[\u00c7\u00e8\u00b3\u00b7\u0014\u0006\u0019\u009c<\u00aa\u0012w?R\u00be\u0088P\u00fcF\u00e2\u00ac\u001b\u0095)\u00f0p\u0018\u0006aA\u00b6\u0089)\u00e0\u00a7.\u009a\u0007\u00fbN\u00ac\u0004\u00ee]u\u00f1A2\u009b+_X&\bw\u00d9\u0003z\u00be\u00d4\u00f5h\fQ;\u00d7=9^\u00eb>TB\u000f\u00c9F\u0097\u0018\u000fY\"\u00d2\u0088\u00af8|\u0088\u00ca\u00cc\u00fb\u00e4\u00a9\u00fb\u000e`W\u008b\u009a\u000f\u00dd\u008eR\u00a5\u00acG\u00c1\u00b6C\u00ea\u0094\u00dd\u00e6g\u0099%v\u00adz\u00c1ed\u001b\u00b6\u00dc\u0099\u00cd\u0086\u00deD\u00906S\u00b6\u0012\u00f3\u0093a&\u00bd\u001b\u000b$\u00e9\u00a7\u0002\u00df\u001f\u009fL\u000b\u00dd\u0000\u008f+A\u0018WY\u0092\u00df\u0013\u00af\u001a\u00d0\u0092\u0005dp|\u00df\u00fe\u00d3%\u00e71\u009a\u00fc\u000f\u000b\u0011\u00a7\u00df\u00ae8,\u00cbpP\u0087\u0085\u0015\u00da\u00cc\u00a6\u00c0\u0010\u0089\"\u00b9S^-x\u00ef\u00e2\u00b4rH\u000b\u00cb.\u009f)\u00baf\u00af\u0098\u0094'\u00b9TJ\u00f5\u0013\u00c6\u0092\u0093\u0098\u000fi\u00b8\u00e9\u0086\u001dX\u00b4b\u00d1\u00ffp\u0012Gl6\u00c8\u0004@f\u00f1\u000ef\u0083 \u00da\u0007\u0000h\u00f2C\u001b\u0001\u00d3\u0007g\u0083zR\u00ed\u00cc\u001b(|\u00ee;\u00a8\u00b6K\u000b\u00felw\u00fd\u00a0l\u00de\u0005%\u00ddP\u00d1\u00d8{\u00ad\u0017\u00175\u00edZ+5+\u00a39M\u0015\u00d1\u00f6B\u00fb\u0099`\u000f/B\u001f\u0014\u00da\u00b0#B\u001cmR\u00b29\u00c81\"g\u00bb\u0014#\u00e3PW\u00ba\u0097(\u00a8}\u00e6\u00e8r\u00ae\u00df\u00a5\u00b5g|d8\u00b5\u00d3Q\u00fd\u0019\u00d2?&\u00a5(\u001e\u000e\u0015(XY2\u0019>w\u00bf\u00cb&f\u00bbX\u001b\u00f6U#\u00f3\u00a6\u00f997\bD]\u0096\u0084p\u0018\u00ab:\u00af\u00b4\u00bag\u00eb(\u00e2\u009a\u00d6\u0081\n\u0082\u0001i~\u00fb\u00acA\u00b7\u00ac6\u0018\u0091a\u00cfx:4\u008b\u00d0@q\u0096\u00afD\u0004\u00fc\u0004\u00d1[\u001e]J\\\u00d6G)\u00b1\u00ff\u00ce\u00ab\u00b8A<\u0098\u00fal\u0005\u00f5T\u00fc\u00df\u0099\u00ff\u001f\u00e4\u00b7\u0086n\u008e\u00a8\u00e34\u00ab\u0087o\u0082\u0088\u0084\u00f6\u0017\u00ed\u008f\u00a1\u008dv]d\t\"\u0003\u00b99\u00f5\u00a0_R\\";
                var4_3 = "\u00864=\u00b6+kA}\u0014\u0085&e\u0013\u00deWP\u00e0\u001a\n]\u00ceuZ\u0001d6MX<\u0006\u0011#\u00cfT\u001fv\u0018\u00f4u+I\u0095\u00d9;\u00f1\u00bfU\u00e6Ud\u00d6qw\u0091F\u0082\u00c0\u00e7G\u00f6\u00ff\t#\u00a9Ocr\u0003\u00df\u00e2\u001f\u0005g\u0015\u0001\u0092\u00dc\b\u009d\u00cb^8\u0015\u009c\u0080a\u0014?\u00d2J\u0016V\u00fftb\u00f0\u0087\u00ab\u00cb\u00e1Y(\u00e9\u0001/G2\u0005\u00c8\u00b0\u00f4&b\u001ed\u0014t\u00d6\u00ef\u00ee\u00d6m\u00a7\u00d2\u00ae\"!\u0018{\u00ca1`D\u00f0\u0093nt\u0017\u00c7\u00c8r@5#\u0010\u009e`\u00cf\u009d\u00cf\u00b5$\u00ff\u00842G\u00c3\u001aq\u00b3x\tN\u00bd4\u00f0NV~\u00d7\u00c5\u0010$\u0090\u0098\u0083%vy\u0087/=2\"\u00b4Mf\u00ff?m\u000b]5\u00c7\u009bV\u00af\u00c6[\u00c7\u00e8\u00b3\u00b7\u0014\u0006\u0019\u009c<\u00aa\u0012w?R\u00be\u0088P\u00fcF\u00e2\u00ac\u001b\u0095)\u00f0p\u0018\u0006aA\u00b6\u0089)\u00e0\u00a7.\u009a\u0007\u00fbN\u00ac\u0004\u00ee]u\u00f1A2\u009b+_X&\bw\u00d9\u0003z\u00be\u00d4\u00f5h\fQ;\u00d7=9^\u00eb>TB\u000f\u00c9F\u0097\u0018\u000fY\"\u00d2\u0088\u00af8|\u0088\u00ca\u00cc\u00fb\u00e4\u00a9\u00fb\u000e`W\u008b\u009a\u000f\u00dd\u008eR\u00a5\u00acG\u00c1\u00b6C\u00ea\u0094\u00dd\u00e6g\u0099%v\u00adz\u00c1ed\u001b\u00b6\u00dc\u0099\u00cd\u0086\u00deD\u00906S\u00b6\u0012\u00f3\u0093a&\u00bd\u001b\u000b$\u00e9\u00a7\u0002\u00df\u001f\u009fL\u000b\u00dd\u0000\u008f+A\u0018WY\u0092\u00df\u0013\u00af\u001a\u00d0\u0092\u0005dp|\u00df\u00fe\u00d3%\u00e71\u009a\u00fc\u000f\u000b\u0011\u00a7\u00df\u00ae8,\u00cbpP\u0087\u0085\u0015\u00da\u00cc\u00a6\u00c0\u0010\u0089\"\u00b9S^-x\u00ef\u00e2\u00b4rH\u000b\u00cb.\u009f)\u00baf\u00af\u0098\u0094'\u00b9TJ\u00f5\u0013\u00c6\u0092\u0093\u0098\u000fi\u00b8\u00e9\u0086\u001dX\u00b4b\u00d1\u00ffp\u0012Gl6\u00c8\u0004@f\u00f1\u000ef\u0083 \u00da\u0007\u0000h\u00f2C\u001b\u0001\u00d3\u0007g\u0083zR\u00ed\u00cc\u001b(|\u00ee;\u00a8\u00b6K\u000b\u00felw\u00fd\u00a0l\u00de\u0005%\u00ddP\u00d1\u00d8{\u00ad\u0017\u00175\u00edZ+5+\u00a39M\u0015\u00d1\u00f6B\u00fb\u0099`\u000f/B\u001f\u0014\u00da\u00b0#B\u001cmR\u00b29\u00c81\"g\u00bb\u0014#\u00e3PW\u00ba\u0097(\u00a8}\u00e6\u00e8r\u00ae\u00df\u00a5\u00b5g|d8\u00b5\u00d3Q\u00fd\u0019\u00d2?&\u00a5(\u001e\u000e\u0015(XY2\u0019>w\u00bf\u00cb&f\u00bbX\u001b\u00f6U#\u00f3\u00a6\u00f997\bD]\u0096\u0084p\u0018\u00ab:\u00af\u00b4\u00bag\u00eb(\u00e2\u009a\u00d6\u0081\n\u0082\u0001i~\u00fb\u00acA\u00b7\u00ac6\u0018\u0091a\u00cfx:4\u008b\u00d0@q\u0096\u00afD\u0004\u00fc\u0004\u00d1[\u001e]J\\\u00d6G)\u00b1\u00ff\u00ce\u00ab\u00b8A<\u0098\u00fal\u0005\u00f5T\u00fc\u00df\u0099\u00ff\u001f\u00e4\u00b7\u0086n\u008e\u00a8\u00e34\u00ab\u0087o\u0082\u0088\u0084\u00f6\u0017\u00ed\u008f\u00a1\u008dv]d\t\"\u0003\u00b99\u00f5\u00a0_R\\".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 17;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "BNm@\u0011\u00e1\u00d4Q:\u0088\u00c0\u00b41\t\u00ae\u00fa\f\u00a2\u0017YpQ~L\u008bi\u00ea\u00b4\n\u0014\u00b7:\u00feMpAX\u00ff\u00c64\u001b\u00d4`\u00c4~j\u0004Q\u00c3b";
                    var4_3 = "BNm@\u0011\u00e1\u00d4Q:\u0088\u00c0\u00b41\t\u00ae\u00fa\f\u00a2\u0017YpQ~L\u008bi\u00ea\u00b4\n\u0014\u00b7:\u00feMpAX\u00ff\u00c64\u001b\u00d4`\u00c4~j\u0004Q\u00c3b".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 15;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 110;
                            break;
                        }
                        case 1: {
                            v15 = 72;
                            break;
                        }
                        case 2: {
                            v15 = 29;
                            break;
                        }
                        case 3: {
                            v15 = 43;
                            break;
                        }
                        case 4: {
                            v15 = 50;
                            break;
                        }
                        case 5: {
                            v15 = 67;
                            break;
                        }
                        default: {
                            v15 = 127;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x87C) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 19;
                case 1 -> 128;
                case 2 -> 147;
                case 3 -> 70;
                case 4 -> 178;
                case 5 -> 10;
                case 6 -> 130;
                case 7 -> 45;
                case 8 -> 12;
                case 9 -> 4;
                case 10 -> 241;
                case 11 -> 86;
                case 12 -> 210;
                case 13 -> 245;
                case 14 -> 163;
                case 15 -> 85;
                case 16 -> 194;
                case 17 -> 144;
                case 18 -> 72;
                case 19 -> 227;
                case 20 -> 228;
                case 21 -> 170;
                case 22 -> 83;
                case 23 -> 255;
                case 24 -> 20;
                case 25 -> 89;
                case 26 -> 177;
                case 27 -> 33;
                case 28 -> 193;
                case 29 -> 36;
                case 30 -> 175;
                case 31 -> 182;
                case 32 -> 149;
                case 33 -> 200;
                case 34 -> 172;
                case 35 -> 191;
                case 36 -> 88;
                case 37 -> 35;
                case 38 -> 63;
                case 39 -> 97;
                case 40 -> 158;
                case 41 -> 23;
                case 42 -> 219;
                case 43 -> 185;
                case 44 -> 108;
                case 45 -> 248;
                case 46 -> 231;
                case 47 -> 168;
                case 48 -> 136;
                case 49 -> 199;
                case 50 -> 183;
                case 51 -> 21;
                case 52 -> 112;
                case 53 -> 127;
                case 54 -> 156;
                case 55 -> 50;
                case 56 -> 100;
                case 57 -> 230;
                case 58 -> 162;
                case 59 -> 125;
                case 60 -> 22;
                case 61 -> 76;
                case 62 -> 186;
                case 63 -> 174;
                case 64 -> 242;
                case 65 -> 30;
                case 66 -> 117;
                case 67 -> 51;
                case 68 -> 148;
                case 69 -> 31;
                case 70 -> 232;
                case 71 -> 126;
                case 72 -> 123;
                case 73 -> 61;
                case 74 -> 75;
                case 75 -> 41;
                case 76 -> 141;
                case 77 -> 223;
                case 78 -> 109;
                case 79 -> 38;
                case 80 -> 82;
                case 81 -> 138;
                case 82 -> 65;
                case 83 -> 59;
                case 84 -> 103;
                case 85 -> 17;
                case 86 -> 67;
                case 87 -> 40;
                case 88 -> 55;
                case 89 -> 77;
                case 90 -> 43;
                case 91 -> 187;
                case 92 -> 68;
                case 93 -> 216;
                case 94 -> 171;
                case 95 -> 99;
                case 96 -> 229;
                case 97 -> 246;
                case 98 -> 209;
                case 99 -> 155;
                case 100 -> 79;
                case 101 -> 124;
                case 102 -> 54;
                case 103 -> 42;
                case 104 -> 84;
                case 105 -> 78;
                case 106 -> 251;
                case 107 -> 212;
                case 108 -> 243;
                case 109 -> 137;
                case 110 -> 1;
                case 111 -> 189;
                case 112 -> 32;
                case 113 -> 176;
                case 114 -> 197;
                case 115 -> 153;
                case 116 -> 154;
                case 117 -> 18;
                case 118 -> 5;
                case 119 -> 96;
                case 120 -> 235;
                case 121 -> 214;
                case 122 -> 15;
                case 123 -> 24;
                case 124 -> 53;
                case 125 -> 142;
                case 126 -> 74;
                case 127 -> 218;
                case 128 -> 237;
                case 129 -> 250;
                case 130 -> 14;
                case 131 -> 28;
                case 132 -> 98;
                case 133 -> 25;
                case 134 -> 116;
                case 135 -> 3;
                case 136 -> 221;
                case 137 -> 13;
                case 138 -> 188;
                case 139 -> 167;
                case 140 -> 27;
                case 141 -> 56;
                case 142 -> 69;
                case 143 -> 80;
                case 144 -> 58;
                case 145 -> 120;
                case 146 -> 7;
                case 147 -> 222;
                case 148 -> 92;
                case 149 -> 240;
                case 150 -> 101;
                case 151 -> 247;
                case 152 -> 239;
                case 153 -> 16;
                case 154 -> 87;
                case 155 -> 211;
                case 156 -> 202;
                case 157 -> 234;
                case 158 -> 81;
                case 159 -> 111;
                case 160 -> 6;
                case 161 -> 57;
                case 162 -> 151;
                case 163 -> 164;
                case 164 -> 133;
                case 165 -> 145;
                case 166 -> 215;
                case 167 -> 157;
                case 168 -> 8;
                case 169 -> 195;
                case 170 -> 254;
                case 171 -> 203;
                case 172 -> 165;
                case 173 -> 113;
                case 174 -> 160;
                case 175 -> 132;
                case 176 -> 173;
                case 177 -> 64;
                case 178 -> 107;
                case 179 -> 104;
                case 180 -> 105;
                case 181 -> 102;
                case 182 -> 238;
                case 183 -> 169;
                case 184 -> 198;
                case 185 -> 236;
                case 186 -> 166;
                case 187 -> 206;
                case 188 -> 207;
                case 189 -> 106;
                case 190 -> 34;
                case 191 -> 190;
                case 192 -> 94;
                case 193 -> 135;
                case 194 -> 134;
                case 195 -> 252;
                case 196 -> 9;
                case 197 -> 196;
                case 198 -> 90;
                case 199 -> 47;
                case 200 -> 217;
                case 201 -> 46;
                case 202 -> 143;
                case 203 -> 208;
                case 204 -> 95;
                case 205 -> 60;
                case 206 -> 139;
                case 207 -> 49;
                case 208 -> 115;
                case 209 -> 253;
                case 210 -> 119;
                case 211 -> 110;
                case 212 -> 225;
                case 213 -> 179;
                case 214 -> 0;
                case 215 -> 146;
                case 216 -> 44;
                case 217 -> 140;
                case 218 -> 226;
                case 219 -> 201;
                case 220 -> 244;
                case 221 -> 233;
                case 222 -> 48;
                case 223 -> 205;
                case 224 -> 114;
                case 225 -> 121;
                case 226 -> 161;
                case 227 -> 213;
                case 228 -> 150;
                case 229 -> 204;
                case 230 -> 249;
                case 231 -> 91;
                case 232 -> 29;
                case 233 -> 192;
                case 234 -> 159;
                case 235 -> 11;
                case 236 -> 2;
                case 237 -> 180;
                case 238 -> 39;
                case 239 -> 131;
                case 240 -> 37;
                case 241 -> 181;
                case 242 -> 122;
                case 243 -> 152;
                case 244 -> 118;
                case 245 -> 71;
                case 246 -> 66;
                case 247 -> 52;
                case 248 -> 224;
                case 249 -> 93;
                case 250 -> 26;
                case 251 -> 73;
                case 252 -> 220;
                case 253 -> 184;
                case 254 -> 62;
                default -> 129;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 68714353579215L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-828231330 - -27717, 828231330 - 30964, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 48876685283066L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.t();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-42597750 - -((char)-31475), 42597750 - (char)-17779, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-42597750 - -((char)-31478), 42597750 - (char)-774, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-42597750 - -((char)-31477), -42597750 - -((char)-14325), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00c85\u00c8\u0088\u00ed\f;\u00c7\u0010^\u00c1\u00eb\u00b73P\u0019\u0015\u00bbS\u00be\u0097\u0085Y\u0016\u00e5";
                    var4_3 = "\u00c85\u00c8\u0088\u00ed\f;\u00c7\u0010^\u00c1\u00eb\u00b73P\u0019\u0015\u00bbS\u00be\u0097\u0085Y\u0016\u00e5".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 16;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0006S+~\u00db5\u00bb\u001a\u008b;\u001d\u00c2\u00fe\u00d6\n\u00aa R\u009b1\u00eaX\u00de\u00ba\u0011e3g\u0015\u0002\u00beo\u00d5\u00b2\n\u00b9\u00f2\u0013\u00e0\u000e\u00c2\u00b99\u0013%\u00ca\u0014O\u0086r\u0001\u00b3\u00fe\u00bc[\u00a3\t\u009a;";
                        var4_3 = "\u0006S+~\u00db5\u00bb\u001a\u008b;\u001d\u00c2\u00fe\u00d6\n\u00aa R\u009b1\u00eaX\u00de\u00ba\u0011e3g\u0015\u0002\u00beo\u00d5\u00b2\n\u00b9\u00f2\u0013\u00e0\u000e\u00c2\u00b99\u0013%\u00ca\u0014O\u0086r\u0001\u00b3\u00fe\u00bc[\u00a3\t\u009a;".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 9;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 93;
                                break;
                            }
                            case 1: {
                                v15 = 89;
                                break;
                            }
                            case 2: {
                                v15 = 102;
                                break;
                            }
                            case 3: {
                                v15 = 54;
                                break;
                            }
                            case 4: {
                                v15 = 4;
                                break;
                            }
                            case 5: {
                                v15 = 97;
                                break;
                            }
                            default: {
                                v15 = 58;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x496C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 224;
                    case 1 -> 255;
                    case 2 -> 9;
                    case 3 -> 131;
                    case 4 -> 153;
                    case 5 -> 95;
                    case 6 -> 16;
                    case 7 -> 59;
                    case 8 -> 118;
                    case 9 -> 151;
                    case 10 -> 88;
                    case 11 -> 161;
                    case 12 -> 2;
                    case 13 -> 68;
                    case 14 -> 248;
                    case 15 -> 242;
                    case 16 -> 10;
                    case 17 -> 84;
                    case 18 -> 113;
                    case 19 -> 159;
                    case 20 -> 35;
                    case 21 -> 204;
                    case 22 -> 200;
                    case 23 -> 55;
                    case 24 -> 103;
                    case 25 -> 168;
                    case 26 -> 32;
                    case 27 -> 93;
                    case 28 -> 63;
                    case 29 -> 52;
                    case 30 -> 82;
                    case 31 -> 117;
                    case 32 -> 123;
                    case 33 -> 60;
                    case 34 -> 183;
                    case 35 -> 67;
                    case 36 -> 104;
                    case 37 -> 190;
                    case 38 -> 11;
                    case 39 -> 170;
                    case 40 -> 98;
                    case 41 -> 191;
                    case 42 -> 188;
                    case 43 -> 15;
                    case 44 -> 147;
                    case 45 -> 1;
                    case 46 -> 240;
                    case 47 -> 97;
                    case 48 -> 142;
                    case 49 -> 51;
                    case 50 -> 4;
                    case 51 -> 87;
                    case 52 -> 111;
                    case 53 -> 29;
                    case 54 -> 213;
                    case 55 -> 116;
                    case 56 -> 205;
                    case 57 -> 7;
                    case 58 -> 69;
                    case 59 -> 192;
                    case 60 -> 86;
                    case 61 -> 43;
                    case 62 -> 47;
                    case 63 -> 149;
                    case 64 -> 203;
                    case 65 -> 236;
                    case 66 -> 18;
                    case 67 -> 146;
                    case 68 -> 148;
                    case 69 -> 96;
                    case 70 -> 228;
                    case 71 -> 13;
                    case 72 -> 135;
                    case 73 -> 109;
                    case 74 -> 210;
                    case 75 -> 211;
                    case 76 -> 140;
                    case 77 -> 53;
                    case 78 -> 76;
                    case 79 -> 244;
                    case 80 -> 234;
                    case 81 -> 34;
                    case 82 -> 100;
                    case 83 -> 19;
                    case 84 -> 62;
                    case 85 -> 144;
                    case 86 -> 173;
                    case 87 -> 162;
                    case 88 -> 64;
                    case 89 -> 237;
                    case 90 -> 207;
                    case 91 -> 180;
                    case 92 -> 212;
                    case 93 -> 208;
                    case 94 -> 141;
                    case 95 -> 92;
                    case 96 -> 189;
                    case 97 -> 44;
                    case 98 -> 222;
                    case 99 -> 221;
                    case 100 -> 230;
                    case 101 -> 223;
                    case 102 -> 50;
                    case 103 -> 253;
                    case 104 -> 171;
                    case 105 -> 91;
                    case 106 -> 56;
                    case 107 -> 249;
                    case 108 -> 127;
                    case 109 -> 179;
                    case 110 -> 229;
                    case 111 -> 101;
                    case 112 -> 199;
                    case 113 -> 122;
                    case 114 -> 243;
                    case 115 -> 126;
                    case 116 -> 38;
                    case 117 -> 152;
                    case 118 -> 186;
                    case 119 -> 172;
                    case 120 -> 107;
                    case 121 -> 106;
                    case 122 -> 196;
                    case 123 -> 193;
                    case 124 -> 139;
                    case 125 -> 231;
                    case 126 -> 130;
                    case 127 -> 61;
                    case 128 -> 57;
                    case 129 -> 165;
                    case 130 -> 175;
                    case 131 -> 197;
                    case 132 -> 83;
                    case 133 -> 108;
                    case 134 -> 239;
                    case 135 -> 227;
                    case 136 -> 23;
                    case 137 -> 129;
                    case 138 -> 225;
                    case 139 -> 174;
                    case 140 -> 66;
                    case 141 -> 73;
                    case 142 -> 187;
                    case 143 -> 128;
                    case 144 -> 198;
                    case 145 -> 219;
                    case 146 -> 17;
                    case 147 -> 119;
                    case 148 -> 79;
                    case 149 -> 157;
                    case 150 -> 233;
                    case 151 -> 247;
                    case 152 -> 36;
                    case 153 -> 125;
                    case 154 -> 194;
                    case 155 -> 215;
                    case 156 -> 26;
                    case 157 -> 176;
                    case 158 -> 49;
                    case 159 -> 250;
                    case 160 -> 58;
                    case 161 -> 112;
                    case 162 -> 216;
                    case 163 -> 246;
                    case 164 -> 20;
                    case 165 -> 74;
                    case 166 -> 201;
                    case 167 -> 202;
                    case 168 -> 41;
                    case 169 -> 12;
                    case 170 -> 77;
                    case 171 -> 218;
                    case 172 -> 217;
                    case 173 -> 184;
                    case 174 -> 214;
                    case 175 -> 42;
                    case 176 -> 54;
                    case 177 -> 110;
                    case 178 -> 94;
                    case 179 -> 31;
                    case 180 -> 81;
                    case 181 -> 245;
                    case 182 -> 22;
                    case 183 -> 124;
                    case 184 -> 232;
                    case 185 -> 102;
                    case 186 -> 105;
                    case 187 -> 134;
                    case 188 -> 65;
                    case 189 -> 251;
                    case 190 -> 14;
                    case 191 -> 150;
                    case 192 -> 177;
                    case 193 -> 185;
                    case 194 -> 226;
                    case 195 -> 164;
                    case 196 -> 121;
                    case 197 -> 75;
                    case 198 -> 3;
                    case 199 -> 21;
                    case 200 -> 252;
                    case 201 -> 27;
                    case 202 -> 5;
                    case 203 -> 90;
                    case 204 -> 115;
                    case 205 -> 80;
                    case 206 -> 99;
                    case 207 -> 30;
                    case 208 -> 48;
                    case 209 -> 241;
                    case 210 -> 145;
                    case 211 -> 132;
                    case 212 -> 120;
                    case 213 -> 166;
                    case 214 -> 8;
                    case 215 -> 156;
                    case 216 -> 39;
                    case 217 -> 158;
                    case 218 -> 72;
                    case 219 -> 25;
                    case 220 -> 133;
                    case 221 -> 71;
                    case 222 -> 182;
                    case 223 -> 209;
                    case 224 -> 6;
                    case 225 -> 85;
                    case 226 -> 254;
                    case 227 -> 167;
                    case 228 -> 206;
                    case 229 -> 24;
                    case 230 -> 178;
                    case 231 -> 136;
                    case 232 -> 195;
                    case 233 -> 40;
                    case 234 -> 163;
                    case 235 -> 181;
                    case 236 -> 33;
                    case 237 -> 137;
                    case 238 -> 114;
                    case 239 -> 154;
                    case 240 -> 235;
                    case 241 -> 46;
                    case 242 -> 70;
                    case 243 -> 138;
                    case 244 -> 45;
                    case 245 -> 28;
                    case 246 -> 78;
                    case 247 -> 238;
                    case 248 -> 0;
                    case 249 -> 37;
                    case 250 -> 169;
                    case 251 -> 160;
                    case 252 -> 220;
                    case 253 -> 143;
                    case 254 -> 155;
                    default -> 89;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 95626503644156L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "Y\u0019on\u001a\b\u0012\u0000\t^\u0013|dWJ\u000f\u001cU";
                    var5_4 = "Y\u0019on\u001a\b\u0012\u0000\t^\u0013|dWJ\u000f\u001cU".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 43;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 25;
                                    break;
                                }
                                case 1: {
                                    v11 = 87;
                                    break;
                                }
                                case 2: {
                                    v11 = 54;
                                    break;
                                }
                                case 3: {
                                    v11 = 43;
                                    break;
                                }
                                case 4: {
                                    v11 = 84;
                                    break;
                                }
                                case 5: {
                                    v11 = 79;
                                    break;
                                }
                                default: {
                                    v11 = 10;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 76854340452786L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = ">\u001c@Wpvm\u00048\u0002LM\n4\u001dGM|tu\u001e\u001cN\t4\u001dGM|tu\u0012\u0016\r3\u001bZ@vyo\u0012\u0011]Jwp";
                    var5_4 = ">\u001c@Wpvm\u00048\u0002LM\n4\u001dGM|tu\u001e\u001cN\t4\u001dGM|tu\u0012\u0016\r3\u001bZ@vyo\u0012\u0011]Jwp".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 43;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "=\u0017OYypo\u0006=\u0017OYuz";
                        var5_4 = "=\u0017OYypo\u0006=\u0017OYuz".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 34;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 92;
                                break;
                            }
                            case 1: {
                                v15 = 89;
                                break;
                            }
                            case 2: {
                                v15 = 2;
                                break;
                            }
                            case 3: {
                                v15 = 8;
                                break;
                            }
                            case 4: {
                                v15 = 50;
                                break;
                            }
                            case 5: {
                                v15 = 60;
                                break;
                            }
                            default: {
                                v15 = 42;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 89936010776771L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-604363770 + -((char)-24487), -604363770 + -12331, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 80243910680674L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00eaD\u0092\u00e4}\u0003g\u00d2\u0097\u0005'\u000b\r\u00c9m\r(\u00bf\u00da\u0015b\u00ed\u00ff\u00a2;\u0019\u00cb\u00db\u00b1\u0010Z\u00bbS~l\u0015\u0015\u0080\u00af\u00d9\u00ba\u008ey\u009d\u00b4\u00e8\u0005\u0013\u00e5\u008b\u0014\u00bd3\u00b5\u00a5Nk\u001a\u00f3\u00ebH\r=e;Dz?\u000bVw\u0005\u009a\u00cb\u0099\u00c3W\u0013(\u00cf\u00d1\u00f0\u00ce\u0090\u001c\u001f\u000f\u0000\u00f54\u00da\u0088\u008bz\u00e0]\u001a\tp\u00e3\u00a8\u00ac\u0016\u00a8";
                    var4_3 = "\u00eaD\u0092\u00e4}\u0003g\u00d2\u0097\u0005'\u000b\r\u00c9m\r(\u00bf\u00da\u0015b\u00ed\u00ff\u00a2;\u0019\u00cb\u00db\u00b1\u0010Z\u00bbS~l\u0015\u0015\u0080\u00af\u00d9\u00ba\u008ey\u009d\u00b4\u00e8\u0005\u0013\u00e5\u008b\u0014\u00bd3\u00b5\u00a5Nk\u001a\u00f3\u00ebH\r=e;Dz?\u000bVw\u0005\u009a\u00cb\u0099\u00c3W\u0013(\u00cf\u00d1\u00f0\u00ce\u0090\u001c\u001f\u000f\u0000\u00f54\u00da\u0088\u008bz\u00e0]\u001a\tp\u00e3\u00a8\u00ac\u0016\u00a8".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 121;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00f8\u00d6\u00cd\u0019u3\u00fc\u008eX\u00d2\u008e%5\"\u00f7\u00d5LXk.d#TX\fE\u0011\u0081\u00e4\u00da\u0094\u0099zMBS\u0000\u00a3d.\u0080G\u00f3\u00aa\u00a6l\u00a3&\u0014\u0013*:\u0087\u008b\u0080\u008flf+\u00db\u00d4\u0006\u00bd\u0003\u00e3\u0088\u0081\u000e\u0082\u00c7\u00ae\u00b9\u00f2}A\u001d.A\u0096\u00c2\u00d9V\u00b2\u00ea\u00ee\u00dd./\u00fdt\u008dyn";
                        var4_3 = "\u00f8\u00d6\u00cd\u0019u3\u00fc\u008eX\u00d2\u008e%5\"\u00f7\u00d5LXk.d#TX\fE\u0011\u0081\u00e4\u00da\u0094\u0099zMBS\u0000\u00a3d.\u0080G\u00f3\u00aa\u00a6l\u00a3&\u0014\u0013*:\u0087\u008b\u0080\u008flf+\u00db\u00d4\u0006\u00bd\u0003\u00e3\u0088\u0081\u000e\u0082\u00c7\u00ae\u00b9\u00f2}A\u001d.A\u0096\u00c2\u00d9V\u00b2\u00ea\u00ee\u00dd./\u00fdt\u008dyn".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 86;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 38;
                                break;
                            }
                            case 1: {
                                v15 = 69;
                                break;
                            }
                            case 2: {
                                v15 = 117;
                                break;
                            }
                            case 3: {
                                v15 = 119;
                                break;
                            }
                            case 4: {
                                v15 = 106;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 84;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x136E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 132;
                    case 1 -> 17;
                    case 2 -> 121;
                    case 3 -> 209;
                    case 4 -> 236;
                    case 5 -> 250;
                    case 6 -> 35;
                    case 7 -> 135;
                    case 8 -> 205;
                    case 9 -> 140;
                    case 10 -> 34;
                    case 11 -> 18;
                    case 12 -> 43;
                    case 13 -> 222;
                    case 14 -> 42;
                    case 15 -> 12;
                    case 16 -> 204;
                    case 17 -> 1;
                    case 18 -> 59;
                    case 19 -> 94;
                    case 20 -> 4;
                    case 21 -> 76;
                    case 22 -> 58;
                    case 23 -> 97;
                    case 24 -> 122;
                    case 25 -> 117;
                    case 26 -> 177;
                    case 27 -> 80;
                    case 28 -> 130;
                    case 29 -> 120;
                    case 30 -> 198;
                    case 31 -> 127;
                    case 32 -> 189;
                    case 33 -> 19;
                    case 34 -> 103;
                    case 35 -> 229;
                    case 36 -> 158;
                    case 37 -> 92;
                    case 38 -> 84;
                    case 39 -> 82;
                    case 40 -> 193;
                    case 41 -> 10;
                    case 42 -> 21;
                    case 43 -> 194;
                    case 44 -> 190;
                    case 45 -> 142;
                    case 46 -> 70;
                    case 47 -> 11;
                    case 48 -> 161;
                    case 49 -> 96;
                    case 50 -> 170;
                    case 51 -> 66;
                    case 52 -> 45;
                    case 53 -> 89;
                    case 54 -> 91;
                    case 55 -> 15;
                    case 56 -> 182;
                    case 57 -> 33;
                    case 58 -> 41;
                    case 59 -> 150;
                    case 60 -> 159;
                    case 61 -> 175;
                    case 62 -> 125;
                    case 63 -> 20;
                    case 64 -> 151;
                    case 65 -> 240;
                    case 66 -> 202;
                    case 67 -> 187;
                    case 68 -> 115;
                    case 69 -> 8;
                    case 70 -> 28;
                    case 71 -> 60;
                    case 72 -> 192;
                    case 73 -> 246;
                    case 74 -> 40;
                    case 75 -> 238;
                    case 76 -> 88;
                    case 77 -> 206;
                    case 78 -> 55;
                    case 79 -> 143;
                    case 80 -> 123;
                    case 81 -> 211;
                    case 82 -> 228;
                    case 83 -> 54;
                    case 84 -> 227;
                    case 85 -> 7;
                    case 86 -> 219;
                    case 87 -> 226;
                    case 88 -> 26;
                    case 89 -> 230;
                    case 90 -> 196;
                    case 91 -> 57;
                    case 92 -> 243;
                    case 93 -> 24;
                    case 94 -> 207;
                    case 95 -> 223;
                    case 96 -> 23;
                    case 97 -> 100;
                    case 98 -> 241;
                    case 99 -> 251;
                    case 100 -> 249;
                    case 101 -> 221;
                    case 102 -> 31;
                    case 103 -> 129;
                    case 104 -> 136;
                    case 105 -> 85;
                    case 106 -> 105;
                    case 107 -> 169;
                    case 108 -> 109;
                    case 109 -> 154;
                    case 110 -> 186;
                    case 111 -> 119;
                    case 112 -> 0;
                    case 113 -> 87;
                    case 114 -> 163;
                    case 115 -> 153;
                    case 116 -> 13;
                    case 117 -> 113;
                    case 118 -> 208;
                    case 119 -> 164;
                    case 120 -> 156;
                    case 121 -> 165;
                    case 122 -> 200;
                    case 123 -> 107;
                    case 124 -> 155;
                    case 125 -> 37;
                    case 126 -> 86;
                    case 127 -> 235;
                    case 128 -> 152;
                    case 129 -> 199;
                    case 130 -> 67;
                    case 131 -> 128;
                    case 132 -> 244;
                    case 133 -> 253;
                    case 134 -> 5;
                    case 135 -> 102;
                    case 136 -> 218;
                    case 137 -> 247;
                    case 138 -> 104;
                    case 139 -> 181;
                    case 140 -> 224;
                    case 141 -> 148;
                    case 142 -> 166;
                    case 143 -> 180;
                    case 144 -> 131;
                    case 145 -> 174;
                    case 146 -> 39;
                    case 147 -> 63;
                    case 148 -> 69;
                    case 149 -> 233;
                    case 150 -> 77;
                    case 151 -> 53;
                    case 152 -> 167;
                    case 153 -> 239;
                    case 154 -> 48;
                    case 155 -> 203;
                    case 156 -> 157;
                    case 157 -> 106;
                    case 158 -> 178;
                    case 159 -> 110;
                    case 160 -> 32;
                    case 161 -> 101;
                    case 162 -> 25;
                    case 163 -> 98;
                    case 164 -> 216;
                    case 165 -> 111;
                    case 166 -> 2;
                    case 167 -> 78;
                    case 168 -> 149;
                    case 169 -> 139;
                    case 170 -> 83;
                    case 171 -> 112;
                    case 172 -> 30;
                    case 173 -> 172;
                    case 174 -> 79;
                    case 175 -> 201;
                    case 176 -> 71;
                    case 177 -> 138;
                    case 178 -> 22;
                    case 179 -> 44;
                    case 180 -> 195;
                    case 181 -> 68;
                    case 182 -> 232;
                    case 183 -> 212;
                    case 184 -> 188;
                    case 185 -> 116;
                    case 186 -> 254;
                    case 187 -> 73;
                    case 188 -> 29;
                    case 189 -> 191;
                    case 190 -> 147;
                    case 191 -> 134;
                    case 192 -> 64;
                    case 193 -> 179;
                    case 194 -> 56;
                    case 195 -> 168;
                    case 196 -> 38;
                    case 197 -> 248;
                    case 198 -> 173;
                    case 199 -> 225;
                    case 200 -> 217;
                    case 201 -> 185;
                    case 202 -> 81;
                    case 203 -> 6;
                    case 204 -> 183;
                    case 205 -> 47;
                    case 206 -> 114;
                    case 207 -> 141;
                    case 208 -> 14;
                    case 209 -> 61;
                    case 210 -> 146;
                    case 211 -> 50;
                    case 212 -> 231;
                    case 213 -> 62;
                    case 214 -> 90;
                    case 215 -> 27;
                    case 216 -> 245;
                    case 217 -> 46;
                    case 218 -> 144;
                    case 219 -> 197;
                    case 220 -> 95;
                    case 221 -> 160;
                    case 222 -> 255;
                    case 223 -> 51;
                    case 224 -> 137;
                    case 225 -> 124;
                    case 226 -> 220;
                    case 227 -> 118;
                    case 228 -> 234;
                    case 229 -> 72;
                    case 230 -> 36;
                    case 231 -> 242;
                    case 232 -> 214;
                    case 233 -> 215;
                    case 234 -> 145;
                    case 235 -> 171;
                    case 236 -> 237;
                    case 237 -> 133;
                    case 238 -> 126;
                    case 239 -> 210;
                    case 240 -> 75;
                    case 241 -> 108;
                    case 242 -> 162;
                    case 243 -> 74;
                    case 244 -> 16;
                    case 245 -> 176;
                    case 246 -> 184;
                    case 247 -> 99;
                    case 248 -> 213;
                    case 249 -> 49;
                    case 250 -> 93;
                    case 251 -> 65;
                    case 252 -> 52;
                    case 253 -> 3;
                    case 254 -> 252;
                    default -> 9;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 52354454398214L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1196931240 + -14891, -1196931240 - -5302, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 114576136668475L;
                    String[] stringArray = SshAgentIpcService.t();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-705811950 + -((char)-767), -705811950 + -((char)-9907), (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 98078371975926L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u001c\u008d\u00d1}\u00c8\u0003U\u00f3\u00ae";
                var4_3 = "\u001c\u008d\u00d1}\u00c8\u0003U\u00f3\u00ae".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 64;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 82;
                                break;
                            }
                            case 1: {
                                v11 = 74;
                                break;
                            }
                            case 2: {
                                v11 = 120;
                                break;
                            }
                            case 3: {
                                v11 = 40;
                                break;
                            }
                            case 4: {
                                v11 = 8;
                                break;
                            }
                            case 5: {
                                v11 = 69;
                                break;
                            }
                            default: {
                                v11 = 72;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x282B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 205;
                    case 1 -> 148;
                    case 2 -> 209;
                    case 3 -> 147;
                    case 4 -> 186;
                    case 5 -> 100;
                    case 6 -> 155;
                    case 7 -> 56;
                    case 8 -> 137;
                    case 9 -> 72;
                    case 10 -> 124;
                    case 11 -> 191;
                    case 12 -> 179;
                    case 13 -> 60;
                    case 14 -> 153;
                    case 15 -> 134;
                    case 16 -> 26;
                    case 17 -> 73;
                    case 18 -> 161;
                    case 19 -> 105;
                    case 20 -> 229;
                    case 21 -> 231;
                    case 22 -> 48;
                    case 23 -> 42;
                    case 24 -> 45;
                    case 25 -> 93;
                    case 26 -> 116;
                    case 27 -> 222;
                    case 28 -> 1;
                    case 29 -> 239;
                    case 30 -> 125;
                    case 31 -> 237;
                    case 32 -> 35;
                    case 33 -> 218;
                    case 34 -> 41;
                    case 35 -> 44;
                    case 36 -> 194;
                    case 37 -> 95;
                    case 38 -> 195;
                    case 39 -> 174;
                    case 40 -> 132;
                    case 41 -> 64;
                    case 42 -> 37;
                    case 43 -> 83;
                    case 44 -> 7;
                    case 45 -> 166;
                    case 46 -> 173;
                    case 47 -> 144;
                    case 48 -> 23;
                    case 49 -> 175;
                    case 50 -> 233;
                    case 51 -> 80;
                    case 52 -> 33;
                    case 53 -> 146;
                    case 54 -> 141;
                    case 55 -> 10;
                    case 56 -> 53;
                    case 57 -> 238;
                    case 58 -> 63;
                    case 59 -> 181;
                    case 60 -> 119;
                    case 61 -> 204;
                    case 62 -> 3;
                    case 63 -> 96;
                    case 64 -> 127;
                    case 65 -> 106;
                    case 66 -> 118;
                    case 67 -> 232;
                    case 68 -> 162;
                    case 69 -> 75;
                    case 70 -> 0;
                    case 71 -> 202;
                    case 72 -> 98;
                    case 73 -> 107;
                    case 74 -> 211;
                    case 75 -> 112;
                    case 76 -> 184;
                    case 77 -> 24;
                    case 78 -> 207;
                    case 79 -> 34;
                    case 80 -> 13;
                    case 81 -> 192;
                    case 82 -> 200;
                    case 83 -> 199;
                    case 84 -> 219;
                    case 85 -> 183;
                    case 86 -> 84;
                    case 87 -> 81;
                    case 88 -> 226;
                    case 89 -> 20;
                    case 90 -> 140;
                    case 91 -> 70;
                    case 92 -> 38;
                    case 93 -> 78;
                    case 94 -> 97;
                    case 95 -> 165;
                    case 96 -> 228;
                    case 97 -> 101;
                    case 98 -> 28;
                    case 99 -> 49;
                    case 100 -> 90;
                    case 101 -> 129;
                    case 102 -> 251;
                    case 103 -> 21;
                    case 104 -> 220;
                    case 105 -> 208;
                    case 106 -> 252;
                    case 107 -> 123;
                    case 108 -> 159;
                    case 109 -> 88;
                    case 110 -> 122;
                    case 111 -> 143;
                    case 112 -> 4;
                    case 113 -> 213;
                    case 114 -> 156;
                    case 115 -> 76;
                    case 116 -> 79;
                    case 117 -> 89;
                    case 118 -> 201;
                    case 119 -> 65;
                    case 120 -> 171;
                    case 121 -> 71;
                    case 122 -> 154;
                    case 123 -> 74;
                    case 124 -> 121;
                    case 125 -> 69;
                    case 126 -> 82;
                    case 127 -> 2;
                    case 128 -> 55;
                    case 129 -> 197;
                    case 130 -> 62;
                    case 131 -> 66;
                    case 132 -> 39;
                    case 133 -> 196;
                    case 134 -> 115;
                    case 135 -> 17;
                    case 136 -> 185;
                    case 137 -> 8;
                    case 138 -> 234;
                    case 139 -> 145;
                    case 140 -> 51;
                    case 141 -> 178;
                    case 142 -> 243;
                    case 143 -> 167;
                    case 144 -> 59;
                    case 145 -> 157;
                    case 146 -> 86;
                    case 147 -> 142;
                    case 148 -> 108;
                    case 149 -> 254;
                    case 150 -> 22;
                    case 151 -> 170;
                    case 152 -> 198;
                    case 153 -> 77;
                    case 154 -> 247;
                    case 155 -> 131;
                    case 156 -> 30;
                    case 157 -> 109;
                    case 158 -> 15;
                    case 159 -> 50;
                    case 160 -> 244;
                    case 161 -> 235;
                    case 162 -> 128;
                    case 163 -> 16;
                    case 164 -> 120;
                    case 165 -> 104;
                    case 166 -> 54;
                    case 167 -> 9;
                    case 168 -> 253;
                    case 169 -> 149;
                    case 170 -> 236;
                    case 171 -> 117;
                    case 172 -> 12;
                    case 173 -> 46;
                    case 174 -> 27;
                    case 175 -> 47;
                    case 176 -> 136;
                    case 177 -> 40;
                    case 178 -> 203;
                    case 179 -> 139;
                    case 180 -> 99;
                    case 181 -> 25;
                    case 182 -> 245;
                    case 183 -> 216;
                    case 184 -> 217;
                    case 185 -> 163;
                    case 186 -> 58;
                    case 187 -> 187;
                    case 188 -> 193;
                    case 189 -> 221;
                    case 190 -> 255;
                    case 191 -> 176;
                    case 192 -> 180;
                    case 193 -> 18;
                    case 194 -> 126;
                    case 195 -> 67;
                    case 196 -> 114;
                    case 197 -> 32;
                    case 198 -> 182;
                    case 199 -> 111;
                    case 200 -> 11;
                    case 201 -> 225;
                    case 202 -> 92;
                    case 203 -> 52;
                    case 204 -> 110;
                    case 205 -> 246;
                    case 206 -> 36;
                    case 207 -> 103;
                    case 208 -> 138;
                    case 209 -> 189;
                    case 210 -> 91;
                    case 211 -> 31;
                    case 212 -> 135;
                    case 213 -> 177;
                    case 214 -> 85;
                    case 215 -> 133;
                    case 216 -> 248;
                    case 217 -> 241;
                    case 218 -> 29;
                    case 219 -> 223;
                    case 220 -> 169;
                    case 221 -> 68;
                    case 222 -> 14;
                    case 223 -> 250;
                    case 224 -> 210;
                    case 225 -> 212;
                    case 226 -> 113;
                    case 227 -> 152;
                    case 228 -> 240;
                    case 229 -> 215;
                    case 230 -> 130;
                    case 231 -> 168;
                    case 232 -> 6;
                    case 233 -> 151;
                    case 234 -> 43;
                    case 235 -> 87;
                    case 236 -> 249;
                    case 237 -> 190;
                    case 238 -> 230;
                    case 239 -> 188;
                    case 240 -> 224;
                    case 241 -> 206;
                    case 242 -> 242;
                    case 243 -> 214;
                    case 244 -> 164;
                    case 245 -> 94;
                    case 246 -> 227;
                    case 247 -> 160;
                    case 248 -> 19;
                    case 249 -> 102;
                    case 250 -> 5;
                    case 251 -> 61;
                    case 252 -> 150;
                    case 253 -> 57;
                    case 254 -> 158;
                    default -> 172;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

