/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.google.common.collect.Sets;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Datatypes {
    public static final Set<Datatype> NUMERIC_DATATYPES = Sets.newHashSet((Object[])new Datatype[]{BasicDatatype.BigDecimal, BasicDatatype.Double, BasicDatatype.Integer, BasicDatatype.Long, BasicDatatype.PDouble});

    public static final class BasicDatatype
    implements Datatype {
        public static final BasicDatatype Void = new BasicDatatype(Void.class);
        public static final BasicDatatype Boolean = new BasicDatatype(Boolean.class);
        public static final BasicDatatype Byte = new BasicDatatype(Byte.class);
        public static final BasicDatatype Character = new BasicDatatype(Character.class);
        public static final BasicDatatype Class = new BasicDatatype(Class.class);
        public static final BasicDatatype Double = new BasicDatatype(Double.class);
        public static final BasicDatatype String = new BasicDatatype(String.class);
        public static final BasicDatatype Short = new BasicDatatype(Short.class);
        public static final BasicDatatype Integer = new BasicDatatype(Integer.class);
        public static final BasicDatatype Long = new BasicDatatype(Long.class);
        public static final BasicDatatype Float = new BasicDatatype(Float.class);
        public static final BasicDatatype ByteArray = new BasicDatatype("java.lang.Byte[]");
        public static final BasicDatatype CharacterArray = new BasicDatatype("java.lang.Character[]");
        public static final BasicDatatype UByte = new BasicDatatype(UByte.class, true);
        public static final BasicDatatype UShort = new BasicDatatype(UShort.class, true);
        public static final BasicDatatype UInteger = new BasicDatatype(UInt.class, true);
        public static final BasicDatatype ULong = new BasicDatatype(ULong.class, true);
        public static final BasicDatatype BigDecimal = new BasicDatatype(BigDecimal.class);
        public static final BasicDatatype BigInteger = new BasicDatatype(BigInteger.class);
        public static final BasicDatatype Duration = new BasicDatatype(Duration.class);
        public static final BasicDatatype Instant = new BasicDatatype(Instant.class);
        public static final BasicDatatype LocalDateTime = new BasicDatatype(LocalDateTime.class);
        public static final BasicDatatype LocalDate = new BasicDatatype(LocalDate.class);
        public static final BasicDatatype LocalTime = new BasicDatatype(LocalTime.class);
        public static final BasicDatatype OffsetDateTime = new BasicDatatype(OffsetDateTime.class);
        public static final BasicDatatype OffsetTime = new BasicDatatype(OffsetTime.class);
        public static final BasicDatatype ZonedDateTime = new BasicDatatype(ZonedDateTime.class);
        public static final BasicDatatype Date = new BasicDatatype(java.util.Date.class);
        public static final BasicDatatype Calendar = new BasicDatatype(Calendar.class);
        public static final BasicDatatype SqlDate = new BasicDatatype(Date.class);
        public static final BasicDatatype SqlTime = new BasicDatatype(Time.class);
        public static final BasicDatatype SqlTimestamp = new BasicDatatype(Timestamp.class);
        public static final BasicDatatype TimeZone = new BasicDatatype(TimeZone.class);
        public static final BasicDatatype Blob = new BasicDatatype(Blob.class);
        public static final BasicDatatype Clob = new BasicDatatype(Clob.class);
        public static final BasicDatatype NClob = new BasicDatatype(NClob.class);
        public static final BasicDatatype Locale = new BasicDatatype(Locale.class);
        public static final BasicDatatype Currency = new BasicDatatype(Currency.class);
        public static final BasicDatatype UUID = new BasicDatatype(UUID.class);
        public static final BasicDatatype Url = new BasicDatatype(URL.class);
        public static final BasicDatatype Uri = new BasicDatatype(URI.class);
        public static final BasicDatatype PBoolean = new BasicDatatype(java.lang.Boolean.TYPE);
        public static final BasicDatatype PByte = new BasicDatatype(java.lang.Byte.TYPE);
        public static final BasicDatatype PFloat = new BasicDatatype(java.lang.Float.TYPE);
        public static final BasicDatatype PChar = new BasicDatatype(java.lang.Character.TYPE);
        public static final BasicDatatype PInt = new BasicDatatype(java.lang.Integer.TYPE);
        public static final BasicDatatype PDouble = new BasicDatatype(java.lang.Double.TYPE);
        public static final BasicDatatype PShort = new BasicDatatype(java.lang.Short.TYPE);
        public static final BasicDatatype PLong = new BasicDatatype(java.lang.Long.TYPE);
        public static final BasicDatatype PByteArray = new BasicDatatype(byte[].class.getCanonicalName());
        public static final BasicDatatype PCharArray = new BasicDatatype(char[].class.getCanonicalName());
        public static final BasicDatatype GeoLateGeometry = new BasicDatatype("org.geolatte.geom.Geometry");
        public static final BasicDatatype VividGeometry = new BasicDatatype("com.vividsolutions.jts.geom.Geometry");
        public static final BasicDatatype ZoneOffset = new BasicDatatype(ZoneOffset.class);
        public static final BasicDatatype InetAddress = new BasicDatatype(InetAddress.class);
        public static final BasicDatatype LobString = new BasicDatatype("java.lang.LobString");
        public static final List<BasicDatatype> HARD_TYPES = Arrays.asList(String, Long, Integer, Boolean, Double, BigDecimal, Instant, LocalDateTime, LocalDate, LocalTime, OffsetDateTime, OffsetTime, Date, SqlDate, SqlTime, SqlTimestamp, TimeZone, ByteArray, Blob, Byte, UByte, UShort, UInteger, ULong, Character, Short, Float, BigInteger, Url, Duration, ZonedDateTime, Calendar, Locale, Currency, Class, UUID, CharacterArray, Clob, NClob, PBoolean, PByte, PFloat, PChar, PInt, PDouble, PShort, PLong, PByteArray, PCharArray, GeoLateGeometry, VividGeometry);
        public static final Map<BasicDatatype, BasicDatatype> PRIMITIVE_TO_BOXED = new HashMap<BasicDatatype, BasicDatatype>(){
            {
                this.put(PBoolean, Boolean);
                this.put(PByte, Byte);
                this.put(PFloat, Float);
                this.put(PChar, Character);
                this.put(PInt, Integer);
                this.put(PDouble, Double);
                this.put(PShort, Short);
                this.put(PLong, Long);
                this.put(PByteArray, ByteArray);
                this.put(PCharArray, CharacterArray);
            }
        };
        private final String fqn;
        private final String packageName;
        private final String className;
        @NlsSafe
        private final String label;
        private final boolean isPrimitive;
        private final boolean isSerializable;
        private final boolean isKotlinType;

        private BasicDatatype(Class<?> class_) {
            this(class_.getName(), null, class_.isPrimitive(), true);
        }

        private BasicDatatype(Class<?> class_, boolean isKotlinType) {
            this(class_.getName(), null, class_.isPrimitive(), true, isKotlinType);
        }

        private BasicDatatype(@NotNull String fqn) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(0);
            }
            this(fqn, null, false, true);
        }

        private BasicDatatype(@NotNull String fqn, @Nullable String label, boolean isPrimitive, boolean isSerializable) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(1);
            }
            this(fqn, label, isPrimitive, isSerializable, false);
        }

        private BasicDatatype(@NotNull String fqn, @Nullable String label, boolean isPrimitive, boolean isSerializable, boolean isKotlinType) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(2);
            }
            this.fqn = fqn;
            this.packageName = ClassUtil.extractPackageName((String)fqn);
            this.className = ClassUtil.extractClassName((String)fqn);
            this.label = label == null ? this.className : label;
            this.isPrimitive = isPrimitive;
            this.isSerializable = isSerializable;
            this.isKotlinType = isKotlinType;
        }

        public static BasicDatatype createUnsafe(@NotNull String fqn, @NotNull String label) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(3);
            }
            if (label == null) {
                BasicDatatype.$$$reportNull$$$0(4);
            }
            return new BasicDatatype(fqn, label, false, true);
        }

        @NotNull
        public static BasicDatatype createUnsafe(@NotNull String fqn, boolean isSerializable) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(5);
            }
            return new BasicDatatype(fqn, null, false, isSerializable);
        }

        @NotNull
        public static BasicDatatype createUnsafe(@NotNull String fqn) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(6);
            }
            return new BasicDatatype(fqn);
        }

        public static BasicDatatype getInstanceStrict(@NotNull PsiType migrationType) {
            if (migrationType == null) {
                BasicDatatype.$$$reportNull$$$0(7);
            }
            if (migrationType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)migrationType).getComponentType();
                if (componentType.equalsToText(java.lang.Byte.TYPE.getSimpleName())) {
                    return PByteArray;
                }
                if (componentType.equalsToText(java.lang.Character.TYPE.getSimpleName())) {
                    return PCharArray;
                }
                if (componentType.equalsToText(Byte.class.getName())) {
                    return ByteArray;
                }
                if (componentType.equalsToText(Character.class.getName())) {
                    return CharacterArray;
                }
            }
            return StreamEx.of(HARD_TYPES).findFirst(basicDatatype -> migrationType.equalsToText(basicDatatype.fqn)).orElse(null);
        }

        @Nullable
        public static BasicDatatype getInstanceWrapIfNull(@NotNull PsiType migrationType) {
            BasicDatatype basicDatatype;
            if (migrationType == null) {
                BasicDatatype.$$$reportNull$$$0(8);
            }
            if ((basicDatatype = BasicDatatype.getInstanceStrict(migrationType)) != null) {
                return basicDatatype;
            }
            String typeCanonicalText = migrationType.getCanonicalText();
            if (StringUtil.isNotEmpty((String)typeCanonicalText)) {
                return new BasicDatatype(typeCanonicalText);
            }
            return null;
        }

        @NotNull
        public static BasicDatatype getInstance(@NotNull String fqn) {
            BasicDatatype datatype;
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(9);
            }
            BasicDatatype basicDatatype = (datatype = BasicDatatype.getInstanceStrict(fqn)) == null ? new BasicDatatype(fqn) : datatype;
            if (basicDatatype == null) {
                BasicDatatype.$$$reportNull$$$0(10);
            }
            return basicDatatype;
        }

        @Nullable
        public static BasicDatatype getInstanceStrict(@NotNull String fqn) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(11);
            }
            return StreamEx.of(HARD_TYPES).findFirst(basicDatatype -> fqn.equals(basicDatatype.fqn) || "java.lang".equals(basicDatatype.packageName) && fqn.endsWith("." + basicDatatype.className)).orElse(null);
        }

        public static boolean isKnownType(@NotNull String fqn) {
            if (fqn == null) {
                BasicDatatype.$$$reportNull$$$0(12);
            }
            return BasicDatatype.getInstanceStrict(fqn) != null;
        }

        public boolean isKnownType() {
            return BasicDatatype.isKnownType(this.fqn);
        }

        public String getName() {
            return this.getClassName();
        }

        @Override
        @NlsSafe
        public String getFqn() {
            return this.fqn;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public boolean isSerializable() {
            return this.isSerializable;
        }

        public boolean isKotlinType() {
            return this.isKotlinType;
        }

        public static Collection<BasicDatatype> values() {
            return HARD_TYPES;
        }

        public static Collection<BasicDatatype> popularIdTypes() {
            return Arrays.asList(Long, Integer, String, UUID);
        }

        public static Collection<BasicDatatype> versionTypes() {
            return Arrays.asList(Long, PLong, Integer, PInt, Short, PShort);
        }

        public static Collection<BasicDatatype> dateAuditTypes() {
            return Arrays.asList(Instant, Long, LocalDateTime, LocalDate, OffsetDateTime, Date, ZonedDateTime, Calendar);
        }

        public static Collection<BasicDatatype> lobTypes() {
            return Arrays.asList(Blob, Clob, NClob);
        }

        public String toString() {
            return this.getLabel();
        }

        public boolean isSame(String fqn) {
            return Objects.equals(this.getFqn(), fqn) || this.equalsWithPrimitive(BasicDatatype.getInstance(fqn));
        }

        public boolean isSame(Datatype ... datatypes) {
            if (datatypes == null) {
                BasicDatatype.$$$reportNull$$$0(13);
            }
            return ContainerUtil.or((Object[])datatypes, this::equalsWithPrimitive);
        }

        public boolean equalsWithPrimitive(Datatype datatype) {
            if (!(datatype instanceof BasicDatatype)) {
                return false;
            }
            if (this.equals(datatype)) {
                return true;
            }
            BasicDatatype boxedType = PRIMITIVE_TO_BOXED.get(this);
            if (boxedType != null && boxedType.equals(datatype)) {
                return true;
            }
            boxedType = PRIMITIVE_TO_BOXED.get(datatype);
            return boxedType != null && boxedType.equals(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicDatatype that = (BasicDatatype)o;
            return Objects.equals(this.fqn, that.fqn) && Objects.equals(this.label, that.label);
        }

        public int hashCode() {
            return Objects.hash(this.fqn, this.label);
        }

        public boolean isSupportAutoIncrement() {
            return this.isSame(Long, Short, Integer, BigInteger);
        }

        @Nullable
        public static BasicDatatype getByClassname(String classname) {
            for (BasicDatatype t : BasicDatatype.values()) {
                if (!t.getClassName().equals(classname)) continue;
                return t;
            }
            return null;
        }

        @Nullable
        public static BasicDatatype getByLabel(String label) {
            for (BasicDatatype t : BasicDatatype.values()) {
                if (!t.getLabel().equals(label)) continue;
                return t;
            }
            return null;
        }

        public boolean isDate() {
            return this.isSame(Instant, LocalDateTime, LocalDate, LocalTime, OffsetDateTime, OffsetTime, ZonedDateTime, Date, Calendar, SqlDate, SqlTime, SqlTimestamp);
        }

        public boolean isZonedTime() {
            return this.isSame(OffsetTime, OffsetDateTime, ZonedDateTime);
        }

        public boolean isNumber() {
            return this.isSame(Double, Short, Integer, Long, Float, BigDecimal, BigInteger, Duration);
        }

        public boolean isString() {
            return this.isSame(String, Url, Uri, Locale, Class, Currency, CharacterArray, PCharArray, TimeZone, ZoneOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migrationType";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "datatypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createUnsafe";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstanceStrict";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstanceWrapIfNull";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 10: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isKnownType";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isSame";
                    break;
                }
            }
            String string = java.lang.String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10 -> new IllegalStateException(string);
            };
        }
    }

    public static enum CollectionDatatype {
        Set("java.util", "Set", JpaModelBundle.message("CollectionDatatype.Set", new Object[0])),
        List("java.util", "List", JpaModelBundle.message("CollectionDatatype.Set", new Object[0])),
        Collection("java.util", "Collection", JpaModelBundle.message("CollectionDatatype.Collection", new Object[0])),
        LinkedHashSet("java.util", "LinkedHashSet", JpaModelBundle.message("CollectionDatatype.LinkedHashSet", new Object[0])),
        Map("java.util", "Map", JpaModelBundle.message("CollectionDatatype.Map", new Object[0]));

        private final String packageName;
        private final String className;
        @Nls
        private final String label;

        private CollectionDatatype(@Nls String packageName, String className, String label) {
            this.packageName = packageName;
            this.className = className;
            this.label = label;
        }

        public String getFqn() {
            return StringUtil.getQualifiedName((String)this.packageName, (String)this.className);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getLabel() {
            return this.label;
        }

        @Nullable
        public static CollectionDatatype getByClassname(String className) {
            for (CollectionDatatype t : CollectionDatatype.values()) {
                if (!t.getClassName().equals(className)) continue;
                return t;
            }
            return null;
        }

        @Nullable
        public static CollectionDatatype getByFqn(String fqn) {
            for (CollectionDatatype t : CollectionDatatype.values()) {
                if (!t.getFqn().equals(fqn)) continue;
                return t;
            }
            return null;
        }

        @Contract(value="null -> null")
        @Nullable
        public static CollectionDatatype getByPsiType(@Nullable PsiType psiType) {
            if (psiType == null) {
                return null;
            }
            return StreamEx.of((Object[])CollectionDatatype.values()).findFirst(collectionDatatype -> psiType.equalsToText(collectionDatatype.getFqn())).orElse(null);
        }

        public static List<CollectionDatatype> getTypes(boolean isNonPersistent) {
            if (isNonPersistent) {
                return Arrays.asList(Set, List, Collection, LinkedHashSet);
            }
            return Arrays.asList(Set, List, Collection);
        }
    }
}

