/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.action;

import com.intellij.ide.IdeView;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jpa.jpb.model.action.ActionUtilsKt;
import com.intellij.jpa.jpb.model.action.StructureKeys;
import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.liquibase.common.ChangelogDirectoryProvider;
import com.intellij.liquibase.common.LiquibaseCreator;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.LiquibaseHelper;
import com.intellij.liquibase.common.action.LiquibaseAction;
import com.intellij.liquibase.common.gui.ChangeLogCreationDialog;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.liquibase.common.util.SqlActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PsiNavigateUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/liquibase/common/action/CreateChangeLogAction;", "Lcom/intellij/liquibase/common/action/LiquibaseAction;", "<init>", "()V", "doActionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "isDumbAware", "", "generateChangelogDirPath", "", "getSelectedDirectory", "Lcom/intellij/psi/PsiDirectory;", "getContextModuleResourcesDir", "liquibaseActionUpdate", "Companion", "intellij.liquibase.common"})
public class CreateChangeLogAction
extends LiquibaseAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "CreateLiquibaseChangeLog";
    @NotNull
    private static final DataKey<String> INIT_DIRECTORY_NAME = DataKey.Companion.create("com.intellij.liquibase.common.createDiffLiquibaseChangeLog.initDirectoryName");
    @NotNull
    private static final DataKey<String> INIT_FILE_NAME = DataKey.Companion.create("com.intellij.liquibase.common.createDiffLiquibaseChangeLog.initFileName");
    @NotNull
    private static final DataKey<LiquibaseFileType> FILE_TYPE = DataKey.Companion.create("com.intellij.liquibase.common.createDiffLiquibaseChangeLog.fileType");

    protected void doActionPerformed(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChangeLogCreationDialog changeLogCreationDialog = new ChangeLogCreationDialog(project, this.generateChangelogDirPath(e, project), this.getSelectedDirectory(e));
        if (changeLogCreationDialog.showAndGet()) {
            String fileName = changeLogCreationDialog.getFileNameWithoutExt();
            LiquibaseCreator liquibaseCreator = LiquibaseCreator.Companion.getInstance(project);
            PsiDirectory psiDirectory = changeLogCreationDialog.getDirectory();
            Intrinsics.checkNotNull((Object)psiDirectory);
            PsiFile dbChangeLogFile = LiquibaseCreator.createDbChangeLogFile$default(liquibaseCreator, psiDirectory, fileName, changeLogCreationDialog.getFileType(), null, null, 24, null);
            if (dbChangeLogFile != null) {
                PsiNavigateUtil.navigate((PsiElement)((PsiElement)dbChangeLogFile));
            }
        }
    }

    public boolean isDumbAware() {
        return true;
    }

    private final String generateChangelogDirPath(AnActionEvent $this$generateChangelogDirPath, Project project) {
        Module module = (Module)$this$generateChangelogDirPath.getData(PlatformDataKeys.MODULE);
        if (module == null) {
            return LiquibaseHelper.generateChangeLogDir$default(LiquibaseHelper.Companion.getInstance(project), false, 1, null);
        }
        Module module2 = module;
        return LiquibaseHelper.generateChangeLogDir$default(LiquibaseHelper.Companion.getInstance(project), module2, false, 2, null);
    }

    @Nullable
    protected PsiDirectory getSelectedDirectory(@Nullable AnActionEvent e) {
        JpsModuleSourceRootType[] myProject;
        JpsModuleSourceRootType[] project;
        if (e == null) {
            return null;
        }
        String[] stringArray = new String[]{"JpaStructureToolBar", "ICON_NAVIGATION", "ICON_NAVIGATION_SECONDARY_BUTTON", "GoToAction"};
        if (this.isActionInPlaces(e, stringArray)) {
            return null;
        }
        if (this.isActionInPlace(e, "IntentionMenu")) {
            String contextLanguage;
            PsiElement psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            String string = psiElement != null && (psiElement = psiElement.getLanguage()) != null ? psiElement.getID() : (contextLanguage = null);
            if (StringsKt.equals((String)"Java", (String)contextLanguage, (boolean)true) || StringsKt.equals((String)"Kotlin", (String)contextLanguage, (boolean)true)) {
                return null;
            }
        }
        if (project != null) {
            myProject = project = e.getProject();
            boolean bl = false;
            if (this.isActionInPlace(e, "JpaChangelogQuickFixAction")) {
                PsiDirectory psiDirectory;
                String string = (String)e.getData(INIT_DIRECTORY_NAME);
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    psiDirectory = SearchHelper.getInstance((Project)myProject).findDirectory(it, GlobalSearchScope.allScope((Project)myProject));
                } else {
                    psiDirectory = null;
                }
                return psiDirectory;
            }
            if (this.isActionInPlace(e, "JpaPaletteDiffAction")) {
                PsiDirectory psiDirectory;
                VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)myProject).getSelectedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
                VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile selectedFile = virtualFile;
                VirtualFile virtualFile2 = selectedFile.getParent();
                if (virtualFile2 != null) {
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    psiDirectory = PsiManager.getInstance((Project)myProject).findDirectory(it);
                } else {
                    psiDirectory = null;
                }
                return psiDirectory;
            }
        }
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        myProject = new JpsModuleSourceRootType[2];
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.RESOURCE, (String)"RESOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.TEST_RESOURCE, (String)"TEST_RESOURCE");
        if (!ActionUtilsKt.isUnderSourceRootOfType((AnActionEvent)e, (JpsModuleSourceRootType[])myProject)) {
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            return psiFile2.getContainingDirectory();
        }
        PsiDirectory dir = super.getSelectedDirectory(e);
        if (!(view != null || dir != null && dir.isWritable())) {
            Intrinsics.checkNotNull((Object)project);
            PsiDirectory eventDir = ChangelogDirectoryProvider.Companion.getChangelogDirectory((Project)project, e);
            if (eventDir != null) {
                return eventDir;
            }
        }
        return dir;
    }

    private final PsiDirectory getContextModuleResourcesDir(AnActionEvent $this$getContextModuleResourcesDir) {
        Module module = (Module)$this$getContextModuleResourcesDir.getData(PlatformDataKeys.MODULE);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Project project = $this$getContextModuleResourcesDir.getProject();
        if (project == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List list = ModuleRootManager.getInstance((Module)module2).getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        return (PsiDirectory)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VirtualFile, PsiDirectory>((Object)psiManager2){

            public final PsiDirectory invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PsiManager)this.receiver).findDirectory(p0);
            }
        })));
    }

    @Override
    public void liquibaseActionUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isActionInPlace(e, "DatabaseViewPopup")) {
            e.getPresentation().setEnabledAndVisible(LiquibaseHelper.isLiquibaseSupported$default(LiquibaseHelper.Companion.getInstance(project), project, false, 2, null) && EventDataProviderEP.Companion.getAGGREGATOR_NOT_DEFAULT().getRdbmsDataStore(e) != null && OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        if (EventDataProviderEP.Companion.getAGGREGATOR().isGlobalActionPlace(e)) {
            e.getPresentation().setEnabledAndVisible(OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        if (!LiquibaseHelper.isLiquibaseSupported$default(LiquibaseHelper.Companion.getInstance(project), project, false, 2, null)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String[] stringArray = new String[]{"GoToAction", "ICON_NAVIGATION_SECONDARY_BUTTON", "ICON_NAVIGATION", "EditorToolbar", "IntentionMenu", "ToolwindowTitle"};
        if (this.isActionInPlaces(e, stringArray)) {
            String[] stringArray2 = new String[]{"ICON_NAVIGATION_SECONDARY_BUTTON", "ICON_NAVIGATION"};
            boolean isOnlyPsiClassElement = this.isActionInPlaces(e, stringArray2);
            List entities = ActionUtilsKt.getActionOrmEntities((AnActionEvent)e, OrmDiffModelProvider.Companion.getSupportedFrameworks(project), (boolean)isOnlyPsiClassElement);
            e.getPresentation().setEnabledAndVisible(OrmUtil.INSTANCE.hasPersistentEntity((Iterable)entities));
            return;
        }
        if (ActionUtilsKt.isEntitiesSelectedInTree((AnActionEvent)e)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        OrmFramework ormFramework = OrmUtil.INSTANCE.getOrmFrameworkByEvent(e);
        if (ormFramework != null) {
            e.getPresentation().setEnabledAndVisible(OrmDiffModelProvider.Companion.findForFramework(ormFramework) != null);
            return;
        }
        JpsModuleSourceRootType[] jpsModuleSourceRootTypeArray = (JpsModuleSourceRootType[])e.getData(StructureKeys.STRUCTURE_NODE);
        if (jpsModuleSourceRootTypeArray != null) {
            JpsModuleSourceRootType[] it = jpsModuleSourceRootTypeArray;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(SqlActionUtils.INSTANCE.isLiquibaseStructureNode((NodeDescriptor<?>)it) && OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        Presentation presentation = e.getPresentation();
        jpsModuleSourceRootTypeArray = new JpsModuleSourceRootType[2];
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.RESOURCE, (String)"RESOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.TEST_RESOURCE, (String)"TEST_RESOURCE");
        presentation.setEnabledAndVisible(ActionUtilsKt.isUnderSourceRootOfType((AnActionEvent)e, (JpsModuleSourceRootType[])jpsModuleSourceRootTypeArray) && OrmUtil.INSTANCE.isAnyEntityInProject(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/common/action/CreateChangeLogAction$Companion;", "", "<init>", "()V", "ID", "", "INIT_DIRECTORY_NAME", "Lcom/intellij/openapi/actionSystem/DataKey;", "getINIT_DIRECTORY_NAME", "()Lcom/intellij/openapi/actionSystem/DataKey;", "INIT_FILE_NAME", "getINIT_FILE_NAME", "FILE_TYPE", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "getFILE_TYPE", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<String> getINIT_DIRECTORY_NAME() {
            return INIT_DIRECTORY_NAME;
        }

        @NotNull
        public final DataKey<String> getINIT_FILE_NAME() {
            return INIT_FILE_NAME;
        }

        @NotNull
        public final DataKey<LiquibaseFileType> getFILE_TYPE() {
            return FILE_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

