/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraphEditorComponentDrawable;
import com.intellij.openapi.graph.impl.view.JByToSwingEventsDelegatingMode;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import t.d.Hd;
import t.d.bW;
import t.d.d5;
import t.d.kD;
import t.d.tt;
import t.m.nS;
import t.p.O;
import t.p.l;
import t.p.m;

public class JBCellEditorMode
extends Hd {
    @NotNull
    private final O myNodeCellEditorProvider;
    @NotNull
    private final m myUserObjectMap;
    @NotNull
    private final CellEditorListener myCellEditorListener = new MyCellEditorListener();
    @Nullable
    private tt myCurrentEditor;
    @Nullable
    private bW myCurrentEditedNodeRealizer;
    @Nullable
    private JComponent myCurrentEditorComponent;
    @Nullable
    private JByToSwingEventsDelegatingMode myEventsDelegatingMode;
    @Nullable
    private JBGraphEditorComponentDrawable myEditorComponentDrawable;
    @Nullable
    private PropertyChangeListener myFocusOwnerChangeListener;

    public JBCellEditorMode(tt nodeCellEditor, m userObjectMap) {
        this(nS.t(nodeCellEditor), userObjectMap);
    }

    public JBCellEditorMode(O nodeCellEditorProvider, m userObjectMap) {
        super(nodeCellEditorProvider, userObjectMap);
        this.myNodeCellEditorProvider = nodeCellEditorProvider;
        this.myUserObjectMap = userObjectMap;
    }

    @Override
    public boolean editNode(l node, EventObject event) {
        if (this.isNodeEditable(node) && (!this.isCellEditing() || this.stopCellEditing())) {
            bW bW2 = this.t().t(node);
            tt tt2 = this.getNodeCellEditor(node);
            if (tt2 == null || event != null && !tt2.isCellEditable(event)) {
                return false;
            }
            this.startCellEditing(bW2, tt2);
            if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500 && this.myEventsDelegatingMode != null && this.isCellEditing()) {
                this.myEventsDelegatingMode.mouseClicked((MouseEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeEditable(l node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void b(MouseEvent mouseEvent) {
        Object object;
        kD kD2;
        if (!this.isCellEditing()) {
            if (!this.shouldStartCellEditing(mouseEvent)) {
                return;
            }
            kD2 = this.t(mouseEvent);
            if (kD2.t() == null) {
                return;
            }
            this.editNode((l)kD2.t(), mouseEvent);
            if (!bW.W) {
                return;
            }
        }
        this.n(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.isCellEditing() && mouseEvent.getID() == 501 && ((object = (kD2 = this.t(mouseEvent)).t()) == null || object != this.myCurrentEditedNodeRealizer.t()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    @Nullable
    public Object getUserObject(l node) {
        return this.myUserObjectMap.get(this.myCurrentEditedNodeRealizer.t());
    }

    @Override
    public void setUserObject(l node, Object data) {
        this.myUserObjectMap.t((Object)node, data);
    }

    @Override
    protected boolean shouldStartCellEditing(@NotNull MouseEvent event) {
        if (event == null) {
            JBCellEditorMode.n(0);
        }
        return event.getID() == 500 && event.getClickCount() == 2;
    }

    @Override
    @Nullable
    public tt getNodeCellEditor(l node) {
        Object object = this.myNodeCellEditorProvider != null ? this.myNodeCellEditorProvider.get(node) : null;
        return object instanceof tt ? (tt)object : null;
    }

    @Override
    public boolean isCellEditing() {
        return this.myCurrentEditor != null;
    }

    @Override
    public void startCellEditing(bW nodeRealizer, tt nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.myCurrentEditor = nodeCellEditor;
            this.myCurrentEditedNodeRealizer = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.myCellEditorListener);
            JComponent jComponent = nodeCellEditor.getNodeCellEditorComponent(this.Y, nodeRealizer, this.getUserObject(nodeRealizer.t()), nodeRealizer.K());
            this.installEditor(jComponent, nodeRealizer);
        }
    }

    @Override
    @Nullable
    public tt getEditor() {
        return this.myCurrentEditor;
    }

    @Override
    @Nullable
    public l getEditingNode() {
        return this.myCurrentEditedNodeRealizer != null ? this.myCurrentEditedNodeRealizer.t() : null;
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean stopCellEditing() {
        return this.myCurrentEditor != null ? this.myCurrentEditor.stopCellEditing() : true;
    }

    @Override
    protected void cellEditingCanceled() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    protected void cellEditingStopped() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    public void reactivateParent() {
        super.reactivateParent();
    }

    @Override
    public void cancelEditing() throws UnsupportedOperationException {
        super.cancelEditing();
    }

    @Override
    protected void setEditing(boolean b10) {
        super.setEditing(b10);
    }

    @Override
    public void activate(boolean b10) {
        super.activate(b10);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseMoved(event);
        }
    }

    private void p(@NotNull MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            JBCellEditorMode.n(1);
        }
        if (mouseEvent.getID() == 501 && this.isCellEditing() && ((object = this.t(mouseEvent).t()) == null || object != this.myCurrentEditedNodeRealizer.t()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseReleased(event);
        }
        this.q(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseDragged(event);
        }
        this.q(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mousePressed(event);
        }
        this.q(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseClicked(event);
        }
        this.q(event);
    }

    private void q(MouseEvent mouseEvent) {
        this.p(mouseEvent);
        if (!bW.W) {
            return;
        }
        this.b(mouseEvent);
    }

    @Override
    protected void installEditor(@NotNull JComponent editorComponent, bW nodeRealizer) {
        if (editorComponent == null) {
            JBCellEditorMode.n(2);
        }
        if (editorComponent.getNextFocusableComponent() == null) {
            editorComponent.setNextFocusableComponent(this.Y.t());
        }
        JComponent jComponent = this.t();
        jComponent.add(editorComponent);
        this.myCurrentEditorComponent = editorComponent;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.n(), nodeRealizer.p());
        JByToSwingEventsDelegatingMode jByToSwingEventsDelegatingMode = new JByToSwingEventsDelegatingMode(true);
        this.t(jByToSwingEventsDelegatingMode, null, null, null);
        jByToSwingEventsDelegatingMode.addDelegateComponent(editorComponent, affineTransform);
        this.myEventsDelegatingMode = jByToSwingEventsDelegatingMode;
        this.myEditorComponentDrawable = new JBGraphEditorComponentDrawable(jComponent, editorComponent, affineTransform);
        this.Y.t(this.myEditorComponentDrawable);
        editorComponent.setBounds(0, 0, (int)nodeRealizer.t(), (int)nodeRealizer.q());
        editorComponent.validate();
        editorComponent.requestFocusInWindow();
        editorComponent.repaint();
        if (this.myFocusOwnerChangeListener == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myFocusOwnerChangeListener = new MyFocusOwnerListener(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
        }
    }

    @Override
    protected void removeEditor() {
        if (this.myFocusOwnerChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
            this.myFocusOwnerChangeListener = null;
        }
        if (this.myCurrentEditorComponent != null) {
            this.myEventsDelegatingMode.reactivateParent();
            this.t().remove(this.myCurrentEditorComponent);
            this.Y.p(this.myEditorComponentDrawable);
            this.Y.t().repaint();
            this.myEventsDelegatingMode = null;
        }
        this.myCurrentEditorComponent = null;
    }

    private void n(Component component) {
        if (component instanceof d5) {
            return;
        }
        boolean bl2 = bW.W;
        if (this.isCellEditing()) {
            JComponent jComponent = this.t();
            for (Component component2 = component; component2 != null && component2 != jComponent; component2 = component2.getParent()) {
                if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                    if (component2 == SwingUtilities.getRoot(this.Y) && !this.stopCellEditing()) {
                        this.cancelCellEditing();
                    }
                    return;
                }
                if (!bl2) continue;
                return;
            }
        }
    }

    @NotNull
    private JComponent t() {
        JComponent jComponent = this.Y.t();
        if (jComponent == null) {
            JBCellEditorMode.n(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void n(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldStartCellEditing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelEditingIfAnotherNodeWasClicked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class MyCellEditorListener
    implements CellEditorListener {
        MyCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingStopped();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingCanceled();
        }
    }

    private final class MyFocusOwnerListener
    implements PropertyChangeListener {
        @NotNull
        private final KeyboardFocusManager myFocusManager;

        public MyFocusOwnerListener(KeyboardFocusManager focusManager) {
            if (focusManager == null) {
                MyFocusOwnerListener.t(0);
            }
            this.myFocusManager = focusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JBCellEditorMode.this.n(this.myFocusManager.getPermanentFocusOwner());
        }

        private static /* synthetic */ void t(int n10) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/openapi/graph/impl/view/JBCellEditorMode$MyFocusOwnerListener", "<init>"));
        }
    }
}

