/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspTypeHierarchyCustomizer;
import com.intellij.platform.lsp.api.customization.LspTypeHierarchySupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.hierarchy.LspHierarchyUtilKt;
import com.intellij.platform.lsp.impl.hierarchy.type.LspTypeHierarchyBrowser;
import com.intellij.platform.lsp.impl.hierarchy.type.LspTypeHierarchyProviderKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/hierarchy/type/LspTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/HierarchyProvider;", "LspTypeHierarchyProvider", "()V", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createHierarchyBrowser", "Lcom/intellij/ide/hierarchy/HierarchyBrowser;", "target", "browserActivated", "", "hierarchyBrowser", "t", "", "server", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lsp.impl"})
public final class LspTypeHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return LspHierarchyUtilKt.getTargetFromEditor(dataContext, (Key<LspServerImpl>)LspTypeHierarchyProviderKt.access$getLSP_TYPE_HIERARCHY_SERVER_KEY$p(), (Function2<? super LspServerImpl, ? super VirtualFile, Boolean>)((Function2)new Function2<LspServerImpl, VirtualFile, Boolean>((Object)this){

            public final Boolean invoke(LspServerImpl p02, VirtualFile p12) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p12, (String)"p1");
                return LspTypeHierarchyProvider.access$shouldProceedWithServer((LspTypeHierarchyProvider)this.receiver, p02, p12);
            }
        }));
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LspServerImpl lspServerImpl = (LspServerImpl)target.getUserData(LspTypeHierarchyProviderKt.access$getLSP_TYPE_HIERARCHY_SERVER_KEY$p());
        if (lspServerImpl == null) {
            Project project = target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = target.getContainingFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            lspServerImpl = LspHierarchyUtilKt.findSupportingServer(project, virtualFile, (Function2<? super LspServerImpl, ? super VirtualFile, Boolean>)((Function2)new Function2<LspServerImpl, VirtualFile, Boolean>((Object)this){

                public final Boolean invoke(LspServerImpl p02, VirtualFile p12) {
                    Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p12, (String)"p1");
                    return LspTypeHierarchyProvider.access$shouldProceedWithServer((LspTypeHierarchyProvider)this.receiver, p02, p12);
                }
            }));
            if (lspServerImpl == null) {
                throw new IllegalStateException("Missing cached LSP server on type-hierarchy target".toString());
            }
        }
        LspServerImpl lspServerImpl2 = lspServerImpl;
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (HierarchyBrowser)new LspTypeHierarchyBrowser(project, target, lspServerImpl2);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        Intrinsics.checkNotNullParameter((Object)hierarchyBrowser, (String)"hierarchyBrowser");
        LspTypeHierarchyBrowser lspTypeHierarchyBrowser = hierarchyBrowser instanceof LspTypeHierarchyBrowser ? (LspTypeHierarchyBrowser)hierarchyBrowser : null;
        if (lspTypeHierarchyBrowser == null) {
            return;
        }
        LspTypeHierarchyBrowser lspTypeHierarchyBrowser2 = lspTypeHierarchyBrowser;
        lspTypeHierarchyBrowser2.changeView(TypeHierarchyBrowserBase.getSubtypesHierarchyType());
    }

    private final boolean t(LspServerImpl lspServerImpl, VirtualFile virtualFile) {
        LspTypeHierarchyCustomizer lspTypeHierarchyCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getTypeHierarchyCustomizer();
        return lspTypeHierarchyCustomizer instanceof LspTypeHierarchySupport && lspServerImpl.supportsTypeHierarchy$intellij_platform_lsp_impl(virtualFile) && ((LspTypeHierarchySupport)lspTypeHierarchyCustomizer).shouldAskServerForTypeHierarchy(virtualFile);
    }

    public static final /* synthetic */ boolean access$shouldProceedWithServer(LspTypeHierarchyProvider $this, LspServerImpl server2, VirtualFile file) {
        return $this.t(server2, file);
    }
}

