/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.config.unified.SshConfigManagerBase;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SshConfigManagerImpl
implements SshConfigManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(SshConfigManagerImpl.class);
    @NotNull
    private final SshConfigManagerBase.App myAppBase = (SshConfigManagerBase.App)ApplicationManager.getApplication().getService(SshConfigManagerBase.App.class);
    @Nullable
    private final SshConfigManagerBase.Project myProjectBase;
    private SshConfigManagerBase.Listener myProjectListener;
    private SshConfigManagerBase.Listener myAppListener = new SshConfigManagerBase.Listener(){

        @Override
        public void changed(@NotNull SshConfigManager.ConfigsData data) {
            if (data == null) {
                1.t(0);
            }
            if (SshConfigManagerImpl.this.myCollectingChangesLevel > 0) {
                SshConfigManagerImpl.this.myHasAppChanges = true;
            } else {
                SshConfigManagerImpl.this.t(true);
            }
        }

        private static /* synthetic */ void t(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$1", "changed"));
        }
    };
    private int myCollectingChangesLevel = 0;
    private boolean myHasAppChanges = false;
    private boolean myHasProjectChanges = false;

    private SshConfigManagerImpl(@Nullable Project project) {
        this.myAppBase.addChangeListener(this.myAppListener);
        if (project != null) {
            this.myProjectBase = (SshConfigManagerBase.Project)project.getService(SshConfigManagerBase.Project.class);
            this.myProjectListener = new SshConfigManagerBase.Listener(){

                @Override
                public void changed(@NotNull SshConfigManager.ConfigsData data) {
                    if (data == null) {
                        2.t(0);
                    }
                    if (SshConfigManagerImpl.this.myCollectingChangesLevel > 0) {
                        SshConfigManagerImpl.this.myHasProjectChanges = true;
                    } else {
                        SshConfigManagerImpl.this.t(false);
                    }
                }

                private static /* synthetic */ void t(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$2", "changed"));
                }
            };
            this.myProjectBase.addChangeListener(this.myProjectListener);
        } else {
            this.myProjectBase = null;
        }
    }

    public void removeDataConfig(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.n(0);
        }
        this.startCollectingNotifications();
        if (data.getConfig().isProjectLevel()) {
            LOG.assertTrue(this.myProjectBase != null);
            this.myProjectBase.removeFromSavedAndCurrent(data);
        } else {
            this.myAppBase.removeFromSavedAndCurrent(data);
        }
        data.getConfig().eraseAuthDataFromPasswordSafe();
        this.handleNotifications(false);
    }

    @Override
    public @Unmodifiable @NotNull List<SshConfig> getConfigs() {
        List list = ContainerUtil.map(this.getLastSavedAndCurrentData().getLastSavedData(), SshUiData::getConfig);
        if (list == null) {
            SshConfigManagerImpl.n(1);
        }
        return list;
    }

    @Override
    @NotNull
    public SshConfigManager.ConfigsData getLastSavedAndCurrentData() {
        SshConfigManager.ConfigsData configsData = this.myAppBase.getLastSavedAndCurrentData();
        if (this.myProjectBase != null) {
            configsData = configsData.createMerged(this.myProjectBase.getLastSavedAndCurrentData());
        }
        SshConfigManager.ConfigsData configsData2 = configsData;
        if (configsData2 == null) {
            SshConfigManagerImpl.n(2);
        }
        return configsData2;
    }

    @NotNull
    private MessageBus t() {
        MessageBus messageBus = this.myProjectBase != null && this.myProjectBase.getProject() != null ? this.myProjectBase.getProject().getMessageBus() : ApplicationManager.getApplication().getMessageBus();
        MessageBus messageBus2 = messageBus;
        if (messageBus2 == null) {
            SshConfigManagerImpl.n(3);
        }
        return messageBus2;
    }

    @Override
    public void setCurrentData(@NotNull List<SshUiData> newData, @NotNull SshConfigManager.Listener source) {
        if (newData == null) {
            SshConfigManagerImpl.n(4);
        }
        if (source == null) {
            SshConfigManagerImpl.n(5);
        }
        this.startCollectingNotifications();
        Split split = new Split(newData);
        if (this.myProjectBase != null) {
            this.myProjectBase.setCurrentData(split.myProjectData);
        } else {
            LOG.assertTrue(split.myProjectData.isEmpty());
        }
        this.myAppBase.setCurrentData(split.myAppData);
        this.handleNotifications(false);
    }

    @Override
    public void startCollectingNotifications() {
        if (this.myCollectingChangesLevel == 0) {
            this.myHasAppChanges = false;
            this.myHasProjectChanges = false;
        }
        ++this.myCollectingChangesLevel;
    }

    @Override
    public void handleNotifications(boolean async) {
        --this.myCollectingChangesLevel;
        if (this.myCollectingChangesLevel == 0) {
            if (async) {
                ApplicationManager.getApplication().invokeLater(() -> this.t());
            } else {
                this.t();
            }
        }
    }

    private void t() {
        if (this.myCollectingChangesLevel == 0) {
            if (this.myHasAppChanges) {
                this.t(true);
            } else if (this.myHasProjectChanges) {
                this.t(false);
            }
            this.myHasAppChanges = false;
            this.myHasProjectChanges = false;
        }
    }

    private void t(boolean bl) {
        MessageBus messageBus = bl ? ApplicationManager.getApplication().getMessageBus() : this.t();
        ((SshConfigManager.Listener)messageBus.syncPublisher(SSH_CONFIGS)).sshConfigsChanged();
    }

    @Override
    public void applyData(@NotNull List<SshUiData> data, @Nullable SshConfigManager.Listener source) {
        if (data == null) {
            SshConfigManagerImpl.n(6);
        }
        this.startCollectingNotifications();
        Split split = new Split(data);
        if (this.myProjectBase != null) {
            this.myProjectBase.applyData(split.myProjectData);
        } else {
            LOG.assertTrue(split.myProjectData.isEmpty());
        }
        this.myAppBase.applyData(split.myAppData);
        this.handleNotifications(false);
    }

    @Override
    public void disposeCurrentData() {
        this.startCollectingNotifications();
        if (this.myProjectBase != null) {
            this.myProjectBase.applyLastSavedData();
        }
        this.myAppBase.applyLastSavedData();
        this.handleNotifications(false);
    }

    private void t(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            SshConfigManagerImpl.n(7);
        }
        this.startCollectingNotifications();
        if (sshUiData.getConfig().isProjectLevel()) {
            LOG.assertTrue(this.myProjectBase != null);
            this.myProjectBase.addToSavedAndCurrent(sshUiData);
        } else {
            this.myAppBase.addToSavedAndCurrent(sshUiData);
        }
        sshUiData.saveAuthDataToPasswordSafe();
        this.handleNotifications(false);
    }

    @Override
    @NotNull
    public SshUiData moveDataConfig(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.n(8);
        }
        LOG.assertTrue(this.myProjectBase != null);
        this.startCollectingNotifications();
        if (data.getConfig().isProjectLevel()) {
            this.myProjectBase.removeFromSavedAndCurrent(data);
            this.myAppBase.addToSavedAndCurrent(data);
        } else {
            this.myProjectBase.addToSavedAndCurrent(data);
            this.myAppBase.removeFromSavedAndCurrent(data);
        }
        data.getConfig().setProjectLevel(!data.getConfig().isProjectLevel());
        this.handleNotifications(false);
        SshUiData sshUiData = data;
        if (sshUiData == null) {
            SshConfigManagerImpl.n(9);
        }
        return sshUiData;
    }

    @Override
    @Nullable
    public SshUiData findCurrentDataByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        SshUiData sshUiData = null;
        if (this.myProjectBase != null) {
            sshUiData = this.myProjectBase.findCurrentByDataName(name);
        }
        if (sshUiData == null) {
            sshUiData = this.myAppBase.findCurrentByDataName(name);
        }
        return sshUiData;
    }

    @Override
    @Nullable
    public SshUiData findCurrentData(PresentableId id) {
        if (id == null) {
            return null;
        }
        SshUiData sshUiData = null;
        if (this.myProjectBase != null) {
            sshUiData = this.myProjectBase.findCurrentByData(id);
        }
        if (sshUiData == null) {
            sshUiData = this.myAppBase.findCurrentByData(id);
        }
        return sshUiData;
    }

    @Override
    @Nullable
    public SshUiData findCurrentDataById(@Nullable String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        SshUiData sshUiData = null;
        if (this.myProjectBase != null) {
            sshUiData = this.myProjectBase.findCurrentByDataId(id);
        }
        if (sshUiData == null) {
            sshUiData = this.myAppBase.findCurrentByDataId(id);
        }
        return sshUiData;
    }

    @Override
    @NotNull
    public SshConfig register(boolean isProjectLevel, @Nullable String host, @Nullable String literalPort, @Nullable String username, AuthType authType, @Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase, @Nullable String keyPath, @Nullable String customName) {
        SshConfig sshConfig = this.t(isProjectLevel, host, literalPort, username, authType, password, passphrase, savePassword, savePassphrase, true, keyPath, customName).getConfig();
        if (sshConfig == null) {
            SshConfigManagerImpl.n(10);
        }
        return sshConfig;
    }

    @Override
    @NotNull
    public SshConfig register(boolean isProjectLevel, @Nullable String host, @Nullable String literalPort, @Nullable String username, AuthType authType, @Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase, boolean useOpenSSHConfig, @Nullable String keyPath, @Nullable String customName) {
        SshConfig sshConfig = this.t(isProjectLevel, host, literalPort, username, authType, password, passphrase, savePassword, savePassphrase, useOpenSSHConfig, keyPath, customName).getConfig();
        if (sshConfig == null) {
            SshConfigManagerImpl.n(11);
        }
        return sshConfig;
    }

    @Override
    @NotNull
    public SshUiData register(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.n(12);
        }
        return this.t(data.getConfig().isProjectLevel(), data.getHost(), data.getLiteralPort(), data.getUserName(), data.getAuthType(), data.getPassword(), data.getPassphrase(), data.isStorePassword(), data.isStorePassphrase(), data.isOpenSshConfigUsageForced(), data.getPrivateKeyFile(), data.getConfig().getCustomName());
    }

    @NotNull
    private SshUiData t(boolean bl, @Nullable String string, @Nullable String string2, @Nullable String string3, AuthType authType, @Nullable String string4, @Nullable String string5, boolean bl2, boolean bl3, boolean bl4, @Nullable String string6, @Nullable String string7) {
        Cloneable cloneable;
        if (bl && this.myProjectBase == null) {
            throw new IllegalStateException("Use project service for project-level configs");
        }
        SshConfig.AuthData authData = SshConfig.AuthData.create(string4, string5, bl2, bl3);
        if (SshConfigManagerImpl.t(string, string2)) {
            cloneable = null;
            if (bl) {
                cloneable = this.myProjectBase.findExistingData(string, string2, string3, authType);
            }
            if (cloneable == null) {
                cloneable = this.myAppBase.findExistingData(string, string2, string3, authType);
            }
            if (cloneable != null) {
                String string8 = ((SshUiData)cloneable).getPrivateKeyFile();
                ((SshUiData)cloneable).getConfig().mergeKeyPath(string6);
                boolean bl5 = Objects.equals(string8, ((SshUiData)cloneable).getPrivateKeyFile());
                boolean bl6 = Objects.equals(string6, ((SshUiData)cloneable).getPrivateKeyFile());
                ((SshUiData)cloneable).mergeAndSaveAuthData(authData, bl5, bl6);
                ((SshUiData)cloneable).getConfig().mergeCustomName(string7);
                Cloneable cloneable2 = cloneable;
                if (cloneable2 == null) {
                    SshConfigManagerImpl.n(13);
                }
                return cloneable2;
            }
        }
        cloneable = SshConfig.create(bl, string, 0, string3, authType, string6);
        ((SshConfig)cloneable).setLiteralPort(string2);
        ((SshConfig)cloneable).setOpenSshConfigUsageForced(bl4);
        SshUiData sshUiData = new SshUiData((SshConfig)cloneable, authData);
        this.t(sshUiData);
        ((SshConfig)cloneable).setCustomName(string7);
        SshUiData sshUiData2 = sshUiData;
        if (sshUiData2 == null) {
            SshConfigManagerImpl.n(14);
        }
        return sshUiData2;
    }

    @Override
    @Nullable
    public SshConfig getConfigFromInitialMappingNameToId(@NotNull String initialName) {
        if (initialName == null) {
            SshConfigManagerImpl.n(15);
        }
        String string = null;
        if (this.myProjectBase != null) {
            string = this.myProjectBase.getIdFromInitialName(initialName);
        }
        if (string == null) {
            string = this.myAppBase.getIdFromInitialName(initialName);
        }
        if (string == null) {
            return null;
        }
        return this.findConfigById(string);
    }

    @Override
    public boolean isPassphraseMayBeRequired(String privateKeyPath) {
        return Ssh.isPassphraseMayBeRequired(privateKeyPath, SshBackendLibrary.get());
    }

    public void dispose() {
        this.myAppBase.removeChangeListener(this.myAppListener);
        this.myAppListener = null;
        if (this.myProjectBase != null) {
            this.myProjectBase.removeChangeListener(this.myProjectListener);
            this.myProjectListener = null;
        }
    }

    private static boolean t(@Nullable String string, @Nullable String string2) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        if (StringUtil.isEmpty((String)string2)) {
            return false;
        }
        return SshConfig.parseSshPort(string2) > -1;
    }

    @Override
    @Nullable
    public SshConfig findConfigByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        @Nullable SshUiData sshUiData = this.findCurrentDataByName(name);
        return sshUiData == null ? null : sshUiData.getConfig();
    }

    @Override
    @Nullable
    public SshConfig findConfigById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        @Nullable SshUiData sshUiData = this.findCurrentDataById(id);
        return sshUiData == null ? null : sshUiData.getConfig();
    }

    @Override
    @Nullable
    public SshConfig findConfig(@Nullable PresentableId id) {
        SshUiData sshUiData = this.findCurrentData(id);
        return sshUiData == null ? null : sshUiData.getConfig();
    }

    private static /* synthetic */ void n(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 9, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfigManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSavedAndCurrentData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDataConfig";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "registerData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeDataConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDataConfig";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveDataConfig";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFromInitialMappingNameToId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 9, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static final class Split {
        private final List<SshUiData> myProjectData;
        private final List<SshUiData> myAppData;

        private Split(@NotNull List<SshUiData> data) {
            if (data == null) {
                Split.t(0);
            }
            this.myProjectData = new ArrayList<SshUiData>();
            this.myAppData = new ArrayList<SshUiData>();
            for (SshUiData sshUiData : data) {
                if (sshUiData.getConfig().isProjectLevel()) {
                    this.myProjectData.add(sshUiData);
                    continue;
                }
                this.myAppData.add(sshUiData);
            }
        }

        private static /* synthetic */ void t(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$Split", "<init>"));
        }
    }

    public static final class AppLevel
    extends SshConfigManagerImpl {
        public AppLevel() {
            super(null);
        }
    }

    public static final class ProjectLevel
    extends SshConfigManagerImpl {
        public ProjectLevel(@NotNull Project project) {
            if (project == null) {
                ProjectLevel.q(0);
            }
            super(project);
        }

        private static /* synthetic */ void q(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ssh/config/unified/SshConfigManagerImpl$ProjectLevel", "<init>"));
        }
    }
}

