/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.ui.ApplicationOnlySdkScopeController;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.NonSpecifiedRemoteConnector;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.remotesdk.console.SshConfigConnector;
import com.jetbrains.plugins.remotesdk.ui.SshConfigProjectLevelSetupForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionSettingsForm {
    private Map<RemoteConnectionType, JRadioButton> myAdditionalConnectors;
    private ComboBox<RemoteConnector> myConfigsCombo;
    private JRadioButton mySshConfig;
    private JPanel myMainPanel;
    private LinkLabel<?> mySshConfigsLink;
    private JPanel myAdditionalConnectorsPlaceholder;
    private SshConfigProjectLevelSetupForm mySshConfigSetupForm;
    @Nullable
    private final Project myProject;
    private boolean myShowConfigSettingsLink = false;
    private final boolean mySuggestConfigsFromOpenProjects;
    private final Disposable myParentDisposable;
    private final ButtonGroup myButtonGroup;

    public RemoteConnectionSettingsForm(@Nullable Project project, Disposable parentDisposable) {
        this(project, parentDisposable, false);
    }

    public RemoteConnectionSettingsForm(Disposable parentDisposable, boolean suggestConfigsFromOpenProjects) {
        this(null, parentDisposable, suggestConfigsFromOpenProjects);
    }

    @Contract(value="!null,_,true->fail")
    private RemoteConnectionSettingsForm(@Nullable Project project, Disposable parentDisposable, boolean suggestConfigsFromOpenProjects) {
        this.$$$setupUI$$$();
        this.myButtonGroup = new ButtonGroup();
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.mySuggestConfigsFromOpenProjects = suggestConfigsFromOpenProjects;
        assert (project == null || !suggestConfigsFromOpenProjects);
    }

    public JComponent createPanel() {
        MutableCollectionComboBoxModel model = new MutableCollectionComboBoxModel(RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestConfigsFromOpenProjects));
        ApplicationManager.getApplication().getMessageBus().connect(this.myParentDisposable).subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                RemoteConnectionSettingsForm.this.updateComboBox(null);
            }
        });
        this.myConfigsCombo.setModel((ComboBoxModel)model);
        this.myConfigsCombo.setSelectedItem(model.getSize() > 0 ? model.getElementAt(0) : null);
        this.myConfigsCombo.setRenderer(BuilderKt.textListCellRenderer((String)RemoteSdkBundle.message("none.combobox.placeholder", new Object[0]), RemoteConnector::getName));
        this.mySshConfigSetupForm.getMainPanel().setVisible(false);
        if (this.myProject == null && this.mySuggestConfigsFromOpenProjects) {
            this.mySshConfig.addItemListener(e -> this.updateSshConfigSetupForm());
            this.myConfigsCombo.addItemListener(e -> this.updateSshConfigSetupForm());
        }
        if (this.myShowConfigSettingsLink) {
            this.mySshConfigsLink.setIcon(null);
            this.mySshConfigsLink.setListener((source, data) -> {
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
                if (settings != null) {
                    settings.select(settings.find("ssh.settings"));
                }
            }, null);
        } else {
            this.mySshConfigsLink.setVisible(false);
        }
        this.myButtonGroup.add(this.mySshConfig);
        for (JRadioButton button : this.myAdditionalConnectors.values()) {
            this.myButtonGroup.add(button);
        }
        SshConnectionProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SshConnectionProvider>(){

            public void extensionAdded(@NotNull SshConnectionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                JRadioButton button = new JRadioButton(extension.getRadioButtonDescription());
                RemoteConnectionSettingsForm.this.myAdditionalConnectors.put(extension.getTypeForConfigurable(), button);
                RemoteConnectionSettingsForm.this.myAdditionalConnectorsPlaceholder.add(button);
                RemoteConnectionSettingsForm.this.myButtonGroup.add(button);
                RemoteConnectionSettingsForm.this.myAdditionalConnectorsPlaceholder.setVisible(true);
            }

            public void extensionRemoved(@NotNull SshConnectionProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                JRadioButton button;
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((button = RemoteConnectionSettingsForm.this.myAdditionalConnectors.remove(extension.getTypeForConfigurable())) == null) {
                    return;
                }
                RemoteConnectionSettingsForm.this.myButtonGroup.remove(button);
                RemoteConnectionSettingsForm.this.myAdditionalConnectorsPlaceholder.remove(button);
                if (RemoteConnectionSettingsForm.this.myAdditionalConnectors.isEmpty()) {
                    RemoteConnectionSettingsForm.this.myAdditionalConnectorsPlaceholder.setVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myParentDisposable);
        return this.myMainPanel;
    }

    private void updateComboBox(@Nullable SshConfig configToSelect) {
        List<RemoteConnector> items = RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestConfigsFromOpenProjects);
        ((MutableCollectionComboBoxModel)this.myConfigsCombo.getModel()).update(items);
        if (configToSelect != null) {
            for (RemoteConnector item : items) {
                if (item.getType() != RemoteConnectionType.SSH_CONFIG || !StringUtil.equals((CharSequence)configToSelect.getId(), (CharSequence)item.getAdditionalData())) continue;
                this.myConfigsCombo.setSelectedItem((Object)item);
                return;
            }
            for (RemoteConnector item : items) {
                if (item.getType() != RemoteConnectionType.SSH_CONFIG || !StringUtil.equals((CharSequence)configToSelect.getName(), (CharSequence)item.getId())) continue;
                this.myConfigsCombo.setSelectedItem((Object)item);
                return;
            }
        }
    }

    private void updateSshConfigSetupForm() {
        Object item;
        boolean visible = false;
        if (this.mySshConfig.isSelected() && (item = this.myConfigsCombo.getSelectedItem()) instanceof RemoteConnector && ((RemoteConnector)item).getType() == RemoteConnectionType.SSH_CONFIG) {
            String additionalData;
            String id = ((RemoteConnector)item).getId();
            SshConfigManager instance = SshConfigManager.getInstance(null);
            SshConfig config = instance.findConfigById(additionalData = ((RemoteConnector)item).getAdditionalData());
            if (config == null) {
                config = instance.findConfigByName(id);
            }
            if (config == null) {
                visible = true;
                this.mySshConfigSetupForm.setProject(null);
                this.mySshConfigSetupForm.setSshConfigName(id);
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    SshConfigManager configManager = SshConfigManager.getInstance((Project)project);
                    config = configManager.findConfigById(additionalData);
                    if (config == null) {
                        config = configManager.findConfigByName(id);
                    }
                    if (config == null) continue;
                    this.mySshConfigSetupForm.setProject(project);
                    break;
                }
            }
        }
        this.mySshConfigSetupForm.getMainPanel().setVisible(visible);
    }

    @Nullable
    public ValidationInfo doValidate() {
        if (this.mySshConfigSetupForm.getMainPanel().isVisible()) {
            return new ValidationInfo(RemoteSdkBundle.message("dialog.message.selected.config.project.level.please.move.it.to.ide.level", new Object[0]), this.myConfigsCombo);
        }
        return null;
    }

    public void setConnectionTypeAndId(@Nullable RemoteConnectionType type, @Nullable String id) {
        if (type == null || type == RemoteConnectionType.NONE) {
            this.mySshConfig.setSelected(true);
            this.setConnectorSelectionById(type, NonSpecifiedRemoteConnector.ID);
            return;
        }
        JRadioButton radioButton = this.myAdditionalConnectors.get(type);
        if (radioButton != null) {
            radioButton.setSelected(true);
            return;
        }
        this.mySshConfig.setSelected(true);
        this.setConnectorSelectionById(type, id);
    }

    private void setConnectorSelectionById(@Nullable RemoteConnectionType type, @Nullable String id) {
        List<RemoteConnector> connectors = RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestConfigsFromOpenProjects);
        for (int i = 0; i < connectors.size(); ++i) {
            RemoteConnector c = connectors.get(i);
            if (type != c.getType() || (id != null || c.getId() != null) && (id == null || !id.equals(c.getId()))) continue;
            this.myConfigsCombo.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    private RemoteConnector getSelected() {
        Object o = this.myConfigsCombo.getSelectedItem();
        if (o instanceof RemoteConnector) {
            return (RemoteConnector)o;
        }
        return null;
    }

    @NotNull
    public RemoteConnectionType getConnectionType() {
        RemoteConnector connector;
        if (this.mySshConfig.isSelected() && (connector = this.getSelected()) != null) {
            RemoteConnectionType remoteConnectionType = connector.getType();
            if (remoteConnectionType == null) {
                RemoteConnectionSettingsForm.$$$reportNull$$$0(0);
            }
            return remoteConnectionType;
        }
        for (Map.Entry<RemoteConnectionType, JRadioButton> entry : this.myAdditionalConnectors.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            RemoteConnectionType remoteConnectionType = entry.getKey();
            if (remoteConnectionType == null) {
                RemoteConnectionSettingsForm.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.NONE;
        if (remoteConnectionType == null) {
            RemoteConnectionSettingsForm.$$$reportNull$$$0(2);
        }
        return remoteConnectionType;
    }

    public String getConnectionId() {
        RemoteConnector connector;
        if (this.mySshConfig.isSelected() && (connector = this.getSelected()) != null) {
            return connector.getId();
        }
        return "";
    }

    public String getAdditionalData() {
        RemoteConnector connector;
        if (this.mySshConfig.isSelected() && (connector = this.getSelected()) != null) {
            return connector.getAdditionalData();
        }
        return null;
    }

    private static List<RemoteConnector> collectConnectionVariants(@Nullable Project project, boolean suggestConfigsFromOpenProjects) {
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        result.add(NonSpecifiedRemoteConnector.INSTANCE);
        result.addAll(RemoteConnectionUtil.getAllRemoteConnectors(project));
        if (project == null && suggestConfigsFromOpenProjects) {
            for (Project otherProject : ProjectManager.getInstance().getOpenProjects()) {
                for (SshConfig config : RemoteSdkUtil.getSshConfigList(otherProject)) {
                    if (!config.isProjectLevel()) continue;
                    result.add(new SshConfigConnector(config));
                }
            }
        }
        return result;
    }

    public void setShowConfigSettingsLink(boolean showConfigSettingsLink) {
        this.myShowConfigSettingsLink = showConfigSettingsLink;
    }

    private void createUIComponents() {
        this.myAdditionalConnectorsPlaceholder = new JPanel();
        SshConnectionProvider[] extensions = (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions();
        int number = extensions.length;
        this.myAdditionalConnectors = new HashMap<RemoteConnectionType, JRadioButton>();
        if (number > 0) {
            this.myAdditionalConnectorsPlaceholder.setLayout(new BoxLayout(this.myAdditionalConnectorsPlaceholder, 1));
            for (SshConnectionProvider provider : extensions) {
                JRadioButton button = new JRadioButton(provider.getRadioButtonDescription());
                this.myAdditionalConnectors.put(provider.getTypeForConfigurable(), button);
                this.myAdditionalConnectorsPlaceholder.add(button);
            }
        } else {
            this.myAdditionalConnectorsPlaceholder.setVisible(false);
        }
        this.mySshConfigSetupForm = new SshConfigProjectLevelSetupForm(null, null, new SshConfigProjectLevelSetupForm.Listener(){

            @Override
            public void onConfigMoved(@NotNull SshConfig movedConfig) {
                if (movedConfig == null) {
                    3.$$$reportNull$$$0(0);
                }
                RemoteConnectionSettingsForm.this.updateComboBox(movedConfig);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "movedConfig", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$3", "onConfigMoved"));
            }
        }, (SdkScopeController)ApplicationOnlySdkScopeController.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm", "getConnectionType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LinkLabel linkLabel;
        ComboBox comboBox;
        JRadioButton jRadioButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteConnectionSettingsForm.class).getString("settings.connection.settings"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null, 0, true));
        SshConfigProjectLevelSetupForm sshConfigProjectLevelSetupForm = this.mySshConfigSetupForm;
        JComponent jComponent = sshConfigProjectLevelSetupForm.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel4 = this.myAdditionalConnectorsPlaceholder;
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySshConfig = jRadioButton = new JRadioButton();
        jRadioButton.setActionCommand("");
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteConnectionSettingsForm.class).getString("remote.connection.setting.ssh.config.label"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfigsCombo = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, new Dimension(40, -1), null, null));
        this.mySshConfigsLink = linkLabel = new LinkLabel();
        this.$$$loadLabelText$$$((JLabel)linkLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteConnectionSettingsForm.class).getString("remote.connection.settings.set.up.configs.action.label"));
        jPanel2.add((Component)linkLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

