/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.JpsFileObject;

@ApiStatus.Internal
public final class ZipFileObject
extends JpsFileObject {
    private final ZipFile myZip;
    private final ZipEntry myEntry;
    private final String myEncoding;

    ZipFileObject(File root, ZipFile zip, ZipEntry entry, String encoding, JavaFileManager.Location location) {
        super(ZipFileObject.createUri(root, entry.getName()), ZipFileObject.findKind(entry.getName()), location);
        this.myZip = zip;
        this.myEntry = entry;
        this.myEncoding = encoding;
    }

    @NotNull
    private static URI createUri(File zipFile, String relPath) {
        String p = zipFile.getPath().replace('\\', '/');
        StringBuilder buf = new StringBuilder(p.length() + relPath.length() + 5);
        if (!p.startsWith("/")) {
            buf.append("///");
        } else if (!p.startsWith("//")) {
            buf.append("//");
        }
        buf.append(p).append(relPath.startsWith("/") ? "!" : "!/").append(relPath);
        try {
            return new URI("jar", null, buf.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new Error("Cannot create URI " + buf, e);
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(this.myZip.getInputStream(this.myEntry));
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.myEntry.getTime();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        String name = this.myEntry.getName();
        int idx = name.lastIndexOf(".");
        return (idx < 0 ? name : name.substring(0, idx)).replace('/', '.');
    }

    @Override
    public boolean isNameCompatible(@NotNull String cn, JavaFileObject.Kind kind) {
        if (cn == null) {
            ZipFileObject.$$$reportNull$$$0(0);
        }
        if (kind == JavaFileObject.Kind.OTHER) {
            return this.getKind() == kind;
        }
        if (this.getKind() != kind) {
            return false;
        }
        String name = this.myEntry.getName();
        return name.length() == cn.length() + kind.extension.length() && name.startsWith(cn) && name.endsWith(kind.extension);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ZipFileObject && super.equals(other);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        try (InputStream in = this.openInputStream();){
            CharBuffer charBuffer;
            block12: {
                InputStreamReader reader = this.myEncoding != null ? new InputStreamReader(in, this.myEncoding) : new InputStreamReader(in);
                try {
                    charBuffer = CharBuffer.wrap(ZipFileObject.loadText(reader, (int)this.myEntry.getSize()));
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return charBuffer;
        }
    }

    private static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        if (reader == null) {
            ZipFileObject.$$$reportNull$$$0(1);
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            return chars;
        }
        return Arrays.copyOf(chars, count);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/javac/ZipFileObject";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameCompatible";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

