/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.model;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.jupyter.core.executor.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewRoot;
import com.intellij.jupyter.core.jupyter.structure.filters.JupyterStructureViewFiltersProvider;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewSelectionManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0018J\u0016\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010.2\u0006\u0010+\u001a\u00020\u0016J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0012R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "Lcom/intellij/ide/structureView/TextEditorBasedStructureViewModel;", "Lcom/intellij/ide/structureView/StructureViewModel$ElementInfoProvider;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;Lcom/intellij/openapi/editor/Editor;)V", "selectionManager", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager;", "getSelectionManager", "()Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager;", "setSelectionManager", "(Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager;)V", "executionInfo", "Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "cachedExecutingCellOrdinal", "", "Ljava/lang/Integer;", "intervalToElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "rootElement", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "getRoot", "isAlwaysShowsPlus", "", "element", "isAlwaysLeaf", "getEditor", "getSorters", "", "Lcom/intellij/ide/util/treeView/smartTree/Sorter;", "()[Lcom/intellij/ide/util/treeView/smartTree/Sorter;", "getFilters", "Lcom/intellij/ide/util/treeView/smartTree/Filter;", "()[Lcom/intellij/ide/util/treeView/smartTree/Filter;", "fireModelUpdate", "", "setIntervalToComponent", "interval", "component", "getComponentsByInterval", "", "getCellStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "ordinal", "Companion", "intellij.jupyter.core"})
public final class JupyterStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Editor editor;
    @Nullable
    private JupyterStructureViewSelectionManager selectionManager;
    @Nullable
    private final JupyterExecutionState executionInfo;
    @Nullable
    private Integer cachedExecutingCellOrdinal;
    @NotNull
    private final ConcurrentHashMap<NotebookCellLines.Interval, List<JupyterStructureViewCellElement>> intervalToElements;
    @NotNull
    private final StructureViewTreeElement rootElement;
    @NotNull
    private static final Key<JupyterStructureViewModel> JUPYTER_STRUCTURE_MODEL_KEY;

    public JupyterStructureViewModel(@NotNull JupyterFile psiFile, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        super(editor, (PsiFile)psiFile);
        Editor editor2 = this.editor = editor;
        this.executionInfo = editor2 != null ? JupyterExecutionState.Companion.getJupyterExecutionState(editor2) : null;
        this.intervalToElements = new ConcurrentHashMap();
        this.rootElement = new JupyterStructureViewRoot(psiFile, this);
    }

    @Nullable
    public final JupyterStructureViewSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public final void setSelectionManager(@Nullable JupyterStructureViewSelectionManager jupyterStructureViewSelectionManager) {
        this.selectionManager = jupyterStructureViewSelectionManager;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return this.rootElement;
    }

    public boolean isAlwaysShowsPlus(@Nullable StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(@Nullable StructureViewTreeElement element) {
        return false;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public Sorter[] getSorters() {
        Object[] objectArray = new Sorter[]{Sorter.ALPHA_SORTER};
        return (Sorter[])ArraysKt.plus((Object[])objectArray, (Object[])JupyterStructureViewFiltersProvider.Companion.getAllSorters());
    }

    @NotNull
    public Filter[] getFilters() {
        return JupyterStructureViewFiltersProvider.Companion.getAllFilters();
    }

    public void fireModelUpdate() {
        this.cachedExecutingCellOrdinal = null;
        super.fireModelUpdate();
    }

    public final boolean setIntervalToComponent(@NotNull NotebookCellLines.Interval interval, @NotNull JupyterStructureViewCellElement component2) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return this.intervalToElements.computeIfAbsent(interval, arg_0 -> JupyterStructureViewModel.setIntervalToComponent$lambda$1(JupyterStructureViewModel::setIntervalToComponent$lambda$0, arg_0)).add(component2);
    }

    @Nullable
    public final List<JupyterStructureViewCellElement> getComponentsByInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.intervalToElements.get(interval);
    }

    @NotNull
    public final ProgressStatus getCellStatus(int ordinal) {
        JupyterExecutionState jupyterExecutionState = this.executionInfo;
        if (jupyterExecutionState == null) {
            return ProgressStatus.NOT_STARTED;
        }
        JupyterExecutionState info = jupyterExecutionState;
        ProgressStatus progressStatus = info.getProgressStatus(ordinal);
        if (progressStatus == null) {
            progressStatus = ProgressStatus.NOT_STARTED;
        }
        return progressStatus;
    }

    private static final List setIntervalToComponent$lambda$0(NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List setIntervalToComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"JUPYTER_STRUCTURE_VIEW_MODEL");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_STRUCTURE_MODEL_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel$Companion;", "", "<init>", "()V", "JUPYTER_STRUCTURE_MODEL_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "getJUPYTER_STRUCTURE_MODEL_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JupyterStructureViewModel> getJUPYTER_STRUCTURE_MODEL_KEY() {
            return JUPYTER_STRUCTURE_MODEL_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

