/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.lang.LangCoreBundle;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathMappingSettings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.execution.target.GradleServerProgressIndicator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020&J2\u0010(\u001a\u00020\f2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0*2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0,H\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/TargetEnvironmentProvider;", "", "<init>", "()V", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "uploads", "Lorg/jetbrains/plugins/gradle/execution/target/TargetEnvironmentProvider$Upload;", "pathMappingSettings", "Lcom/intellij/util/PathMappingSettings;", "getPathMappingSettings", "()Lcom/intellij/util/PathMappingSettings;", "supplyEnvironmentAndRunHandlers", "targetEnvironment", "progressIndicator", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProgressIndicator;", "uploadVolumes", "upload", "Lcom/intellij/execution/target/value/TargetValue;", "", "uploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "uploadPathString", "uploadRelativePath", "requestUploadIntoTarget", "path", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "environmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "requestPort", "", "targetPort", "doWhenEnvironmentPrepared", "onCancel", "Lkotlin/Function0;", "block", "Lkotlin/Function2;", "Upload", "intellij.gradle"})
public final class TargetEnvironmentProvider {
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise = new AsyncPromise();
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise = new ArrayList();
    @NotNull
    private final List<Upload> uploads = new ArrayList();
    @NotNull
    private final PathMappingSettings pathMappingSettings = new PathMappingSettings();

    @NotNull
    public final PathMappingSettings getPathMappingSettings() {
        return this.pathMappingSettings;
    }

    public final void supplyEnvironmentAndRunHandlers(@NotNull TargetEnvironment targetEnvironment, @NotNull GradleServerProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)targetEnvironment, (Object)progressIndicator));
        for (Promise<Unit> promise : this.dependingOnEnvironmentPromise) {
            progressIndicator.checkCanceled();
            promise.blockingGet(0);
        }
        this.dependingOnEnvironmentPromise.clear();
    }

    public final void uploadVolumes(@NotNull GradleServerProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        for (Upload upload : this.uploads) {
            progressIndicator.checkCanceled();
            upload.getVolume().upload(upload.getRelativePath(), (TargetProgressIndicator)progressIndicator);
        }
        this.uploads.clear();
    }

    @NotNull
    public final TargetValue<String> upload(@NotNull TargetEnvironment.UploadRoot uploadRoot, @NotNull String uploadPathString, @NotNull String uploadRelativePath) {
        Intrinsics.checkNotNullParameter((Object)uploadRoot, (String)"uploadRoot");
        Intrinsics.checkNotNullParameter((Object)uploadPathString, (String)"uploadPathString");
        Intrinsics.checkNotNullParameter((Object)uploadRelativePath, (String)"uploadRelativePath");
        DeferredTargetValue result = new DeferredTargetValue((Object)uploadPathString);
        TargetEnvironmentProvider.doWhenEnvironmentPrepared$default(this, null, (arg_0, arg_1) -> TargetEnvironmentProvider.upload$lambda$0(uploadRoot, uploadRelativePath, result, this, uploadPathString, arg_0, arg_1), 1, null);
        return (TargetValue)result;
    }

    @NotNull
    public final TargetValue<String> requestUploadIntoTarget(@NotNull String path, @NotNull TargetEnvironmentRequest request, @NotNull TargetEnvironmentConfiguration environmentConfiguration) {
        JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration;
        Path uploadPath;
        block3: {
            Path localRootPath;
            block2: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)environmentConfiguration, (String)"environmentConfiguration");
                uploadPath = Paths.get(FileUtilRt.toSystemDependentName((String)path), new String[0]);
                localRootPath = uploadPath.getParent();
                JavaLanguageRuntimeConfiguration languageRuntime = (JavaLanguageRuntimeConfiguration)environmentConfiguration.getRuntimes().findByType(JavaLanguageRuntimeConfiguration.class);
                LanguageRuntimeType.VolumeDescriptor toolingFileOnTarget = new LanguageRuntimeType.VolumeDescriptor(new LanguageRuntimeType.VolumeType("gradleToolingFilesOnTarget"), "", "", "", "", null, 32, null);
                javaLanguageRuntimeConfiguration = languageRuntime;
                if (javaLanguageRuntimeConfiguration == null) break block2;
                Intrinsics.checkNotNull((Object)localRootPath);
                if ((javaLanguageRuntimeConfiguration = javaLanguageRuntimeConfiguration.createUploadRoot(toolingFileOnTarget, localRootPath)) != null) break block3;
            }
            Intrinsics.checkNotNull((Object)localRootPath);
            javaLanguageRuntimeConfiguration = new TargetEnvironment.UploadRoot(localRootPath, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
        }
        JavaLanguageRuntimeConfiguration uploadRoot = javaLanguageRuntimeConfiguration;
        ((Collection)request.getUploadVolumes()).add(uploadRoot);
        DeferredTargetValue result = new DeferredTargetValue((Object)path);
        this.doWhenEnvironmentPrepared((Function0<Unit>)((Function0)new Function0<Unit>((Object)result){

            public final void invoke() {
                ((DeferredTargetValue)this.receiver).stopProceeding();
            }
        }), (Function2<? super TargetEnvironment, ? super TargetProgressIndicator, Unit>)((Function2)(arg_0, arg_1) -> TargetEnvironmentProvider.requestUploadIntoTarget$lambda$0((TargetEnvironment.UploadRoot)uploadRoot, uploadPath, this, result, arg_0, arg_1)));
        return (TargetValue)result;
    }

    @NotNull
    public final TargetValue<Integer> requestPort(@NotNull TargetEnvironmentRequest request, int targetPort) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TargetEnvironment.TargetPortBinding binding = new TargetEnvironment.TargetPortBinding(null, targetPort);
        request.getTargetPortBindings().add(binding);
        DeferredLocalTargetValue result = new DeferredLocalTargetValue((Object)targetPort);
        TargetEnvironmentProvider.doWhenEnvironmentPrepared$default(this, null, (arg_0, arg_1) -> TargetEnvironmentProvider.requestPort$lambda$0(binding, result, arg_0, arg_1), 1, null);
        return (TargetValue)result;
    }

    private final void doWhenEnvironmentPrepared(Function0<Unit> onCancel, Function2<? super TargetEnvironment, ? super TargetProgressIndicator, Unit> block) {
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> TargetEnvironmentProvider.doWhenEnvironmentPrepared$lambda$2(arg_0 -> TargetEnvironmentProvider.doWhenEnvironmentPrepared$lambda$1(onCancel, block, arg_0), arg_0)));
    }

    static /* synthetic */ void doWhenEnvironmentPrepared$default(TargetEnvironmentProvider targetEnvironmentProvider, Function0 function0, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = TargetEnvironmentProvider::doWhenEnvironmentPrepared$lambda$0;
        }
        targetEnvironmentProvider.doWhenEnvironmentPrepared((Function0<Unit>)function0, (Function2<? super TargetEnvironment, ? super TargetProgressIndicator, Unit>)function2);
    }

    private static final Unit upload$lambda$0(TargetEnvironment.UploadRoot $uploadRoot, String $uploadRelativePath, DeferredTargetValue $result, TargetEnvironmentProvider this$0, String $uploadPathString, TargetEnvironment environment, TargetProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        String resolvedTargetPath = volume.resolveTargetPath($uploadRelativePath);
        volume.upload($uploadRelativePath, progress);
        $result.resolve((Object)resolvedTargetPath);
        this$0.pathMappingSettings.addMapping($uploadPathString, resolvedTargetPath);
        return Unit.INSTANCE;
    }

    private static final Unit requestUploadIntoTarget$lambda$0(TargetEnvironment.UploadRoot $uploadRoot, Path $uploadPath, TargetEnvironmentProvider this$0, DeferredTargetValue $result, TargetEnvironment environment, TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        try {
            String relativePath = ((Object)$uploadPath.getFileName()).toString();
            String resolvedTargetPath = volume.resolveTargetPath(relativePath);
            this$0.uploads.add(new Upload(volume, relativePath));
            $result.resolve((Object)resolvedTargetPath);
        }
        catch (Throwable t) {
            Object[] objectArray = new Object[]{volume.getLocalRoot(), t.getLocalizedMessage()};
            targetProgressIndicator.stopWithErrorMessage(LangCoreBundle.message((String)"progress.message.failed.to.resolve.0.1", (Object[])objectArray));
            $result.resolveFailure(t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit requestPort$lambda$0(TargetEnvironment.TargetPortBinding $binding, DeferredLocalTargetValue $result, TargetEnvironment environment, TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"<unused var>");
        ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getTargetPortBindings().get($binding);
        Integer localPort = resolvedPortBinding != null && (resolvedPortBinding = resolvedPortBinding.getLocalEndpoint()) != null ? Integer.valueOf(resolvedPortBinding.getPort()) : null;
        $result.resolve((Object)localPort);
        return Unit.INSTANCE;
    }

    private static final Unit doWhenEnvironmentPrepared$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit doWhenEnvironmentPrepared$lambda$1(Function0 $onCancel, Function2 $block, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator progress = (TargetProgressIndicator)pair.component2();
        if (progress.isCanceled() || progress.isStopped()) {
            $onCancel.invoke();
        } else {
            $block.invoke((Object)environment, (Object)progress);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doWhenEnvironmentPrepared$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/TargetEnvironmentProvider$Upload;", "", "volume", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "relativePath", "", "<init>", "(Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;Ljava/lang/String;)V", "getVolume", "()Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "getRelativePath", "()Ljava/lang/String;", "intellij.gradle"})
    private static final class Upload {
        @NotNull
        private final TargetEnvironment.UploadableVolume volume;
        @NotNull
        private final String relativePath;

        public Upload(@NotNull TargetEnvironment.UploadableVolume volume, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.volume = volume;
            this.relativePath = relativePath;
        }

        @NotNull
        public final TargetEnvironment.UploadableVolume getVolume() {
            return this.volume;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }
    }
}

