/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.AddInnerRequireAmdModuleToModulesListFix;
import com.intellij.lang.javascript.modules.AddRequiredAmdModuleToModulesListFix;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmdJsModulesSuggester
implements JsModulesSuggester {
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    @NotNull
    private final JSAmdUtil.AmdLoaderCall myWrappingAmdLoaderCall;
    @NotNull
    private final Set<VirtualFile> myPredefinedFiles;
    private static final TokenSet CALL_EXPRESSIONS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.CALL_EXPRESSION});

    public AmdJsModulesSuggester(@NotNull ModuleReferenceInfo info, @NotNull PsiElement node, @NotNull JSAmdUtil.AmdLoaderCall amdLoaderCall) {
        if (info == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(0);
        }
        if (node == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(1);
        }
        if (amdLoaderCall == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(2);
        }
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myPredefinedFiles = JsModulesSuggester.getPredefinedLibraries(node);
        this.myWrappingAmdLoaderCall = amdLoaderCall;
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result2) {
        if (result2 == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(3);
        }
        return result2 instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)result2).getNamespace() == null;
    }

    @Override
    @NotNull
    public List<LocalQuickFix> findFixes(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(4);
        }
        ArrayList<LocalQuickFix> firstWordFixes = new ArrayList<LocalQuickFix>();
        if (this.myModuleReferenceInfo.getParentName() != null) {
            firstWordFixes.addAll(this.findVariantsForMethods());
        } else {
            firstWordFixes.addAll(this.findVariantsByName());
        }
        ArrayList<LocalQuickFix> arrayList = firstWordFixes;
        if (arrayList == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getMessage(@NotNull Collection<LocalQuickFix> fixes) {
        if (fixes == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(6);
        }
        return JavaScriptBundle.message((String)"js.inspection.missing.amd.dependency", (Object[])new Object[0]);
    }

    private Collection<LocalQuickFix> findVariantsByName() {
        PsiFile[] filesByName = FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(this.myNode.getText() + ".js"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myNode.getProject()));
        if (filesByName.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        for (PsiFile file : filesByName) {
            PsiElement[] possible;
            if (!file.isValid() || this.myNode.getContainingFile().equals((Object)file) || !(file instanceof JSFile)) continue;
            for (PsiElement expression : possible = JSStubBasedPsiTreeUtil.getChildrenByType((PsiElement)file, (TokenSet)CALL_EXPRESSIONS_TOKEN_SET)) {
                LocalQuickFix fix;
                if (!(expression instanceof JSCallExpression) || !((JSCallExpression)expression).isDefineCall() || (fix = this.getFixForElementInFile(expression, JSAmdPsiUtil.getExplicitModuleName((JSCallExpression)((JSCallExpression)expression)), file)) == null) continue;
                fixes.add(fix);
            }
        }
        return fixes;
    }

    private Collection<LocalQuickFix> findVariantsForMethods() {
        Collection<PsiElement> results = this.myModuleReferenceInfo.getResolvedParent();
        if (results.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        for (PsiElement resolvedElement : results) {
            LocalQuickFix fix;
            Pair<Boolean, String> pair;
            PsiFile resolveFile = resolvedElement.getContainingFile();
            if (resolveFile.equals((Object)this.myNode.getContainingFile()) || !Boolean.TRUE.equals((pair = JSAmdUtil.isFromAmdModuleReturn(resolvedElement)).getFirst()) || (fix = this.getFixForElementInFile(resolvedElement, (String)pair.getSecond(), resolveFile)) == null) continue;
            fixes.add(fix);
        }
        return fixes;
    }

    private LocalQuickFix getFixForElementInFile(PsiElement resolvedElement, @Nullable String moduleId, PsiFile resolveFile) {
        boolean isSingleQuotes;
        if (this.myPredefinedFiles.contains(resolvedElement.getContainingFile().getVirtualFile())) {
            return null;
        }
        String reference = moduleId != null ? moduleId : this.clarifyModuleReference(resolvedElement, resolveFile, resolveFile.getVirtualFile().getNameWithoutExtension());
        boolean bl = isSingleQuotes = !JSCodeStyleSettings.getSettings((PsiElement)this.myNode).USE_DOUBLE_QUOTES;
        if (this.myWrappingAmdLoaderCall.isDefinesModule() && this.myWrappingAmdLoaderCall.getRequireSugaredParameter() != null && this.myWrappingAmdLoaderCall.getModulesArray() == null) {
            return new AddInnerRequireAmdModuleToModulesListFix(this.myWrappingAmdLoaderCall.getRequireSugaredParameter().getText(), this.myWrappingAmdLoaderCall.wrapInPointers(), reference, this.myModuleReferenceInfo.getContextName(), isSingleQuotes);
        }
        return new AddRequiredAmdModuleToModulesListFix(this.myWrappingAmdLoaderCall.wrapInPointers(), reference, this.myModuleReferenceInfo.getContextName(), isSingleQuotes);
    }

    private String clarifyModuleReference(PsiElement resolvedElement, PsiFile resolveFile, String reference) {
        if (Comparing.equal((Object)this.myNode.getContainingFile().getVirtualFile().getParent(), (Object)resolveFile.getVirtualFile().getParent())) {
            reference = "./" + (String)reference;
        } else {
            VirtualFile base = this.findPossibleModuleBase(resolvedElement, this.myNode.getContainingFile().getVirtualFile());
            if (base != null) {
                Object variant;
                String aliasedVariant = JSAmdUtil.correctPathWithAliases(resolvedElement);
                if (aliasedVariant != null) {
                    variant = aliasedVariant;
                } else {
                    variant = AmdJsModulesSuggester.betterRelativeFile(resolveFile.getVirtualFile(), base, '/');
                    if (variant != null && (((String)variant).startsWith("../") || ((String)variant).startsWith("./") || ((String)variant).startsWith("/"))) {
                        variant = base.getName() + "/" + (String)variant;
                    }
                }
                reference = variant != null ? AmdJsModulesSuggester.cutExtension(resolveFile.getName(), (String)variant) : reference;
            }
        }
        return reference;
    }

    private static String cutExtension(String original, String relative) {
        int idx;
        if (original.contains(".") && (idx = relative.lastIndexOf(46)) > 0) {
            return relative.substring(0, idx);
        }
        return relative;
    }

    public VirtualFile findPossibleModuleBase(PsiElement resolved, @NotNull VirtualFile nodeFile) {
        if (nodeFile == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(7);
        }
        VirtualFile file = resolved.getContainingFile().getVirtualFile();
        ArrayList<VirtualFile> matches = new ArrayList<VirtualFile>(JSAmdUtil.getBaseDirectories(resolved));
        if (matches.size() > 1) {
            matches.sort((o1, o2) -> {
                String rel1 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)o1);
                String rel2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)o2);
                if (rel1 == null) {
                    return -1;
                }
                if (rel2 == null) {
                    return 1;
                }
                return Integer.compare(rel1.split("/").length, rel2.split("/").length);
            });
            return (VirtualFile)matches.get(0);
        }
        if (matches.size() == 1) {
            return (VirtualFile)matches.get(0);
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file);
        if (nodeModulesDir != null && NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir) == null) {
            return nodeModulesDir;
        }
        return nodeFile;
    }

    @Nullable
    private static String betterRelativeFile(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        String path2;
        if (file == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(8);
        }
        if (ancestor == null) {
            AmdJsModulesSuggester.$$$reportNull$$$0(9);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)ancestor, (char)separator)) != null) {
            return path2;
        }
        if (ancestor.getParent() != null) {
            String part = AmdJsModulesSuggester.betterRelativeFile(file, ancestor.getParent(), separator);
            return "../" + part;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdLoaderCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/AmdJsModulesSuggester";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/AmdJsModulesSuggester";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGlobally";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFixes";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleModuleBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "betterRelativeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

