/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.css.resolve.StylesheetFileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.tailwind.util.TailwindUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TailwindImportReferenceContributor
extends PsiReferenceContributor {
    private static final String[] TAILWIND_IMPORTS_WITH_QUOTES = new String[]{"\"tailwindcss/base\"", "'tailwindcss/base'", "\"tailwindcss/components\"", "'tailwindcss/components'", "\"tailwindcss/utilities\"", "'tailwindcss/utilities'", "\"tailwindcss/screens\"", "'tailwindcss/screens'"};

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TailwindImportReferenceContributor.$$$reportNull$$$0(0);
        }
        double priority = 100.0;
        PsiElementPattern.Capture pattern = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(CssString.class).withParent(CssImport.class)).withText((ElementPattern)StandardPatterns.string().oneOf(TAILWIND_IMPORTS_WITH_QUOTES));
        registrar.registerReferenceProvider((ElementPattern)pattern, new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof CssString)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = element.getText();
                if (!ArrayUtil.contains((String)text, (String[])TAILWIND_IMPORTS_WITH_QUOTES)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                TailwindImportFileReferenceSet referenceSet = new TailwindImportFileReferenceSet(element);
                FileReference[] fileReferenceArray = referenceSet.getAllReferences();
                if (fileReferenceArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tailwind/references/TailwindImportReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tailwind/references/TailwindImportReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        }, 100.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/tailwind/references/TailwindImportReferenceContributor", "registerReferenceProviders"));
    }

    private static class TailwindImportFileReferenceSet
    extends StylesheetFileReferenceSet {
        private TailwindImportFileReferenceSet(@NotNull PsiElement element) {
            if (element == null) {
                TailwindImportFileReferenceSet.$$$reportNull$$$0(0);
            }
            super(element, ((CssString)element).getValue(), TextRange.create((int)1, (int)(element.getTextLength() - 1)), new FileType[0]);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiFile psiFile = this.getContainingFile();
            VirtualFile contextFile = psiFile != null ? psiFile.getVirtualFile() : null;
            VirtualFile packageDir = contextFile != null ? TailwindUtil.getTailwindCssPackageDir(psiFile.getProject(), contextFile) : null;
            VirtualFile parentDir = packageDir != null ? packageDir.getParent() : null;
            PsiDirectory parentPsiDir = parentDir != null ? this.getElement().getManager().findDirectory(parentDir) : null;
            List list = ContainerUtil.createMaybeSingletonList(parentPsiDir);
            if (list == null) {
                TailwindImportFileReferenceSet.$$$reportNull$$$0(1);
            }
            return list;
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            return new StylesheetFileReference(this, (FileReferenceSet)this, range, index, text){

                protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result, boolean caseSensitive) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (this.isLast() && ArrayUtil.contains((String)text, (String[])new String[]{"base", "components", "utilities", "screens"})) {
                        text = (String)text + ".css";
                    }
                    super.innerResolveInContext((String)text, context, result, caseSensitive);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "result";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/tailwind/references/TailwindImportReferenceContributor$TailwindImportFileReferenceSet$1";
                    objectArray[2] = "innerResolveInContext";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tailwind/references/TailwindImportReferenceContributor$TailwindImportFileReferenceSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tailwind/references/TailwindImportReferenceContributor$TailwindImportFileReferenceSet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeDefaultContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

