/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.listeners.JupyterConfigChangeListener;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteServerNode;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.ui.BalloonStyle;
import com.intellij.jupyter.py.connections.JupyterConnectionSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterOpenJupyterSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "updateSelectedForFile", "project", "Lcom/intellij/openapi/project/Project;", "newConfig", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "showBalloon", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "askUserConfirmation", "", "config", "getConfigForNode", "getConfigForFile", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterOpenJupyterSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterOpenJupyterSettingsAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterOpenJupyterSettingsAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class JupyterOpenJupyterSettingsAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "OpenJupyterSettingsAction";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JupyterServerConfig oldConfig;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JupyterServerConfig jupyterServerConfig = this.getConfigForNode(e);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getConfigForFile(e);
        }
        JupyterServerConfig jupyterServerConfig2 = oldConfig = jupyterServerConfig;
        String string = JupyterConnectionSettings.INSTANCE.open(project2, jupyterServerConfig2 != null ? jupyterServerConfig2.getId() : null);
        if (string == null) {
            return;
        }
        String serverConfigId = string;
        JupyterServerConfig jupyterServerConfig3 = JupyterConnectionSettingsManager.Companion.getInstance().getConfig(serverConfigId);
        if (jupyterServerConfig3 == null) {
            return;
        }
        JupyterServerConfig newConfig = jupyterServerConfig3;
        this.updateSelectedForFile(e, project2, newConfig);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JupyterServerConfig jupyterServerConfig = this.getConfigForNode(e);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getConfigForFile(e);
        }
        JupyterServerConfig config = jupyterServerConfig;
        e.getPresentation().setEnabledAndVisible(config != null);
    }

    private final void updateSelectedForFile(AnActionEvent e, Project project, JupyterServerConfig newConfig) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        VirtualFile virtualFile = notebookFile.getFile();
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (virtualFile instanceof JupyterRemoteVirtualFile) {
            return;
        }
        if (!this.askUserConfirmation(project, virtualFile, newConfig)) {
            return;
        }
        JupyterConnectionSettingsManager.Companion.getInstance().setConfigForFile(virtualFile, newConfig);
        ((JupyterConfigChangeListener)project.getMessageBus().syncPublisher(JupyterConfigChangeListener.Companion.getJUPYTER_SELECTED_CONFIG_CHANGE_TOPIC())).activeConfigChanged(project, editor2, notebookFile, newConfig);
        this.showBalloon(project, virtualFile);
    }

    private final void showBalloon(Project project, VirtualFile virtualFile) {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object object = ArraysKt.firstOrNull((Object[])fileEditorArray);
        JupyterFileEditor jupyterFileEditor = object instanceof JupyterFileEditor ? (JupyterFileEditor)object : null;
        if (jupyterFileEditor == null) {
            return;
        }
        JupyterFileEditor fileEditor = jupyterFileEditor;
        fileEditor.showServerBalloon(JupyterRemoteBundle.message((String)"connection.settings.changed", (Object[])new Object[0]), BalloonStyle.INFO);
    }

    private final boolean askUserConfirmation(Project project, VirtualFile virtualFile, JupyterServerConfig config) {
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project, virtualFile).getSession();
        if (jupyterNotebookSession == null) {
            return true;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JupyterServerConfig jupyterServerConfig = session.getConnectionParameters().getConfig();
        if (jupyterServerConfig == null) {
            return true;
        }
        JupyterServerConfig existingConnectionConfig = jupyterServerConfig;
        if (JupyterConnectionSettingsManager.Companion.getInstance().getConfig(existingConnectionConfig.getId()) == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)config.getId(), (Object)existingConnectionConfig.getId())) {
            return true;
        }
        Object[] objectArray = new Object[]{config.getName(), existingConnectionConfig.getName()};
        boolean isOk = Messages.showOkCancelDialog((Project)project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.ok", (Object[])new Object[0]), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        return isOk;
    }

    private final JupyterServerConfig getConfigForNode(AnActionEvent e) {
        Navigatable[] navigatableArray;
        block8: {
            block7: {
                Navigatable[] navigatableArray2;
                block6: {
                    Navigatable[] selectedFiles;
                    navigatableArray = selectedFiles = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
                    if (selectedFiles == null) break block7;
                    for (Navigatable it : navigatableArray) {
                        boolean bl = false;
                        navigatableArray2 = it instanceof JupyterRemoteServerNode ? (Navigatable[])it : null;
                        if (navigatableArray2 == null) {
                            continue;
                        }
                        break block6;
                    }
                    navigatableArray2 = navigatableArray = null;
                }
                if (navigatableArray2 != null) break block8;
            }
            return null;
        }
        Navigatable[] serverNode = navigatableArray;
        String authority = serverNode.getRemotePath().getAuthority();
        return JupyterConnectionSettingsManager.Companion.getInstance().getConnectionSettingsForAuthority(authority);
    }

    private final JupyterServerConfig getConfigForFile(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        BackedNotebookVirtualFile virtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(virtualFile, project2);
        return config;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterOpenJupyterSettingsAction$Companion;", "", "<init>", "()V", "ID", "", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

