/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.helpers.providers;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterScriptUtilsKt;
import com.intellij.jupyter.py.helpers.JupyterPyHelperProvider;
import com.intellij.jupyter.py.helpers.upload.PyRemoteLibUploader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/helpers/providers/ConfiguredPyHelperProvider;", "Lcom/intellij/jupyter/py/helpers/JupyterPyHelperProvider;", "<init>", "()V", "serverRoot", "Ljava/nio/file/Path;", "getServerRoot", "()Ljava/nio/file/Path;", "isApplicable", "", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getPaths", "", "getHelpersPaths", "virtualFile", "intellij.jupyter.py"})
public final class ConfiguredPyHelperProvider
implements JupyterPyHelperProvider {
    @NotNull
    private final Path serverRoot;

    public ConfiguredPyHelperProvider() {
        Path path = Paths.get(JupyterScriptUtilsKt.withStartSlash((String)PyRemoteLibUploader.INSTANCE.getRemoteLibName()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.serverRoot = path;
    }

    @Override
    @NotNull
    public Path getServerRoot() {
        return this.serverRoot;
    }

    @Override
    public boolean isApplicable(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(file, project);
        return config instanceof JupyterConfiguredServerConfig;
    }

    @Override
    @NotNull
    public List<Path> getPaths(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getHelpersPaths(project, file);
    }

    private final List<Path> getHelpersPaths(Project project, BackedNotebookVirtualFile virtualFile) {
        String string = StringUtil.escapeCharCharacters((String)PyRemoteLibUploader.INSTANCE.getRemoteLibName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
        String helpersLibDirectoryName = string;
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project, virtualFile).getSession();
        if (jupyterNotebookSession == null) {
            return CollectionsKt.emptyList();
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        Path path = Paths.get(session.getPathFromRoot(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path sessionPath = path;
        String subDirPrefix = sessionPath.getNameCount() == 1 ? "." : StringsKt.repeat((CharSequence)"../", (int)(sessionPath.getNameCount() - 1));
        Path path2 = Paths.get(subDirPrefix, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = Paths.get(helpersLibDirectoryName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path helpersPathDir = path2.resolve(path3);
        Path helpersPath = helpersPathDir.resolve("pydev");
        Path helpersProPath = helpersPathDir.resolve("jupyter_debug");
        Object[] objectArray = new Path[]{helpersPath, helpersProPath};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

