/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinInlayHintToggleActionKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayHintToggleAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "lastOptionName", "", "getText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "findElement", "Lcom/intellij/psi/PsiElement;", "startInWriteAction", "Holder", "kotlin.idea"})
public final class KotlinInlayHintToggleAction
implements IntentionAction,
LowPriorityAction {
    @IntentionName
    @NotNull
    private String lastOptionName = "";

    @NotNull
    public String getText() {
        return this.lastOptionName;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"hints.types", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.lastOptionName = "";
        for (PsiElement element = this.findElement(editor, file); element != null; element = element.getParent()) {
            for (HintType hintType : Holder.INSTANCE.getHintTypes()) {
                Pair pair;
                if (!hintType.isApplicable(element) || (pair = KotlinInlayHintToggleActionKt.findSetting$default(hintType, project, null, 4, null)) == null) continue;
                Pair it = pair;
                boolean bl = false;
                boolean enabled = ((KotlinAbstractHintsProvider.HintsSettings)it.getSecond()).isEnabled(hintType);
                this.lastOptionName = enabled ? hintType.getHideDescription() : hintType.getShowDescription();
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        for (PsiElement element = this.findElement(editor, file); element != null; element = element.getParent()) {
            for (HintType hintType : Holder.INSTANCE.getHintTypes()) {
                if (!KotlinInlayHintToggleActionKt.toggleHintSetting$default(hintType, project, element, null, 8, null)) continue;
                return;
            }
        }
    }

    private final PsiElement findElement(Editor editor, PsiFile file) {
        KtFile ktFile2 = file instanceof KtFile ? (KtFile)file : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        int offset = editor.getCaretModel().getOffset();
        return ktFile3.findElementAt(offset - 1);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayHintToggleAction$Holder;", "", "<init>", "()V", "hintTypes", "", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "getHintTypes", "()[Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "[Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "kotlin.idea"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final HintType[] hintTypes;

        private Holder() {
        }

        @NotNull
        public final HintType[] getHintTypes() {
            return hintTypes;
        }

        static {
            HintType[] hintTypeArray = new HintType[]{HintType.RANGES, HintType.PROPERTY_HINT, HintType.LOCAL_VARIABLE_HINT, HintType.FUNCTION_HINT, HintType.PARAMETER_TYPE_HINT, HintType.PARAMETER_HINT, HintType.LAMBDA_RETURN_EXPRESSION, HintType.LAMBDA_IMPLICIT_PARAMETER_RECEIVER, HintType.SUSPENDING_CALL};
            hintTypes = hintTypeArray;
        }
    }
}

