/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.wasm.debugger.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"REF_PREFIX", "", "NULL_PREFIX", "ref", "typeName", "nullableRef", "isRef", "", "wasmTypeName", "isNull", "wasmValue", "Lorg/jetbrains/debugger/values/Value;", "getClassNameFrom", "kotlin-ultimate.wasm.debugger"})
public final class WasmTypeUtilsKt {
    @NotNull
    public static final String REF_PREFIX = "(ref ";
    @NotNull
    public static final String NULL_PREFIX = "null ";

    @NotNull
    public static final String ref(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return "(ref $" + typeName + ")";
    }

    @NotNull
    public static final String nullableRef(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return "(ref null $" + typeName + ")";
    }

    public static final boolean isRef(@NotNull String wasmTypeName) {
        Intrinsics.checkNotNullParameter((Object)wasmTypeName, (String)"wasmTypeName");
        return StringsKt.startsWith$default((String)wasmTypeName, (String)REF_PREFIX, (boolean)false, (int)2, null);
    }

    public static final boolean isNull(@NotNull Value wasmValue) {
        Intrinsics.checkNotNullParameter((Object)wasmValue, (String)"wasmValue");
        return wasmValue instanceof PrimitiveValue && ((PrimitiveValue)wasmValue).getType() == ValueType.NULL;
    }

    @NotNull
    public static final String getClassNameFrom(@NotNull String wasmTypeName) {
        Intrinsics.checkNotNullParameter((Object)wasmTypeName, (String)"wasmTypeName");
        int classNameWithoutPackageStartIndex = StringsKt.lastIndexOf$default((CharSequence)wasmTypeName, (char)'.', (int)0, (boolean)false, (int)6, null);
        int startPosition = classNameWithoutPackageStartIndex > 0 ? classNameWithoutPackageStartIndex : (StringsKt.startsWith$default((String)wasmTypeName, (String)NULL_PREFIX, (int)5, (boolean)false, (int)4, null) ? 10 : 5);
        String string = wasmTypeName.substring(startPosition + 1, StringsKt.getLastIndex((CharSequence)wasmTypeName));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

