/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.core.service;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileFormattingService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileSystemWizardService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.TemplateEngineService$writeTemplate$;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardService;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplate;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTextDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.Template;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\n0\u000fR\u00020\u0010j\u0002`\u00112\u0006\u0010\u0006\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/TemplateEngineService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardService;", "<init>", "()V", "renderTemplate", "", "template", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplateDescriptor;", "data", "", "", "getTemplateText", "writeTemplate", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplate;", "intellij.kotlin.projectWizard.core"})
@SourceDebugExtension(value={"SMAP\nTemplateEngineService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateEngineService.kt\norg/jetbrains/kotlin/tools/projectWizard/core/service/TemplateEngineService\n+ 2 Context.kt\norg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n119#2,5:63\n119#2,5:69\n1#3:68\n*S KotlinDebug\n*F\n+ 1 TemplateEngineService.kt\norg/jetbrains/kotlin/tools/projectWizard/core/service/TemplateEngineService\n*L\n29#1:63,5\n36#1:69,5\n*E\n"})
public abstract class TemplateEngineService
implements WizardService {
    @NotNull
    public abstract String renderTemplate(@NotNull FileTemplateDescriptor var1, @NotNull Map<String, ? extends Object> var2);

    @NotNull
    protected final String getTemplateText(@NotNull FileTemplateDescriptor template2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        try {
            String templateId = StringsKt.replace$default((String)template2.getTemplateId(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            URL uRL = Template.class.getResource(templateId);
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can not get template " + template2.getTemplateId(), e);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TaskResult<Unit> writeTemplate(@NotNull Context.Writer $this$writeTemplate, @NotNull FileTemplate template2) {
        void this_$iv$iv;
        String string;
        block10: {
            String unformattedText;
            block9: {
                String string2;
                void this_$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)$this$writeTemplate, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                Context.Reader $this$iv = $this$writeTemplate;
                Function1 filter$iv = writeTemplate$$inlined$service$default$1.INSTANCE;
                boolean $i$f$service = false;
                Context.Reader reader = $this$iv;
                Function1 filter$iv$iv = filter$iv;
                boolean $i$f$serviceOrNull = false;
                Object s = Context.Reader.access$getThis$0$p((Context.Reader)this_$iv$iv2).getServicesManager().serviceByClass(Reflection.getOrCreateKotlinClass(FileFormattingService.class), filter$iv$iv);
                if (s == null) {
                    throw new IllegalStateException(("Service " + Reflection.getOrCreateKotlinClass(FileFormattingService.class).getSimpleName() + " was not found").toString());
                }
                FileFormattingService formatter2 = (FileFormattingService)s;
                FileDescriptor descriptor2 = template2.getDescriptor();
                if (descriptor2 instanceof FileTemplateDescriptor) {
                    string2 = this.renderTemplate((FileTemplateDescriptor)descriptor2, template2.getData());
                } else if (descriptor2 instanceof FileTextDescriptor) {
                    string2 = ((FileTextDescriptor)descriptor2).getText();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                unformattedText = string2;
                Path path2 = template2.getDescriptor().getRelativePath();
                String fileName = path2 != null && (path2 = path2.getFileName()) != null ? ((Object)path2).toString() : null;
                string = fileName;
                if (string == null) break block9;
                String it = string;
                boolean bl = false;
                String string3 = formatter2.formatFile(unformattedText, it);
                string = string3;
                if (string3 != null) break block10;
            }
            string = unformattedText;
        }
        String text = string;
        Context.Reader $this$iv = $this$writeTemplate;
        Function1 filter$iv = writeTemplate$$inlined$service$default$2.INSTANCE;
        boolean $i$f$service = false;
        Context.Reader bl = $this$iv;
        Function1 filter$iv$iv = filter$iv;
        boolean $i$f$serviceOrNull = false;
        Object s = Context.Reader.access$getThis$0$p((Context.Reader)this_$iv$iv).getServicesManager().serviceByClass(Reflection.getOrCreateKotlinClass(FileSystemWizardService.class), filter$iv$iv);
        if (s == null) {
            throw new IllegalStateException(("Service " + Reflection.getOrCreateKotlinClass(FileSystemWizardService.class).getSimpleName() + " was not found").toString());
        }
        return ((FileSystemWizardService)s).createFile(UtilsKt.divNullable(template2.getRootPath(), template2.getDescriptor().getRelativePath()), text);
    }
}

