/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.javaee.application.facet.JavaeeFacetEditorValidator;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfigurationBase;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.module.view.web.WebFacetEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class WebFacetConfigurationImpl
extends JavaeeFacetConfigurationBase
implements WebFacetConfiguration {
    private List<WebRootData> myWebRoots = new ArrayList<WebRootData>();
    private List<String> mySourceRoots = new ArrayList<String>();

    public WebFacetConfigurationImpl(ConfigFileMetaDataProvider metaDataProvider) {
        super(metaDataProvider);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        WebFacet webFacet = (WebFacet)context.getFacet();
        validatorsManager.registerValidator((FacetEditorValidator)new JavaeeFacetEditorValidator((JavaeeFacet)webFacet, context), new JComponent[0]);
        WebFacetEditor facetEditor = new WebFacetEditor(webFacet, context, validatorsManager);
        return new FacetEditorTab[]{facetEditor};
    }

    @NotNull
    public List<WebRootData> getWebRoots() {
        List<WebRootData> list = Collections.unmodifiableList(this.myWebRoots);
        if (list == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<String> getSourceRoots() {
        List<String> list = this.mySourceRoots;
        if (list == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setSourceRoots(@NotNull List<String> sourceRoots) {
        if (sourceRoots == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(2);
        }
        this.mySourceRoots = new ArrayList<String>(sourceRoots);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element sourceRoots;
        if (element == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(3);
        }
        this.myWebRoots.clear();
        this.mySourceRoots.clear();
        Element webRootsElement = element.getChild("webroots");
        if (webRootsElement != null) {
            for (Element root : webRootsElement.getChildren("root")) {
                this.myWebRoots.add(WebRootData.create((Element)root));
            }
        }
        if ((sourceRoots = element.getChild("sourceRoots")) != null) {
            for (Element rootElement : sourceRoots.getChildren("root")) {
                this.mySourceRoots.add(rootElement.getAttributeValue("url"));
            }
        }
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element roots = new Element("webroots");
        for (WebRootData webRoot : this.myWebRoots) {
            Element root = new Element("root");
            root.setAttribute("url", webRoot.getUrl());
            root.setAttribute("relative", webRoot.getRelativePath());
            roots.addContent(root);
        }
        element.addContent(roots);
        Element sourceRoots = new Element("sourceRoots");
        for (String sourceRoot : this.mySourceRoots) {
            sourceRoots.addContent(new Element("root").setAttribute("url", sourceRoot));
        }
        element.addContent(sourceRoots);
    }

    public void setWebRoots(@NotNull List<WebRootData> webRoots) {
        if (webRoots == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(4);
        }
        this.myWebRoots = new ArrayList<WebRootData>(webRoots);
    }

    public void addWebRoot(@NotNull WebRootData root) {
        if (root == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(5);
        }
        this.myWebRoots.add(root);
    }

    public void removeWebRoot(@NotNull WebRootData webRootData) {
        if (webRootData == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(6);
        }
        this.myWebRoots.remove(webRootData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/facet/WebFacetConfigurationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webRootData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/facet/WebFacetConfigurationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSourceRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWebRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWebRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeWebRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

