/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.jetbrains.annotations.NotNull;

final class Xsd2InstanceUtils {
    Xsd2InstanceUtils() {
    }

    public static String generate(String[] args) {
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> opts = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        flags.add("partial");
        opts.add("name");
        CommandLine cl = new CommandLine(args, flags, opts);
        String[] badOpts = cl.getBadOpts();
        if (badOpts.length > 0) {
            throw new IllegalArgumentException("Unrecognized option: " + badOpts[0]);
        }
        boolean dl = cl.getOpt("dl") != null;
        boolean nopvr = cl.getOpt("nopvr") != null;
        boolean noupa = cl.getOpt("noupa") != null;
        File[] schemaFiles = cl.filesEndingWith(".xsd");
        String rootName = cl.getOpt("name");
        if (rootName == null) {
            throw new IllegalArgumentException("Required option \"-name\" must be present");
        }
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (File schemaFile : schemaFiles) {
            try {
                sdocs.add((XmlObject)SchemaDocument.Factory.parse(schemaFile, new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load schema file: " + String.valueOf(schemaFile) + ": " + e.getLocalizedMessage());
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[0]);
        SchemaTypeSystem sts = null;
        if (schemas.length > 0) {
            XmlOptions compileOptions = new XmlOptions();
            if (dl) {
                compileOptions.setCompileDownloadUrls();
            }
            if (nopvr) {
                compileOptions.setCompileNoPvrRule();
            }
            if (noupa) {
                compileOptions.setCompileNoUpaRule();
            }
            try {
                sts = XmlBeans.compileXsd(schemas, XmlBeans.getBuiltinTypeSystem(), compileOptions);
            }
            catch (XmlException e) {
                StringBuilder out = new StringBuilder("Schema compilation errors: ");
                Collection<XmlError> errors = e.getErrors();
                if (errors != null) {
                    for (XmlError error : errors) {
                        out.append("\n").append(error);
                    }
                } else {
                    out.append(e.getMessage());
                }
                throw new IllegalArgumentException(out.toString());
            }
        }
        if (sts == null) {
            throw new IllegalArgumentException("No Schemas to process.");
        }
        SchemaType[] globalElems = sts.documentTypes();
        SchemaType elem = null;
        for (SchemaType globalElem : globalElems) {
            if (!rootName.equals(globalElem.getDocumentElementName().getLocalPart())) continue;
            elem = globalElem;
            break;
        }
        if (elem == null) {
            throw new IllegalArgumentException("Could not find a global element with name \"" + rootName + "\"");
        }
        return SampleXmlUtil.createSampleForType(elem);
    }

    public static XmlElementDescriptor getDescriptor(XmlTag tag, String elementName) {
        PsiMetaData metaData = tag.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            return nsDescriptor.getElementDescriptor(elementName, nsDescriptor.getDefaultNamespace());
        }
        return null;
    }

    public static List<String> addVariantsFromRootTag(XmlTag rootTag) {
        PsiMetaData metaData = rootTag.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlElementDescriptor[] rootElementsDescriptors;
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            ArrayList<String> elementDescriptors = new ArrayList<String>();
            for (XmlElementDescriptor e : rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)rootTag, XmlDocument.class))) {
                elementDescriptors.add(e.getName());
            }
            return elementDescriptors;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String processAndSaveAllSchemas(@NotNull XmlFile file, final @NotNull Map<String, String> scannedToFileName, final @NotNull SchemaReferenceProcessor schemaReferenceProcessor) {
        byte[] bytes;
        String fileName;
        String previous;
        if (file == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(0);
        }
        if (scannedToFileName == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(1);
        }
        if (schemaReferenceProcessor == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(2);
        }
        if ((previous = scannedToFileName.get(fileName = file.getName())) != null) {
            String string = previous;
            if (string == null) {
                Xsd2InstanceUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        scannedToFileName.put(fileName, fileName);
        final StringBuilder result = new StringBuilder();
        file.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(psiElement);
                if (psiElement instanceof LeafPsiElement) {
                    String text = psiElement.getText();
                    result.append(text);
                }
            }

            public void visitXmlAttribute(@NotNull XmlAttribute xmlAttribute) {
                PsiElement psiElement;
                Object[] references;
                PsiReference reference;
                if (xmlAttribute == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean replaced = false;
                if (xmlAttribute.isNamespaceDeclaration()) {
                    XmlNSDescriptor nsDescriptor;
                    replaced = true;
                    String value = xmlAttribute.getValue();
                    result.append(xmlAttribute.getText()).append(" ");
                    if (!scannedToFileName.containsKey(value) && (nsDescriptor = xmlAttribute.getParent().getNSDescriptor(value, true)) != null) {
                        Xsd2InstanceUtils.processAndSaveAllSchemas(Objects.requireNonNull(nsDescriptor.getDescriptorFile()), scannedToFileName, schemaReferenceProcessor);
                    }
                } else if ("schemaLocation".equals(xmlAttribute.getName()) && (reference = (PsiReference)ArrayUtil.getLastElement((Object[])(references = Objects.requireNonNull(xmlAttribute.getValueElement()).getReferences()))) != null && (psiElement = reference.resolve()) instanceof XmlFile) {
                    String s = Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)psiElement, scannedToFileName, schemaReferenceProcessor);
                    result.append(xmlAttribute.getName()).append("='").append(s).append('\'');
                    replaced = true;
                }
                if (!replaced) {
                    result.append(xmlAttribute.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "xmlAttribute";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/tools/Xsd2InstanceUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VirtualFile virtualFile = file.getVirtualFile();
        String content = result.toString();
        if (virtualFile != null) {
            bytes = content.getBytes(virtualFile.getCharset());
        } else {
            try {
                String charsetName = XmlUtil.extractXmlEncodingFromProlog((byte[])content.getBytes(StandardCharsets.UTF_8));
                bytes = charsetName != null ? content.getBytes(charsetName) : content.getBytes(StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                bytes = content.getBytes(StandardCharsets.UTF_8);
            }
        }
        schemaReferenceProcessor.processSchema(fileName, bytes);
        String string = fileName;
        if (string == null) {
            Xsd2InstanceUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scannedToFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaReferenceProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/tools/Xsd2InstanceUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/tools/Xsd2InstanceUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processAndSaveAllSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAndSaveAllSchemas";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static interface SchemaReferenceProcessor {
        public void processSchema(String var1, byte[] var2);
    }
}

