/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.RecordAugmentProvider;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConstructorClassProcessor
extends AbstractClassProcessor {
    private static final String BUILDER_DEFAULT_ANNOTATION = "lombok.Builder.Default";

    AbstractConstructorClassProcessor(@NotNull String supportedAnnotationClass, @NotNull Class<? extends PsiElement> supportedClass) {
        if (supportedAnnotationClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(0);
        }
        if (supportedClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    @Override
    public Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(2);
        }
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(3);
        }
        return List.of(this.getConstructorName(psiClass), this.getStaticConstructorName(psiAnnotation));
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(6);
        }
        boolean result = true;
        if (!this.validateAnnotationOnRightType(psiClass, builder)) {
            result = false;
        }
        if (!AbstractConstructorClassProcessor.validateVisibility(psiAnnotation)) {
            result = false;
        }
        if (!this.validateBaseClassConstructor(psiClass, builder)) {
            result = false;
        }
        return result;
    }

    private static boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String visibility;
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(7);
        }
        return null != (visibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation));
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(9);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.annotation.only.supported.on.class.or.enum.type", StringUtil.getShortName((String)this.getSupportedAnnotationClasses()[0])).withLocalQuickFixes(() -> {
                String annotationFqn = Arrays.stream(this.getSupportedAnnotationClasses()).findFirst().orElse(null);
                return PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, annotationFqn);
            });
            result = false;
        }
        return result;
    }

    public boolean validateBaseClassConstructor(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(11);
        }
        if (psiClass instanceof PsiAnonymousClass || psiClass.isEnum()) {
            return true;
        }
        PsiClass baseClass = psiClass.getSuperClass();
        if (baseClass == null || psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)baseClass)) {
            return true;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            int parametersCount = constructor.getParameterList().getParametersCount();
            if (parametersCount != 0 && (parametersCount != 1 || !constructor.isVarArgs())) continue;
            return true;
        }
        builder.addErrorMessage("inspection.message.lombok.needs.default.constructor.in.base.class", new Object[0]);
        return false;
    }

    private static boolean validateIsStaticConstructorNotDefined(@NotNull PsiClass psiClass, @Nullable String staticConstructorName, @NotNull Collection<PsiField> params, @NotNull ProblemSink builder) {
        Collection<PsiMethod> definedMethods;
        PsiMethod existedStaticMethod;
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(12);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(14);
        }
        boolean result = true;
        ArrayList<PsiType> paramTypes = new ArrayList<PsiType>(params.size());
        for (PsiField param : params) {
            paramTypes.add(param.getType());
        }
        if (AbstractConstructorClassProcessor.isStaticConstructor(staticConstructorName) && null != (existedStaticMethod = AbstractConstructorClassProcessor.findExistedMethod(definedMethods = PsiClassUtil.collectClassStaticMethodsIntern(psiClass), staticConstructorName, paramTypes))) {
            if (paramTypes.isEmpty()) {
                builder.addErrorMessage("inspection.message.method.s.matched.static.constructor.name.already.defined", staticConstructorName).withLocalQuickFixes(() -> new SafeDeleteFix((PsiElement)existedStaticMethod));
            } else {
                builder.addErrorMessage("inspection.message.method.s.with.d.parameters.matched.static.constructor.name.already.defined", staticConstructorName, paramTypes.size()).withLocalQuickFixes(() -> new SafeDeleteFix((PsiElement)existedStaticMethod));
            }
            result = false;
        }
        return result;
    }

    public boolean validateIsConstructorNotDefined(@NotNull PsiClass psiClass, @Nullable String staticConstructorName, @NotNull Collection<PsiField> params, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(15);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(17);
        }
        return this.validateIsConstructorNotDefined(psiClass, params, builder) || AbstractConstructorClassProcessor.validateIsStaticConstructorNotDefined(psiClass, staticConstructorName, params, builder);
    }

    private boolean validateIsConstructorNotDefined(@NotNull PsiClass psiClass, @NotNull Collection<PsiField> params, @NotNull ProblemSink builder) {
        String constructorName;
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(18);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(20);
        }
        boolean result = true;
        List paramTypes = ContainerUtil.map(params, PsiField::getType);
        Collection<PsiMethod> definedConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        PsiMethod existedMethod = AbstractConstructorClassProcessor.findExistedMethod(definedConstructors, constructorName = this.getConstructorName(psiClass), paramTypes);
        if (null != existedMethod) {
            if (paramTypes.isEmpty()) {
                builder.addErrorMessage("inspection.message.constructor.without.parameters.already.defined", new Object[0]).withLocalQuickFixes(() -> new SafeDeleteFix((PsiElement)existedMethod), () -> {
                    String annotationFqn = Arrays.stream(this.getSupportedAnnotationClasses()).findFirst().orElse(null);
                    return PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, annotationFqn);
                });
            } else {
                String name = HighlightMessageUtil.getSymbolName((PsiElement)existedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)2);
                builder.addErrorMessage("inspection.message.constructor.with.d.parameters.already.defined", name).withLocalQuickFixes(() -> new SafeDeleteFix((PsiElement)existedMethod), () -> {
                    String annotationFqn = Arrays.stream(this.getSupportedAnnotationClasses()).findFirst().orElse(null);
                    return PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, annotationFqn);
                });
            }
            result = false;
        }
        return result;
    }

    @NotNull
    public String getConstructorName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(21);
        }
        String string = StringUtil.notNullize((String)psiClass.getName());
        if (string == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private static PsiMethod findExistedMethod(Collection<PsiMethod> definedMethods, String methodName, List<PsiType> paramTypes) {
        for (PsiMethod method : definedMethods) {
            if (!PsiElementUtil.methodMatches(method, null, null, methodName, paramTypes)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    protected static Collection<PsiField> getAllNotInitializedAndNotStaticFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(23);
        }
        ArrayList<PsiField> allNotInitializedNotStaticFields = new ArrayList<PsiField>();
        boolean classAnnotatedWithValue = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value");
        Collection<Object> fields = psiClass.isRecord() ? RecordAugmentProvider.getFieldAugments((PsiClass)psiClass) : PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : fields) {
            if (!AbstractConstructorClassProcessor.isNotInitializedAndNotStaticField(psiField, classAnnotatedWithValue)) continue;
            allNotInitializedNotStaticFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = allNotInitializedNotStaticFields;
        if (arrayList == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    static boolean isNotInitializedAndNotStaticField(@NotNull PsiField psiField, boolean classAnnotatedWithValue) {
        if (psiField == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(25);
        }
        boolean addField = !psiField.getName().startsWith("$");
        PsiModifierList modifierList = psiField.getModifierList();
        if (null != modifierList) {
            addField &= !modifierList.hasModifierProperty("static");
            boolean isFinal = AbstractConstructorClassProcessor.isFieldFinal(psiField, modifierList, classAnnotatedWithValue);
            addField &= !isFinal || !psiField.hasInitializer() || PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, BUILDER_DEFAULT_ANNOTATION) != null;
        }
        return addField;
    }

    @NotNull
    public static Collection<PsiField> getAllFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(26);
        }
        return AbstractConstructorClassProcessor.getAllNotInitializedAndNotStaticFields(psiClass);
    }

    @NotNull
    public static Collection<PsiField> getRequiredFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(27);
        }
        return AbstractConstructorClassProcessor.getRequiredFields(psiClass, false);
    }

    @NotNull
    static Collection<PsiField> getRequiredFields(@NotNull PsiClass psiClass, boolean ignoreNonNull) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(28);
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        boolean classAnnotatedWithValue = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value");
        for (PsiField psiField : AbstractConstructorClassProcessor.getAllNotInitializedAndNotStaticFields(psiClass)) {
            if (!AbstractConstructorClassProcessor.isRequiredField(psiField, ignoreNonNull, classAnnotatedWithValue)) continue;
            result.add(psiField);
        }
        ArrayList<PsiField> arrayList = result;
        if (arrayList == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    static boolean isRequiredField(@NotNull PsiField psiField, boolean ignoreNonNull, boolean classAnnotatedWithValue) {
        if (psiField == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(30);
        }
        PsiModifierList modifierList = psiField.getModifierList();
        boolean shouldAddField = false;
        if (null != modifierList) {
            boolean isFinal = AbstractConstructorClassProcessor.isFieldFinal(psiField, modifierList, classAnnotatedWithValue);
            boolean isNonNull = !ignoreNonNull && PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, LombokUtils.NONNULL_ANNOTATIONS);
            shouldAddField = (isFinal || isNonNull) && !psiField.hasInitializer();
        }
        return shouldAddField;
    }

    private static boolean isFieldFinal(@NotNull PsiField psiField, @NotNull PsiModifierList modifierList, boolean classAnnotatedWithValue) {
        boolean isFinal;
        if (psiField == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(31);
        }
        if (modifierList == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(32);
        }
        if (!(isFinal = modifierList.hasModifierProperty("final")) && classAnnotatedWithValue) {
            isFinal = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, "lombok.experimental.NonFinal");
        }
        return isFinal;
    }

    @NotNull
    protected Collection<PsiMethod> createConstructorMethod(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, boolean useJavaDefaults, @NotNull Collection<PsiField> params) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(33);
        }
        if (methodModifier == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(34);
        }
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(35);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(36);
        }
        String staticName = this.getStaticConstructorName(psiAnnotation);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodModifier, psiAnnotation, useJavaDefaults, params, staticName, false);
        if (collection == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(37);
        }
        return collection;
    }

    protected String getStaticConstructorName(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(38);
        }
        return PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticName", "");
    }

    private static boolean isStaticConstructor(@Nullable String staticName) {
        return !StringUtil.isEmptyOrSpaces((String)staticName);
    }

    @NotNull
    protected Collection<PsiMethod> createConstructorMethod(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, boolean useJavaDefaults, @NotNull Collection<PsiField> params, @Nullable String staticName, boolean skipConstructorIfAnyConstructorExists) {
        String constructorVisibility;
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(39);
        }
        if (methodModifier == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(40);
        }
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(41);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(42);
        }
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        boolean hasStaticConstructor = !AbstractConstructorClassProcessor.validateIsStaticConstructorNotDefined(psiClass, staticName, params, new ProblemProcessingSink());
        boolean staticConstructorRequired = AbstractConstructorClassProcessor.isStaticConstructor(staticName);
        String string = constructorVisibility = staticConstructorRequired || psiClass.isEnum() ? "private" : methodModifier;
        if (!skipConstructorIfAnyConstructorExists || !AbstractConstructorClassProcessor.isAnyConstructorDefined(psiClass)) {
            boolean hasConstructor;
            boolean bl = hasConstructor = !this.validateIsConstructorNotDefined(psiClass, useJavaDefaults ? Collections.emptyList() : params, new ProblemProcessingSink());
            if (!hasConstructor) {
                PsiMethod constructor = this.createConstructor(psiClass, constructorVisibility, useJavaDefaults, params, psiAnnotation);
                methods.add(constructor);
            }
        }
        if (staticConstructorRequired && !hasStaticConstructor) {
            PsiMethod staticConstructor = AbstractConstructorClassProcessor.createStaticConstructor(psiClass, methodModifier, staticName, useJavaDefaults, params, psiAnnotation);
            methods.add(staticConstructor);
        }
        ArrayList<PsiMethod> arrayList = methods;
        if (arrayList == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    private PsiMethod createConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String modifier, boolean useJavaDefaults, @NotNull Collection<PsiField> params, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(44);
        }
        if (modifier == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(45);
        }
        if (params == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(46);
        }
        if (psiAnnotation == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(47);
        }
        LombokLightMethodBuilder constructorBuilder = new LombokLightMethodBuilder(psiClass.getManager(), this.getConstructorName(psiClass)).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier(modifier).withWriteAccess();
        LombokCopyableAnnotations.copyOnXAnnotations(psiAnnotation, (PsiModifierList)constructorBuilder.getModifierList(), "onConstructor");
        if (useJavaDefaults) {
            StringBuilder blockText = new StringBuilder();
            for (PsiField param : params) {
                String fieldInitializer = PsiTypesUtil.getDefaultValueOfType((PsiType)param.getType());
                blockText.append(String.format("this.%s = %s;\n", param.getName(), fieldInitializer));
            }
            constructorBuilder.withBodyText(blockText.toString());
        } else {
            boolean addConstructorProperties;
            ArrayList<String> fieldNames = new ArrayList<String>();
            AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
            for (PsiField psiField : params) {
                AccessorsInfo paramAccessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
                fieldNames.add(paramAccessorsInfo.removePrefixWithDefault(psiField.getName()));
            }
            if (!(fieldNames.isEmpty() || !(addConstructorProperties = this.configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ANYCONSTRUCTOR_ADD_CONSTRUCTOR_PROPERTIES, psiClass)) && this.configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ANYCONSTRUCTOR_SUPPRESS_CONSTRUCTOR_PROPERTIES, psiClass))) {
                String constructorPropertiesAnnotation = "java.beans.ConstructorProperties( {" + fieldNames.stream().collect(Collectors.joining("\", \"", "\"", "\"")) + "} ) ";
                constructorBuilder.withAnnotation(constructorPropertiesAnnotation);
            }
            StringBuilder blockText = new StringBuilder();
            Iterator fieldNameIterator = fieldNames.iterator();
            Iterator<PsiField> fieldIterator = params.iterator();
            while (fieldNameIterator.hasNext() && fieldIterator.hasNext()) {
                String parameterName = (String)fieldNameIterator.next();
                PsiField parameterField = fieldIterator.next();
                LombokLightParameter parameter = new LombokLightParameter(parameterName, parameterField.getType(), (PsiElement)constructorBuilder);
                parameter.setNavigationElement((PsiElement)parameterField);
                constructorBuilder.withParameter(parameter);
                LombokCopyableAnnotations.copyCopyableAnnotations(parameterField, parameter.getModifierList(), LombokCopyableAnnotations.BASE_COPYABLE);
                blockText.append(String.format("this.%s = %s;\n", parameterField.getName(), parameterName));
            }
            constructorBuilder.withBodyText(blockText.toString());
        }
        return constructorBuilder;
    }

    private static PsiMethod createStaticConstructor(PsiClass psiClass, @PsiModifier.ModifierConstant String methodModifier, String staticName, boolean useJavaDefaults, Collection<PsiField> params, PsiAnnotation psiAnnotation) {
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiClass.getManager(), staticName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier(methodModifier).withModifier("static").withWriteAccess();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (psiClass.hasTypeParameters()) {
            PsiTypeParameter[] classTypeParameters = psiClass.getTypeParameters();
            for (int index = 0; index < classTypeParameters.length; ++index) {
                PsiTypeParameter classTypeParameter = classTypeParameters[index];
                LightTypeParameterBuilder methodTypeParameter = AbstractConstructorClassProcessor.createTypeParameter(methodBuilder, index, classTypeParameter);
                methodBuilder.withTypeParameter((PsiTypeParameter)methodTypeParameter);
                substitutor = substitutor.put(classTypeParameter, PsiSubstitutor.EMPTY.substitute((PsiTypeParameter)methodTypeParameter));
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiClassType returnType = factory.createType(psiClass, substitutor);
        methodBuilder.withMethodReturnType((PsiType)returnType);
        if (!useJavaDefaults) {
            for (PsiField psiField : params) {
                String parameterName = psiField.getName();
                PsiType parameterType = substitutor.substitute(psiField.getType());
                LombokLightParameter parameter = new LombokLightParameter(parameterName, parameterType, (PsiElement)methodBuilder);
                parameter.setNavigationElement((PsiElement)psiField);
                methodBuilder.withParameter(parameter);
                LombokCopyableAnnotations.copyCopyableAnnotations(psiField, parameter.getModifierList(), LombokCopyableAnnotations.BASE_COPYABLE);
            }
        }
        String codeBlockText = AbstractConstructorClassProcessor.createStaticCodeBlockText((PsiType)returnType, useJavaDefaults, (PsiParameterList)methodBuilder.getParameterList());
        methodBuilder.withBodyText(codeBlockText);
        LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiClass, methodBuilder);
        return methodBuilder;
    }

    @NotNull
    private static LightTypeParameterBuilder createTypeParameter(LombokLightMethodBuilder method, int index, PsiTypeParameter psiClassTypeParameter) {
        String nameOfTypeParameter = StringUtil.notNullize((String)psiClassTypeParameter.getName());
        LightTypeParameterBuilder result = new LightTypeParameterBuilder(nameOfTypeParameter, (PsiTypeParameterListOwner)method, index);
        LightReferenceListBuilder resultExtendsList = result.getExtendsList();
        for (PsiClassType referencedType : psiClassTypeParameter.getExtendsList().getReferencedTypes()) {
            resultExtendsList.addReference(referencedType);
        }
        LightTypeParameterBuilder lightTypeParameterBuilder = result;
        if (lightTypeParameterBuilder == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(48);
        }
        return lightTypeParameterBuilder;
    }

    @NotNull
    private static String createStaticCodeBlockText(@NotNull PsiType psiType, boolean useJavaDefaults, @NotNull PsiParameterList parameterList) {
        if (psiType == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(49);
        }
        if (parameterList == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(50);
        }
        String psiClassName = psiType.getPresentableText();
        String paramsText = useJavaDefaults ? "" : AbstractConstructorClassProcessor.joinParameters(parameterList);
        String string = String.format("return new %s(%s);", psiClassName, paramsText);
        if (string == null) {
            AbstractConstructorClassProcessor.$$$reportNull$$$0(51);
        }
        return string;
    }

    private static String joinParameters(PsiParameterList parameterList) {
        return Arrays.stream(parameterList.getParameters()).map(PsiParameter::getName).collect(Collectors.joining(","));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 24, 29, 37, 43, 48, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 35: 
            case 38: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 36: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 22: 
            case 24: 
            case 29: 
            case 37: 
            case 43: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AbstractConstructorClassProcessor";
                break;
            }
            case 25: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/AbstractConstructorClassProcessor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNotInitializedAndNotStaticFields";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredFields";
                break;
            }
            case 37: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorMethod";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameter";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createStaticCodeBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateBaseClassConstructor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateIsStaticConstructorNotDefined";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateIsConstructorNotDefined";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorName";
                break;
            }
            case 22: 
            case 24: 
            case 29: 
            case 37: 
            case 43: 
            case 48: 
            case 51: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllNotInitializedAndNotStaticFields";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isNotInitializedAndNotStaticField";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredFields";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isRequiredField";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFieldFinal";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorMethod";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStaticConstructorName";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createStaticCodeBlockText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 24, 29, 37, 43, 48, 51 -> new IllegalStateException(string);
        };
    }
}

