/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restTestClient;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/mvc/webClient/restTestClient/RestTestClientUtils;", "", "<init>", "()V", "isRestTestClientAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getRestTestClientMethods", "", "Lcom/intellij/psi/PsiMethod;", "getRestTestClientApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "findRestTestClientApiClasses", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findUrlMethods", "apiSearchScope", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nRestTestClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestTestClientUtils.kt\ncom/intellij/spring/mvc/webClient/restTestClient/RestTestClientUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,61:1\n3919#2:62\n4434#2,2:63\n*S KotlinDebug\n*F\n+ 1 RestTestClientUtils.kt\ncom/intellij/spring/mvc/webClient/restTestClient/RestTestClientUtils\n*L\n57#1:62\n57#1:63,2\n*E\n"})
public final class RestTestClientUtils {
    @NotNull
    public static final RestTestClientUtils INSTANCE = new RestTestClientUtils();

    private RestTestClientUtils() {
    }

    @JvmStatic
    public static final boolean isRestTestClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.test.web.servlet.client.RestTestClient");
    }

    @JvmStatic
    public static final boolean isRestTestClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.test.web.servlet.client.RestTestClient");
    }

    @NotNull
    public final List<PsiMethod> getRestTestClientMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> RestTestClientUtils.getRestTestClientMethods$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public final List<PsiClass> getRestTestClientApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(() -> RestTestClientUtils.getRestTestClientApiClasses$lambda$0(query));
    }

    private final List<PsiClass> findRestTestClientApiClasses(Project project, GlobalSearchScope searchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses("org.springframework.test.web.servlet.client.RestTestClient", searchScope);
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiMethod> findUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiClass uriSpecClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.test.web.servlet.client.RestTestClient.UriSpec", apiSearchScope);
        if (uriSpecClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiMethod[] psiMethodArray = uriSpecClass.findMethodsByName("uri", true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        Object[] objectArray = psiMethodArray;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            if (!(it.hasParameters() && TypeUtils.isJavaLangString((PsiType)it.getParameterList().getParameters()[0].getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final CachedValueProvider.Result getRestTestClientMethods$lambda$0(Project $project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        List<PsiMethod> methods = INSTANCE.findUrlMethods($project, globalSearchScope);
        return CachedValueProvider.Result.createSingleDependency(methods, (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getRestTestClientApiClasses$lambda$0(ScopedCacheValueHolder $query) {
        List<PsiClass> classes = INSTANCE.findRestTestClientApiClasses($query.getProject(), $query.getApiSearchScope());
        return CachedValueProvider.Result.createSingleDependency(classes, (Object)JavaLibraryModificationTracker.getInstance((Project)$query.getProject()));
    }
}

