/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ssh.AgentProxyConnectorFactory;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.NamedPipeAgentConnector;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelConfig;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.ssh.impl.channels.FailSafeSftpChannel;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.messages.Topic;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 E2\u00020\u0001:\u0002DEB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u00020\u000e2\b\b\u0001\u0010\u001f\u001a\u00020\u00072\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&J\u001a\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010+\u001a\u00020*H\u0007J\u0016\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u000202J\u0016\u00103\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u000202J\u0016\u00104\u001a\u0002052\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u000206J3\u00107\u001a\u0002H8\"\b\b\u0000\u00108*\u0002092\u0006\u0010%\u001a\u00020&2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u0002H80;H\u0002\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020(0?H\u0007J\b\u0010A\u001a\u00020\u0007H\u0002J\u0012\u0010B\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010@\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/ssh/SshConnectionService;", "Lcom/intellij/openapi/Disposable;", "SshConnectionService", "()V", "sshConnectionsGroup", "Lcom/intellij/notification/NotificationGroup;", "pageantName", "", "Lcom/intellij/openapi/util/NlsSafe;", "sshAgentName", "agentProxyConnector", "Lkotlin/Pair;", "Lcom/jcraft/jsch/agentproxy/Connector;", "dispose", "", "reset", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ssh/SshSessionKey;", "Lcom/intellij/ssh/impl/SshConnection;", "sshAgentProxyLock", "", "W", "path", "agentProxyConnectorFactory", "Lcom/intellij/ssh/AgentProxyConnectorFactory;", "getAgentProxyConnectorFactory", "()Lcom/intellij/ssh/AgentProxyConnectorFactory;", "n", "customUnixSocketPath", "W", "authAgentName", "e", "Lcom/jcraft/jsch/agentproxy/AgentProxyException;", "W", "errorMessage", "W", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "connect", "Lcom/intellij/ssh/SshSession;", "checkCanAuthenticate", "", "addToPool", "exec", "Lcom/intellij/ssh/channels/ExecChannel;", "channelConfig", "Lcom/intellij/ssh/ExecChannelConfig;", "sftp", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/SftpChannelConfig;", "failSafeSftp", "shell", "Lcom/intellij/ssh/channels/ShellChannel;", "Lcom/intellij/ssh/ShellChannelConfig;", "W", "R", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "(Lcom/intellij/ssh/SessionConfig;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "getSessions", "", "overridenSshAuthSock", "W", "overrideSshAuthSock", "value", "Listener", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,299:1\n1#2:300\n77#3:301\n97#3,5:302\n*S KotlinDebug\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService\n*L\n253#1:301\n253#1:302,5\n*E\n"})
public final class SshConnectionService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationGroup sshConnectionsGroup = NotificationGroup.Companion.balloonGroup("SSH Connections", SshBundle.message("ssh.connections.notifications.group.title", new Object[0]));
    @NotNull
    private final String pageantName;
    @NotNull
    private final String sshAgentName;
    @Nullable
    private Pair<? extends Connector, String> agentProxyConnector;
    @NotNull
    private final ConcurrentHashMap<SshSessionKey, SshConnection> pool = new ConcurrentHashMap();
    @NotNull
    private final Object sshAgentProxyLock = new Object();
    @NotNull
    private final AgentProxyConnectorFactory agentProxyConnectorFactory;
    @Nullable
    private volatile String overridenSshAuthSock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SSH_AUTH_SOCK = "SSH_AUTH_SOCK";
    @NotNull
    private static final Topic<Listener> TOPIC;

    public SshConnectionService() {
        this.pageantName = "Pageant";
        this.sshAgentName = "ssh-agent";
        SshConnectionService sshConnectionService = this;
        SshConnectionService sshConnectionService2 = this;
        boolean bl = false;
        sshConnectionService2.agentProxyConnectorFactory = new AgentProxyConnectorFactory(this, sshConnectionService){
            final /* synthetic */ SshConnectionService this$0;
            final /* synthetic */ SshConnectionService $sshConnectionService;
            {
                this.this$0 = $receiver;
                this.$sshConnectionService = $sshConnectionService;
            }

            public Pair<Connector, String> get(String path2) {
                return SshConnectionService.access$getAgentProxyConnector(this.this$0, path2);
            }

            public String toString() {
                return "<AgentProxyConnectionFactory of " + this.$sshConnectionService + "}>";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object;
        Object object2 = this.sshAgentProxyLock;
        synchronized (object2) {
            boolean bl = false;
            this.agentProxyConnector = null;
            object = Unit.INSTANCE;
        }
        LOG.debug("Disconnecting SSH connections on " + SshConnectionService.class + " dispose");
        Iterator iterator = ((Map)this.pool).entrySet().iterator();
        while (iterator.hasNext()) {
            object = (SshConnection)iterator.next().getValue();
            ((SshConnection)object).dispose();
        }
        this.pool.clear();
    }

    @TestOnly
    public final void reset() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Connector, String> W(String string) {
        Object object = this.sshAgentProxyLock;
        synchronized (object) {
            block5: {
                boolean bl = false;
                if (string == null) break block5;
                String string2 = string;
                boolean bl2 = false;
                Pair<Connector, String> pair = this.n(string2);
                return pair;
            }
            Pair<? extends Connector, String> pair = this.agentProxyConnector;
            if (pair == null) {
                Pair<Connector, String> pair2;
                Pair<Connector, String> pair3 = pair2 = this.n(null);
                boolean bl = false;
                this.agentProxyConnector = pair3;
                pair = pair2;
            }
            Pair<? extends Connector, String> pair4 = pair;
            return pair4;
        }
    }

    @NotNull
    public final AgentProxyConnectorFactory getAgentProxyConnectorFactory() {
        return this.agentProxyConnectorFactory;
    }

    private final Pair<Connector, String> n(String string) {
        LOG.debug("Creating authentication agent connector");
        if (SystemInfo.isWindows) {
            NamedPipeAgentConnector namedPipeAgentConnector;
            if (Registry.Companion.is("openssh.agent.windows") && (namedPipeAgentConnector = NamedPipeAgentConnector.Companion.getInstance()).isAvailable()) {
                return TuplesKt.to((Object)namedPipeAgentConnector, (Object)namedPipeAgentConnector.getName());
            }
            try {
                return TuplesKt.to((Object)new PageantConnector(), (Object)"pageant");
            }
            catch (AgentProxyException agentProxyException) {
                this.W("Pageant", agentProxyException);
                this.W(this.pageantName, agentProxyException.getMessage());
            }
        } else {
            String string2 = null;
            if (string != null) {
                if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0]) || ((CharSequence)string).length() == 0) {
                    LOG.info("Path " + string + " to SSH agent socket is incorrect");
                    Object[] objectArray = new Object[]{string};
                    this.W(this.sshAgentName, SshBundle.message("ssh.connection.service.0.path.to.auth.socket.is.incorrect", objectArray));
                    return null;
                }
                string2 = string;
                LOG.debug("UNIX-domain socket by path " + string + " will be used to connect to authentication agent");
            } else {
                string2 = this.W();
                if (((CharSequence)string2).length() == 0) {
                    LOG.info("SSH_AUTH_SOCK environment variable is not defined");
                    Object[] objectArray = new Object[]{SSH_AUTH_SOCK};
                    this.W(this.sshAgentName, SshBundle.message("ssh.connection.service.0.environment.variable.is.not.defined", objectArray));
                    return null;
                }
                LOG.debug("UNIX-domain socket " + string2 + " defined in environment variable SSH_AUTH_SOCK will be used to connect to authentication agent");
            }
            try {
                return TuplesKt.to((Object)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory(), string2), (Object)("ssh-agent[" + string2 + "]"));
            }
            catch (AgentProxyException agentProxyException) {
                this.W("ssh-agent", agentProxyException);
                this.W(this.sshAgentName, agentProxyException.getMessage());
            }
        }
        return null;
    }

    private final void W(String string, AgentProxyException agentProxyException) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to create " + string + " proxy", (Throwable)agentProxyException);
        } else {
            LOG.info("Failed to create " + string + " proxy: " + agentProxyException);
        }
    }

    private final void W(@NlsSafe String string, @Nls(capitalization=Nls.Capitalization.Sentence) String string2) {
        Object[] objectArray = new Object[]{string, string2};
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(SshBundle.message("ssh.connection.service.unable.to.connect.to.0.1", objectArray)).br().append("\n\n");
        objectArray = new Object[]{string};
        String string3 = htmlBuilder.append(SshBundle.message("ssh.connection.service.using.0.during.ssh.key.based.authentication.process.disabled", objectArray)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String string4 = string3;
        objectArray = new Object[]{string};
        String string5 = SshBundle.message("ssh.connection.service.notification.title.authentication.using", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        this.sshConnectionsGroup.createNotification(string5, string4, NotificationType.WARNING).notify(null);
    }

    private final SshConnection W(SessionConfig sessionConfig) {
        SshSessionKey sshSessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection = this.pool.computeIfAbsent(sshSessionKey, arg_0 -> SshConnectionService.W(arg_0 -> SshConnectionService.W(sshSessionKey, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sshConnection, (String)"computeIfAbsent(...)");
        return sshConnection;
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.W(sessionConfig).getSshSession(sessionConfig);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig, boolean addToPool) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.W(sessionConfig).checkCanAuthenticate(sessionConfig, addToPool);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(SshConnectionService sshConnectionService, SessionConfig sessionConfig, boolean bl, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sshConnectionService.checkCanAuthenticate(sessionConfig, bl);
    }

    @NotNull
    public final ExecChannel exec(@NotNull SessionConfig sessionConfig, @NotNull ExecChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (ExecChannel)this.W(sessionConfig).openChannel(sessionConfig, arg_0 -> SshConnectionService.W(channelConfig, arg_0));
    }

    @NotNull
    public final SftpChannel sftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (SftpChannel)this.W(sessionConfig).openChannel(sessionConfig, arg_0 -> SshConnectionService.W(channelConfig, arg_0));
    }

    @NotNull
    public final SftpChannel failSafeSftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return new FailSafeSftpChannel((Function0<? extends SftpChannel>)((Function0)() -> SshConnectionService.W(this, sessionConfig, channelConfig)));
    }

    @NotNull
    public final ShellChannel shell(@NotNull SessionConfig sessionConfig, @NotNull ShellChannelConfig channelConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        return (ShellChannel)this.W(sessionConfig, arg_0 -> SshConnectionService.W(channelConfig, arg_0));
    }

    private final <R extends SshChannel> R W(SessionConfig sessionConfig, Function1<? super SshSessionChannelFactory, ? extends R> function1) throws SshException {
        return this.W(sessionConfig).openChannel(sessionConfig, function1);
    }

    @ApiStatus.Internal
    @NotNull
    public final List<SshSession> getSessions() {
        Map map = this.pool;
        boolean bl = false;
        Map map2 = map;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Map.Entry entry : map2.entrySet()) {
            Object object = entry;
            boolean bl3 = false;
            object = ((SshConnection)object.getValue()).getSessions();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (List)collection;
    }

    private final String W() {
        String string = (String)EnvironmentUtil.getEnvironmentMap().get(SSH_AUTH_SOCK);
        String string2 = this.overridenSshAuthSock;
        if (string2 == null && (string2 = string) == null) {
            string2 = "";
        }
        return string2;
    }

    @TestOnly
    public final void overrideSshAuthSock(@Nullable String value) {
        this.overridenSshAuthSock = value;
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return SshConnectionService.checkCanAuthenticate$default(this, sessionConfig, false, 2, null);
    }

    private static final SshConnection W(SshSessionKey sshSessionKey, SshSessionKey sshSessionKey2) {
        Intrinsics.checkNotNullParameter((Object)sshSessionKey2, (String)"it");
        return new SshConnection(sshSessionKey.getUsername(), sshSessionKey.getHost(), sshSessionKey.getPort());
    }

    private static final SshConnection W(Function1 function1, Object object) {
        return (SshConnection)function1.invoke(object);
    }

    private static final ExecChannel W(ExecChannelConfig execChannelConfig, SshSessionChannelFactory sshSessionChannelFactory) {
        Intrinsics.checkNotNullParameter((Object)sshSessionChannelFactory, (String)"session");
        LOG.debug("Executing SSH command: " + execChannelConfig.getCommand() + " within " + sshSessionChannelFactory);
        return sshSessionChannelFactory.execChannel(execChannelConfig);
    }

    private static final SftpChannel W(SftpChannelConfig sftpChannelConfig, SshSessionChannelFactory sshSessionChannelFactory) {
        Intrinsics.checkNotNullParameter((Object)sshSessionChannelFactory, (String)"session");
        LOG.debug("Creating sftp channel within " + sshSessionChannelFactory);
        return sshSessionChannelFactory.sftpChannel(sftpChannelConfig);
    }

    private static final SftpChannel W(SshConnectionService sshConnectionService, SessionConfig sessionConfig, SftpChannelConfig sftpChannelConfig) {
        return sshConnectionService.sftp(sessionConfig, sftpChannelConfig);
    }

    private static final ShellChannel W(ShellChannelConfig shellChannelConfig, SshSessionChannelFactory sshSessionChannelFactory) {
        Intrinsics.checkNotNullParameter((Object)sshSessionChannelFactory, (String)"session");
        LOG.debug("Creating shell channel within " + sshSessionChannelFactory);
        return sshSessionChannelFactory.shellChannel(shellChannelConfig);
    }

    @NotNull
    public static final SshConnectionService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Pair access$getAgentProxyConnector(SshConnectionService $this, String path2) {
        return $this.W(path2);
    }

    static {
        Logger logger = Logger.getInstance(SshConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Topic topic = Topic.create((String)"SshConnectionService", Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/SshConnectionService$Companion;", "", "SshConnectionService$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SSH_AUTH_SOCK", "", "instance", "Lcom/intellij/ssh/SshConnectionService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/ssh/SshConnectionService;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/ssh/SshConnectionService$Listener;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,299:1\n42#2,3:300\n*S KotlinDebug\n*F\n+ 1 SshConnectionService.kt\ncom/intellij/ssh/SshConnectionService$Companion\n*L\n290#1:300,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SshConnectionService getInstance() {
            boolean bl = false;
            Class<SshConnectionService> clazz = SshConnectionService.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SshConnectionService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ssh/SshConnectionService$Listener;", "", "sessionOrChannelRequested", "", "userName", "", "host", "port", "", "intellij.platform.ssh"})
    public static interface Listener {
        public void sessionOrChannelRequested(@NotNull String var1, @NotNull String var2, int var3);
    }
}

