/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.BorderPropertySet;
import com.openhtmltopdf.css.style.derived.RectPropertySet;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.BoxDimensions;
import com.openhtmltopdf.render.ContentLimitContainer;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.FlowingColumnContainerBox;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.LambdaUtil;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.w3c.dom.Element;

public abstract class Box
implements Styleable,
DisplayListItem {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Element _element;
    private int _x;
    private int _y;
    private int _absY;
    private int _absX;
    private int _contentWidth;
    private int _rightMBP = 0;
    private int _leftMBP = 0;
    private int _height;
    private Layer _layer = null;
    private Layer _containingLayer;
    private Box _parent;
    private List<Box> _boxes;
    private int _tx;
    private int _ty;
    private CalculatedStyle _style;
    private Box _containingBlock;
    private Dimension _relativeOffset;
    private PaintingInfo _paintingInfo;
    private RectPropertySet _workingMargin;
    private int _index;
    private String _pseudoElementOrClass;
    private boolean _anonymous;
    private Area _absoluteClipBox;
    private boolean _clipBoxCalculated = false;
    private Object _accessibilityObject;
    public static final int NOTHING = 0;
    public static final int FLUX = 1;
    public static final int CHILDREN_FLUX = 2;
    public static final int DONE = 3;
    private int _state = 0;
    public static final int DUMP_RENDER = 2;
    public static final int DUMP_LAYOUT = 1;

    protected Box() {
    }

    public Rectangle getClipBox(RenderingContext c, Layer layer) {
        return this.calcClipBox(c, layer);
    }

    private Box getClipParent() {
        if (this.getStyle() != null && this.getStyle().isPositioned()) {
            return this.getContainingBlock();
        }
        if (this instanceof BlockBox && ((BlockBox)this).isFloated()) {
            return this.getContainingBlock();
        }
        return this.getParent();
    }

    public Rectangle getParentClipBox(RenderingContext c, Layer layer) {
        Box clipParent = this.getClipParent();
        if (clipParent == null || clipParent.getContainingLayer() != layer) {
            return null;
        }
        return clipParent.getClipBox(c, layer);
    }

    private Rectangle calcClipBox(RenderingContext c, Layer layer) {
        if (this.getContainingLayer() != layer) {
            return null;
        }
        if (this.getStyle() != null && this.getStyle().isIdent(CSSName.OVERFLOW, IdentValue.HIDDEN)) {
            Rectangle parentClip = this.getParentClipBox(c, layer);
            return parentClip != null ? this.getChildrenClipEdge(c).intersection(parentClip) : this.getChildrenClipEdge(c);
        }
        return this.getParentClipBox(c, layer);
    }

    public Area getAbsoluteClipBox(CssContext c) {
        if (!this._clipBoxCalculated) {
            this._absoluteClipBox = this.calcAbsoluteClipBox(c);
            this._clipBoxCalculated = true;
        }
        return this._absoluteClipBox != null ? (Area)this._absoluteClipBox.clone() : null;
    }

    private Area calcAbsoluteClipBox(CssContext c) {
        Area parentClip;
        Rectangle localClip = this.getStyle() != null && this.getStyle().isIdent(CSSName.OVERFLOW, IdentValue.HIDDEN) ? this.getChildrenClipEdge(c) : null;
        Box parentBox = this.getClipParent();
        Area area = parentClip = parentBox != null ? parentBox.getAbsoluteClipBox(c) : null;
        if (localClip != null) {
            AffineTransform transform = this.getContainingLayer().getCurrentTransformMatrix();
            Area ourClip = new Area(transform != null ? transform.createTransformedShape(localClip) : localClip);
            if (parentClip != null) {
                ourClip.intersect(parentClip);
            }
            return ourClip;
        }
        return parentClip;
    }

    public abstract String dump(LayoutContext var1, String var2, int var3);

    protected void dumpBoxes(LayoutContext c, String indent, List<Box> boxes, int which, StringBuilder result) {
        Iterator<Box> i = boxes.iterator();
        while (i.hasNext()) {
            Box b = i.next();
            result.append(b.dump(c, indent + "  ", which));
            if (!i.hasNext()) continue;
            result.append('\n');
        }
    }

    public int getWidth() {
        return this.getContentWidth() + this.getLeftMBP() + this.getRightMBP();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Box: ");
        sb.append(" (" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + " x " + this.getHeight() + ")");
        return sb.toString();
    }

    public void addChildForLayout(LayoutContext c, Box child) {
        this.addChild(child);
        child.initContainingLayer(c);
    }

    public void addChild(Box child) {
        if (this._boxes == null) {
            this._boxes = new ArrayList<Box>();
        }
        if (child == null) {
            throw new NullPointerException("trying to add null child");
        }
        child.setParent(this);
        child.setIndex(this._boxes.size());
        this._boxes.add(child);
    }

    public void addAllChildren(List<Box> children) {
        children.forEach(this::addChild);
    }

    public void removeAllChildren() {
        if (this._boxes != null) {
            this._boxes.clear();
        }
    }

    public boolean removeChild(Box target) {
        if (this._boxes != null) {
            if (target.getIndex() < this.getChildCount() && this.getChild(target.getIndex()).equals(target)) {
                return this.removeChild(target.getIndex());
            }
            int index = this.getChildren().indexOf(target);
            return index >= 0 && this.removeChild(index);
        }
        return false;
    }

    public Box getPreviousSibling() {
        Box parent = this.getParent();
        return parent == null ? null : parent.getPrevious(this);
    }

    public Box getNextSibling() {
        Box parent = this.getParent();
        return parent == null ? null : parent.getNext(this);
    }

    protected Box getPrevious(Box child) {
        return child.getIndex() == 0 ? null : this.getChild(child.getIndex() - 1);
    }

    protected Box getNext(Box child) {
        return child.getIndex() == this.getChildCount() - 1 ? null : this.getChild(child.getIndex() + 1);
    }

    public boolean removeChild(int index) {
        if (this._boxes != null) {
            this.getChildren().remove(index);
            int size = this.getChildCount();
            for (int i = index; i < size; ++i) {
                Box child = this.getChild(i);
                child.setIndex(child.getIndex() - 1);
            }
            return true;
        }
        return false;
    }

    public void setParent(Box box) {
        this._parent = box;
    }

    public Box getParent() {
        return this._parent;
    }

    public Box getDocumentParent() {
        return this.getParent();
    }

    public int getChildCount() {
        return this._boxes == null ? 0 : this._boxes.size();
    }

    public Box getChild(int i) {
        if (this._boxes == null) {
            throw new IndexOutOfBoundsException();
        }
        return this._boxes.get(i);
    }

    public Iterator<Box> getChildIterator() {
        return this._boxes == null ? Collections.emptyIterator() : this._boxes.iterator();
    }

    public List<Box> getChildren() {
        return this._boxes == null ? Collections.emptyList() : this._boxes;
    }

    public <T> Iterator<T> getChildIteratorOfType(Class<T> type) {
        return new ChildIteratorOfType(this.getChildIterator(), type);
    }

    public synchronized int getState() {
        return this._state;
    }

    public synchronized void setState(int state) {
        this._state = state;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "NOTHING";
            }
            case 1: {
                return "FLUX";
            }
            case 2: {
                return "CHILDREN_FLUX";
            }
            case 3: {
                return "DONE";
            }
        }
        return "unknown";
    }

    @Override
    public final CalculatedStyle getStyle() {
        return this._style;
    }

    @Override
    public void setStyle(CalculatedStyle style) {
        this._style = style;
    }

    public Box getContainingBlock() {
        return this._containingBlock == null ? this.getParent() : this._containingBlock;
    }

    public void setContainingBlock(Box containingBlock) {
        this._containingBlock = containingBlock;
    }

    public Rectangle getMarginEdge(int left, int top, CssContext cssCtx, int tx, int ty) {
        Rectangle result = new Rectangle(left, top, this.getWidth(), this.getHeight());
        result.translate(tx, ty);
        return result;
    }

    public Rectangle getMarginEdge(CssContext cssCtx, int tx, int ty) {
        return this.getMarginEdge(this.getX(), this.getY(), cssCtx, tx, ty);
    }

    public Rectangle getPaintingBorderEdge(CssContext cssCtx) {
        return this.getBorderEdge(this.getAbsX(), this.getAbsY(), cssCtx);
    }

    public Rectangle getPaintingPaddingEdge(CssContext cssCtx) {
        return this.getPaddingEdge(this.getAbsX(), this.getAbsY(), cssCtx);
    }

    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        return this.getPaintingBorderEdge(cssCtx);
    }

    public Rectangle getChildrenClipEdge(CssContext c) {
        return this.getPaintingPaddingEdge(c);
    }

    public boolean intersects(CssContext cssCtx, Shape clip) {
        AffineTransform ctm = this.getContainingLayer().getCurrentTransformMatrix();
        if (ctm == null || clip == null) {
            return clip == null || clip.intersects(this.getPaintingClipEdge(cssCtx));
        }
        Shape boxShape = ctm.createTransformedShape(this.getPaintingClipEdge(cssCtx));
        return clip.intersects(boxShape.getBounds2D());
    }

    public Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left(), top + (int)margin.top(), this.getWidth() - (int)margin.left() - (int)margin.right(), this.getHeight() - (int)margin.top() - (int)margin.bottom());
        return result;
    }

    public Rectangle getPaddingEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        BorderPropertySet border = this.getBorder(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left() + (int)border.left(), top + (int)margin.top() + (int)border.top(), this.getWidth() - (int)margin.width() - (int)border.width(), this.getHeight() - (int)margin.height() - (int)border.height());
        return result;
    }

    protected int getPaddingWidth(CssContext cssCtx) {
        RectPropertySet padding = this.getPadding(cssCtx);
        return (int)padding.left() + this.getContentWidth() + (int)padding.right();
    }

    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left() + (int)border.left() + (int)padding.left(), top + (int)margin.top() + (int)border.top() + (int)padding.top(), this.getWidth() - (int)margin.width() - (int)border.width() - (int)padding.width(), this.getHeight() - (int)margin.height() - (int)border.height() - (int)padding.height());
        return result;
    }

    public Layer getLayer() {
        return this._layer;
    }

    public void setLayer(Layer layer) {
        this._layer = layer;
    }

    public Dimension positionRelative(CssContext cssCtx) {
        int initialX = this.getX();
        int initialY = this.getY();
        CalculatedStyle style = this.getStyle();
        if (!style.isIdent(CSSName.LEFT, IdentValue.AUTO)) {
            this.setX(this.getX() + (int)style.getFloatPropertyProportionalWidth(CSSName.LEFT, this.getContainingBlock().getContentWidth(), cssCtx));
        } else if (!style.isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
            this.setX(this.getX() - (int)style.getFloatPropertyProportionalWidth(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), cssCtx));
        }
        int cbContentHeight = 0;
        if (!this.getContainingBlock().getStyle().isAutoHeight()) {
            CalculatedStyle cbStyle = this.getContainingBlock().getStyle();
            cbContentHeight = (int)cbStyle.getFloatPropertyProportionalHeight(CSSName.HEIGHT, 0.0f, cssCtx);
        } else if (this.isInlineBlock()) {
            cbContentHeight = this.getContainingBlock().getHeight();
        }
        if (!style.isIdent(CSSName.TOP, IdentValue.AUTO)) {
            this.setY(this.getY() + (int)style.getFloatPropertyProportionalHeight(CSSName.TOP, cbContentHeight, cssCtx));
        } else if (!style.isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
            this.setY(this.getY() - (int)style.getFloatPropertyProportionalHeight(CSSName.BOTTOM, cbContentHeight, cssCtx));
        }
        this.setRelativeOffset(new Dimension(this.getX() - initialX, this.getY() - initialY));
        return this.getRelativeOffset();
    }

    protected boolean isInlineBlock() {
        return false;
    }

    public void setAbsY(int absY) {
        this._absY = absY;
    }

    public int getAbsY() {
        return this._absY;
    }

    public void setAbsX(int absX) {
        this._absX = absX;
    }

    public int getAbsX() {
        return this._absX;
    }

    public boolean isStyled() {
        return this._style != null;
    }

    public int getBorderSides() {
        return 15;
    }

    public void paintBorder(RenderingContext c) {
        c.getOutputDevice().paintBorder(c, this);
    }

    private boolean isPaintsRootElementBackground() {
        return this.isRoot() && this.getStyle().isHasBackground() || this.isBody() && !this.getParent().getStyle().isHasBackground();
    }

    public void paintBackground(RenderingContext c) {
        if (!this.isPaintsRootElementBackground()) {
            c.getOutputDevice().paintBackground(c, this);
        }
    }

    public boolean hasNonTextContent(CssContext c) {
        if (this.getStyle().getBackgroundColor() != null && this.getStyle().getBackgroundColor() != FSRGBColor.TRANSPARENT) {
            return true;
        }
        if (!this.getStyle().isIdent(CSSName.BACKGROUND_IMAGE, IdentValue.NONE)) {
            return true;
        }
        BorderPropertySet border = this.getBorder(c);
        return !border.isAllZeros();
    }

    public void setAccessiblityObject(Object object) {
        this._accessibilityObject = object;
    }

    public Object getAccessibilityObject() {
        return this._accessibilityObject;
    }

    public void paintRootElementBackground(RenderingContext c) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null) {
            if (this.getStyle().isHasBackground()) {
                this.paintRootElementBackground(c, pI);
            } else if (this.getChildCount() > 0) {
                Box body = this.getChild(0);
                body.paintRootElementBackground(c, pI);
            }
        }
    }

    private void paintRootElementBackground(RenderingContext c, PaintingInfo pI) {
        Dimension marginCorner = pI.getOuterMarginCorner();
        Rectangle canvasBounds = new Rectangle(0, 0, marginCorner.width, marginCorner.height);
        canvasBounds.add(c.getViewportRectangle());
        c.getOutputDevice().paintBackground(c, this.getStyle(), canvasBounds, canvasBounds, BorderPropertySet.EMPTY_BORDER);
    }

    public boolean hasRootElementBackground(RenderingContext c) {
        if (this.getStyle().isHasBackground()) {
            return true;
        }
        return this.getChildCount() > 0 && this.getChild(0).getStyle().isHasBackground();
    }

    public Layer getContainingLayer() {
        return this._containingLayer;
    }

    public void setContainingLayer(Layer containingLayer) {
        this._containingLayer = containingLayer;
    }

    public void initContainingLayer(LayoutContext c) {
        if (this.getLayer() != null) {
            this.setContainingLayer(this.getLayer());
        } else if (this.getContainingLayer() == null) {
            List<Box> content;
            if (this.getParent() == null || this.getParent().getContainingLayer() == null) {
                throw new RuntimeException("internal error");
            }
            this.setContainingLayer(this.getParent().getContainingLayer());
            if (c.getLayer().isInline() && (content = ((InlineLayoutBox)c.getLayer().getMaster()).getElementWithContent()).contains(this)) {
                this.setContainingLayer(c.getLayer());
            }
        }
    }

    public void connectChildrenToCurrentLayer(LayoutContext c) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box box = this.getChild(i);
            box.setContainingLayer(c.getLayer());
            box.connectChildrenToCurrentLayer(c);
        }
    }

    public List<Box> getElementBoxes(Element elem) {
        ArrayList<Box> result = new ArrayList<Box>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            if (child.getElement() == elem) {
                result.add(child);
            }
            result.addAll(child.getElementBoxes(elem));
        }
        return result;
    }

    public void reset(LayoutContext c) {
        String id;
        Element e;
        this.resetChildren(c);
        if (this._layer != null) {
            this._layer.detach();
            this._layer = null;
        }
        this.setContainingLayer(null);
        this.setLayer(null);
        this.setPaintingInfo(null);
        this.setContentWidth(0);
        this._workingMargin = null;
        String anchorName = c.getNamespaceHandler().getAnchorName(this.getElement());
        if (anchorName != null) {
            c.removeBoxId(anchorName);
        }
        if ((e = this.getElement()) != null && (id = c.getNamespaceHandler().getID(e)) != null) {
            c.removeBoxId(id);
        }
    }

    public void detach(LayoutContext c) {
        this.reset(c);
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
            this.setParent(null);
        }
    }

    public void resetChildren(LayoutContext c, int start, int end) {
        for (int i = start; i <= end; ++i) {
            Box box = this.getChild(i);
            box.reset(c);
        }
    }

    protected void resetChildren(LayoutContext c) {
        int remaining = this.getChildCount();
        for (int i = 0; i < remaining; ++i) {
            Box box = this.getChild(i);
            box.reset(c);
        }
    }

    public abstract void calcCanvasLocation();

    public void calcChildLocations() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    public int forcePageBreakBefore(LayoutContext c, IdentValue pageBreakValue, boolean pendingPageName) {
        return this.forcePageBreakBefore(c, pageBreakValue, pendingPageName, this.getAbsY());
    }

    public int forcePageBreakBefore(LayoutContext c, IdentValue pageBreakValue, boolean pendingPageName, int absY) {
        PageBox page = c.getRootLayer().getFirstPage((CssContext)c, absY);
        if (page == null) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.LAYOUT_BOX_HAS_NO_PAGE);
            return 0;
        }
        int pageBreakCount = 1;
        if (page.getTop() == absY) {
            --pageBreakCount;
            if (pendingPageName && page == c.getRootLayer().getLastPage()) {
                c.getRootLayer().removeLastPage();
                c.setPageName(c.getPendingPageName());
                c.getRootLayer().addPage(c);
            }
        }
        if (page.isLeftPage() && pageBreakValue == IdentValue.LEFT || page.isRightPage() && pageBreakValue == IdentValue.RIGHT) {
            ++pageBreakCount;
        }
        if (pageBreakCount == 0) {
            return 0;
        }
        if (pageBreakCount == 1 && pendingPageName) {
            c.setPageName(c.getPendingPageName());
        }
        int delta = page.getBottom() + c.getExtraSpaceTop() - absY;
        if (page == c.getRootLayer().getLastPage()) {
            c.getRootLayer().addPage(c);
        }
        if (pageBreakCount == 2) {
            page = c.getRootLayer().getPages().get(page.getPageNo() + 1);
            delta += page.getContentHeight(c);
            if (pendingPageName) {
                c.setPageName(c.getPendingPageName());
            }
            if (page == c.getRootLayer().getLastPage()) {
                c.getRootLayer().addPage(c);
            }
        }
        this.setY(this.getY() + delta);
        return delta;
    }

    public void forcePageBreakAfter(LayoutContext c, IdentValue pageBreakValue) {
        boolean needSecondPageBreak = false;
        PageBox page = c.getRootLayer().getLastPage(c, this);
        if (page != null) {
            if (page.isLeftPage() && pageBreakValue == IdentValue.LEFT || page.isRightPage() && pageBreakValue == IdentValue.RIGHT) {
                needSecondPageBreak = true;
            }
            int delta = page.getBottom() + c.getExtraSpaceTop() - (this.getAbsY() + this.getMarginBorderPadding(c, 3) + this.getHeight());
            if (page == c.getRootLayer().getLastPage()) {
                c.getRootLayer().addPage(c);
            }
            if (needSecondPageBreak) {
                page = c.getRootLayer().getPages().get(page.getPageNo() + 1);
                delta += page.getContentHeight(c);
                if (page == c.getRootLayer().getLastPage()) {
                    c.getRootLayer().addPage(c);
                }
            }
            this.setHeight(this.getHeight() + delta);
        }
    }

    public boolean crossesPageBreak(LayoutContext c) {
        if (!c.isPageBreaksAllowed()) {
            return false;
        }
        PageBox pageBox = c.getRootLayer().getFirstPage((CssContext)c, this);
        if (pageBox == null) {
            return false;
        }
        if (c.isInFloatBottom()) {
            return this.getAbsY() + this.getHeight() >= pageBox.getBottom();
        }
        return this.getAbsY() + this.getHeight() >= pageBox.getBottom(c) - c.getExtraSpaceBottom();
    }

    public Dimension getRelativeOffset() {
        return this._relativeOffset;
    }

    public void setRelativeOffset(Dimension relativeOffset) {
        this._relativeOffset = relativeOffset;
    }

    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            result = child.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        return edge.contains(absX, absY) && this.getStyle().isVisible(null, this) ? this : null;
    }

    public boolean isRoot() {
        return this.getElement() != null && !this.isAnonymous() && this.getElement().getParentNode().getNodeType() == 9;
    }

    public boolean isBody() {
        return this.getParent() != null && this.getParent().isRoot();
    }

    @Override
    public Element getElement() {
        return this._element;
    }

    @Override
    public void setElement(Element element) {
        this._element = element;
    }

    public void setMarginTop(CssContext cssContext, int marginTop) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setTop(marginTop);
    }

    public void setMarginBottom(CssContext cssContext, int marginBottom) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setBottom(marginBottom);
    }

    public void setMarginLeft(CssContext cssContext, int marginLeft) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setLeft(marginLeft);
    }

    public void setMarginRight(CssContext cssContext, int marginRight) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setRight(marginRight);
    }

    private void ensureWorkingMargin(CssContext cssContext) {
        if (this._workingMargin == null) {
            this._workingMargin = this.getStyleMargin(cssContext).copyOf();
        }
    }

    public RectPropertySet getMargin(CssContext cssContext) {
        return this._workingMargin != null ? this._workingMargin : this.getStyleMargin(cssContext);
    }

    protected RectPropertySet getStyleMargin(CssContext cssContext) {
        return this.getStyle().getMarginRect(this.getContainingBlockWidth(), cssContext);
    }

    protected RectPropertySet getStyleMargin(CssContext cssContext, boolean useCache) {
        return this.getStyle().getMarginRect(this.getContainingBlockWidth(), cssContext, useCache);
    }

    public RectPropertySet getPadding(CssContext cssCtx) {
        return this.getStyle().getPaddingRect(this.getContainingBlockWidth(), cssCtx);
    }

    public BorderPropertySet getBorder(CssContext cssCtx) {
        return this.getStyle().getBorder(cssCtx);
    }

    protected int getContainingBlockWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    protected void resetTopMargin(CssContext cssContext) {
        if (this._workingMargin != null) {
            RectPropertySet styleMargin = this.getStyleMargin(cssContext);
            this._workingMargin.setTop(styleMargin.top());
        }
    }

    public PaintingInfo calcPaintingInfo(CssContext c, boolean useCache) {
        PaintingInfo cached = this.getPaintingInfo();
        if (cached != null && useCache) {
            return cached;
        }
        PaintingInfo result = new PaintingInfo();
        Rectangle bounds = this.getMarginEdge(this.getAbsX(), this.getAbsY(), c, 0, 0);
        result.setOuterMarginCorner(new Dimension(bounds.x + bounds.width, bounds.y + bounds.height));
        result.setAggregateBounds(this.getPaintingClipEdge(c));
        if (!this.getStyle().isOverflowApplies() || this.getStyle().isOverflowVisible()) {
            this.calcChildPaintingInfo(c, result, useCache);
        }
        this.setPaintingInfo(result);
        return result;
    }

    protected void calcChildPaintingInfo(CssContext c, PaintingInfo result, boolean useCache) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            PaintingInfo info = child.calcPaintingInfo(c, useCache);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
            result.getAggregateBounds().add(info.getAggregateBounds());
        }
    }

    public int getMarginBorderPadding(CssContext cssCtx, int which) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet margin = this.getMargin(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        switch (which) {
            case 1: {
                return (int)(margin.left() + border.left() + padding.left());
            }
            case 2: {
                return (int)(margin.right() + border.right() + padding.right());
            }
            case 3: {
                return (int)(margin.top() + border.top() + padding.top());
            }
            case 4: {
                return (int)(margin.bottom() + border.bottom() + padding.bottom());
            }
        }
        throw new IllegalArgumentException();
    }

    protected void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    protected int getIndex() {
        return this._index;
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    @Override
    public String getPseudoElementOrClass() {
        return this._pseudoElementOrClass;
    }

    public void setPseudoElementOrClass(String pseudoElementOrClass) {
        this._pseudoElementOrClass = pseudoElementOrClass;
    }

    public void setX(int x) {
        this._x = x;
    }

    public int getX() {
        return this._x;
    }

    public void setY(int y) {
        this._y = y;
    }

    public int getY() {
        return this._y;
    }

    public void setTy(int ty) {
        this._ty = ty;
    }

    public int getTy() {
        return this._ty;
    }

    public void setTx(int tx) {
        this._tx = tx;
    }

    public int getTx() {
        return this._tx;
    }

    public void setRightMBP(int rightMBP) {
        this._rightMBP = rightMBP;
    }

    public int getRightMBP() {
        return this._rightMBP;
    }

    public void setLeftMBP(int leftMBP) {
        this._leftMBP = leftMBP;
    }

    public int getLeftMBP() {
        return this._leftMBP;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getHeight() {
        return this._height;
    }

    protected void setBorderBoxHeight(CssContext c, int h) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        this.setHeight((int)Math.max(0.0f, (float)h - border.height() - padding.height()));
    }

    public int getBorderBoxHeight(CssContext c) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        return (int)((float)this.getHeight() + border.height() + padding.height());
    }

    public Rectangle getBorderBox(CssContext c) {
        RectPropertySet margin = this.getMargin(c);
        int w = this.getBorderBoxWidth(c);
        int h = this.getHeight() - (int)margin.top() - (int)margin.bottom();
        int x = this.getAbsX() + (int)margin.left();
        int y = this.getAbsY() + (int)margin.top();
        return new Rectangle(x, y, w, h);
    }

    public void setContentWidth(int contentWidth) {
        this._contentWidth = contentWidth < 0 ? 0 : contentWidth;
    }

    public int getContentWidth() {
        return this._contentWidth;
    }

    public int getBorderBoxWidth(CssContext c) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        return (int)((float)this.getContentWidth() + border.width() + padding.width());
    }

    public void setBorderBoxWidth(CssContext c, int borderBoxWidth) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        this.setContentWidth((int)((float)borderBoxWidth - border.width() - padding.width()));
    }

    public PaintingInfo getPaintingInfo() {
        return this._paintingInfo;
    }

    private void setPaintingInfo(PaintingInfo paintingInfo) {
        this._paintingInfo = paintingInfo;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }

    public BoxDimensions getBoxDimensions() {
        BoxDimensions result = new BoxDimensions();
        result.setLeftMBP(this.getLeftMBP());
        result.setRightMBP(this.getRightMBP());
        result.setContentWidth(this.getContentWidth());
        result.setHeight(this.getHeight());
        return result;
    }

    public void setBoxDimensions(BoxDimensions dimensions) {
        this.setLeftMBP(dimensions.getLeftMBP());
        this.setRightMBP(dimensions.getRightMBP());
        this.setContentWidth(dimensions.getContentWidth());
        this.setHeight(dimensions.getHeight());
    }

    public void collectText(RenderingContext c, StringBuilder buffer) {
        for (Box b : this.getChildren()) {
            b.collectText(c, buffer);
        }
    }

    public void exportText(RenderingContext c, Writer writer) throws IOException {
        if (c.isPrint() && this.isRoot()) {
            c.setPage(0, c.getRootLayer().getPages().get(0));
            c.getPage().exportLeadingText(c, writer);
        }
        for (Box b : this.getChildren()) {
            b.exportText(c, writer);
        }
        if (c.isPrint() && this.isRoot()) {
            this.exportPageBoxText(c, writer);
        }
    }

    private void exportPageBoxText(RenderingContext c, Writer writer) throws IOException {
        c.getPage().exportTrailingText(c, writer);
        if (c.getPage() != c.getRootLayer().getLastPage()) {
            List<PageBox> pages = c.getRootLayer().getPages();
            do {
                PageBox next = pages.get(c.getPageNo() + 1);
                c.setPage(next.getPageNo(), next);
                next.exportLeadingText(c, writer);
                next.exportTrailingText(c, writer);
            } while (c.getPage() != c.getRootLayer().getLastPage());
        }
    }

    protected void exportPageBoxText(RenderingContext c, Writer writer, int yPos) throws IOException {
        c.getPage().exportTrailingText(c, writer);
        List<PageBox> pages = c.getRootLayer().getPages();
        PageBox next = pages.get(c.getPageNo() + 1);
        c.setPage(next.getPageNo(), next);
        while (next.getBottom() < yPos) {
            next.exportLeadingText(c, writer);
            next.exportTrailingText(c, writer);
            next = pages.get(c.getPageNo() + 1);
            c.setPage(next.getPageNo(), next);
        }
        next.exportLeadingText(c, writer);
    }

    public boolean isInDocumentFlow() {
        Box flowRoot = this.rootBox();
        return flowRoot.isRoot();
    }

    public void analyzePageBreaks(LayoutContext c, ContentLimitContainer container) {
        container.updateTop(c, this.getAbsY());
        for (Box b : this.getChildren()) {
            b.analyzePageBreaks(c, container);
        }
        container.updateBottom(c, this.getAbsY() + this.getHeight());
    }

    public FSColor getEffBackgroundColor(RenderingContext c) {
        FSColor result = null;
        for (Box current = this; current != null; current = current.getContainingBlock()) {
            result = current.getStyle().getBackgroundColor();
            if (result == null) continue;
            return result;
        }
        PageBox page = c.getPage();
        result = page.getStyle().getBackgroundColor();
        if (result == null) {
            return new FSRGBColor(255, 255, 255);
        }
        return result;
    }

    protected boolean isMarginAreaRoot() {
        return false;
    }

    public boolean isContainedInMarginBox() {
        return this.rootBox().isMarginAreaRoot();
    }

    public int getEffectiveWidth() {
        return this.getWidth();
    }

    protected boolean isInitialContainingBlock() {
        return false;
    }

    public boolean isFirstChild() {
        return this.getParent() != null && this.getParent().getChildCount() > 0 && this.getParent().getChild(0) == this;
    }

    public boolean isTerminalColumnBreak() {
        return this.getChildCount() == 0;
    }

    public List<Box> ancestorsWhile(Predicate<Box> predicate) {
        ArrayList<Box> ancestors = new ArrayList<Box>(4);
        for (Box parent = this.getParent(); parent != null && predicate.test(parent); parent = parent.getParent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    public List<Box> ancestors() {
        return this.ancestorsWhile(LambdaUtil.alwaysTrue());
    }

    public Box findAncestor(Predicate<Box> predicate) {
        Box parent;
        for (parent = this.getParent(); parent != null && !predicate.test(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public Box rootBox() {
        return this.getParent() != null ? this.findAncestor(bx -> bx.getParent() == null) : this;
    }

    public void findColumnBreakOpportunities(FlowingColumnContainerBox.ColumnBreakStore store) {
        if (this.isTerminalColumnBreak() && this.isFirstChild()) {
            List<Box> ancestors = this.ancestorsWhile(store::checkContainerShouldProcess);
            store.addBreak(this, ancestors);
        } else if (this.isTerminalColumnBreak()) {
            store.addBreak(this, null);
        } else {
            for (Box child : this.getChildren()) {
                child.findColumnBreakOpportunities(store);
            }
        }
    }

    public static class ChildIteratorOfType<T>
    implements Iterator<T> {
        private final Iterator<Box> iter;
        private final Class<T> type;

        private ChildIteratorOfType(Iterator<Box> parent, Class<T> clazz) {
            this.iter = parent;
            this.type = clazz;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            Box box = this.iter.next();
            if (this.type.isAssignableFrom(box.getClass())) {
                return (T)box;
            }
            XRLog.log(Level.SEVERE, LogMessageId.LogMessageId2Param.GENERAL_EXPECTING_BOX_CHILDREN_OF_TYPE_BUT_GOT, (Object)this.type.getCanonicalName(), (Object)box.getClass().getCanonicalName());
            return null;
        }
    }
}

