/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebContextConfigurable
extends PerFileConfigurableBase<String> {
    public WebContextConfigurable(@NotNull Project project) {
        if (project == null) {
            WebContextConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappingsEx)new MyMappings(project));
    }

    @Nls
    public String getDisplayName() {
        return WebBundle.message("web.contexts", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.settings.webcontexts";
    }

    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            WebContextConfigurable.$$$reportNull$$$0(1);
        }
        if (key == DESCRIPTION) {
            return WebBundle.message("web.contexts.caption", ApplicationNamesInfo.getInstance().getProductName());
        }
        if (key == MAPPING_TITLE) {
            return WebBundle.message("web.context", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return "There are web contexts specified for the subdirectories. Override them?";
        }
        if (key == OVERRIDE_TITLE) {
            return "Override Web Contexts";
        }
        if (key == EMPTY_TEXT) {
            return WebBundle.message("web.contexts.no.contexts", new Object[0]);
        }
        return null;
    }

    protected boolean canRemoveTarget(Object target) {
        return !this.isWebRoot(target);
    }

    protected void renderValue(@Nullable Object target, @NotNull String s, @NotNull ColoredTextContainer renderer) {
        VirtualFile file;
        WebDirectoryElement element;
        if (s == null) {
            WebContextConfigurable.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            WebContextConfigurable.$$$reportNull$$$0(3);
        }
        WebDirectoryElement webDirectoryElement = element = (file = VirtualFileManager.getInstance().findFileByUrl(s)) == null ? null : WebUtil.findWebDirectoryByFile((VirtualFile)file, (Project)this.myProject);
        if (element != null) {
            @NlsSafe String path = element.getPath();
            renderer.append(path, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    protected void renderTarget(@Nullable Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            WebContextConfigurable.$$$reportNull$$$0(4);
        }
        super.renderTarget(target, renderer);
        if (this.isWebRoot(target)) {
            renderer.setIcon(AllIcons.Nodes.WebFolder);
        }
    }

    private boolean isWebRoot(@Nullable Object target) {
        return ((MyMappings)this.myMappings).roots.contains(target);
    }

    @NotNull
    protected Collection<String> getValueVariants(@Nullable Object target) {
        Collection<String> collection = ((MyMappings)this.myMappings).getValueVariants((VirtualFile)target);
        if (collection == null) {
            WebContextConfigurable.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/WebContextConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/WebContextConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderTarget";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class MyMappings
    implements PerFileMappingsEx<String> {
        final Project project;
        final Set<VirtualFile> roots = new LinkedHashSet<VirtualFile>();

        MyMappings(Project project) {
            this.project = project;
        }

        @NotNull
        public Map<VirtualFile, String> getMappings() {
            HashMap<VirtualFile, String> mappings = new HashMap<VirtualFile, String>(WebContextManager.getInstance((Project)this.project).getMappings());
            for (Module module : ModuleManager.getInstance((Project)this.project).getModules()) {
                for (WebFacet facet : WebFacet.getInstances((Module)module)) {
                    for (WebRoot root : facet.getWebRoots()) {
                        VirtualFile file = root.getFile();
                        if (file == null) continue;
                        this.roots.add(file);
                        if (mappings.containsKey(file)) continue;
                        mappings.put(file, null);
                    }
                }
            }
            HashMap<VirtualFile, String> hashMap = mappings;
            if (hashMap == null) {
                MyMappings.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        public void setMappings(@NotNull Map<VirtualFile, String> mappings) {
            if (mappings == null) {
                MyMappings.$$$reportNull$$$0(1);
            }
            WebContextManager.getInstance((Project)this.project).setMappings(mappings);
        }

        public void setMapping(VirtualFile file, String value) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<String> getValueVariants(@Nullable VirtualFile file) {
            WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)this.project);
            if (webFacet != null) {
                VirtualFile virtualFile;
                Collection items;
                VirtualFile originalVirtualFile;
                WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement("/", webFacet);
                if (element != null && (originalVirtualFile = element.getOriginalVirtualFile()) != null) {
                    List<String> list = Collections.singletonList(originalVirtualFile.getUrl());
                    if (list == null) {
                        MyMappings.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.project);
                if (module != null && !(items = WebUtil.getWebUtil().getContextsByPath("/", module)).isEmpty() && (virtualFile = ((PsiFileSystemItem)items.iterator().next()).getVirtualFile()) != null) {
                    List<String> list = Collections.singletonList(virtualFile.getUrl());
                    if (list == null) {
                        MyMappings.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                MyMappings.$$$reportNull$$$0(4);
            }
            return list;
        }

        public String getDefaultMapping(@Nullable VirtualFile file) {
            return null;
        }

        @Nullable
        public String getMapping(@Nullable VirtualFile file) {
            Map<VirtualFile, String> mappings = this.getMappings();
            for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
                String s = mappings.get(cur);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/web/WebContextConfigurable$MyMappings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/web/WebContextConfigurable$MyMappings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setMappings";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

