/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwReferenceDataWithSource;
import com.intellij.swagger.core.index.SwReferenceIndexAccessorKt;
import com.intellij.swagger.core.model.SwSecondarySpecificationSchemaAssemblyKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"computeSecondarySpecificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "specificationPart", "Lcom/intellij/psi/PsiFile;", "computeReferencesChainFromRoot", "", "Lcom/intellij/swagger/core/index/SwReferenceDataWithSource;", "root", "intellij.swagger.core"})
public final class SwSecondarySpecificationModelComputationKt {
    @NotNull
    public static final SwSpecificationType computeSecondarySpecificationType(@NotNull PsiFile specificationPart) {
        Intrinsics.checkNotNullParameter((Object)specificationPart, (String)"specificationPart");
        List<SwReferenceDataWithSource> referencesChainToRoot = SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot(specificationPart);
        Collection collection = referencesChainToRoot;
        if (collection == null || collection.isEmpty()) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        SwReferenceDataWithSource referenceToCurrentFile = (SwReferenceDataWithSource)CollectionsKt.last(referencesChainToRoot);
        PsiElement psiElement = referenceToCurrentFile.getSourcePsiFile().findElementAt(referenceToCurrentFile.getReferenceData().getReferenceOffsetInFile());
        if (psiElement == null) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        PsiElement elementWithReference = psiElement;
        return SwSecondarySpecificationSchemaAssemblyKt.inheritSecondarySpecificationTypeFromCurrentFileConsideringLocation(elementWithReference, !referenceToCurrentFile.getReferenceData().getReferencesEntireFile());
    }

    private static final List<SwReferenceDataWithSource> computeReferencesChainFromRoot(PsiFile root) {
        VirtualFile virtualFile = root.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!(SwSpecificationDetectionKt.detectPrimarySpecificationType(virtualFile, root) instanceof SwSpecificationType.NONE)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)root);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2).uniteWith(module2.getModuleContentScope());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"uniteWith(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Set visitedFileUrls = new LinkedHashSet();
        SwReferenceDataWithSource wrappedSearchRoot = new SwReferenceDataWithSource(root, false, new SwReferenceData("", -1, false));
        return CollectionsKt.dropLast(SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$findReferencesChainDfs(searchScope, visitedFileUrls, wrappedSearchRoot), (int)1);
    }

    private static final boolean computeReferencesChainFromRoot$isVisited(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24isVisited, Set<String> visitedFileUrls) {
        return visitedFileUrls.contains($this$computeReferencesChainFromRoot_u24isVisited.getSourcePsiFile().getVirtualFile().getUrl());
    }

    private static final void computeReferencesChainFromRoot$markVisited(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24markVisited, Set<String> visitedFileUrls) {
        String string = $this$computeReferencesChainFromRoot_u24markVisited.getSourcePsiFile().getVirtualFile().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        visitedFileUrls.add(string);
    }

    private static final boolean computeReferencesChainFromRoot$shouldContinueSearch(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24shouldContinueSearch) {
        VirtualFile virtualFile = $this$computeReferencesChainFromRoot_u24shouldContinueSearch.getSourcePsiFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return SwSpecificationDetectionKt.detectPrimarySpecificationType(virtualFile, $this$computeReferencesChainFromRoot_u24shouldContinueSearch.getSourcePsiFile()) instanceof SwSpecificationType.UNKNOWN;
    }

    private static final List<SwReferenceDataWithSource> computeReferencesChainFromRoot$findReferencesChainDfs(GlobalSearchScope searchScope, Set<String> visitedFileUrls, SwReferenceDataWithSource currentRoot) {
        ProgressManager.checkCanceled();
        if (SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$isVisited(currentRoot, visitedFileUrls)) {
            return CollectionsKt.emptyList();
        }
        SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$markVisited(currentRoot, visitedFileUrls);
        if (!SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$shouldContinueSearch(currentRoot)) {
            return CollectionsKt.listOf((Object)currentRoot);
        }
        for (SwReferenceDataWithSource nextReference : SwReferenceIndexAccessorKt.findReferencesToCurrentFile(currentRoot.getSourcePsiFile(), searchScope)) {
            List<SwReferenceDataWithSource> maybePath = SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$findReferencesChainDfs(searchScope, visitedFileUrls, nextReference);
            if (!(!((Collection)maybePath).isEmpty())) continue;
            return CollectionsKt.plus((Collection)maybePath, (Object)currentRoot);
        }
        return CollectionsKt.emptyList();
    }
}

