/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadableInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadableInterpreter;", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "versionStr", "", "<init>", "(Ljava/lang/String;)V", "version", "Lcom/intellij/util/text/SemVer;", "getType", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType;", "getReferenceName", "getPresentableName", "getCachedVersion", "Lcom/intellij/openapi/util/Ref;", "fetchVersion", "", "consumer", "Lcom/intellij/util/NullableConsumer;", "validate", "project", "Lcom/intellij/openapi/project/Project;", "toString", "intellij.javascript.backend"})
public final class NodeJsDownloadableInterpreter
extends NodeJsInterpreter {
    @Nullable
    private final SemVer version;

    public NodeJsDownloadableInterpreter(@NotNull String versionStr) {
        Intrinsics.checkNotNullParameter((Object)versionStr, (String)"versionStr");
        this.version = SemVer.parseFromText((String)versionStr);
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        return NodeDownloadableInterpreterType.Companion.getInstance();
    }

    @Override
    @NotNull
    public String getReferenceName() {
        return this.getPresentableName();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = JavaScriptBundle.message((String)"node.interpreter.download", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public Ref<SemVer> getCachedVersion() {
        Ref ref2 = Ref.create((Object)this.version);
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        return ref2;
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.consume((Object)this.version);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return null;
    }

    @NotNull
    public String toString() {
        Object object = this.version;
        if (object == null || (object = object.getRawVersion()) == null) {
            object = "<unknown version>";
        }
        return object;
    }
}

