/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\u0012\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"jupyterNotebookOrNull", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJupyterNotebookOrNull", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getOriginalVirtualFile", "getAnyJupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "getAllJupyterEditors", "", "getOrReadJupyterNotebook", "getOrReadJsonText", "", "getRelativePathFromProjectRoot", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
public final class JupyterFileExtensionsKt {
    @Nullable
    public static final JupyterNotebook getJupyterNotebookOrNull(@NotNull VirtualFile $this$jupyterNotebookOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$jupyterNotebookOrNull, (String)"<this>");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked($this$jupyterNotebookOrNull);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebookOrNull() : null;
    }

    @NotNull
    public static final VirtualFile getOriginalVirtualFile(@NotNull VirtualFile $this$getOriginalVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalVirtualFile, (String)"<this>");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked($this$getOriginalVirtualFile);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getOriginFile()) == null) {
            backedNotebookVirtualFile = $this$getOriginalVirtualFile;
        }
        return backedNotebookVirtualFile;
    }

    @Nullable
    public static final Editor getAnyJupyterEditor(@NotNull VirtualFile $this$getAnyJupyterEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnyJupyterEditor, (String)"<this>");
        return JupyterHelper.INSTANCE.getAnyJupyterEditorByOriginalVirtualFile($this$getAnyJupyterEditor);
    }

    @Nullable
    public static final Set<Editor> getAllJupyterEditors(@NotNull VirtualFile $this$getAllJupyterEditors) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllJupyterEditors, (String)"<this>");
        return JupyterHelper.INSTANCE.getAllJupyterEditorsByOriginalVirtualFile($this$getAllJupyterEditors);
    }

    @NotNull
    public static final JupyterNotebook getOrReadJupyterNotebook(@NotNull VirtualFile $this$getOrReadJupyterNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrReadJupyterNotebook, (String)"<this>");
        BackedNotebookVirtualFile backedFile = BackedNotebookVirtualFile.Companion.takeIfBacked($this$getOrReadJupyterNotebook);
        Object object = backedFile;
        if (object == null || (object = object.getNotebookOrNull()) == null) {
            object = JupyterFileUtils.INSTANCE.readNotebook($this$getOrReadJupyterNotebook);
        }
        return object;
    }

    @NotNull
    public static final String getOrReadJsonText(@NotNull VirtualFile $this$getOrReadJsonText) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrReadJsonText, (String)"<this>");
        JupyterNotebook jupyterNotebook = JupyterFileExtensionsKt.getOrReadJupyterNotebook($this$getOrReadJsonText);
        ObjectNode notebookJson = jupyterNotebook.getJson();
        String string = notebookJson.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPrettyString(...)");
        return string;
    }

    @Nullable
    public static final Path getRelativePathFromProjectRoot(@NotNull VirtualFile $this$getRelativePathFromProjectRoot, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getRelativePathFromProjectRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (projectRoot == null) {
            return VirtualFileUtil.toNioPathOrNull((VirtualFile)$this$getRelativePathFromProjectRoot);
        }
        String string = VfsUtilCore.getRelativePath((VirtualFile)$this$getRelativePathFromProjectRoot, (VirtualFile)projectRoot);
        return string != null ? NioPathUtil.toNioPathOrNull((String)string) : null;
    }
}

