/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelper;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPart;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper;", "Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "<init>", "(Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;)V", "getRoot", "()Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "specifiedDatabaseOf", "Lcom/intellij/database/model/basic/BasicDatabase;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "databaseOf", "databaseByName", "name", "", "databaseIsKnown", "", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "distributeObjectPathsBetweenDatabases", "", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "", "Lcom/intellij/database/util/ObjectPath;", "paths", "", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nIntrospectionTaskHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrospectionTaskHelper.kt\ncom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AnyFun.kt\ncom/intellij/database/util/common/AnyFun\n*L\n1#1,151:1\n1#2:152\n61#3:153\n61#3:154\n*S KotlinDebug\n*F\n+ 1 IntrospectionTaskHelper.kt\ncom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper\n*L\n106#1:153\n107#1:154\n*E\n"})
public final class MultiDatabaseIntrospectionTaskHelper
extends IntrospectionTaskHelper {
    @NotNull
    private final BasicMultiDatabaseRoot root;

    public MultiDatabaseIntrospectionTaskHelper(@NotNull BasicMultiDatabaseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(null);
        this.root = root;
    }

    @Override
    @NotNull
    public BasicMultiDatabaseRoot getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public BasicDatabase specifiedDatabaseOf(@NotNull IntrospectionTask task) {
        BasicMateDatabase basicMateDatabase;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getDatabaseName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            basicMateDatabase = this.getRoot().findDatabaseByName(it);
        } else {
            basicMateDatabase = null;
        }
        return basicMateDatabase;
    }

    @Override
    @Nullable
    public BasicDatabase databaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.databaseByName(task.getDatabaseName());
    }

    @Override
    @Nullable
    public BasicDatabase databaseByName(@Nullable String name) {
        return name == null || ((CharSequence)name).length() == 0 || Intrinsics.areEqual((Object)name, (Object)"@") ? (BasicDatabase)this.getRoot().getCurrentDatabase() : (BasicDatabase)this.getRoot().findDatabaseByName(name);
    }

    @Override
    public boolean databaseIsKnown(@NotNull DefiniteIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String dbName = task.getDatabaseName();
        if (Intrinsics.areEqual((Object)dbName, (Object)"@")) {
            return this.getRoot().getCurrentDatabase() != null;
        }
        return this.getRoot().findDatabaseByName(dbName) != null;
    }

    @Override
    @NotNull
    public Map<BasicNamespaceOwner, Set<ObjectPath>> distributeObjectPathsBetweenDatabases(@NotNull Collection<? extends ObjectPath> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Map distribution = new HashMap();
        HashMap<Object, Optional> dbs = new HashMap<Object, Optional>();
        for (ObjectPath objectPath : paths) {
            Set basket;
            boolean bl;
            ObjectPart dp = (ObjectPart)objectPath.findParent(ObjectKind.DATABASE, false);
            if (dp != null) {
                Set basket2;
                Optional db;
                Optional optional;
                if (Intrinsics.areEqual((Object)dp.name, (Object)"@")) {
                    BasicMateDatabase $this$asOptional$iv = this.getRoot().getCurrentDatabase();
                    boolean $i$f$getAsOptional = false;
                    Optional optional2 = Optional.ofNullable($this$asOptional$iv);
                    optional = optional2;
                    Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"ofNullable(...)");
                } else {
                    Optional optional3 = dbs.computeIfAbsent(dp, arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$1(arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$0(this, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"computeIfAbsent(...)");
                    optional = optional3;
                }
                if ((db = optional).isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)distribution.computeIfAbsent(db.get(), arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$3(MultiDatabaseIntrospectionTaskHelper::distributeObjectPathsBetweenDatabases$lambda$2, arg_0)), (String)"computeIfAbsent(...)");
                bl = basket2.add(objectPath);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)distribution.computeIfAbsent(this.getRoot(), arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$5(MultiDatabaseIntrospectionTaskHelper::distributeObjectPathsBetweenDatabases$lambda$4, arg_0)), (String)"computeIfAbsent(...)");
            bl = basket.add(objectPath);
        }
        return distribution;
    }

    private static final Optional distributeObjectPathsBetweenDatabases$lambda$0(MultiDatabaseIntrospectionTaskHelper this$0, ObjectNamePart dp) {
        Intrinsics.checkNotNullParameter((Object)dp, (String)"dp");
        NamingFamily<? extends BasicMateDatabase> namingFamily = this$0.getRoot().getDatabases();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getDatabases(...)");
        Object $this$asOptional$iv = ModelFun.findByScriptName((Family)namingFamily, dp);
        boolean $i$f$getAsOptional = false;
        Optional optional = Optional.ofNullable($this$asOptional$iv);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    private static final Optional distributeObjectPathsBetweenDatabases$lambda$1(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$2(BasicNamespaceOwner it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$4(BasicNamespaceOwner it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$5(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

