/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 53985650253208L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-2088600450 + -((char)-25838), -2088600450 + -((char)-24137), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2088600450 + -((char)-25839), 2088600450 + (char)-1428, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 140614367729434L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.W();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1433381520 + (char)-32420, -1433381520 + -24339, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1433381520 + (char)-32419, -1433381520 + -27515, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1433381520 + (char)-32422, -1433381520 + -((char)-30813), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 133159291751868L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.n();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32363), -1874301000 - -28119, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32362), 1874301000 - 15226, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32361), -1874301000 - -17116, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32376), 1874301000 - 32615, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32375), -1874301000 - -29162, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32374), 1874301000 - (char)-30493, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32376), 1874301000 - 32615, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1874301000 - -((char)-32373), 1874301000 - 31421, (int)l2));
                            if (ActionTimestamp.W() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.W(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 125419203808728L;
                    bl = SshAgentIpcService.n();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 50864077800680L;
                boolean bl2 = SshAgentIpcService.W();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1219868490 - -12122, 1219868490 + 7541, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12123, 1219868490 + 11723, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12124, 1219868490 + 1224, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1219868490 - -12122, 1219868490 + 7541, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12125, -1219868490 + -16018, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1219868490 - -12122, 1219868490 + 7541, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12118, 1219868490 - 12358, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12119, 1219868490 + 3563, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12124, 1219868490 + 1224, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1219868490 - -12122, 1219868490 + 7541, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1219868490 - -12126, 1219868490 - 7573, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1219868490 - -12120, -1219868490 + -3601, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 16042556898293L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-854052120 + -12575, -854052120 - -6801, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 48496161018931L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1685298060 - -((char)-30310), -1685298060 - -15385, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "n\u00a9\u00ce4\u001c\u00f6\u00a7;\u00e2>\u0096j\u00ef\u001bw\u0013:&\u00b7\u0014K\u00f0j\u0019\u0093\u0091+R\u00f1\u00151\u00db\u00d9\u00d4pa7\u00ae\u0011w";
                        var4_3 = "n\u00a9\u00ce4\u001c\u00f6\u00a7;\u00e2>\u0096j\u00ef\u001bw\u0013:&\u00b7\u0014K\u00f0j\u0019\u0093\u0091+R\u00f1\u00151\u00db\u00d9\u00d4pa7\u00ae\u0011w".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 112;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 31;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 74;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 83;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 5;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 116;
                                        break;
                                    }
                                    default: {
                                        v11 = 44;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFBA3C) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 90;
                            case 1 -> 29;
                            case 2 -> 55;
                            case 3 -> 56;
                            case 4 -> 84;
                            case 5 -> 184;
                            case 6 -> 83;
                            case 7 -> 120;
                            case 8 -> 46;
                            case 9 -> 12;
                            case 10 -> 48;
                            case 11 -> 17;
                            case 12 -> 220;
                            case 13 -> 130;
                            case 14 -> 162;
                            case 15 -> 18;
                            case 16 -> 175;
                            case 17 -> 177;
                            case 18 -> 250;
                            case 19 -> 232;
                            case 20 -> 9;
                            case 21 -> 210;
                            case 22 -> 151;
                            case 23 -> 235;
                            case 24 -> 37;
                            case 25 -> 134;
                            case 26 -> 11;
                            case 27 -> 245;
                            case 28 -> 129;
                            case 29 -> 159;
                            case 30 -> 182;
                            case 31 -> 30;
                            case 32 -> 14;
                            case 33 -> 125;
                            case 34 -> 201;
                            case 35 -> 145;
                            case 36 -> 116;
                            case 37 -> 64;
                            case 38 -> 38;
                            case 39 -> 72;
                            case 40 -> 22;
                            case 41 -> 40;
                            case 42 -> 141;
                            case 43 -> 248;
                            case 44 -> 95;
                            case 45 -> 70;
                            case 46 -> 79;
                            case 47 -> 131;
                            case 48 -> 163;
                            case 49 -> 181;
                            case 50 -> 86;
                            case 51 -> 214;
                            case 52 -> 173;
                            case 53 -> 155;
                            case 54 -> 47;
                            case 55 -> 103;
                            case 56 -> 32;
                            case 57 -> 158;
                            case 58 -> 20;
                            case 59 -> 123;
                            case 60 -> 143;
                            case 61 -> 10;
                            case 62 -> 35;
                            case 63 -> 234;
                            case 64 -> 168;
                            case 65 -> 206;
                            case 66 -> 153;
                            case 67 -> 7;
                            case 68 -> 111;
                            case 69 -> 50;
                            case 70 -> 89;
                            case 71 -> 2;
                            case 72 -> 15;
                            case 73 -> 28;
                            case 74 -> 230;
                            case 75 -> 216;
                            case 76 -> 31;
                            case 77 -> 44;
                            case 78 -> 148;
                            case 79 -> 3;
                            case 80 -> 21;
                            case 81 -> 226;
                            case 82 -> 247;
                            case 83 -> 156;
                            case 84 -> 218;
                            case 85 -> 140;
                            case 86 -> 219;
                            case 87 -> 224;
                            case 88 -> 243;
                            case 89 -> 23;
                            case 90 -> 94;
                            case 91 -> 8;
                            case 92 -> 43;
                            case 93 -> 194;
                            case 94 -> 202;
                            case 95 -> 165;
                            case 96 -> 73;
                            case 97 -> 246;
                            case 98 -> 161;
                            case 99 -> 167;
                            case 100 -> 112;
                            case 101 -> 19;
                            case 102 -> 215;
                            case 103 -> 238;
                            case 104 -> 199;
                            case 105 -> 96;
                            case 106 -> 133;
                            case 107 -> 197;
                            case 108 -> 92;
                            case 109 -> 66;
                            case 110 -> 251;
                            case 111 -> 208;
                            case 112 -> 174;
                            case 113 -> 196;
                            case 114 -> 13;
                            case 115 -> 249;
                            case 116 -> 69;
                            case 117 -> 106;
                            case 118 -> 244;
                            case 119 -> 136;
                            case 120 -> 139;
                            case 121 -> 203;
                            case 122 -> 150;
                            case 123 -> 170;
                            case 124 -> 75;
                            case 125 -> 236;
                            case 126 -> 57;
                            case 127 -> 207;
                            case 128 -> 142;
                            case 129 -> 33;
                            case 130 -> 137;
                            case 131 -> 252;
                            case 132 -> 144;
                            case 133 -> 186;
                            case 134 -> 5;
                            case 135 -> 52;
                            case 136 -> 99;
                            case 137 -> 101;
                            case 138 -> 87;
                            case 139 -> 114;
                            case 140 -> 200;
                            case 141 -> 51;
                            case 142 -> 71;
                            case 143 -> 65;
                            case 144 -> 213;
                            case 145 -> 77;
                            case 146 -> 60;
                            case 147 -> 109;
                            case 148 -> 198;
                            case 149 -> 113;
                            case 150 -> 176;
                            case 151 -> 135;
                            case 152 -> 205;
                            case 153 -> 211;
                            case 154 -> 233;
                            case 155 -> 132;
                            case 156 -> 25;
                            case 157 -> 1;
                            case 158 -> 117;
                            case 159 -> 178;
                            case 160 -> 91;
                            case 161 -> 97;
                            case 162 -> 254;
                            case 163 -> 154;
                            case 164 -> 241;
                            case 165 -> 146;
                            case 166 -> 171;
                            case 167 -> 68;
                            case 168 -> 190;
                            case 169 -> 39;
                            case 170 -> 126;
                            case 171 -> 62;
                            case 172 -> 172;
                            case 173 -> 108;
                            case 174 -> 76;
                            case 175 -> 255;
                            case 176 -> 36;
                            case 177 -> 100;
                            case 178 -> 169;
                            case 179 -> 88;
                            case 180 -> 34;
                            case 181 -> 53;
                            case 182 -> 63;
                            case 183 -> 124;
                            case 184 -> 227;
                            case 185 -> 212;
                            case 186 -> 74;
                            case 187 -> 102;
                            case 188 -> 27;
                            case 189 -> 127;
                            case 190 -> 67;
                            case 191 -> 128;
                            case 192 -> 229;
                            case 193 -> 160;
                            case 194 -> 104;
                            case 195 -> 228;
                            case 196 -> 98;
                            case 197 -> 81;
                            case 198 -> 253;
                            case 199 -> 185;
                            case 200 -> 179;
                            case 201 -> 152;
                            case 202 -> 42;
                            case 203 -> 195;
                            case 204 -> 188;
                            case 205 -> 164;
                            case 206 -> 166;
                            case 207 -> 54;
                            case 208 -> 209;
                            case 209 -> 147;
                            case 210 -> 221;
                            case 211 -> 193;
                            case 212 -> 58;
                            case 213 -> 80;
                            case 214 -> 217;
                            case 215 -> 157;
                            case 216 -> 187;
                            case 217 -> 115;
                            case 218 -> 121;
                            case 219 -> 237;
                            case 220 -> 183;
                            case 221 -> 189;
                            case 222 -> 118;
                            case 223 -> 0;
                            case 224 -> 204;
                            case 225 -> 6;
                            case 226 -> 240;
                            case 227 -> 49;
                            case 228 -> 119;
                            case 229 -> 105;
                            case 230 -> 225;
                            case 231 -> 122;
                            case 232 -> 191;
                            case 233 -> 138;
                            case 234 -> 149;
                            case 235 -> 61;
                            case 236 -> 242;
                            case 237 -> 45;
                            case 238 -> 192;
                            case 239 -> 223;
                            case 240 -> 82;
                            case 241 -> 85;
                            case 242 -> 4;
                            case 243 -> 110;
                            case 244 -> 41;
                            case 245 -> 24;
                            case 246 -> 222;
                            case 247 -> 16;
                            case 248 -> 239;
                            case 249 -> 93;
                            case 250 -> 78;
                            case 251 -> 231;
                            case 252 -> 59;
                            case 253 -> 180;
                            case 254 -> 26;
                            default -> 107;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (!bl) {
                ActionTimestamp.W("vNNWgc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 120888899612067L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.W();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2747), 1544922090 - (char)-23050, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2743), 1544922090 - (char)-3348, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2770), 1544922090 - (char)-5625, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2747), 1544922090 - (char)-23050, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2743), 1544922090 - (char)-3348, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1544922090 - -((char)-2771), 1544791020 + (char)-5698, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 46962136221154L;
                        boolean bl3 = SshAgentIpcService.W();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(963888780 - (char)-12919, -963888780 - -((char)-11703), (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(963888780 - (char)-12916, -963888780 - -((char)-6973), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 4299236850557L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = SshAgentIpcService.n();
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-25427580 - -17921, 25427580 - 4946, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-25427580 - -17917, 25427580 - 22620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-25427580 - -17946, -25427580 - -30322, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-25427580 - -17917, 25427580 - 22620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-25427580 - -17923, 25427580 - 31477, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-25427580 - -17921, 25427580 - 4946, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-25427580 - -17917, 25427580 - 22620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-25427580 - -17933, 25427580 - 19904, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-25427580 - -17921, 25427580 - 4946, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-25427580 - -17917, 25427580 - 22620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-25427580 - -17932, -25427580 - -3400, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-25427580 - -17921, 25427580 - 4946, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-25427580 - -17917, 25427580 - 22620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-25427580 - -17935, -25427580 - -5938, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 45124562200355L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.W();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17061, -1635753600 + -27148, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17057, -1635753600 + -((char)-22782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17076, -1635753600 + -((char)-19555), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17077, -1635753600 + -((char)-26209), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17061, -1635753600 + -27148, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17057, -1635753600 + -((char)-22782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17078, -1635753600 + -((char)-23979), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17061, -1635753600 + -27148, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17057, -1635753600 + -((char)-22782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17079, 1635753600 + (char)-14916, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17061, -1635753600 + -27148, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17057, -1635753600 + -((char)-22782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17080, 1635753600 + 27358, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17061, -1635753600 + -27148, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17057, -1635753600 + -((char)-22782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17033, 1635753600 + (char)-18179, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1635753600 + (char)-17034, 1635753600 + (char)-26170, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d21BQn\u00cd&\u008c\u0014\u00d2yz\u00bf\u0097\u0098\u00b6<\u00f1dg\u00a9hy\u00877\u0013`V\u00c3\u0006\u00ba\u001fO\u0094\u00a54\u0018\u00a5\u00d7\u00f4Z\u00c4\u00e1\u00de\u00d34\u00e4\u00d0\u00c9\u00f8\u008a\u00c7\u00cb\u00b2\u0096L\u0080\u00f1j\u0003\u00af\t\u0090S\u00cc{\u00a8ZK\u00ec\u00ba\u0005\u00c0\u00d4\u0000\u00edV\b\u0097\u0000\u00ea\u0006)\u0001\u00c8\u00f7\u0014\u00d5\u00ef\u00e2\u00f6\u00e9\u00b9L\u008f\u00c0\u00cf\u00eah\u0093\u00e2C\u00a9\u0099`\u00fe\u0081\u0005\u00acg\u008d\u009b\u00e7\u001eV\u00a8\u00c7\u00063\u00ae\u0082@\u001a\u0082^\u0082e\u00c3\u00d6\u0086q\u00ae\u00e6s\b;0H\b\u0089\u00d1\u00a7d\u00e8\u0010\u00f2\u0013\u00b7\u00b4j\u00ca_5\u00dc\u009e\u000b\u00fc\u00c9Y\u00ecJ\t;\u0092oR\u008fX\u00893\f\u0010Q\u00c6\u00c3\u000e\u00e4\u009d\u008e\u00df\u00e6\u00c3LW!,\u00f1\u00e4?\u00ba\u0096R\u00c1\u008c_\u00f0\u0012%\u0019\u00fc\n\u008e$\u0096C\u00bcs\"\r\u001e\u00a6\u0089\u009d/\u00db8Yna\\,!\u0095\u00a9\u00c2\u0004\u00a5\u00a5\u009ft\u009dTU\u00fd\u00df{c\b\u00e7\u00e5\u00c4\u0080\u00ef\u00e2h\u00966\u0094\u00ec\u0014\u00fa\u0080\b\u001b\u00cd{\u00bf\u001b6\u008e\u0011\f\u00f977\u00fb\u008f\u00dc\u00f2K@\u0019\u00ca\bF\u00f0\u0091\u0016/\u00abFv\u0018\u00d0\u007f\u00d2\u0000\u00ddm\u00e3L\u00ee\u00f5hrE\u001b\u00e1\u0018\u0014@\u00ac!CG\u00c3\u00d4\u00ee<\u0092\u00d6\u00b9j\u00b9\u00a2d/\u00dd\u00f8\u0012\u00ef\u00d2\u0018\u00dap\u00d9\u009c\u00e8r\u00f9\u00c0jW\u009d|\u0006\u0081\u009e\u00caX\u00eb\u00c4\u00f4\u00fdz\u001f\u00c9\u00a54\u00a7M\u009aM\u00c6\u00e3Ra\u0098\u0082\u009d!\u00fc\u00f4\t+Mz|\u00a9\u000bZ1\u008c|\u00d2b\u00f3\u000bRIB4!%'t\u00fa\u00f2\u0097\u0015\u00faFW\u00d6\u0084\u0011\u007f\u008f\u00cfm\u00f9\u00b4/\u00b4\u0089\u008f\u001a\u00f3+kL)\u00ddn\u00b6\u00de\u001d\u00b5G#\u00a2\u00eeI\u000f\u0083e\u009f\u00e6|\u00c2\u00e1\u0093\u00d3\u00dfZgK\u00f5y\u009cC\u008aCS\u0000i)\u00f1\u00d0\u0093\u001f4\u0013\u0007\u00d2\u0093]{D\\\u00f7\u0007&z\u00a7*\u00fc\u0099\u00f6(\u00b9#vV\u00b5\u00ce\u00a4k\u00ae0\u00e2\u00e2\u00d5Y\u0017\u00e2j\u00ef\u008du?=\u00a8\u00f0\u0085\u00bb\u0016.\u0099\u00bc\u00c3\u008c\u00eb\u00f9\u00caN\u0016\u0019T\u0096\u000f\u00e8\u00ae\u0012\u00ce\u00d1\u00b1\u008dG\u00fe8I\u00b2\u0000\u00073\"\u0088\u0004\u001c\u0093H\u001c\u00ed\u0016\u00f7H\u00e3\u00db\u00d5\u00f31\u00faBh\u00ac\u0084\u0090=\u0092k\u00c1 \u00e5\u00f8\u00f44\u0017\u0083\u00a4\u0080\u000eH\u0098\u0006\bSi\u00dd\\\u00f4[\b\u00de$\u0080\u001b\u00a9o=\u00f3\u00cf\u00a3\u00dbYc|w;\u009b\n\u00de\u00d3\u0017\u00e7\u00bb\u00e9I\u00a4\u00da\u00fe\u0083\u00ff\u00f8\nIq\u00e57\u00c0\u00df\u00e9\u00fc\u008e\u00aa\u0018\u00a4<\u009c\u0094\u00fa\u00f3\\\r\u008d?h\u00cc\u00c1\u00a7iG\u0096t\\\u00e2\u00cd\u008e\u0011\u00e8)q\u009d#\u00a0\u00afz\u0011\u00dah\u00d1\u0010\u00e8\u00ac\u0090\u00e5#M\u000f\u0018\u00ef\u00d6@\u00b3\u0098\u0003\u0098\u00ed\u00dd\u0082\u00fe\u00c0LUTV\u00c2\u00e1\u00d19|\u00d7\t\u00c0\u007f\u0010\u00f1j\u00e3c\u001f\u00ec";
                var4_3 = "\u00d21BQn\u00cd&\u008c\u0014\u00d2yz\u00bf\u0097\u0098\u00b6<\u00f1dg\u00a9hy\u00877\u0013`V\u00c3\u0006\u00ba\u001fO\u0094\u00a54\u0018\u00a5\u00d7\u00f4Z\u00c4\u00e1\u00de\u00d34\u00e4\u00d0\u00c9\u00f8\u008a\u00c7\u00cb\u00b2\u0096L\u0080\u00f1j\u0003\u00af\t\u0090S\u00cc{\u00a8ZK\u00ec\u00ba\u0005\u00c0\u00d4\u0000\u00edV\b\u0097\u0000\u00ea\u0006)\u0001\u00c8\u00f7\u0014\u00d5\u00ef\u00e2\u00f6\u00e9\u00b9L\u008f\u00c0\u00cf\u00eah\u0093\u00e2C\u00a9\u0099`\u00fe\u0081\u0005\u00acg\u008d\u009b\u00e7\u001eV\u00a8\u00c7\u00063\u00ae\u0082@\u001a\u0082^\u0082e\u00c3\u00d6\u0086q\u00ae\u00e6s\b;0H\b\u0089\u00d1\u00a7d\u00e8\u0010\u00f2\u0013\u00b7\u00b4j\u00ca_5\u00dc\u009e\u000b\u00fc\u00c9Y\u00ecJ\t;\u0092oR\u008fX\u00893\f\u0010Q\u00c6\u00c3\u000e\u00e4\u009d\u008e\u00df\u00e6\u00c3LW!,\u00f1\u00e4?\u00ba\u0096R\u00c1\u008c_\u00f0\u0012%\u0019\u00fc\n\u008e$\u0096C\u00bcs\"\r\u001e\u00a6\u0089\u009d/\u00db8Yna\\,!\u0095\u00a9\u00c2\u0004\u00a5\u00a5\u009ft\u009dTU\u00fd\u00df{c\b\u00e7\u00e5\u00c4\u0080\u00ef\u00e2h\u00966\u0094\u00ec\u0014\u00fa\u0080\b\u001b\u00cd{\u00bf\u001b6\u008e\u0011\f\u00f977\u00fb\u008f\u00dc\u00f2K@\u0019\u00ca\bF\u00f0\u0091\u0016/\u00abFv\u0018\u00d0\u007f\u00d2\u0000\u00ddm\u00e3L\u00ee\u00f5hrE\u001b\u00e1\u0018\u0014@\u00ac!CG\u00c3\u00d4\u00ee<\u0092\u00d6\u00b9j\u00b9\u00a2d/\u00dd\u00f8\u0012\u00ef\u00d2\u0018\u00dap\u00d9\u009c\u00e8r\u00f9\u00c0jW\u009d|\u0006\u0081\u009e\u00caX\u00eb\u00c4\u00f4\u00fdz\u001f\u00c9\u00a54\u00a7M\u009aM\u00c6\u00e3Ra\u0098\u0082\u009d!\u00fc\u00f4\t+Mz|\u00a9\u000bZ1\u008c|\u00d2b\u00f3\u000bRIB4!%'t\u00fa\u00f2\u0097\u0015\u00faFW\u00d6\u0084\u0011\u007f\u008f\u00cfm\u00f9\u00b4/\u00b4\u0089\u008f\u001a\u00f3+kL)\u00ddn\u00b6\u00de\u001d\u00b5G#\u00a2\u00eeI\u000f\u0083e\u009f\u00e6|\u00c2\u00e1\u0093\u00d3\u00dfZgK\u00f5y\u009cC\u008aCS\u0000i)\u00f1\u00d0\u0093\u001f4\u0013\u0007\u00d2\u0093]{D\\\u00f7\u0007&z\u00a7*\u00fc\u0099\u00f6(\u00b9#vV\u00b5\u00ce\u00a4k\u00ae0\u00e2\u00e2\u00d5Y\u0017\u00e2j\u00ef\u008du?=\u00a8\u00f0\u0085\u00bb\u0016.\u0099\u00bc\u00c3\u008c\u00eb\u00f9\u00caN\u0016\u0019T\u0096\u000f\u00e8\u00ae\u0012\u00ce\u00d1\u00b1\u008dG\u00fe8I\u00b2\u0000\u00073\"\u0088\u0004\u001c\u0093H\u001c\u00ed\u0016\u00f7H\u00e3\u00db\u00d5\u00f31\u00faBh\u00ac\u0084\u0090=\u0092k\u00c1 \u00e5\u00f8\u00f44\u0017\u0083\u00a4\u0080\u000eH\u0098\u0006\bSi\u00dd\\\u00f4[\b\u00de$\u0080\u001b\u00a9o=\u00f3\u00cf\u00a3\u00dbYc|w;\u009b\n\u00de\u00d3\u0017\u00e7\u00bb\u00e9I\u00a4\u00da\u00fe\u0083\u00ff\u00f8\nIq\u00e57\u00c0\u00df\u00e9\u00fc\u008e\u00aa\u0018\u00a4<\u009c\u0094\u00fa\u00f3\\\r\u008d?h\u00cc\u00c1\u00a7iG\u0096t\\\u00e2\u00cd\u008e\u0011\u00e8)q\u009d#\u00a0\u00afz\u0011\u00dah\u00d1\u0010\u00e8\u00ac\u0090\u00e5#M\u000f\u0018\u00ef\u00d6@\u00b3\u0098\u0003\u0098\u00ed\u00dd\u0082\u00fe\u00c0LUTV\u00c2\u00e1\u00d19|\u00d7\t\u00c0\u007f\u0010\u00f1j\u00e3c\u001f\u00ec".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 76;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u000f\u0015E\u0018\u00ca\u00c4\u0014\u00a4a\u00b7\u0098\u008d\u0014\u0095[*3\u008b.R\u00eca\u00ae\u00cb\u00a2G\u00e1\u00ca:\u0014\u0091>\u00bb\u00fe\u0006\u0019-\u00a5+\u00fe\u0095S\u009f\u008f\u00d0@P'\u0097\u0082";
                    var4_3 = "\u000f\u0015E\u0018\u00ca\u00c4\u0014\u00a4a\u00b7\u0098\u008d\u0014\u0095[*3\u008b.R\u00eca\u00ae\u00cb\u00a2G\u00e1\u00ca:\u0014\u0091>\u00bb\u00fe\u0006\u0019-\u00a5+\u00fe\u0095S\u009f\u008f\u00d0@P'\u0097\u0082".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 96;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 125;
                            break;
                        }
                        case 1: {
                            v15 = 111;
                            break;
                        }
                        case 2: {
                            v15 = 124;
                            break;
                        }
                        case 3: {
                            v15 = 126;
                            break;
                        }
                        case 4: {
                            v15 = 66;
                            break;
                        }
                        case 5: {
                            v15 = 69;
                            break;
                        }
                        default: {
                            v15 = 72;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x7CF4) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 16;
                case 1 -> 239;
                case 2 -> 57;
                case 3 -> 6;
                case 4 -> 77;
                case 5 -> 184;
                case 6 -> 208;
                case 7 -> 231;
                case 8 -> 42;
                case 9 -> 106;
                case 10 -> 7;
                case 11 -> 200;
                case 12 -> 198;
                case 13 -> 66;
                case 14 -> 35;
                case 15 -> 72;
                case 16 -> 13;
                case 17 -> 41;
                case 18 -> 54;
                case 19 -> 182;
                case 20 -> 25;
                case 21 -> 37;
                case 22 -> 14;
                case 23 -> 113;
                case 24 -> 87;
                case 25 -> 52;
                case 26 -> 2;
                case 27 -> 134;
                case 28 -> 29;
                case 29 -> 19;
                case 30 -> 181;
                case 31 -> 158;
                case 32 -> 132;
                case 33 -> 91;
                case 34 -> 133;
                case 35 -> 240;
                case 36 -> 237;
                case 37 -> 154;
                case 38 -> 215;
                case 39 -> 209;
                case 40 -> 159;
                case 41 -> 26;
                case 42 -> 234;
                case 43 -> 167;
                case 44 -> 67;
                case 45 -> 0;
                case 46 -> 99;
                case 47 -> 235;
                case 48 -> 137;
                case 49 -> 75;
                case 50 -> 32;
                case 51 -> 47;
                case 52 -> 96;
                case 53 -> 86;
                case 54 -> 61;
                case 55 -> 206;
                case 56 -> 247;
                case 57 -> 69;
                case 58 -> 28;
                case 59 -> 65;
                case 60 -> 70;
                case 61 -> 188;
                case 62 -> 145;
                case 63 -> 122;
                case 64 -> 165;
                case 65 -> 236;
                case 66 -> 144;
                case 67 -> 108;
                case 68 -> 101;
                case 69 -> 143;
                case 70 -> 230;
                case 71 -> 189;
                case 72 -> 85;
                case 73 -> 92;
                case 74 -> 224;
                case 75 -> 58;
                case 76 -> 3;
                case 77 -> 155;
                case 78 -> 31;
                case 79 -> 196;
                case 80 -> 192;
                case 81 -> 197;
                case 82 -> 73;
                case 83 -> 170;
                case 84 -> 12;
                case 85 -> 56;
                case 86 -> 111;
                case 87 -> 95;
                case 88 -> 152;
                case 89 -> 43;
                case 90 -> 62;
                case 91 -> 187;
                case 92 -> 248;
                case 93 -> 255;
                case 94 -> 33;
                case 95 -> 78;
                case 96 -> 80;
                case 97 -> 220;
                case 98 -> 225;
                case 99 -> 244;
                case 100 -> 109;
                case 101 -> 219;
                case 102 -> 179;
                case 103 -> 193;
                case 104 -> 253;
                case 105 -> 146;
                case 106 -> 210;
                case 107 -> 94;
                case 108 -> 221;
                case 109 -> 163;
                case 110 -> 50;
                case 111 -> 245;
                case 112 -> 212;
                case 113 -> 104;
                case 114 -> 48;
                case 115 -> 226;
                case 116 -> 180;
                case 117 -> 60;
                case 118 -> 195;
                case 119 -> 123;
                case 120 -> 110;
                case 121 -> 136;
                case 122 -> 201;
                case 123 -> 1;
                case 124 -> 55;
                case 125 -> 213;
                case 126 -> 161;
                case 127 -> 228;
                case 128 -> 125;
                case 129 -> 63;
                case 130 -> 156;
                case 131 -> 102;
                case 132 -> 36;
                case 133 -> 175;
                case 134 -> 20;
                case 135 -> 169;
                case 136 -> 227;
                case 137 -> 120;
                case 138 -> 185;
                case 139 -> 76;
                case 140 -> 160;
                case 141 -> 22;
                case 142 -> 97;
                case 143 -> 9;
                case 144 -> 100;
                case 145 -> 139;
                case 146 -> 34;
                case 147 -> 93;
                case 148 -> 59;
                case 149 -> 89;
                case 150 -> 238;
                case 151 -> 191;
                case 152 -> 30;
                case 153 -> 190;
                case 154 -> 157;
                case 155 -> 176;
                case 156 -> 172;
                case 157 -> 112;
                case 158 -> 211;
                case 159 -> 171;
                case 160 -> 4;
                case 161 -> 74;
                case 162 -> 10;
                case 163 -> 18;
                case 164 -> 166;
                case 165 -> 251;
                case 166 -> 214;
                case 167 -> 64;
                case 168 -> 24;
                case 169 -> 202;
                case 170 -> 177;
                case 171 -> 40;
                case 172 -> 128;
                case 173 -> 15;
                case 174 -> 174;
                case 175 -> 140;
                case 176 -> 223;
                case 177 -> 68;
                case 178 -> 126;
                case 179 -> 183;
                case 180 -> 107;
                case 181 -> 203;
                case 182 -> 254;
                case 183 -> 173;
                case 184 -> 71;
                case 185 -> 46;
                case 186 -> 84;
                case 187 -> 105;
                case 188 -> 250;
                case 189 -> 121;
                case 190 -> 88;
                case 191 -> 246;
                case 192 -> 127;
                case 193 -> 241;
                case 194 -> 151;
                case 195 -> 53;
                case 196 -> 39;
                case 197 -> 205;
                case 198 -> 229;
                case 199 -> 49;
                case 200 -> 218;
                case 201 -> 216;
                case 202 -> 90;
                case 203 -> 79;
                case 204 -> 135;
                case 205 -> 148;
                case 206 -> 199;
                case 207 -> 17;
                case 208 -> 103;
                case 209 -> 242;
                case 210 -> 124;
                case 211 -> 138;
                case 212 -> 45;
                case 213 -> 8;
                case 214 -> 149;
                case 215 -> 142;
                case 216 -> 23;
                case 217 -> 222;
                case 218 -> 249;
                case 219 -> 243;
                case 220 -> 186;
                case 221 -> 82;
                case 222 -> 98;
                case 223 -> 81;
                case 224 -> 118;
                case 225 -> 130;
                case 226 -> 232;
                case 227 -> 204;
                case 228 -> 129;
                case 229 -> 21;
                case 230 -> 207;
                case 231 -> 217;
                case 232 -> 38;
                case 233 -> 114;
                case 234 -> 162;
                case 235 -> 116;
                case 236 -> 51;
                case 237 -> 115;
                case 238 -> 252;
                case 239 -> 164;
                case 240 -> 5;
                case 241 -> 178;
                case 242 -> 168;
                case 243 -> 141;
                case 244 -> 119;
                case 245 -> 150;
                case 246 -> 117;
                case 247 -> 147;
                case 248 -> 27;
                case 249 -> 131;
                case 250 -> 153;
                case 251 -> 194;
                case 252 -> 11;
                case 253 -> 233;
                case 254 -> 44;
                default -> 83;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 49033914312286L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1727371530 - (char)-19261, -1727371530 - -((char)-7849), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 2626288799199L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.W();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2063828220 - -((char)-11069), 2063828220 - (char)-10931, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2063828220 - -((char)-11072), 2063828220 - (char)-19175, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2063828220 - -((char)-11071), -2063828220 - -((char)-19854), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "o+N\u00f6\u00b1\u00eb<#\u0010\u00c0\u0094J\u00a0\u008b\u009a\u0082Tp\tzP5-\u0018\u00d3";
                    var4_3 = "o+N\u00f6\u00b1\u00eb<#\u0010\u00c0\u0094J\u00a0\u008b\u009a\u0082Tp\tzP5-\u0018\u00d3".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 77;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00bc\u00df\u0016J\u00e85L/\u001f8\u001b\u0092\u00aa\u00dc \u0081\u00c0\u00a3\u00b7\u009bo\u00ad\u0004\u00a1\u00de6^\r\u0018%\u00ba\u001fe(\u001cJZ\u00c8aEf\u00d0\rT\u0006\u00b6@T\f\u00b1:n\r7\u00b1\u00d2\u00f4\u00de!";
                        var4_3 = "\u00bc\u00df\u0016J\u00e85L/\u001f8\u001b\u0092\u00aa\u00dc \u0081\u00c0\u00a3\u00b7\u009bo\u00ad\u0004\u00a1\u00de6^\r\u0018%\u00ba\u001fe(\u001cJZ\u00c8aEf\u00d0\rT\u0006\u00b6@T\f\u00b1:n\r7\u00b1\u00d2\u00f4\u00de!".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 113;
                                break;
                            }
                            case 1: {
                                v15 = 49;
                                break;
                            }
                            case 2: {
                                v15 = 103;
                                break;
                            }
                            case 3: {
                                v15 = 112;
                                break;
                            }
                            case 4: {
                                v15 = 94;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 11;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8219) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 121;
                    case 1 -> 238;
                    case 2 -> 73;
                    case 3 -> 210;
                    case 4 -> 196;
                    case 5 -> 173;
                    case 6 -> 2;
                    case 7 -> 119;
                    case 8 -> 228;
                    case 9 -> 49;
                    case 10 -> 94;
                    case 11 -> 80;
                    case 12 -> 6;
                    case 13 -> 140;
                    case 14 -> 21;
                    case 15 -> 138;
                    case 16 -> 25;
                    case 17 -> 43;
                    case 18 -> 175;
                    case 19 -> 189;
                    case 20 -> 151;
                    case 21 -> 133;
                    case 22 -> 29;
                    case 23 -> 250;
                    case 24 -> 61;
                    case 25 -> 44;
                    case 26 -> 75;
                    case 27 -> 254;
                    case 28 -> 35;
                    case 29 -> 60;
                    case 30 -> 42;
                    case 31 -> 114;
                    case 32 -> 194;
                    case 33 -> 201;
                    case 34 -> 4;
                    case 35 -> 205;
                    case 36 -> 54;
                    case 37 -> 39;
                    case 38 -> 33;
                    case 39 -> 1;
                    case 40 -> 185;
                    case 41 -> 72;
                    case 42 -> 253;
                    case 43 -> 97;
                    case 44 -> 71;
                    case 45 -> 16;
                    case 46 -> 162;
                    case 47 -> 107;
                    case 48 -> 216;
                    case 49 -> 191;
                    case 50 -> 70;
                    case 51 -> 56;
                    case 52 -> 62;
                    case 53 -> 237;
                    case 54 -> 209;
                    case 55 -> 139;
                    case 56 -> 122;
                    case 57 -> 157;
                    case 58 -> 153;
                    case 59 -> 168;
                    case 60 -> 23;
                    case 61 -> 65;
                    case 62 -> 131;
                    case 63 -> 170;
                    case 64 -> 134;
                    case 65 -> 8;
                    case 66 -> 242;
                    case 67 -> 83;
                    case 68 -> 152;
                    case 69 -> 40;
                    case 70 -> 167;
                    case 71 -> 255;
                    case 72 -> 47;
                    case 73 -> 166;
                    case 74 -> 53;
                    case 75 -> 154;
                    case 76 -> 181;
                    case 77 -> 84;
                    case 78 -> 76;
                    case 79 -> 150;
                    case 80 -> 14;
                    case 81 -> 3;
                    case 82 -> 243;
                    case 83 -> 240;
                    case 84 -> 183;
                    case 85 -> 93;
                    case 86 -> 52;
                    case 87 -> 198;
                    case 88 -> 37;
                    case 89 -> 215;
                    case 90 -> 127;
                    case 91 -> 203;
                    case 92 -> 226;
                    case 93 -> 120;
                    case 94 -> 117;
                    case 95 -> 110;
                    case 96 -> 227;
                    case 97 -> 74;
                    case 98 -> 13;
                    case 99 -> 199;
                    case 100 -> 245;
                    case 101 -> 77;
                    case 102 -> 90;
                    case 103 -> 143;
                    case 104 -> 87;
                    case 105 -> 208;
                    case 106 -> 7;
                    case 107 -> 58;
                    case 108 -> 105;
                    case 109 -> 115;
                    case 110 -> 99;
                    case 111 -> 195;
                    case 112 -> 147;
                    case 113 -> 98;
                    case 114 -> 141;
                    case 115 -> 159;
                    case 116 -> 106;
                    case 117 -> 192;
                    case 118 -> 28;
                    case 119 -> 230;
                    case 120 -> 136;
                    case 121 -> 231;
                    case 122 -> 34;
                    case 123 -> 128;
                    case 124 -> 252;
                    case 125 -> 12;
                    case 126 -> 165;
                    case 127 -> 145;
                    case 128 -> 177;
                    case 129 -> 67;
                    case 130 -> 158;
                    case 131 -> 146;
                    case 132 -> 155;
                    case 133 -> 89;
                    case 134 -> 15;
                    case 135 -> 179;
                    case 136 -> 24;
                    case 137 -> 202;
                    case 138 -> 91;
                    case 139 -> 104;
                    case 140 -> 27;
                    case 141 -> 111;
                    case 142 -> 59;
                    case 143 -> 244;
                    case 144 -> 95;
                    case 145 -> 55;
                    case 146 -> 36;
                    case 147 -> 248;
                    case 148 -> 63;
                    case 149 -> 200;
                    case 150 -> 225;
                    case 151 -> 126;
                    case 152 -> 113;
                    case 153 -> 182;
                    case 154 -> 124;
                    case 155 -> 224;
                    case 156 -> 149;
                    case 157 -> 212;
                    case 158 -> 204;
                    case 159 -> 22;
                    case 160 -> 178;
                    case 161 -> 176;
                    case 162 -> 57;
                    case 163 -> 197;
                    case 164 -> 233;
                    case 165 -> 221;
                    case 166 -> 79;
                    case 167 -> 135;
                    case 168 -> 100;
                    case 169 -> 31;
                    case 170 -> 69;
                    case 171 -> 30;
                    case 172 -> 118;
                    case 173 -> 123;
                    case 174 -> 193;
                    case 175 -> 48;
                    case 176 -> 217;
                    case 177 -> 186;
                    case 178 -> 206;
                    case 179 -> 0;
                    case 180 -> 112;
                    case 181 -> 132;
                    case 182 -> 96;
                    case 183 -> 88;
                    case 184 -> 247;
                    case 185 -> 239;
                    case 186 -> 142;
                    case 187 -> 46;
                    case 188 -> 187;
                    case 189 -> 163;
                    case 190 -> 219;
                    case 191 -> 218;
                    case 192 -> 38;
                    case 193 -> 66;
                    case 194 -> 174;
                    case 195 -> 137;
                    case 196 -> 32;
                    case 197 -> 68;
                    case 198 -> 103;
                    case 199 -> 19;
                    case 200 -> 171;
                    case 201 -> 102;
                    case 202 -> 172;
                    case 203 -> 129;
                    case 204 -> 130;
                    case 205 -> 86;
                    case 206 -> 78;
                    case 207 -> 161;
                    case 208 -> 241;
                    case 209 -> 234;
                    case 210 -> 164;
                    case 211 -> 236;
                    case 212 -> 222;
                    case 213 -> 249;
                    case 214 -> 184;
                    case 215 -> 85;
                    case 216 -> 125;
                    case 217 -> 190;
                    case 218 -> 229;
                    case 219 -> 50;
                    case 220 -> 11;
                    case 221 -> 20;
                    case 222 -> 169;
                    case 223 -> 81;
                    case 224 -> 45;
                    case 225 -> 211;
                    case 226 -> 214;
                    case 227 -> 148;
                    case 228 -> 17;
                    case 229 -> 10;
                    case 230 -> 207;
                    case 231 -> 64;
                    case 232 -> 232;
                    case 233 -> 144;
                    case 234 -> 220;
                    case 235 -> 5;
                    case 236 -> 18;
                    case 237 -> 101;
                    case 238 -> 160;
                    case 239 -> 51;
                    case 240 -> 26;
                    case 241 -> 116;
                    case 242 -> 108;
                    case 243 -> 246;
                    case 244 -> 82;
                    case 245 -> 180;
                    case 246 -> 92;
                    case 247 -> 41;
                    case 248 -> 109;
                    case 249 -> 235;
                    case 250 -> 223;
                    case 251 -> 156;
                    case 252 -> 213;
                    case 253 -> 251;
                    case 254 -> 188;
                    default -> 9;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 31318650303711L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "OWW\u0018.w\u001b\u0016\tH]D\u0012c5\u0006\n\u001b";
                    var5_4 = "OWW\u0018.w\u001b\u0016\tH]D\u0012c5\u0006\n\u001b".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 23;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 51;
                                    break;
                                }
                                case 1: {
                                    v11 = 37;
                                    break;
                                }
                                case 2: {
                                    v11 = 50;
                                    break;
                                }
                                case 3: {
                                    v11 = 97;
                                    break;
                                }
                                case 4: {
                                    v11 = 92;
                                    break;
                                }
                                case 5: {
                                    v11 = 12;
                                    break;
                                }
                                default: {
                                    v11 = 63;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 41750440654763L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0019\u0000aw=09\u0004\u001f\u001emm\n\u0013\u0001fm12!9\u0000o\t\u0013\u0001fm12!5\n\r\u0014\u0007{`;?;5\r|j:6";
                    var5_4 = "\u0019\u0000aw=09\u0004\u001f\u001emm\n\u0013\u0001fm12!9\u0000o\t\u0013\u0001fm12!5\n\r\u0014\u0007{`;?;5\r|j:6".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 18;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u001d\fi~31<\u0006\u001d\fi~?;";
                        var5_4 = "\u001d\fi~31<\u0006\u001d\fi~?;".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 28;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 66;
                                break;
                            }
                            case 1: {
                                v15 = 124;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 70;
                                break;
                            }
                            case 5: {
                                v15 = 67;
                                break;
                            }
                            default: {
                                v15 = 71;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 31479013821979L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1198504080 - -3307, -1198504080 - -2164, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 98617138850917L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "Z\u00a5D\u00bb\u0013\u0003\u00d6\u00f1a\u0005\u00d9W\u0012!:\r\u00bdv\u00a8O\u0098d\u000ei\u00a3\u00a0\u00bbX}\u0010\u009eZ\u000b!\u00d3<L_\"\u00e2h]\u00e1I]\u00d4\u0005~\u00d3\u00e6\u00b1\u00a43}\u0081\u0097\u008c\u0095\u00cd\u00b4u@Z\u00afc\u00df\u00df\u00b6\u0019\u00a7V\u008f|4\u00bf\u009aS[\u001c\u0004\u00f9sm \u000b\u00bd/\u00fa\u000b\u00cd\u00c5\u00d4\u00dc3\u00a4\u008e4\u00b3\u00d6\u0000\u00be~.T";
                    var4_3 = "Z\u00a5D\u00bb\u0013\u0003\u00d6\u00f1a\u0005\u00d9W\u0012!:\r\u00bdv\u00a8O\u0098d\u000ei\u00a3\u00a0\u00bbX}\u0010\u009eZ\u000b!\u00d3<L_\"\u00e2h]\u00e1I]\u00d4\u0005~\u00d3\u00e6\u00b1\u00a43}\u0081\u0097\u008c\u0095\u00cd\u00b4u@Z\u00afc\u00df\u00df\u00b6\u0019\u00a7V\u008f|4\u00bf\u009aS[\u001c\u0004\u00f9sm \u000b\u00bd/\u00fa\u000b\u00cd\u00c5\u00d4\u00dc3\u00a4\u008e4\u00b3\u00d6\u0000\u00be~.T".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "FC\u009b\u0089J\u00a2\u00f4\u0007\u00bebp\u00c6i\u00b1\u00c7@LR\u00a5\u00ee\u009f\u00ce\u00a8\n(\u00e8\u0014\u0016\u00b1\u00ab\u00d1\f5~\u0089\u00c0\u00fa>\u0080z\u009d\u00ef\u00a5<\u0083\u0005\u00e0\u008a^s\u00e0\u00d9e\u0010]\u00de\"\u00cf\rU\u00f7V\u00fb\u00fc\u00a8\u0098S\u00ebYY \u00e9\u00cc\u00cca\u00aa\bB\u00d1M\u008a@Y\nfB\u00d0g\u00c5\u00fc\u00a8\u009dI";
                        var4_3 = "FC\u009b\u0089J\u00a2\u00f4\u0007\u00bebp\u00c6i\u00b1\u00c7@LR\u00a5\u00ee\u009f\u00ce\u00a8\n(\u00e8\u0014\u0016\u00b1\u00ab\u00d1\f5~\u0089\u00c0\u00fa>\u0080z\u009d\u00ef\u00a5<\u0083\u0005\u00e0\u008a^s\u00e0\u00d9e\u0010]\u00de\"\u00cf\rU\u00f7V\u00fb\u00fc\u00a8\u0098S\u00ebYY \u00e9\u00cc\u00cca\u00aa\bB\u00d1M\u008a@Y\nfB\u00d0g\u00c5\u00fc\u00a8\u009dI".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 85;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 83;
                                break;
                            }
                            case 1: {
                                v15 = 44;
                                break;
                            }
                            case 2: {
                                v15 = 57;
                                break;
                            }
                            case 3: {
                                v15 = 27;
                                break;
                            }
                            case 4: {
                                v15 = 117;
                                break;
                            }
                            case 5: {
                                v15 = 28;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9A40) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 84;
                    case 1 -> 96;
                    case 2 -> 153;
                    case 3 -> 69;
                    case 4 -> 59;
                    case 5 -> 230;
                    case 6 -> 76;
                    case 7 -> 147;
                    case 8 -> 104;
                    case 9 -> 63;
                    case 10 -> 81;
                    case 11 -> 183;
                    case 12 -> 86;
                    case 13 -> 3;
                    case 14 -> 253;
                    case 15 -> 176;
                    case 16 -> 226;
                    case 17 -> 209;
                    case 18 -> 217;
                    case 19 -> 14;
                    case 20 -> 249;
                    case 21 -> 98;
                    case 22 -> 34;
                    case 23 -> 245;
                    case 24 -> 77;
                    case 25 -> 25;
                    case 26 -> 159;
                    case 27 -> 150;
                    case 28 -> 137;
                    case 29 -> 222;
                    case 30 -> 212;
                    case 31 -> 16;
                    case 32 -> 220;
                    case 33 -> 41;
                    case 34 -> 36;
                    case 35 -> 144;
                    case 36 -> 33;
                    case 37 -> 89;
                    case 38 -> 181;
                    case 39 -> 24;
                    case 40 -> 184;
                    case 41 -> 210;
                    case 42 -> 188;
                    case 43 -> 250;
                    case 44 -> 7;
                    case 45 -> 108;
                    case 46 -> 0;
                    case 47 -> 145;
                    case 48 -> 112;
                    case 49 -> 56;
                    case 50 -> 106;
                    case 51 -> 46;
                    case 52 -> 19;
                    case 53 -> 231;
                    case 54 -> 62;
                    case 55 -> 105;
                    case 56 -> 200;
                    case 57 -> 237;
                    case 58 -> 117;
                    case 59 -> 165;
                    case 60 -> 146;
                    case 61 -> 255;
                    case 62 -> 162;
                    case 63 -> 1;
                    case 64 -> 72;
                    case 65 -> 107;
                    case 66 -> 170;
                    case 67 -> 66;
                    case 68 -> 128;
                    case 69 -> 118;
                    case 70 -> 204;
                    case 71 -> 246;
                    case 72 -> 100;
                    case 73 -> 187;
                    case 74 -> 120;
                    case 75 -> 206;
                    case 76 -> 131;
                    case 77 -> 109;
                    case 78 -> 148;
                    case 79 -> 94;
                    case 80 -> 196;
                    case 81 -> 60;
                    case 82 -> 47;
                    case 83 -> 229;
                    case 84 -> 11;
                    case 85 -> 235;
                    case 86 -> 52;
                    case 87 -> 215;
                    case 88 -> 68;
                    case 89 -> 241;
                    case 90 -> 154;
                    case 91 -> 101;
                    case 92 -> 22;
                    case 93 -> 80;
                    case 94 -> 123;
                    case 95 -> 180;
                    case 96 -> 221;
                    case 97 -> 115;
                    case 98 -> 224;
                    case 99 -> 190;
                    case 100 -> 129;
                    case 101 -> 201;
                    case 102 -> 74;
                    case 103 -> 236;
                    case 104 -> 31;
                    case 105 -> 136;
                    case 106 -> 248;
                    case 107 -> 166;
                    case 108 -> 182;
                    case 109 -> 225;
                    case 110 -> 37;
                    case 111 -> 205;
                    case 112 -> 186;
                    case 113 -> 214;
                    case 114 -> 90;
                    case 115 -> 119;
                    case 116 -> 4;
                    case 117 -> 121;
                    case 118 -> 113;
                    case 119 -> 79;
                    case 120 -> 157;
                    case 121 -> 238;
                    case 122 -> 198;
                    case 123 -> 64;
                    case 124 -> 8;
                    case 125 -> 228;
                    case 126 -> 197;
                    case 127 -> 208;
                    case 128 -> 254;
                    case 129 -> 233;
                    case 130 -> 55;
                    case 131 -> 158;
                    case 132 -> 110;
                    case 133 -> 199;
                    case 134 -> 227;
                    case 135 -> 185;
                    case 136 -> 127;
                    case 137 -> 174;
                    case 138 -> 223;
                    case 139 -> 93;
                    case 140 -> 216;
                    case 141 -> 73;
                    case 142 -> 29;
                    case 143 -> 141;
                    case 144 -> 75;
                    case 145 -> 70;
                    case 146 -> 175;
                    case 147 -> 45;
                    case 148 -> 143;
                    case 149 -> 179;
                    case 150 -> 39;
                    case 151 -> 61;
                    case 152 -> 160;
                    case 153 -> 247;
                    case 154 -> 177;
                    case 155 -> 5;
                    case 156 -> 142;
                    case 157 -> 116;
                    case 158 -> 13;
                    case 159 -> 132;
                    case 160 -> 114;
                    case 161 -> 30;
                    case 162 -> 91;
                    case 163 -> 151;
                    case 164 -> 9;
                    case 165 -> 111;
                    case 166 -> 191;
                    case 167 -> 23;
                    case 168 -> 97;
                    case 169 -> 48;
                    case 170 -> 43;
                    case 171 -> 78;
                    case 172 -> 194;
                    case 173 -> 88;
                    case 174 -> 27;
                    case 175 -> 58;
                    case 176 -> 138;
                    case 177 -> 193;
                    case 178 -> 152;
                    case 179 -> 232;
                    case 180 -> 54;
                    case 181 -> 18;
                    case 182 -> 167;
                    case 183 -> 95;
                    case 184 -> 207;
                    case 185 -> 10;
                    case 186 -> 103;
                    case 187 -> 26;
                    case 188 -> 130;
                    case 189 -> 163;
                    case 190 -> 168;
                    case 191 -> 71;
                    case 192 -> 243;
                    case 193 -> 211;
                    case 194 -> 51;
                    case 195 -> 218;
                    case 196 -> 135;
                    case 197 -> 87;
                    case 198 -> 12;
                    case 199 -> 134;
                    case 200 -> 102;
                    case 201 -> 202;
                    case 202 -> 192;
                    case 203 -> 6;
                    case 204 -> 164;
                    case 205 -> 139;
                    case 206 -> 15;
                    case 207 -> 50;
                    case 208 -> 189;
                    case 209 -> 17;
                    case 210 -> 49;
                    case 211 -> 169;
                    case 212 -> 149;
                    case 213 -> 125;
                    case 214 -> 239;
                    case 215 -> 83;
                    case 216 -> 126;
                    case 217 -> 155;
                    case 218 -> 244;
                    case 219 -> 35;
                    case 220 -> 156;
                    case 221 -> 178;
                    case 222 -> 140;
                    case 223 -> 67;
                    case 224 -> 242;
                    case 225 -> 32;
                    case 226 -> 99;
                    case 227 -> 28;
                    case 228 -> 171;
                    case 229 -> 251;
                    case 230 -> 53;
                    case 231 -> 173;
                    case 232 -> 40;
                    case 233 -> 2;
                    case 234 -> 82;
                    case 235 -> 21;
                    case 236 -> 252;
                    case 237 -> 133;
                    case 238 -> 213;
                    case 239 -> 161;
                    case 240 -> 65;
                    case 241 -> 42;
                    case 242 -> 124;
                    case 243 -> 240;
                    case 244 -> 234;
                    case 245 -> 44;
                    case 246 -> 172;
                    case 247 -> 20;
                    case 248 -> 195;
                    case 249 -> 219;
                    case 250 -> 38;
                    case 251 -> 122;
                    case 252 -> 85;
                    case 253 -> 92;
                    case 254 -> 203;
                    default -> 57;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 115695621029454L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2087027610 - -((char)-6733), -2087027610 - -((char)-17895), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 97069487896043L;
                    boolean bl = SshAgentIpcService.W();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1067958360 + 10597, 1067958360 + 11451, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 63920120490935L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "'\u00c8\u0082\u00f6\u00ac\u0003O\u00ee\u00d9";
                var4_3 = "'\u00c8\u0082\u00f6\u00ac\u0003O\u00ee\u00d9".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 10;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 35;
                                break;
                            }
                            case 1: {
                                v11 = 99;
                                break;
                            }
                            case 2: {
                                v11 = 97;
                                break;
                            }
                            case 3: {
                                v11 = 45;
                                break;
                            }
                            case 4: {
                                v11 = 38;
                                break;
                            }
                            case 5: {
                                v11 = 56;
                                break;
                            }
                            default: {
                                v11 = 93;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFDC57) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 76;
                    case 1 -> 156;
                    case 2 -> 137;
                    case 3 -> 176;
                    case 4 -> 47;
                    case 5 -> 77;
                    case 6 -> 46;
                    case 7 -> 223;
                    case 8 -> 154;
                    case 9 -> 57;
                    case 10 -> 36;
                    case 11 -> 101;
                    case 12 -> 235;
                    case 13 -> 152;
                    case 14 -> 194;
                    case 15 -> 116;
                    case 16 -> 56;
                    case 17 -> 115;
                    case 18 -> 22;
                    case 19 -> 198;
                    case 20 -> 150;
                    case 21 -> 250;
                    case 22 -> 111;
                    case 23 -> 10;
                    case 24 -> 82;
                    case 25 -> 6;
                    case 26 -> 219;
                    case 27 -> 214;
                    case 28 -> 205;
                    case 29 -> 149;
                    case 30 -> 44;
                    case 31 -> 14;
                    case 32 -> 145;
                    case 33 -> 130;
                    case 34 -> 72;
                    case 35 -> 126;
                    case 36 -> 134;
                    case 37 -> 202;
                    case 38 -> 41;
                    case 39 -> 186;
                    case 40 -> 185;
                    case 41 -> 118;
                    case 42 -> 221;
                    case 43 -> 165;
                    case 44 -> 92;
                    case 45 -> 120;
                    case 46 -> 75;
                    case 47 -> 107;
                    case 48 -> 234;
                    case 49 -> 157;
                    case 50 -> 197;
                    case 51 -> 231;
                    case 52 -> 50;
                    case 53 -> 52;
                    case 54 -> 249;
                    case 55 -> 173;
                    case 56 -> 203;
                    case 57 -> 129;
                    case 58 -> 139;
                    case 59 -> 238;
                    case 60 -> 242;
                    case 61 -> 237;
                    case 62 -> 54;
                    case 63 -> 175;
                    case 64 -> 117;
                    case 65 -> 0;
                    case 66 -> 74;
                    case 67 -> 181;
                    case 68 -> 112;
                    case 69 -> 28;
                    case 70 -> 39;
                    case 71 -> 218;
                    case 72 -> 143;
                    case 73 -> 89;
                    case 74 -> 29;
                    case 75 -> 161;
                    case 76 -> 45;
                    case 77 -> 16;
                    case 78 -> 64;
                    case 79 -> 253;
                    case 80 -> 65;
                    case 81 -> 140;
                    case 82 -> 189;
                    case 83 -> 8;
                    case 84 -> 31;
                    case 85 -> 24;
                    case 86 -> 228;
                    case 87 -> 1;
                    case 88 -> 123;
                    case 89 -> 212;
                    case 90 -> 220;
                    case 91 -> 169;
                    case 92 -> 170;
                    case 93 -> 66;
                    case 94 -> 43;
                    case 95 -> 102;
                    case 96 -> 108;
                    case 97 -> 18;
                    case 98 -> 210;
                    case 99 -> 85;
                    case 100 -> 233;
                    case 101 -> 168;
                    case 102 -> 227;
                    case 103 -> 206;
                    case 104 -> 204;
                    case 105 -> 3;
                    case 106 -> 2;
                    case 107 -> 93;
                    case 108 -> 17;
                    case 109 -> 188;
                    case 110 -> 73;
                    case 111 -> 87;
                    case 112 -> 177;
                    case 113 -> 144;
                    case 114 -> 166;
                    case 115 -> 132;
                    case 116 -> 99;
                    case 117 -> 62;
                    case 118 -> 222;
                    case 119 -> 61;
                    case 120 -> 251;
                    case 121 -> 109;
                    case 122 -> 128;
                    case 123 -> 255;
                    case 124 -> 209;
                    case 125 -> 153;
                    case 126 -> 243;
                    case 127 -> 27;
                    case 128 -> 69;
                    case 129 -> 86;
                    case 130 -> 15;
                    case 131 -> 9;
                    case 132 -> 200;
                    case 133 -> 33;
                    case 134 -> 7;
                    case 135 -> 162;
                    case 136 -> 164;
                    case 137 -> 147;
                    case 138 -> 25;
                    case 139 -> 241;
                    case 140 -> 100;
                    case 141 -> 59;
                    case 142 -> 148;
                    case 143 -> 190;
                    case 144 -> 172;
                    case 145 -> 159;
                    case 146 -> 70;
                    case 147 -> 151;
                    case 148 -> 141;
                    case 149 -> 171;
                    case 150 -> 133;
                    case 151 -> 138;
                    case 152 -> 239;
                    case 153 -> 113;
                    case 154 -> 105;
                    case 155 -> 122;
                    case 156 -> 254;
                    case 157 -> 211;
                    case 158 -> 13;
                    case 159 -> 195;
                    case 160 -> 49;
                    case 161 -> 83;
                    case 162 -> 32;
                    case 163 -> 174;
                    case 164 -> 51;
                    case 165 -> 252;
                    case 166 -> 95;
                    case 167 -> 196;
                    case 168 -> 236;
                    case 169 -> 229;
                    case 170 -> 11;
                    case 171 -> 37;
                    case 172 -> 155;
                    case 173 -> 248;
                    case 174 -> 12;
                    case 175 -> 230;
                    case 176 -> 42;
                    case 177 -> 215;
                    case 178 -> 217;
                    case 179 -> 5;
                    case 180 -> 135;
                    case 181 -> 232;
                    case 182 -> 79;
                    case 183 -> 68;
                    case 184 -> 247;
                    case 185 -> 163;
                    case 186 -> 110;
                    case 187 -> 199;
                    case 188 -> 244;
                    case 189 -> 53;
                    case 190 -> 104;
                    case 191 -> 71;
                    case 192 -> 240;
                    case 193 -> 158;
                    case 194 -> 60;
                    case 195 -> 98;
                    case 196 -> 84;
                    case 197 -> 167;
                    case 198 -> 213;
                    case 199 -> 131;
                    case 200 -> 121;
                    case 201 -> 127;
                    case 202 -> 224;
                    case 203 -> 245;
                    case 204 -> 38;
                    case 205 -> 119;
                    case 206 -> 91;
                    case 207 -> 192;
                    case 208 -> 187;
                    case 209 -> 97;
                    case 210 -> 225;
                    case 211 -> 78;
                    case 212 -> 55;
                    case 213 -> 103;
                    case 214 -> 142;
                    case 215 -> 207;
                    case 216 -> 246;
                    case 217 -> 124;
                    case 218 -> 48;
                    case 219 -> 226;
                    case 220 -> 125;
                    case 221 -> 34;
                    case 222 -> 136;
                    case 223 -> 179;
                    case 224 -> 21;
                    case 225 -> 146;
                    case 226 -> 88;
                    case 227 -> 180;
                    case 228 -> 114;
                    case 229 -> 30;
                    case 230 -> 23;
                    case 231 -> 193;
                    case 232 -> 208;
                    case 233 -> 183;
                    case 234 -> 19;
                    case 235 -> 94;
                    case 236 -> 35;
                    case 237 -> 96;
                    case 238 -> 26;
                    case 239 -> 63;
                    case 240 -> 182;
                    case 241 -> 80;
                    case 242 -> 201;
                    case 243 -> 216;
                    case 244 -> 20;
                    case 245 -> 81;
                    case 246 -> 40;
                    case 247 -> 191;
                    case 248 -> 160;
                    case 249 -> 4;
                    case 250 -> 67;
                    case 251 -> 58;
                    case 252 -> 106;
                    case 253 -> 184;
                    case 254 -> 178;
                    default -> 90;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

