/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public class ListTasksCmdImpl
extends AbstrDockerCmd<ListTasksCmd, List<Task>>
implements ListTasksCmd {
    private FiltersBuilder filters = new FiltersBuilder();

    public ListTasksCmdImpl(ListTasksCmd.Exec exec) {
        super(exec);
    }

    @CheckForNull
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    public ListTasksCmd withLabelFilter(Map<String, String> labels) {
        this.filters.withLabels(labels);
        return this;
    }

    public ListTasksCmd withLabelFilter(String ... labels) {
        this.filters.withLabels(labels);
        return this;
    }

    public ListTasksCmd withIdFilter(String ... ids) {
        this.filters.withFilter("id", ids);
        return this;
    }

    public ListTasksCmd withNameFilter(String ... names) {
        this.filters.withFilter("name", names);
        return this;
    }

    public ListTasksCmd withNodeFilter(String ... nodeNames) {
        this.filters.withFilter("node", nodeNames);
        return this;
    }

    public ListTasksCmd withServiceFilter(String ... serviceNames) {
        this.filters.withFilter("service", serviceNames);
        return this;
    }

    public ListTasksCmd withStateFilter(TaskState ... desiredStates) {
        String[] states = new String[desiredStates.length];
        for (int i = 0; i < desiredStates.length; ++i) {
            states[i] = desiredStates[i].getValue();
        }
        this.filters.withFilter("desired-state", states);
        return this;
    }
}

