/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.base.view;

import com.intellij.xdebugger.impl.parallelStacks.base.view.GraphUtilsKt;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import s.D.Du;
import s.D.FY;
import s.W.Z;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksEditMode;", "Ls/D/FY;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "ParallelStacksEditMode", "(Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "lastMovedNode", "Ls/W/Z;", "getLastMovedNode", "()Ls/W/Z;", "setLastMovedNode", "(Ls/W/Z;)V", "lastClickedNode", "getLastClickedNode", "setLastClickedNode", "lastLeftMouseDown", "Ljava/awt/geom/Point2D;", "getLastLeftMouseDown", "()Ljava/awt/geom/Point2D;", "setLastLeftMouseDown", "(Ljava/awt/geom/Point2D;)V", "onWheelMoved", "", "wheelRotation", "", "point", "Ljava/awt/Point;", "mousePressedLeft", "x", "y", "mouseDragged", "event", "Ljava/awt/event/MouseEvent;", "mouseReleasedLeft", "mouseReleased", "mouseMoved", "mouseClicked", "mouseDraggedRight", "mousePressedRight", "mouseReleasedRight", "mouseShiftPressedRight", "mouseShiftPressedLeft", "mouseShiftReleasedLeft", "intellij.platform.debugger.parallelStacks"})
public class ParallelStacksEditMode
extends FY {
    @NotNull
    private final UpdatableGraph2DView graphView;
    @Nullable
    private Z lastMovedNode;
    @Nullable
    private Z lastClickedNode;
    @NotNull
    private Point2D lastLeftMouseDown;

    public ParallelStacksEditMode(@NotNull UpdatableGraph2DView graphView) {
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        super(graphView);
        this.graphView = graphView;
        this.lastLeftMouseDown = new Point2D.Double(0.0, 0.0);
        this.graphView.addMouseWheelListener(arg_0 -> ParallelStacksEditMode.s(this, arg_0));
    }

    @Nullable
    protected final Z getLastMovedNode() {
        return this.lastMovedNode;
    }

    protected final void setLastMovedNode(@Nullable Z z2) {
        this.lastMovedNode = z2;
    }

    @Nullable
    protected final Z getLastClickedNode() {
        return this.lastClickedNode;
    }

    protected final void setLastClickedNode(@Nullable Z z2) {
        this.lastClickedNode = z2;
    }

    @NotNull
    protected final Point2D getLastLeftMouseDown() {
        return this.lastLeftMouseDown;
    }

    protected final void setLastLeftMouseDown(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.lastLeftMouseDown = point2D;
    }

    protected void onWheelMoved(double wheelRotation, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.graphView.zoomWithMouseWheel(wheelRotation, point);
        Point2D point2D = this.graphView.s();
        double d2 = this.graphView.s();
        double d3 = (double)point.x / d2 + point2D.getX();
        double d4 = (double)point.y / d2 + point2D.getY();
        Object object = this.s().s(d3, d4).s();
        if (object == null) {
            return;
        }
        Object object2 = object;
        Du du = this.s();
        Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(du, (Z)object2);
        if (parallelStacksNodeRealizer == null) {
            return;
        }
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer;
        parallelStacksNodeRealizer2.onWheelMoved(wheelRotation, point);
    }

    @Override
    public void mousePressedLeft(double x10, double y2) {
        block3: {
            this.lastLeftMouseDown = new Point2D.Double(x10, y2);
            this.graphView.setActivePoint(null);
            Object object = this.s().s(x10, y2).s();
            if (object == null) {
                return;
            }
            Object object2 = object;
            if (this.lastClickedNode != null && !Intrinsics.areEqual((Object)object2, (Object)this.lastClickedNode)) {
                ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer;
                Du du = this.s();
                Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
                ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(du, this.lastClickedNode);
                if (parallelStacksNodeRealizer2 != null) {
                    parallelStacksNodeRealizer2.mousePressExpired();
                }
            }
            this.lastClickedNode = object2;
            Du du = this.s();
            Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(du, (Z)object2);
            if (parallelStacksNodeRealizer == null) break block3;
            parallelStacksNodeRealizer.mousePressed(x10, y2);
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (SwingUtilities.isLeftMouseButton(event)) {
            this.graphView.setCursor(Cursor.getPredefinedCursor(13));
            Point point = event.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.graphView.drag(this.lastLeftMouseDown, point);
        }
    }

    @Override
    public void mouseReleasedLeft(double x10, double y2) {
        this.graphView.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super.mouseReleased(event);
            if (!SwingUtilities.isRightMouseButton(event)) break block1;
            JPopupMenu jPopupMenu = this.graphView.getComponentPopupMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(this.graphView, event.getX(), event.getY());
            }
        }
    }

    @Override
    public void mouseMoved(double x10, double y2) {
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer;
        Object object = this.s().s(x10, y2).s();
        if (this.lastMovedNode != null && !Intrinsics.areEqual((Object)object, (Object)this.lastMovedNode)) {
            Du du = this.s();
            Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer2 = parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(du, this.lastMovedNode);
            if (parallelStacksNodeRealizer2 != null) {
                parallelStacksNodeRealizer2.mouseLeft();
            }
        }
        this.lastMovedNode = object;
        if (object == null) {
            return;
        }
        Du du = this.s();
        Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
        ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer3 = GraphUtilsKt.getParallelStacksRealizer(du, (Z)object);
        if (parallelStacksNodeRealizer3 == null) {
            return;
        }
        parallelStacksNodeRealizer = parallelStacksNodeRealizer3;
        parallelStacksNodeRealizer.mouseMoved(x10, y2);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            MouseEvent mouseEvent = event;
            boolean bl = false;
            Point2D point2D = this.graphView.s();
            double d2 = this.graphView.s();
            double d3 = (double)mouseEvent.getX() / d2 + point2D.getX();
            double d4 = (double)mouseEvent.getY() / d2 + point2D.getY();
            Object object = this.s().s(d3, d4).s();
            Du du = this.s();
            Intrinsics.checkNotNullExpressionValue((Object)du, (String)"getGraph2D(...)");
            ParallelStacksNodeRealizer<?> parallelStacksNodeRealizer = GraphUtilsKt.getParallelStacksRealizer(du, (Z)object);
            if (parallelStacksNodeRealizer == null) break block0;
            parallelStacksNodeRealizer.mouseClicked(event.getClickCount() == 2, d3, d4);
        }
    }

    @Override
    public void mouseDraggedRight(double x10, double y2) {
    }

    @Override
    public void mousePressedRight(double x10, double y2) {
    }

    @Override
    public void mouseReleasedRight(double x10, double y2) {
    }

    @Override
    public void mouseShiftPressedRight(double x10, double y2) {
    }

    @Override
    public void mouseShiftPressedLeft(double x10, double y2) {
    }

    @Override
    public void mouseShiftReleasedLeft(double x10, double y2) {
    }

    private static final void s(ParallelStacksEditMode parallelStacksEditMode, MouseWheelEvent mouseWheelEvent) {
        double d2 = mouseWheelEvent.getPreciseWheelRotation();
        Point point = mouseWheelEvent.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        parallelStacksEditMode.onWheelMoved(d2, point);
    }
}

