/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.ParentDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.nio.file.Paths;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DirectoryWithBrowseField
extends TextFieldWithBrowseButton {
    private final Project project;

    public DirectoryWithBrowseField(Project project) {
        super(null, (Disposable)ParentDisposable.getInstance(project));
        this.project = project;
        this.addActionListener(this::showChooser);
    }

    @NotNull
    public abstract VirtualFile getRootDirectory();

    private void showChooser(ActionEvent e) {
        VirtualFile rootDirectory = this.getRootDirectory();
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false).withRoots(new VirtualFile[]{rootDirectory}).withTreeRootVisible(true);
        chooserDescriptor.setForcedToUseIdeaFileChooser(true);
        String currentSelected = this.getText();
        VirtualFile currentSelectedDirectory = StringUtils.isNotEmpty((CharSequence)currentSelected) ? rootDirectory.findFileByRelativePath(currentSelected) : rootDirectory;
        VirtualFile chosenDirectory = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)this.project, (VirtualFile)currentSelectedDirectory);
        if (chosenDirectory == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)chosenDirectory, (VirtualFile)rootDirectory);
        if (StringUtils.isEmpty((CharSequence)relativePath)) {
            this.setText(null);
            return;
        }
        if (rootDirectory.findFileByRelativePath(relativePath) != null) {
            this.setText(relativePath);
        } else {
            this.setText(null);
        }
    }

    public String getDirectory() {
        return Paths.get(this.getRootDirectory().getPath(), this.getText()).toString();
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.OpenDiskHover;
        if (icon == null) {
            DirectoryWithBrowseField.$$$reportNull$$$0(0);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/jpb/model/ui/component/DirectoryWithBrowseField", "getDefaultIcon"));
    }
}

