/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.elements;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewElementsRetriever;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureElementState;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewModel;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewSelectionManager;
import com.intellij.jupyter.core.jupyter.structure.presentation.JupyterStructureItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001HBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"J\u0010\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0006\u0010'\u001a\u00020\u0003J\b\u0010(\u001a\u00020$H\u0002J\b\u0010)\u001a\u00020$H\u0002J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0018H\u0002J\r\u00101\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000204H\u0002J\u0014\u00106\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b7H\u0000\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u001dH\u0016J\n\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u0013\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00160@H\u0016\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u001dH\u0016J\b\u0010E\u001a\u00020\u001dH\u0016J\b\u0010F\u001a\u00020GH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "title", "", "level", "", "parent", "model", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "indexInCell", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Ljava/lang/String;ILcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Ljava/lang/Integer;)V", "getLevel", "()I", "getModel", "()Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "children", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "executionState", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureElementState;", "associatedIntervals", "cachedPresentation", "Lcom/intellij/jupyter/core/jupyter/structure/presentation/JupyterStructureItemPresentation;", "addChild", "", "child", "associateInterval", "interval", "collectAllRelatedIntervals", "", "updateStatus", "", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "getInterval", "markAsExecuting", "markAsQueued", "markAsError", "markAsCompleted", "markAsCancelled", "propagateState", "state", "shouldUpdateState", "newState", "getExecutionState", "getExecutionState$intellij_jupyter_core", "getIcon", "Ljavax/swing/Icon;", "getCellTypeIcon", "getExecutionCountString", "Lorg/jetbrains/annotations/Nls;", "getExecutionCountString$intellij_jupyter_core", "navigate", "requestFocus", "getRespectivePsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/impl/JupyterPsiCellImpl;", "valueKey", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement$ValueKey;", "getChildren", "", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "canNavigate", "canNavigateToSource", "getValue", "", "ValueKey", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewCellElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,169:1\n1869#2:170\n1870#2:172\n1617#2,9:173\n1869#2:182\n1870#2:184\n1626#2:185\n1761#2,3:187\n1#3:171\n1#3:183\n183#4:186\n184#4:190\n37#5,2:191\n37#5,2:193\n37#5,2:195\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement\n*L\n42#1:170\n42#1:172\n107#1:173,9\n107#1:182\n107#1:184\n107#1:185\n116#1:187,3\n107#1:183\n115#1:186\n115#1:190\n153#1:191,2\n154#1:193,2\n156#1:195,2\n*E\n"})
public final class JupyterStructureViewCellElement
implements StructureViewTreeElement {
    @NotNull
    private final NotebookCellLines.Interval cell;
    @NotNull
    private final String title;
    private final int level;
    @Nullable
    private final JupyterStructureViewCellElement parent;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final JupyterCellType cellType;
    @NotNull
    private final List<TreeElement> children;
    @NotNull
    private JupyterStructureElementState executionState;
    @NotNull
    private final List<NotebookCellLines.Interval> associatedIntervals;
    @NotNull
    private final JupyterStructureItemPresentation cachedPresentation;
    @NotNull
    private final ValueKey valueKey;

    public JupyterStructureViewCellElement(@NotNull NotebookCellLines.Interval cell, @NlsContexts.Label @NotNull String title, int level, @Nullable JupyterStructureViewCellElement parent, @NotNull JupyterStructureViewModel model, @NotNull JupyterCellType cellType, @Nullable Integer indexInCell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.cell = cell;
        this.title = title;
        this.level = level;
        this.parent = parent;
        this.model = model;
        this.cellType = cellType;
        this.children = new ArrayList();
        this.executionState = JupyterStructureElementState.NOT_RUNNING;
        this.associatedIntervals = new ArrayList();
        this.cachedPresentation = new JupyterStructureItemPresentation(this.title, null, this.getIcon(), this.level == 1, this.getExecutionState$intellij_jupyter_core());
        this.valueKey = new ValueKey(this.cell, this.title, this.level, indexInCell);
    }

    public /* synthetic */ JupyterStructureViewCellElement(NotebookCellLines.Interval interval, String string, int n, JupyterStructureViewCellElement jupyterStructureViewCellElement, JupyterStructureViewModel jupyterStructureViewModel, JupyterCellType jupyterCellType, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            jupyterStructureViewCellElement = null;
        }
        if ((n3 & 0x40) != 0) {
            n2 = null;
        }
        this(interval, string, n, jupyterStructureViewCellElement, jupyterStructureViewModel, jupyterCellType, n2);
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public final JupyterStructureViewModel getModel() {
        return this.model;
    }

    public final boolean addChild(@NotNull TreeElement child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.children.add(child);
    }

    public final boolean associateInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.associatedIntervals.add(interval);
    }

    @NotNull
    public final List<NotebookCellLines.Interval> collectAllRelatedIntervals() {
        List intervals = new ArrayList();
        intervals.addAll((Collection)this.associatedIntervals);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeElement child = (TreeElement)element$iv;
            boolean bl = false;
            Object object = child instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)child : null;
            if (object == null || (object = ((JupyterStructureViewCellElement)object).collectAllRelatedIntervals()) == null) continue;
            Object it = object;
            boolean bl2 = false;
            intervals.addAll((Collection)it);
        }
        return intervals;
    }

    public final void updateStatus(@Nullable ProgressStatus status) {
        ProgressStatus progressStatus = status;
        switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1: {
                this.markAsExecuting();
                break;
            }
            case 2: {
                this.markAsQueued();
                break;
            }
            case 3: {
                this.markAsError();
                break;
            }
            case 4: {
                this.markAsCompleted();
                break;
            }
            case 5: {
                this.markAsCancelled();
                break;
            }
            case -1: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final NotebookCellLines.Interval getInterval() {
        return this.cell;
    }

    private final void markAsExecuting() {
        block0: {
            this.executionState = JupyterStructureElementState.RUNNING;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.RUNNING);
        }
    }

    private final void markAsQueued() {
        block1: {
            if (this.executionState != JupyterStructureElementState.NOT_RUNNING) break block1;
            this.executionState = JupyterStructureElementState.QUEUED;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement != null) {
                jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.QUEUED);
            }
        }
    }

    private final void markAsError() {
        block0: {
            this.executionState = JupyterStructureElementState.ERROR;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.ERROR);
        }
    }

    private final void markAsCompleted() {
        block0: {
            this.executionState = JupyterStructureElementState.COMPLETED;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.COMPLETED);
        }
    }

    private final void markAsCancelled() {
        block0: {
            this.executionState = JupyterStructureElementState.CANCELLED;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.CANCELLED);
        }
    }

    private final void propagateState(JupyterStructureElementState state) {
        block1: {
            if (!this.shouldUpdateState(state)) break block1;
            this.executionState = state;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement != null) {
                jupyterStructureViewCellElement.propagateState(state);
            }
        }
    }

    private final boolean shouldUpdateState(JupyterStructureElementState newState) {
        JupyterStructureElementState previousState = this.executionState;
        return switch (WhenMappings.$EnumSwitchMapping$1[previousState.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                if (newState.isRunning() || newState.isError() || newState.isCancelled()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (newState.isCompleted() || newState.isError() || newState.isCancelled()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (newState.isRunning() || newState.isQueued() || newState.isError()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (newState.isRunning() || newState.isQueued() || newState.isError()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final JupyterStructureElementState getExecutionState$intellij_jupyter_core() {
        JupyterStructureElementState jupyterStructureElementState;
        Object v2;
        block8: {
            Object element$iv;
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            JupyterStructureElementState[] jupyterStructureElementStateArray = new JupyterStructureElementState[]{JupyterStructureElementState.ERROR, JupyterStructureElementState.RUNNING};
            if (SetsKt.setOf((Object[])jupyterStructureElementStateArray).contains((Object)this.executionState)) {
                return this.executionState;
            }
            Iterable $this$mapNotNull$iv = this.children;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JupyterStructureElementState it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                TreeElement treeElement = (TreeElement)element$iv$iv;
                boolean bl3 = false;
                JupyterStructureViewCellElement jupyterStructureViewCellElement = treeElement instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)treeElement : null;
                if ((jupyterStructureViewCellElement != null ? jupyterStructureViewCellElement.getExecutionState$intellij_jupyter_core() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List childStates = (List)destination$iv$iv;
            JupyterStructureElementState[] $i$f$mapNotNull22 = new JupyterStructureElementState[]{JupyterStructureElementState.ERROR, JupyterStructureElementState.RUNNING, JupyterStructureElementState.QUEUED, JupyterStructureElementState.CANCELLED, JupyterStructureElementState.COMPLETED};
            Sequence $this$firstOrNull$iv = SequencesKt.sequenceOf((Object[])$i$f$mapNotNull22);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            do {
                block14: {
                    block11: {
                        boolean bl5;
                        block9: {
                            Iterator iterator3;
                            JupyterStructureElementState state;
                            block13: {
                                block10: {
                                    Iterable $this$any$iv;
                                    block12: {
                                        if (!iterator2.hasNext()) break block10;
                                        element$iv = iterator2.next();
                                        state = (JupyterStructureElementState)((Object)element$iv);
                                        boolean bl6 = false;
                                        if (this.executionState == state) break block11;
                                        $this$any$iv = childStates;
                                        boolean $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block12;
                                        bl5 = false;
                                        break block9;
                                    }
                                    iterator3 = $this$any$iv.iterator();
                                    break block13;
                                }
                                v2 = null;
                                break block8;
                            }
                            while (iterator3.hasNext()) {
                                Object element$iv2 = iterator3.next();
                                JupyterStructureElementState jupyterStructureElementState2 = (JupyterStructureElementState)((Object)element$iv2);
                                boolean bl7 = false;
                                if (!(jupyterStructureElementState2 == state)) continue;
                                bl5 = true;
                                break block9;
                            }
                            bl5 = false;
                        }
                        if (!bl5) break block14;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while (!bl);
            v2 = element$iv;
        }
        if ((jupyterStructureElementState = (JupyterStructureElementState)v2) == null) {
            jupyterStructureElementState = JupyterStructureElementState.NOT_RUNNING;
        }
        return jupyterStructureElementState;
    }

    private final Icon getIcon() {
        return this.getCellTypeIcon();
    }

    private final Icon getCellTypeIcon() {
        Icon icon;
        JupyterCellType jupyterCellType = JupyterCellLinesExtensionsKt.toJupyterCellType(this.cell.getType());
        if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getMARKDOWN())) {
            Icon icon2 = JupyterCoreIcons.MarkdownCell;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"MarkdownCell");
        } else if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getCODE())) {
            Icon icon3 = JupyterCoreIcons.CodeCell;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CodeCell");
        } else if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getRAW())) {
            Icon icon4 = EmptyIcon.ICON_16;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ICON_16");
        } else {
            Icon icon5 = EmptyIcon.ICON_16;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ICON_16");
        }
        return icon;
    }

    @Nullable
    public final String getExecutionCountString$intellij_jupyter_core() {
        if (this.getExecutionState$intellij_jupyter_core().isRunningOrQueued()) {
            return null;
        }
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        Object object = JupyterEditorExtensionsKt.getJupyterCell(editor2, this.cell.getOrdinal());
        if (object == null || (object = object.getExecutionCount()) == null) {
            return null;
        }
        int executionCount = (Integer)object;
        return "[" + executionCount + "]";
    }

    public void navigate(boolean requestFocus) {
        JupyterStructureViewSelectionManager jupyterStructureViewSelectionManager = this.model.getSelectionManager();
        if (jupyterStructureViewSelectionManager == null) {
            return;
        }
        JupyterStructureViewSelectionManager selectionModel = jupyterStructureViewSelectionManager;
        selectionModel.withNavigationFlag((Function0<Unit>)((Function0)() -> JupyterStructureViewCellElement.navigate$lambda$0(this, requestFocus)));
    }

    private final JupyterPsiCellImpl getRespectivePsiCell() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCell(editor2, this.cell.getOrdinal());
        return jupyterPsiCell instanceof JupyterPsiCellImpl ? (JupyterPsiCellImpl)jupyterPsiCell : null;
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (!Intrinsics.areEqual((Object)this.cellType, (Object)JupyterCellType.Companion.getCODE())) {
            Collection $this$toTypedArray$iv = this.children;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TreeElement[0]);
        }
        JupyterPsiCellImpl jupyterPsiCellImpl = this.getRespectivePsiCell();
        if (jupyterPsiCellImpl == null) {
            Collection $this$toTypedArray$iv = this.children;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TreeElement[0]);
        }
        JupyterPsiCellImpl psiCellElement = jupyterPsiCellImpl;
        List<TreeElement> elementsInCellRange = JupyterStructureViewElementsRetriever.Companion.getStructureElements(psiCellElement);
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)elementsInCellRange, (Iterable)this.children);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        JupyterStructureElementState executionState = this.getExecutionState$intellij_jupyter_core();
        String execCount = this.getExecutionCountString$intellij_jupyter_core();
        this.cachedPresentation.update$intellij_jupyter_core(this.title, execCount, this.getIcon(), this.level == 1, executionState);
        return (ItemPresentation)this.cachedPresentation;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public Object getValue() {
        return this.valueKey;
    }

    private static final Unit navigate$lambda$0(JupyterStructureViewCellElement this$0, boolean $requestFocus) {
        block0: {
            JupyterPsiCellImpl jupyterPsiCellImpl;
            JupyterPsiCellImpl it = jupyterPsiCellImpl = this$0.getRespectivePsiCell();
            boolean bl = false;
            JupyterPsiCellImpl jupyterPsiCellImpl2 = it;
            Object object = (jupyterPsiCellImpl2 != null ? jupyterPsiCellImpl2.isValid() : false) ? jupyterPsiCellImpl : null;
            if (object == null) break block0;
            object.navigate($requestFocus);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J8\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement$ValueKey;", "", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "title", "", "level", "", "indexInCell", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Ljava/lang/String;ILjava/lang/Integer;)V", "getInterval", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getTitle", "()Ljava/lang/String;", "getLevel", "()I", "getIndexInCell", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "copy", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Ljava/lang/String;ILjava/lang/Integer;)Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement$ValueKey;", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.core"})
    private static final class ValueKey {
        @NotNull
        private final NotebookCellLines.Interval interval;
        @NotNull
        private final String title;
        private final int level;
        @Nullable
        private final Integer indexInCell;

        public ValueKey(@NotNull NotebookCellLines.Interval interval, @NotNull String title, int level, @Nullable Integer indexInCell) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.interval = interval;
            this.title = title;
            this.level = level;
            this.indexInCell = indexInCell;
        }

        @NotNull
        public final NotebookCellLines.Interval getInterval() {
            return this.interval;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public final int getLevel() {
            return this.level;
        }

        @Nullable
        public final Integer getIndexInCell() {
            return this.indexInCell;
        }

        @NotNull
        public final NotebookCellLines.Interval component1() {
            return this.interval;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        public final int component3() {
            return this.level;
        }

        @Nullable
        public final Integer component4() {
            return this.indexInCell;
        }

        @NotNull
        public final ValueKey copy(@NotNull NotebookCellLines.Interval interval, @NotNull String title, int level, @Nullable Integer indexInCell) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new ValueKey(interval, title, level, indexInCell);
        }

        public static /* synthetic */ ValueKey copy$default(ValueKey valueKey, NotebookCellLines.Interval interval, String string, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                interval = valueKey.interval;
            }
            if ((n3 & 2) != 0) {
                string = valueKey.title;
            }
            if ((n3 & 4) != 0) {
                n = valueKey.level;
            }
            if ((n3 & 8) != 0) {
                n2 = valueKey.indexInCell;
            }
            return valueKey.copy(interval, string, n, n2);
        }

        @NotNull
        public String toString() {
            return "ValueKey(interval=" + this.interval + ", title=" + this.title + ", level=" + this.level + ", indexInCell=" + this.indexInCell + ")";
        }

        public int hashCode() {
            int result2 = this.interval.hashCode();
            result2 = result2 * 31 + this.title.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.level);
            result2 = result2 * 31 + (this.indexInCell == null ? 0 : ((Object)this.indexInCell).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValueKey)) {
                return false;
            }
            ValueKey valueKey = (ValueKey)other;
            if (!Intrinsics.areEqual((Object)this.interval, (Object)valueKey.interval)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)valueKey.title)) {
                return false;
            }
            if (this.level != valueKey.level) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.indexInCell, (Object)valueKey.indexInCell);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_OK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.NOT_STARTED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JupyterStructureElementState.values().length];
            try {
                nArray[JupyterStructureElementState.NOT_RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.COMPLETED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

