/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.ReplaceableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.MemBasedSharedIndexStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001d\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0013H\u0082\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u000fJ\b\u0010'\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "Ljava/io/Closeable;", "mutableStorage", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "providedStorages", "", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "replaceableChunkStorages", "", "Lcom/intellij/indexing/shared/platform/api/ReplaceableSharedIndexStorage;", "<init>", "(Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;Ljava/util/List;Ljava/util/List;)V", "testStorage", "Lcom/intellij/indexing/shared/platform/impl/MemBasedSharedIndexStorage;", "toString", "", "foreachStorage", "", "action", "Lkotlin/Function1;", "getChunkRoot", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "chunkId", "addTestChunk", "chunkLocation", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addChunk", "chunkSourcePath", "Ljava/nio/file/Path;", "option", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "storageId", "getStorageId", "()Ljava/lang/String;", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "", "close", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexStorageHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n103#1,2:160\n105#1,3:164\n103#1,2:171\n105#1,3:175\n103#1,2:181\n105#1,3:185\n103#1,2:188\n105#1,3:192\n1869#2,2:162\n1869#2,2:167\n1869#2,2:169\n1869#2,2:173\n1803#2,3:178\n1869#2,2:183\n1869#2,2:190\n13#3:195\n*S KotlinDebug\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder\n*L\n98#1:160,2\n98#1:164,3\n110#1:171,2\n110#1:175,3\n143#1:181,2\n143#1:185,3\n150#1:188,2\n150#1:192,3\n98#1:162,2\n104#1:167,2\n105#1:169,2\n110#1:173,2\n139#1:178,3\n143#1:183,2\n150#1:190,2\n32#1:195\n*E\n"})
public final class SharedIndexStorageHolder
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedIndexStorage mutableStorage;
    @NotNull
    private final List<SharedIndexStorage> providedStorages;
    @NotNull
    private final List<ReplaceableSharedIndexStorage> replaceableChunkStorages;
    @NotNull
    private final MemBasedSharedIndexStorage testStorage;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MAIN_STORAGE_OLD_NAME = "chunks.zip";
    @NotNull
    public static final String MAIN_STORAGE_NAME = "shared-index.chunks";

    public SharedIndexStorageHolder(@NotNull MutableSharedIndexStorage mutableStorage, @NotNull List<? extends SharedIndexStorage> providedStorages, @NotNull List<ReplaceableSharedIndexStorage> replaceableChunkStorages) {
        Intrinsics.checkNotNullParameter((Object)mutableStorage, (String)"mutableStorage");
        Intrinsics.checkNotNullParameter(providedStorages, (String)"providedStorages");
        Intrinsics.checkNotNullParameter(replaceableChunkStorages, (String)"replaceableChunkStorages");
        this.mutableStorage = mutableStorage;
        this.providedStorages = providedStorages;
        this.replaceableChunkStorages = replaceableChunkStorages;
        this.testStorage = new MemBasedSharedIndexStorage();
    }

    @NotNull
    public String toString() {
        SharedIndexStorage it$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("CompositeStorage{");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl2 = false;
        $this$toString_u24lambda_u240.append(it.toString()).append(", ");
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl2 = false;
            $this$toString_u24lambda_u240.append(it.toString()).append(", ");
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl4 = false;
            it = it$iv;
            bl2 = false;
            $this$toString_u24lambda_u240.append(it.toString()).append(", ");
        }
        it = this_$iv.testStorage;
        bl2 = false;
        $this$toString_u24lambda_u240.append(it.toString()).append(", ");
        $this$toString_u24lambda_u240.append("}");
        return stringBuilder.toString();
    }

    private final void foreachStorage(Function1<? super SharedIndexStorage, Unit> action) {
        SharedIndexStorage it;
        boolean $i$f$foreachStorage = false;
        action.invoke((Object)this.mutableStorage);
        Iterable $this$forEach$iv = this.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
        $this$forEach$iv = this.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ReplaceableSharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
        action.invoke((Object)this.testStorage);
    }

    @Nullable
    public final SharedChunkLocation getChunkRoot(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        SharedChunkLocation chunkRoot = it.getChunkRoot(chunkId);
        if (chunkRoot != null) {
            return chunkRoot;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        it = this_$iv.testStorage;
        bl = false;
        chunkRoot = it.getChunkRoot(chunkId);
        if (chunkRoot != null) {
            return chunkRoot;
        }
        return null;
    }

    @TestOnly
    public final void addTestChunk(@NotNull SharedChunkLocation chunkLocation, @NotNull String chunkId, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)chunkLocation, (String)"chunkLocation");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.testStorage.appendChunk(chunkLocation, chunkId);
        Disposer.register((Disposable)parentDisposable, () -> SharedIndexStorageHolder.addTestChunk$lambda$0(this, chunkId));
    }

    public final void addChunk(@NotNull Path chunkSourcePath, @NotNull String chunkId, @NotNull ChunkStorageOption option) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                this.mutableStorage.appendChunk(chunkSourcePath, chunkId);
                break;
            }
            case 2: {
                String string = "Not supported yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final String getStorageId() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.union((Iterable)this.providedStorages, (Iterable)CollectionsKt.listOf((Object)this.mutableStorage)), (CharSequence)", ", null, null, (int)0, null, SharedIndexStorageHolder::_get_storageId_$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SharedIndexStats getSharedIndexStats() {
        void $this$fold$iv;
        Iterable iterable = this.providedStorages;
        SharedIndexStats initial$iv = this.mutableStorage.getSharedIndexStats();
        boolean $i$f$fold = false;
        SharedIndexStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            SharedIndexStorage sharedIndexStorage = (SharedIndexStorage)element$iv;
            SharedIndexStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(it.getSharedIndexStats());
        }
        return accumulator$iv;
    }

    public final boolean isCompatibleChunk(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        if (it.containsChunk(chunkId) && it.isCompatibleChunk(chunkId)) {
            return true;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        it = this_$iv.testStorage;
        bl = false;
        return it.containsChunk(chunkId) && it.isCompatibleChunk(chunkId);
    }

    @Override
    public void close() {
        SharedIndexStorage it$iv;
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        try {
            it.close();
        }
        catch (Throwable t) {
            LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
        it = this_$iv.testStorage;
        bl = false;
        try {
            it.close();
        }
        catch (Throwable t) {
            LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
        }
    }

    private static final void addTestChunk$lambda$0(SharedIndexStorageHolder this$0, String $chunkId) {
        this$0.testStorage.removeChunk($chunkId);
    }

    private static final CharSequence _get_storageId_$lambda$0(SharedIndexStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStorageId();
    }

    @JvmStatic
    @NotNull
    public static final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
        return Companion.openStoragesOrReset(corruptionHandler);
    }

    @JvmStatic
    public static final void deleteMutableStorage() {
        Companion.deleteMutableStorage();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexStorageHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000f\u0010\r\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAIN_STORAGE_OLD_NAME", "", "MAIN_STORAGE_NAME", "openStoragesOrReset", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "corruptionHandler", "Ljava/lang/Runnable;", "tryOpenStorages", "tryOpenStorages$intellij_indexing_shared", "deleteMutableStorage", "", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
            Intrinsics.checkNotNullParameter((Object)corruptionHandler, (String)"corruptionHandler");
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            SharedIndexMainZipStorage mutableStorage = (SharedIndexMainZipStorage)IOUtil.openCleanOrResetBroken(() -> Companion.openStoragesOrReset$lambda$0(oldStoragePath, newStoragePath), () -> Companion.openStoragesOrReset$lambda$1(corruptionHandler, oldStoragePath, newStoragePath));
            List<SharedIndexStorage> bundledIndexes = BundledSharedIndexesResolver.openBundledStorages();
            Intrinsics.checkNotNull((Object)mutableStorage);
            return new SharedIndexStorageHolder(mutableStorage, bundledIndexes, new ArrayList());
        }

        @Nullable
        public final SharedIndexStorageHolder tryOpenStorages$intellij_indexing_shared() {
            Object object;
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            Object object2 = this;
            try {
                Companion $this$tryOpenStorages_u24lambda_u240 = object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)oldStoragePath);
                Intrinsics.checkNotNull((Object)newStoragePath);
                object = Result.constructor-impl((Object)new SharedIndexMainZipStorage(oldStoragePath, newStoragePath, "shared index central storage"));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            SharedIndexMainZipStorage sharedIndexMainZipStorage = (SharedIndexMainZipStorage)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (sharedIndexMainZipStorage == null) {
                return null;
            }
            SharedIndexMainZipStorage mutableStorage = sharedIndexMainZipStorage;
            List<SharedIndexStorage> bundledIndexes = BundledSharedIndexesResolver.openBundledStorages();
            return new SharedIndexStorageHolder(mutableStorage, bundledIndexes, new ArrayList());
        }

        @JvmStatic
        public final void deleteMutableStorage() {
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            FileUtil.deleteWithRenaming((File)oldStoragePath.toFile());
            FileUtil.deleteWithRenaming((File)newStoragePath.toFile());
        }

        private static final SharedIndexMainZipStorage openStoragesOrReset$lambda$0(Path $oldStoragePath, Path $newStoragePath) {
            Intrinsics.checkNotNull((Object)$oldStoragePath);
            Intrinsics.checkNotNull((Object)$newStoragePath);
            return new SharedIndexMainZipStorage($oldStoragePath, $newStoragePath, "shared index central storage");
        }

        private static final void openStoragesOrReset$lambda$1(Runnable $corruptionHandler, Path $oldStoragePath, Path $newStoragePath) {
            $corruptionHandler.run();
            if (Files.exists($oldStoragePath, new LinkOption[0])) {
                FileUtil.delete((Path)$oldStoragePath);
            }
            if (Files.exists($newStoragePath, new LinkOption[0])) {
                FileUtil.delete((Path)$newStoragePath);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChunkStorageOption.values().length];
            try {
                nArray[ChunkStorageOption.APPENDABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkStorageOption.REPLACEABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

