/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModelKt;
import com.intellij.spring.mvc.apiversioning.SpringWebApiVersioningSupport;
import com.intellij.spring.mvc.apiversioning.model.SpringApiVersioningConfiguration;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002J9\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00150\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00140\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "getApiVersioningConfiguration", "Lcom/intellij/spring/mvc/apiversioning/model/SpringApiVersioningConfiguration;", "getApiVersioningConfigurationCached", "getApiVersioningConfigurationInternal", "mergeConfigurations", "configurations", "", "getSameValueOrNull", "R", "T", "", "fn", "Lkotlin/Function1;", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isApiVersioningAvailable", "Companion", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringApiVersioningModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringApiVersioningModel.kt\ncom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1617#2,9:116\n1869#2:125\n1870#2:127\n1626#2:128\n1374#2:129\n1460#2,5:130\n1374#2:136\n1460#2,5:137\n1740#2,3:142\n1#3:126\n1#3:135\n*S KotlinDebug\n*F\n+ 1 SpringApiVersioningModel.kt\ncom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel\n*L\n67#1:116,9\n67#1:125\n67#1:127\n67#1:128\n81#1:129\n81#1:130,5\n82#1:136\n82#1:137,5\n102#1:142,3\n67#1:126\n*E\n"})
public final class SpringApiVersioningModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public SpringApiVersioningModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public final boolean isAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ThreadingAssertions.assertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        return this.isApiVersioningAvailable(module);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final SpringApiVersioningConfiguration getApiVersioningConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ThreadingAssertions.assertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        if (!this.isApiVersioningAvailable(module)) {
            return null;
        }
        return this.getApiVersioningConfigurationCached(module);
    }

    private final SpringApiVersioningConfiguration getApiVersioningConfigurationCached(Module module) {
        return (SpringApiVersioningConfiguration)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> SpringApiVersioningModel.getApiVersioningConfigurationCached$lambda$0(this, module));
    }

    /*
     * WARNING - void declaration
     */
    private final SpringApiVersioningConfiguration getApiVersioningConfigurationInternal(Module module) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = SpringWebApiVersioningSupport.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SpringApiVersioningConfiguration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpringWebApiVersioningSupport provider = (SpringWebApiVersioningSupport)element$iv$iv;
            boolean bl2 = false;
            if (provider.getConfiguration(module) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allConfigurations = (List)destination$iv$iv;
        return this.mergeConfigurations(allConfigurations);
    }

    /*
     * WARNING - void declaration
     */
    private final SpringApiVersioningConfiguration mergeConfigurations(List<SpringApiVersioningConfiguration> configurations) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        if (configurations.isEmpty()) {
            return null;
        }
        if (configurations.size() == 1) {
            return (SpringApiVersioningConfiguration)CollectionsKt.first(configurations);
        }
        Boolean versionRequired = (Boolean)this.getSameValueOrNull((Collection)configurations, SpringApiVersioningModel::mergeConfigurations$lambda$0);
        String defaultVersion = (String)this.getSameValueOrNull((Collection)configurations, SpringApiVersioningModel::mergeConfigurations$lambda$1);
        Boolean detectSupportedVersion = (Boolean)this.getSameValueOrNull((Collection)configurations, SpringApiVersioningModel::mergeConfigurations$lambda$2);
        Iterable $this$flatMap$iv = configurations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            SpringApiVersioningConfiguration it = (SpringApiVersioningConfiguration)element$iv$iv;
            boolean bl = false;
            List list = it.getSupportedVersions();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable it = $this$flatMap$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        Iterable supportedVersions = !((Collection)it).isEmpty() ? $this$flatMap$iv : null;
        Iterable $this$flatMap$iv2 = configurations;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SpringApiVersioningConfiguration it2 = (SpringApiVersioningConfiguration)element$iv$iv;
            boolean bl2 = false;
            List list = it2.getResolvers();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List resolvers = (List)destination$iv$iv2;
        Boolean hasCustomVersionParser = (Boolean)this.getSameValueOrNull((Collection)configurations, SpringApiVersioningModel::mergeConfigurations$lambda$6);
        Boolean hasSupportedVersionPredicate = (Boolean)this.getSameValueOrNull((Collection)configurations, SpringApiVersioningModel::mergeConfigurations$lambda$7);
        return new SpringApiVersioningConfiguration(versionRequired, defaultVersion, detectSupportedVersion, (List<String>)supportedVersions, resolvers, hasCustomVersionParser, hasSupportedVersionPredicate);
    }

    private final <T, R> R getSameValueOrNull(Collection<? extends T> $this$getSameValueOrNull, Function1<? super T, ? extends R> fn) {
        Object object;
        if ($this$getSameValueOrNull.isEmpty()) {
            object = null;
        } else if ($this$getSameValueOrNull.size() == 1) {
            object = fn.invoke(CollectionsKt.first((Iterable)$this$getSameValueOrNull));
        } else {
            boolean bl;
            block7: {
                Iterable $this$all$iv = $this$getSameValueOrNull;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)fn.invoke(it), (Object)fn.invoke(CollectionsKt.first((Iterable)$this$getSameValueOrNull)))) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            object = bl ? fn.invoke(CollectionsKt.first((Iterable)$this$getSameValueOrNull)) : null;
        }
        return (R)object;
    }

    private final boolean isApiVersioningAvailable(Module module) {
        return SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_7_0);
    }

    private static final CachedValueProvider.Result getApiVersioningConfigurationCached$lambda$0(SpringApiVersioningModel this$0, Module $module) {
        Object[] objectArray = new Object[]{PsiModificationTracker.getInstance((Project)$module.getProject()).forLanguages(arg_0 -> SpringApiVersioningModel.getApiVersioningConfigurationCached$lambda$0$1(SpringApiVersioningModel::getApiVersioningConfigurationCached$lambda$0$0, arg_0))};
        return CachedValueProvider.Result.create((Object)this$0.getApiVersioningConfigurationInternal($module), (Object[])objectArray);
    }

    private static final boolean getApiVersioningConfigurationCached$lambda$0$0(Language language) {
        return SpringApiVersioningModelKt.access$getLanguagesToTrack$p().contains(language.getID());
    }

    private static final boolean getApiVersioningConfigurationCached$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean mergeConfigurations$lambda$0(SpringApiVersioningConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVersionRequired();
    }

    private static final String mergeConfigurations$lambda$1(SpringApiVersioningConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefaultVersion();
    }

    private static final Boolean mergeConfigurations$lambda$2(SpringApiVersioningConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDetectSupportedVersions();
    }

    private static final Boolean mergeConfigurations$lambda$6(SpringApiVersioningConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHasCustomVersionParser();
    }

    private static final Boolean mergeConfigurations$lambda$7(SpringApiVersioningConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHasSupportedVersionPredicate();
    }

    @JvmStatic
    @NotNull
    public static final SpringApiVersioningModel getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.mvc.impl"})
    @SourceDebugExtension(value={"SMAP\nSpringApiVersioningModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringApiVersioningModel.kt\ncom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n30#2,2:116\n*S KotlinDebug\n*F\n+ 1 SpringApiVersioningModel.kt\ncom/intellij/spring/mvc/apiversioning/SpringApiVersioningModel$Companion\n*L\n113#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpringApiVersioningModel getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SpringApiVersioningModel> serviceClass$iv = SpringApiVersioningModel.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SpringApiVersioningModel)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

