/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JSStubBasedScopeHandler {
    public static final JSStubBasedScopeHandler INSTANCE = new JSStubBasedScopeHandler();

    public boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull PsiScopeProcessor processor, boolean includeParentScopes) {
        String name;
        JSElement scope;
        if (context == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(1);
        }
        if ((scope = JSStubBasedScopeHandler.getScope(context = (PsiElement)ObjectUtils.coalesce((Object)CompletionUtilCoreImpl.getOriginalElement((PsiElement)context), (Object)context))) == null) {
            return true;
        }
        String string = name = processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
        if (!JSStubBasedPsiTreeUtil.hasStub((PsiElement)scope)) {
            return JSTreeUtil.processDeclarationsInScope(context, (PsiElement)scope, processor, name, includeParentScopes);
        }
        return JSStubBasedScopeHandler.processDeclarationsInScopeStubBased(context, scope, processor, name, includeParentScopes);
    }

    @Nullable
    protected static JSElement getScope(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(2);
        }
        return (scope = JSStubBasedPsiTreeUtil.getContextOfType(context, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, false)) instanceof TypeScriptInterface ? ((TypeScriptInterface)scope).getBody() : (JSElement)scope;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        if (context == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(5);
        }
        while (scope != null) {
            if (!JSStubBasedScopeHandler.processDeclarationsInScopeStubBased(context, scope, processor, name)) {
                return false;
            }
            if (!includeParentScopes || scope instanceof PsiFile || scope instanceof JSEmbeddedContent) {
                return true;
            }
            context = scope;
            scope = (JSElement)JSStubBasedPsiTreeUtil.getContextOfType((PsiElement)scope, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        }
        return true;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name) {
        if (context == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(8);
        }
        List<JSElement> elements = scope == context && name != null ? JSScopeNamesCache.findNamedElementsInStubScope(name, (PsiElement)scope) : JSStubBasedScopeHandler.findElementsInStubScopeWithContext(context, scope, name);
        for (PsiElement psiElement : elements) {
            if (processor.execute(psiElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<JSElement> findElementsInStubScopeWithContext(@NotNull PsiElement context, @NotNull JSElement scope, @Nullable String name) {
        if (context == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(10);
        }
        List<JSElement> declarations = JSScopeNamesCache.getNamedElementsInScope(scope, name, true);
        SmartList result = new SmartList();
        int declarationsBeforeContext = 0;
        if (name != null && declarations.size() > 1 && (declarationsBeforeContext = Collections.binarySearch(declarations, context, JSStubBasedPsiTreeUtil.TEXT_OFFSET_COMPARATOR)) < 0) {
            declarationsBeforeContext = -declarationsBeforeContext - 1;
        }
        for (int i = 0; i < declarations.size(); ++i) {
            JSElement declaration = declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
            String extractedName = JSStubBasedPsiTreeUtil.extractNameIfAcceptable((PsiElement)declaration);
            if (name != null && !name.equals(extractedName)) continue;
            result.add(declaration);
        }
        SmartList smartList = result;
        if (smartList == null) {
            JSStubBasedScopeHandler.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSStubBasedScopeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedScopeHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInStubScopeWithContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeStubBased";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInStubScopeWithContext";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

