/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 13400060633262L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-237367770 - -((char)-27240), -237367770 - -29855, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-237367770 - -((char)-27239), 237367770 - (char)-32204, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 74441588454422L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.s();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1215281040 - 140, -1215281040 - -11542, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1215281040 - 139, -1215281040 - -12144, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1215281040 - 142, -1215281040 - -4583, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 123744709625472L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.s();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21771), 1888063350 + (char)-20345, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21772), -1888063350 + -((char)-13987), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21773), -1888063350 + -((char)-27269), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21774), 1888063350 + (char)-13283, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21775), -1888063350 + -((char)-20423), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21776), -1888063350 + -((char)-23638), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21774), 1888063350 + (char)-13283, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1888063350 + -((char)-21777), 1888063350 + (char)-12383, (int)l2));
            if (ActionTimestamp.s() != 0) {
                SshAgentIpcService.s(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 48147105337014L;
                    actionTimestampArray = SshAgentIpcService.s();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 140129164424083L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                actionTimestampArray = SshAgentIpcService.s();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1561436910 - 12895, -1561436910 - -21384, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12896, -1561436910 - -31383, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12897, -1561436910 - -25904, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1561436910 - 12895, -1561436910 - -21384, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12898, 1561436910 - 18610, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1561436910 - 12895, -1561436910 - -21384, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12891, 1561436910 - (char)-31460, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12892, 1561436910 - 17763, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12897, -1561436910 - -25904, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1561436910 - 12895, -1561436910 - -21384, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1561436910 - 12899, -1561436910 - -((char)-28306), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1561436910 - 12893, -1561436910 - -11912, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 117370909898664L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1956350820 + 29078, 1956350820 + 27904, (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 26606993947968L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(328461420 + 2471, 328461420 - 10619, (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "?w\u00c4\u0012\u00e5\u00f0\u00b7\u008c\u0097\u00e8\u00c5\bGx\u0015\bV\u00b8\u0082\u0014\u000f\u00ec\u00c2g>\u009c\u00b1\u0084\u00d5\u00efH<4\u0007\u00balN\u00f2\u0086>";
                    var4_3 = "?w\u00c4\u0012\u00e5\u00f0\u00b7\u008c\u0097\u00e8\u00c5\bGx\u0015\bV\u00b8\u0082\u0014\u000f\u00ec\u00c2g>\u009c\u00b1\u0084\u00d5\u00efH<4\u0007\u00balN\u00f2\u0086>".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 41;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 53;
                                    break;
                                }
                                case 1: {
                                    v11 = 107;
                                    break;
                                }
                                case 2: {
                                    v11 = 93;
                                    break;
                                }
                                case 3: {
                                    v11 = 29;
                                    break;
                                }
                                case 4: {
                                    v11 = 45;
                                    break;
                                }
                                case 5: {
                                    v11 = 13;
                                    break;
                                }
                                default: {
                                    v11 = 116;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFFCB52) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 242;
                        case 1 -> 57;
                        case 2 -> 149;
                        case 3 -> 102;
                        case 4 -> 18;
                        case 5 -> 53;
                        case 6 -> 165;
                        case 7 -> 134;
                        case 8 -> 59;
                        case 9 -> 24;
                        case 10 -> 43;
                        case 11 -> 11;
                        case 12 -> 163;
                        case 13 -> 72;
                        case 14 -> 173;
                        case 15 -> 75;
                        case 16 -> 249;
                        case 17 -> 144;
                        case 18 -> 44;
                        case 19 -> 52;
                        case 20 -> 155;
                        case 21 -> 16;
                        case 22 -> 156;
                        case 23 -> 68;
                        case 24 -> 73;
                        case 25 -> 168;
                        case 26 -> 30;
                        case 27 -> 218;
                        case 28 -> 21;
                        case 29 -> 26;
                        case 30 -> 183;
                        case 31 -> 56;
                        case 32 -> 94;
                        case 33 -> 239;
                        case 34 -> 103;
                        case 35 -> 127;
                        case 36 -> 228;
                        case 37 -> 63;
                        case 38 -> 238;
                        case 39 -> 55;
                        case 40 -> 194;
                        case 41 -> 151;
                        case 42 -> 114;
                        case 43 -> 109;
                        case 44 -> 184;
                        case 45 -> 40;
                        case 46 -> 212;
                        case 47 -> 67;
                        case 48 -> 247;
                        case 49 -> 100;
                        case 50 -> 153;
                        case 51 -> 221;
                        case 52 -> 96;
                        case 53 -> 172;
                        case 54 -> 47;
                        case 55 -> 122;
                        case 56 -> 2;
                        case 57 -> 255;
                        case 58 -> 143;
                        case 59 -> 223;
                        case 60 -> 131;
                        case 61 -> 17;
                        case 62 -> 220;
                        case 63 -> 36;
                        case 64 -> 62;
                        case 65 -> 93;
                        case 66 -> 123;
                        case 67 -> 178;
                        case 68 -> 157;
                        case 69 -> 185;
                        case 70 -> 23;
                        case 71 -> 207;
                        case 72 -> 235;
                        case 73 -> 179;
                        case 74 -> 133;
                        case 75 -> 82;
                        case 76 -> 86;
                        case 77 -> 241;
                        case 78 -> 231;
                        case 79 -> 28;
                        case 80 -> 224;
                        case 81 -> 0;
                        case 82 -> 39;
                        case 83 -> 125;
                        case 84 -> 58;
                        case 85 -> 209;
                        case 86 -> 232;
                        case 87 -> 138;
                        case 88 -> 219;
                        case 89 -> 48;
                        case 90 -> 12;
                        case 91 -> 250;
                        case 92 -> 135;
                        case 93 -> 187;
                        case 94 -> 74;
                        case 95 -> 154;
                        case 96 -> 214;
                        case 97 -> 80;
                        case 98 -> 42;
                        case 99 -> 112;
                        case 100 -> 35;
                        case 101 -> 159;
                        case 102 -> 180;
                        case 103 -> 124;
                        case 104 -> 208;
                        case 105 -> 240;
                        case 106 -> 237;
                        case 107 -> 95;
                        case 108 -> 147;
                        case 109 -> 201;
                        case 110 -> 195;
                        case 111 -> 234;
                        case 112 -> 107;
                        case 113 -> 6;
                        case 114 -> 200;
                        case 115 -> 170;
                        case 116 -> 230;
                        case 117 -> 130;
                        case 118 -> 193;
                        case 119 -> 216;
                        case 120 -> 118;
                        case 121 -> 137;
                        case 122 -> 210;
                        case 123 -> 41;
                        case 124 -> 140;
                        case 125 -> 45;
                        case 126 -> 166;
                        case 127 -> 251;
                        case 128 -> 198;
                        case 129 -> 65;
                        case 130 -> 226;
                        case 131 -> 76;
                        case 132 -> 110;
                        case 133 -> 1;
                        case 134 -> 181;
                        case 135 -> 158;
                        case 136 -> 132;
                        case 137 -> 222;
                        case 138 -> 4;
                        case 139 -> 117;
                        case 140 -> 227;
                        case 141 -> 233;
                        case 142 -> 146;
                        case 143 -> 136;
                        case 144 -> 175;
                        case 145 -> 126;
                        case 146 -> 162;
                        case 147 -> 203;
                        case 148 -> 253;
                        case 149 -> 182;
                        case 150 -> 160;
                        case 151 -> 32;
                        case 152 -> 104;
                        case 153 -> 64;
                        case 154 -> 77;
                        case 155 -> 150;
                        case 156 -> 236;
                        case 157 -> 105;
                        case 158 -> 243;
                        case 159 -> 217;
                        case 160 -> 211;
                        case 161 -> 20;
                        case 162 -> 50;
                        case 163 -> 66;
                        case 164 -> 70;
                        case 165 -> 206;
                        case 166 -> 29;
                        case 167 -> 152;
                        case 168 -> 9;
                        case 169 -> 176;
                        case 170 -> 116;
                        case 171 -> 245;
                        case 172 -> 91;
                        case 173 -> 142;
                        case 174 -> 204;
                        case 175 -> 33;
                        case 176 -> 161;
                        case 177 -> 84;
                        case 178 -> 34;
                        case 179 -> 8;
                        case 180 -> 27;
                        case 181 -> 7;
                        case 182 -> 215;
                        case 183 -> 108;
                        case 184 -> 252;
                        case 185 -> 169;
                        case 186 -> 115;
                        case 187 -> 171;
                        case 188 -> 254;
                        case 189 -> 148;
                        case 190 -> 197;
                        case 191 -> 92;
                        case 192 -> 13;
                        case 193 -> 90;
                        case 194 -> 19;
                        case 195 -> 139;
                        case 196 -> 71;
                        case 197 -> 190;
                        case 198 -> 38;
                        case 199 -> 202;
                        case 200 -> 85;
                        case 201 -> 128;
                        case 202 -> 141;
                        case 203 -> 79;
                        case 204 -> 119;
                        case 205 -> 15;
                        case 206 -> 54;
                        case 207 -> 60;
                        case 208 -> 164;
                        case 209 -> 31;
                        case 210 -> 87;
                        case 211 -> 88;
                        case 212 -> 229;
                        case 213 -> 192;
                        case 214 -> 225;
                        case 215 -> 113;
                        case 216 -> 81;
                        case 217 -> 98;
                        case 218 -> 97;
                        case 219 -> 129;
                        case 220 -> 174;
                        case 221 -> 248;
                        case 222 -> 61;
                        case 223 -> 167;
                        case 224 -> 177;
                        case 225 -> 205;
                        case 226 -> 244;
                        case 227 -> 51;
                        case 228 -> 22;
                        case 229 -> 196;
                        case 230 -> 99;
                        case 231 -> 49;
                        case 232 -> 106;
                        case 233 -> 46;
                        case 234 -> 5;
                        case 235 -> 186;
                        case 236 -> 189;
                        case 237 -> 89;
                        case 238 -> 37;
                        case 239 -> 101;
                        case 240 -> 111;
                        case 241 -> 69;
                        case 242 -> 121;
                        case 243 -> 246;
                        case 244 -> 78;
                        case 245 -> 83;
                        case 246 -> 145;
                        case 247 -> 188;
                        case 248 -> 191;
                        case 249 -> 213;
                        case 250 -> 10;
                        case 251 -> 120;
                        case 252 -> 3;
                        case 253 -> 25;
                        case 254 -> 14;
                        default -> 199;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (actionTimestampArray != null) {
            int n3 = ActionTimestamp.I();
            ActionTimestamp.s(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 34273939891262L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.s();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(100923900 - (char)-11558, -100923900 - -((char)-7885), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(100923900 - (char)-11562, -100923900 - -((char)-19671), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(100923900 - (char)-11585, -100923900 - -((char)-16273), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(100923900 - (char)-11558, -100923900 - -((char)-7885), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(100923900 - (char)-11562, -100923900 - -((char)-19671), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(100923900 - (char)-11582, 100923900 - 32453, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 128083273735414L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.s();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1240970760 - -5627, -1240970760 - -8848, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1240970760 - -5624, 1240970760 - 8495, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 103086371315363L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = SshAgentIpcService.s();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14263), 1433774730 - (char)-13088, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14267), 1433643660 + (char)-9948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14290), 1433643660 + (char)-9758, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14267), 1433643660 + (char)-9948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14265), 1433774730 - (char)-1256, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14263), 1433774730 - (char)-13088, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14267), 1433643660 + (char)-9948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14283), -1433643660 + -((char)-9473), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14263), 1433774730 - (char)-13088, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14267), 1433643660 + (char)-9948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14284), -1433643660 + -((char)-4077), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14263), 1433774730 - (char)-13088, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14267), 1433643660 + (char)-9948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1433774730 - -((char)-14285), -1433774730 - -((char)-18400), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 46402413985427L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.s();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6923), 412739430 - (char)-22068, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6927), 412739430 - (char)-31770, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6914), -412739430 - -((char)-9319), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6907), 412739430 - (char)-32518, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6923), 412739430 - (char)-22068, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6927), 412739430 - (char)-31770, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6908), -412739430 - -((char)-20553), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6923), 412739430 - (char)-22068, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6927), 412739430 - (char)-31770, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6909), 412739430 - 28678, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6923), 412739430 - (char)-22068, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6927), 412739430 - (char)-31770, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6910), -412739430 - -((char)-18326), (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6923), 412739430 - (char)-22068, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6927), 412739430 - (char)-31770, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6903), -412739430 - -((char)-22506), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-412739430 - -((char)-6904), 412739430 - (char)-17026, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00e7#'\u0010S\u0014\u00f4\u00a1\u0014x\u00b6\u00ecE\u00d46\u00ab\u00ff8\u00df]O\u00de\u00d0Gh\u00c8\u0088\u00bc/\u0006\u0092r\u0089:\u00ec\u0010\u0018\u00f2\u00d0\u00dd\u00b9pl=t\"\u00d3\u0011\u00be1\u0011\u00e8\u00d2\u0094\u00b6\u0019u.\u00c2\u0092y\t\u00c2\u00bbEe\bh*\u00bc\u00fc\u0005\u00fcoD\u0099O\br\"\u0095AW\u0018r\u00c2\u0014\u008b*\u00eaMy?+IF\u00d49\u009a\u0018\u00c9$\u00a6\u00b6\u0082\u008a,\u0005P\u00c5\u00d1\u00cc\u00fd\u001e~U\u0001\u00baz\u00c8\u00de\u009a\u00fb\u001aa\u0000s\u00e6\u0002H(t\\\u00d9*x\u001e\u00e3\u00cem\u00f8NW\u00bf\u0010$\u0096\u00ae\u0007\u00d8M|\u00d3\u00d2\u0081\u00c9\u008e`b\u00cfG\t\u001e\u0000\b\u0003\u00f2\u0083S^=\u0010\u000bEK}d\u0002\u00eb: \u00bc\u0097)\u00ab\u0096\u00b6\u00d9?)\u00a3\u00e3d+\u001aq\u00ac\u007f\r\u00b4\u0019v3\u009f\u00cb^a\u00ef\u00be\u00d2\u00c6zRR\u00b3f!\u00b3\u0004$\u0083\u00bf\u0091\u000fT\u00ba\u00b4q,\u001f\u009e/_Q\u009d\u007f\u00da\u00fd\u00c61#\u0019\u0082 \u00b0\u00d8G\u009e\u00c1\u00c4\u00ae\u00ef\b~\u0002\u0014Eg\u0098t\u00d2\fV\u00c0\u0001\u0006\u00d8\u0092m\u0094\u00d9!\u00fa\u009eF\u00f9\u00d0\u00f4\u0004f\u00d2\u00ba\u009c#,\u00af\u00fb\u0083g>g\u0096\u0093\u00f6O\u00e3\u00aa_\u00ed\u00c0o\u00c7\u00b18?o\u00d8\u00eaLg\u00cem\u00aa +\u00a6k\u0093\u001a\u0018\u00b0\u0002\u0002\u00b5%^\u00f5\u001b\u00cev\"\u008da\u00a2\u00b9p\u00c8%\u00f5E\u00cfd\u00e1\u0018\u00ad\u001f\u00c53vv\u0094Q\u0003\u00a9@|\u0016\u00cc\u009db\u00d4i\u0089\u00b8\u0015\u008a\u00c8\u0092\u0095\u0015\u00dec\u00edC\u00e8\u00efw\u000bGD#\u0096\u009c\u0080\u00e5\u00d6\u00c8e\u00d2\u0015\u00ac\u000b^|4\u00b5\u001c\r\u00c9\u00fe:W\u00a6\u00bd\u00ae\u00c4=\u0099^\u00d7\u0097)|\u00baAGrw\u00dfm\u00db\u00e4e\u00df\u00f7\n\u0007a\u00ac1j\u001c\u00d78\u00b0X\u0015\u0083C'\u0012\u0097\u00aa\u00f3\u00ac\u008c\u00c9[\u00a6\u0005\u00d2w[\u0007\u00d4\"^N\u00b5\u000b\u00bc\u0007n\u00c1m^4\u00e6\u009a(8\u0080\u0085!Z\u00d1,\u009e\u00d5M\u008e\u00dc\u00a9\u00eb\u008e\u00de\u009ak\u0002\u0014\u00bb\u0007Rt\u00d9\u00bal{\u00c0|+\u0097gk.\n\u00e0R\u0089n\u000f\u00a4\nXY\t\u00b2\u00e31Y5\u00be\u0082\u000ft\u00c4\"B\u0015\u0086\u00b2\u008a\u00c9\u00c0\u00ba8\u001e\u0019\u0080{\u00ed\u00f2S\u00f9^J\u00b39\u00cd\u00cd\u00b6)\n\t\u00c8\u007fX\u00a5\rc\u00a0\u000e$\u00daHC\u000b\u00f1\u00a3YQ8\u00bf##J\u001b\u008f9::\u00bek\u0080Vb^T\u00ee\u000e\u00c5z@@\u0096\u00c06SI\u00f3\u0080\u00a5\u00a1\u00cd\nG$\u00e7\u009e\u0011\u001b\u00a6r\r\u00b8\u0018B\u00d2\u0083J\u0088\u00d9g^\u0080\u0096\u00cahdF\u00cb\u0011\u0001\u00bd?*\u00d4\u0081X\u00ca)\u0014\u00e2LL\u00d3\u0016\u00ebA]a\u00b5o\u00e9\u0015[\u00f9YW\u000b\u0015\u00c1\t;r\u0011T^1\u00e2\t\u000f\u00b1=\u001a.\u001d\u0084\u00e9\u0096\u00ea\u00d3\t\u00b9=\u00fc\u00baf{\u0097\u001a\u0018";
                var4_3 = "\u00e7#'\u0010S\u0014\u00f4\u00a1\u0014x\u00b6\u00ecE\u00d46\u00ab\u00ff8\u00df]O\u00de\u00d0Gh\u00c8\u0088\u00bc/\u0006\u0092r\u0089:\u00ec\u0010\u0018\u00f2\u00d0\u00dd\u00b9pl=t\"\u00d3\u0011\u00be1\u0011\u00e8\u00d2\u0094\u00b6\u0019u.\u00c2\u0092y\t\u00c2\u00bbEe\bh*\u00bc\u00fc\u0005\u00fcoD\u0099O\br\"\u0095AW\u0018r\u00c2\u0014\u008b*\u00eaMy?+IF\u00d49\u009a\u0018\u00c9$\u00a6\u00b6\u0082\u008a,\u0005P\u00c5\u00d1\u00cc\u00fd\u001e~U\u0001\u00baz\u00c8\u00de\u009a\u00fb\u001aa\u0000s\u00e6\u0002H(t\\\u00d9*x\u001e\u00e3\u00cem\u00f8NW\u00bf\u0010$\u0096\u00ae\u0007\u00d8M|\u00d3\u00d2\u0081\u00c9\u008e`b\u00cfG\t\u001e\u0000\b\u0003\u00f2\u0083S^=\u0010\u000bEK}d\u0002\u00eb: \u00bc\u0097)\u00ab\u0096\u00b6\u00d9?)\u00a3\u00e3d+\u001aq\u00ac\u007f\r\u00b4\u0019v3\u009f\u00cb^a\u00ef\u00be\u00d2\u00c6zRR\u00b3f!\u00b3\u0004$\u0083\u00bf\u0091\u000fT\u00ba\u00b4q,\u001f\u009e/_Q\u009d\u007f\u00da\u00fd\u00c61#\u0019\u0082 \u00b0\u00d8G\u009e\u00c1\u00c4\u00ae\u00ef\b~\u0002\u0014Eg\u0098t\u00d2\fV\u00c0\u0001\u0006\u00d8\u0092m\u0094\u00d9!\u00fa\u009eF\u00f9\u00d0\u00f4\u0004f\u00d2\u00ba\u009c#,\u00af\u00fb\u0083g>g\u0096\u0093\u00f6O\u00e3\u00aa_\u00ed\u00c0o\u00c7\u00b18?o\u00d8\u00eaLg\u00cem\u00aa +\u00a6k\u0093\u001a\u0018\u00b0\u0002\u0002\u00b5%^\u00f5\u001b\u00cev\"\u008da\u00a2\u00b9p\u00c8%\u00f5E\u00cfd\u00e1\u0018\u00ad\u001f\u00c53vv\u0094Q\u0003\u00a9@|\u0016\u00cc\u009db\u00d4i\u0089\u00b8\u0015\u008a\u00c8\u0092\u0095\u0015\u00dec\u00edC\u00e8\u00efw\u000bGD#\u0096\u009c\u0080\u00e5\u00d6\u00c8e\u00d2\u0015\u00ac\u000b^|4\u00b5\u001c\r\u00c9\u00fe:W\u00a6\u00bd\u00ae\u00c4=\u0099^\u00d7\u0097)|\u00baAGrw\u00dfm\u00db\u00e4e\u00df\u00f7\n\u0007a\u00ac1j\u001c\u00d78\u00b0X\u0015\u0083C'\u0012\u0097\u00aa\u00f3\u00ac\u008c\u00c9[\u00a6\u0005\u00d2w[\u0007\u00d4\"^N\u00b5\u000b\u00bc\u0007n\u00c1m^4\u00e6\u009a(8\u0080\u0085!Z\u00d1,\u009e\u00d5M\u008e\u00dc\u00a9\u00eb\u008e\u00de\u009ak\u0002\u0014\u00bb\u0007Rt\u00d9\u00bal{\u00c0|+\u0097gk.\n\u00e0R\u0089n\u000f\u00a4\nXY\t\u00b2\u00e31Y5\u00be\u0082\u000ft\u00c4\"B\u0015\u0086\u00b2\u008a\u00c9\u00c0\u00ba8\u001e\u0019\u0080{\u00ed\u00f2S\u00f9^J\u00b39\u00cd\u00cd\u00b6)\n\t\u00c8\u007fX\u00a5\rc\u00a0\u000e$\u00daHC\u000b\u00f1\u00a3YQ8\u00bf##J\u001b\u008f9::\u00bek\u0080Vb^T\u00ee\u000e\u00c5z@@\u0096\u00c06SI\u00f3\u0080\u00a5\u00a1\u00cd\nG$\u00e7\u009e\u0011\u001b\u00a6r\r\u00b8\u0018B\u00d2\u0083J\u0088\u00d9g^\u0080\u0096\u00cahdF\u00cb\u0011\u0001\u00bd?*\u00d4\u0081X\u00ca)\u0014\u00e2LL\u00d3\u0016\u00ebA]a\u00b5o\u00e9\u0015[\u00f9YW\u000b\u0015\u00c1\t;r\u0011T^1\u00e2\t\u000f\u00b1=\u001a.\u001d\u0084\u00e9\u0096\u00ea\u00d3\t\u00b9=\u00fc\u00baf{\u0097\u001a\u0018".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 32;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b4\u00cd\u00a1P\u0097l\u009a\u00f7\u008aN\u00b6spo\u0091O\u00f9t\u00b6\f\u00da\u00ecR\u00e9n\u00c2\u00d9_{\u0014\u00cdh\u00a3g\u00c4\u008bP\u00b1\u00be\u00eft\u00b0\u0002\u00d6%Q}V\u00f3\r";
                    var4_3 = "\u00b4\u00cd\u00a1P\u0097l\u009a\u00f7\u008aN\u00b6spo\u0091O\u00f9t\u00b6\f\u00da\u00ecR\u00e9n\u00c2\u00d9_{\u0014\u00cdh\u00a3g\u00c4\u008bP\u00b1\u00be\u00eft\u00b0\u0002\u00d6%Q}V\u00f3\r".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 30;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 37;
                            break;
                        }
                        case 1: {
                            v15 = 35;
                            break;
                        }
                        case 2: {
                            v15 = 85;
                            break;
                        }
                        case 3: {
                            v15 = 21;
                            break;
                        }
                        case 4: {
                            v15 = 23;
                            break;
                        }
                        case 5: {
                            v15 = 56;
                            break;
                        }
                        default: {
                            v15 = 118;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x310) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 129;
                case 1 -> 197;
                case 2 -> 149;
                case 3 -> 68;
                case 4 -> 20;
                case 5 -> 87;
                case 6 -> 32;
                case 7 -> 199;
                case 8 -> 104;
                case 9 -> 80;
                case 10 -> 48;
                case 11 -> 147;
                case 12 -> 115;
                case 13 -> 51;
                case 14 -> 160;
                case 15 -> 255;
                case 16 -> 179;
                case 17 -> 200;
                case 18 -> 178;
                case 19 -> 7;
                case 20 -> 120;
                case 21 -> 211;
                case 22 -> 227;
                case 23 -> 142;
                case 24 -> 14;
                case 25 -> 63;
                case 26 -> 116;
                case 27 -> 118;
                case 28 -> 167;
                case 29 -> 251;
                case 30 -> 187;
                case 31 -> 219;
                case 32 -> 134;
                case 33 -> 26;
                case 34 -> 226;
                case 35 -> 41;
                case 36 -> 183;
                case 37 -> 156;
                case 38 -> 95;
                case 39 -> 37;
                case 40 -> 139;
                case 41 -> 47;
                case 42 -> 143;
                case 43 -> 195;
                case 44 -> 36;
                case 45 -> 108;
                case 46 -> 55;
                case 47 -> 45;
                case 48 -> 4;
                case 49 -> 191;
                case 50 -> 220;
                case 51 -> 106;
                case 52 -> 56;
                case 53 -> 98;
                case 54 -> 6;
                case 55 -> 164;
                case 56 -> 249;
                case 57 -> 57;
                case 58 -> 83;
                case 59 -> 243;
                case 60 -> 173;
                case 61 -> 176;
                case 62 -> 79;
                case 63 -> 33;
                case 64 -> 100;
                case 65 -> 162;
                case 66 -> 145;
                case 67 -> 75;
                case 68 -> 99;
                case 69 -> 67;
                case 70 -> 0;
                case 71 -> 69;
                case 72 -> 35;
                case 73 -> 163;
                case 74 -> 38;
                case 75 -> 19;
                case 76 -> 74;
                case 77 -> 242;
                case 78 -> 224;
                case 79 -> 148;
                case 80 -> 132;
                case 81 -> 192;
                case 82 -> 225;
                case 83 -> 70;
                case 84 -> 201;
                case 85 -> 238;
                case 86 -> 11;
                case 87 -> 61;
                case 88 -> 44;
                case 89 -> 189;
                case 90 -> 158;
                case 91 -> 206;
                case 92 -> 235;
                case 93 -> 205;
                case 94 -> 25;
                case 95 -> 73;
                case 96 -> 18;
                case 97 -> 58;
                case 98 -> 128;
                case 99 -> 237;
                case 100 -> 232;
                case 101 -> 126;
                case 102 -> 82;
                case 103 -> 159;
                case 104 -> 21;
                case 105 -> 105;
                case 106 -> 131;
                case 107 -> 23;
                case 108 -> 97;
                case 109 -> 102;
                case 110 -> 155;
                case 111 -> 15;
                case 112 -> 241;
                case 113 -> 121;
                case 114 -> 40;
                case 115 -> 64;
                case 116 -> 1;
                case 117 -> 153;
                case 118 -> 89;
                case 119 -> 96;
                case 120 -> 136;
                case 121 -> 198;
                case 122 -> 252;
                case 123 -> 144;
                case 124 -> 161;
                case 125 -> 212;
                case 126 -> 127;
                case 127 -> 175;
                case 128 -> 78;
                case 129 -> 77;
                case 130 -> 204;
                case 131 -> 150;
                case 132 -> 107;
                case 133 -> 114;
                case 134 -> 231;
                case 135 -> 46;
                case 136 -> 93;
                case 137 -> 62;
                case 138 -> 240;
                case 139 -> 84;
                case 140 -> 66;
                case 141 -> 182;
                case 142 -> 194;
                case 143 -> 110;
                case 144 -> 24;
                case 145 -> 203;
                case 146 -> 119;
                case 147 -> 170;
                case 148 -> 193;
                case 149 -> 185;
                case 150 -> 168;
                case 151 -> 169;
                case 152 -> 245;
                case 153 -> 141;
                case 154 -> 181;
                case 155 -> 146;
                case 156 -> 125;
                case 157 -> 112;
                case 158 -> 76;
                case 159 -> 229;
                case 160 -> 34;
                case 161 -> 59;
                case 162 -> 228;
                case 163 -> 43;
                case 164 -> 88;
                case 165 -> 92;
                case 166 -> 94;
                case 167 -> 234;
                case 168 -> 122;
                case 169 -> 186;
                case 170 -> 71;
                case 171 -> 111;
                case 172 -> 209;
                case 173 -> 215;
                case 174 -> 223;
                case 175 -> 140;
                case 176 -> 239;
                case 177 -> 8;
                case 178 -> 5;
                case 179 -> 154;
                case 180 -> 72;
                case 181 -> 3;
                case 182 -> 171;
                case 183 -> 233;
                case 184 -> 113;
                case 185 -> 12;
                case 186 -> 65;
                case 187 -> 28;
                case 188 -> 17;
                case 189 -> 196;
                case 190 -> 16;
                case 191 -> 152;
                case 192 -> 30;
                case 193 -> 50;
                case 194 -> 184;
                case 195 -> 151;
                case 196 -> 29;
                case 197 -> 42;
                case 198 -> 109;
                case 199 -> 86;
                case 200 -> 218;
                case 201 -> 90;
                case 202 -> 124;
                case 203 -> 103;
                case 204 -> 60;
                case 205 -> 49;
                case 206 -> 166;
                case 207 -> 208;
                case 208 -> 165;
                case 209 -> 221;
                case 210 -> 27;
                case 211 -> 216;
                case 212 -> 10;
                case 213 -> 222;
                case 214 -> 174;
                case 215 -> 246;
                case 216 -> 101;
                case 217 -> 253;
                case 218 -> 135;
                case 219 -> 214;
                case 220 -> 52;
                case 221 -> 250;
                case 222 -> 13;
                case 223 -> 207;
                case 224 -> 213;
                case 225 -> 9;
                case 226 -> 217;
                case 227 -> 177;
                case 228 -> 190;
                case 229 -> 2;
                case 230 -> 22;
                case 231 -> 91;
                case 232 -> 236;
                case 233 -> 202;
                case 234 -> 54;
                case 235 -> 157;
                case 236 -> 172;
                case 237 -> 254;
                case 238 -> 180;
                case 239 -> 117;
                case 240 -> 133;
                case 241 -> 137;
                case 242 -> 138;
                case 243 -> 53;
                case 244 -> 85;
                case 245 -> 130;
                case 246 -> 188;
                case 247 -> 31;
                case 248 -> 39;
                case 249 -> 244;
                case 250 -> 210;
                case 251 -> 247;
                case 252 -> 123;
                case 253 -> 81;
                case 254 -> 248;
                default -> 230;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 133032198823279L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-118225140 - -27729, 118225140 - 19510, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 140391499485597L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.s();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1903529610 - (char)-28964, -1903529610 - -((char)-18399), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1903529610 - (char)-28963, -1903529610 - -((char)-7213), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1903529610 - (char)-28962, 1903529610 - (char)-10455, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "?\u0002\u0004\u0019l\u00f3\u009b3\u0010\u009d\u008d\u00a1IbB\u00a3\\iH\u0093\u00ec\u00ed\u00a6\u0010\u009f";
                    var4_3 = "?\u0002\u0004\u0019l\u00f3\u009b3\u0010\u009d\u008d\u00a1IbB\u00a3\\iH\u0093\u00ec\u00ed\u00a6\u0010\u009f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 103;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ae\u00e3\u00be\u00ad\u00c35\u00caJ%\u00f4bD3\u00bf\u0084\u00074Mf\u00f0\u00ecW\u009e\u009e\u00b3\u009eE\u00a1\u00ecZD\u00ce\u00f5\u00a4\u00b7L\u00c5h\u00ac\u001ei\u0002{\u00e4\u00a8\u009e\u00da\u00e7\u00e6P\u008d2\u00c5\u00f3\u001e\u00f3\u0096\u0010\r";
                        var4_3 = "\u00ae\u00e3\u00be\u00ad\u00c35\u00caJ%\u00f4bD3\u00bf\u0084\u00074Mf\u00f0\u00ecW\u009e\u009e\u00b3\u009eE\u00a1\u00ecZD\u00ce\u00f5\u00a4\u00b7L\u00c5h\u00ac\u001ei\u0002{\u00e4\u00a8\u009e\u00da\u00e7\u00e6P\u008d2\u00c5\u00f3\u001e\u00f3\u0096\u0010\r".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 96;
                                break;
                            }
                            case 1: {
                                v15 = 100;
                                break;
                            }
                            case 2: {
                                v15 = 106;
                                break;
                            }
                            case 3: {
                                v15 = 127;
                                break;
                            }
                            case 4: {
                                v15 = 4;
                                break;
                            }
                            case 5: {
                                v15 = 28;
                                break;
                            }
                            default: {
                                v15 = 51;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2E32) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 186;
                    case 1 -> 197;
                    case 2 -> 61;
                    case 3 -> 190;
                    case 4 -> 33;
                    case 5 -> 170;
                    case 6 -> 122;
                    case 7 -> 117;
                    case 8 -> 238;
                    case 9 -> 92;
                    case 10 -> 97;
                    case 11 -> 91;
                    case 12 -> 2;
                    case 13 -> 192;
                    case 14 -> 63;
                    case 15 -> 76;
                    case 16 -> 95;
                    case 17 -> 222;
                    case 18 -> 249;
                    case 19 -> 148;
                    case 20 -> 100;
                    case 21 -> 191;
                    case 22 -> 193;
                    case 23 -> 98;
                    case 24 -> 223;
                    case 25 -> 53;
                    case 26 -> 4;
                    case 27 -> 99;
                    case 28 -> 7;
                    case 29 -> 50;
                    case 30 -> 44;
                    case 31 -> 70;
                    case 32 -> 159;
                    case 33 -> 9;
                    case 34 -> 88;
                    case 35 -> 5;
                    case 36 -> 215;
                    case 37 -> 17;
                    case 38 -> 81;
                    case 39 -> 24;
                    case 40 -> 52;
                    case 41 -> 232;
                    case 42 -> 48;
                    case 43 -> 156;
                    case 44 -> 206;
                    case 45 -> 1;
                    case 46 -> 208;
                    case 47 -> 108;
                    case 48 -> 41;
                    case 49 -> 65;
                    case 50 -> 116;
                    case 51 -> 30;
                    case 52 -> 230;
                    case 53 -> 112;
                    case 54 -> 246;
                    case 55 -> 178;
                    case 56 -> 137;
                    case 57 -> 11;
                    case 58 -> 166;
                    case 59 -> 59;
                    case 60 -> 87;
                    case 61 -> 25;
                    case 62 -> 226;
                    case 63 -> 225;
                    case 64 -> 248;
                    case 65 -> 171;
                    case 66 -> 237;
                    case 67 -> 110;
                    case 68 -> 200;
                    case 69 -> 216;
                    case 70 -> 83;
                    case 71 -> 227;
                    case 72 -> 15;
                    case 73 -> 182;
                    case 74 -> 149;
                    case 75 -> 127;
                    case 76 -> 173;
                    case 77 -> 201;
                    case 78 -> 111;
                    case 79 -> 167;
                    case 80 -> 164;
                    case 81 -> 66;
                    case 82 -> 54;
                    case 83 -> 165;
                    case 84 -> 115;
                    case 85 -> 175;
                    case 86 -> 27;
                    case 87 -> 195;
                    case 88 -> 14;
                    case 89 -> 153;
                    case 90 -> 233;
                    case 91 -> 221;
                    case 92 -> 146;
                    case 93 -> 64;
                    case 94 -> 80;
                    case 95 -> 210;
                    case 96 -> 126;
                    case 97 -> 253;
                    case 98 -> 255;
                    case 99 -> 183;
                    case 100 -> 73;
                    case 101 -> 125;
                    case 102 -> 109;
                    case 103 -> 154;
                    case 104 -> 136;
                    case 105 -> 209;
                    case 106 -> 180;
                    case 107 -> 69;
                    case 108 -> 55;
                    case 109 -> 251;
                    case 110 -> 162;
                    case 111 -> 104;
                    case 112 -> 145;
                    case 113 -> 172;
                    case 114 -> 71;
                    case 115 -> 129;
                    case 116 -> 132;
                    case 117 -> 101;
                    case 118 -> 158;
                    case 119 -> 194;
                    case 120 -> 245;
                    case 121 -> 218;
                    case 122 -> 38;
                    case 123 -> 84;
                    case 124 -> 239;
                    case 125 -> 185;
                    case 126 -> 141;
                    case 127 -> 123;
                    case 128 -> 242;
                    case 129 -> 78;
                    case 130 -> 18;
                    case 131 -> 23;
                    case 132 -> 224;
                    case 133 -> 142;
                    case 134 -> 90;
                    case 135 -> 189;
                    case 136 -> 105;
                    case 137 -> 94;
                    case 138 -> 60;
                    case 139 -> 155;
                    case 140 -> 231;
                    case 141 -> 128;
                    case 142 -> 86;
                    case 143 -> 56;
                    case 144 -> 138;
                    case 145 -> 75;
                    case 146 -> 114;
                    case 147 -> 157;
                    case 148 -> 96;
                    case 149 -> 0;
                    case 150 -> 43;
                    case 151 -> 179;
                    case 152 -> 51;
                    case 153 -> 199;
                    case 154 -> 13;
                    case 155 -> 62;
                    case 156 -> 58;
                    case 157 -> 16;
                    case 158 -> 102;
                    case 159 -> 212;
                    case 160 -> 229;
                    case 161 -> 205;
                    case 162 -> 107;
                    case 163 -> 219;
                    case 164 -> 49;
                    case 165 -> 32;
                    case 166 -> 47;
                    case 167 -> 39;
                    case 168 -> 93;
                    case 169 -> 240;
                    case 170 -> 29;
                    case 171 -> 152;
                    case 172 -> 241;
                    case 173 -> 45;
                    case 174 -> 151;
                    case 175 -> 163;
                    case 176 -> 207;
                    case 177 -> 113;
                    case 178 -> 254;
                    case 179 -> 57;
                    case 180 -> 40;
                    case 181 -> 22;
                    case 182 -> 181;
                    case 183 -> 161;
                    case 184 -> 168;
                    case 185 -> 20;
                    case 186 -> 144;
                    case 187 -> 244;
                    case 188 -> 135;
                    case 189 -> 202;
                    case 190 -> 134;
                    case 191 -> 3;
                    case 192 -> 28;
                    case 193 -> 150;
                    case 194 -> 234;
                    case 195 -> 176;
                    case 196 -> 35;
                    case 197 -> 252;
                    case 198 -> 74;
                    case 199 -> 26;
                    case 200 -> 19;
                    case 201 -> 188;
                    case 202 -> 6;
                    case 203 -> 213;
                    case 204 -> 133;
                    case 205 -> 12;
                    case 206 -> 160;
                    case 207 -> 67;
                    case 208 -> 204;
                    case 209 -> 72;
                    case 210 -> 177;
                    case 211 -> 10;
                    case 212 -> 120;
                    case 213 -> 103;
                    case 214 -> 187;
                    case 215 -> 203;
                    case 216 -> 184;
                    case 217 -> 196;
                    case 218 -> 42;
                    case 219 -> 79;
                    case 220 -> 140;
                    case 221 -> 147;
                    case 222 -> 8;
                    case 223 -> 139;
                    case 224 -> 34;
                    case 225 -> 118;
                    case 226 -> 89;
                    case 227 -> 131;
                    case 228 -> 250;
                    case 229 -> 36;
                    case 230 -> 211;
                    case 231 -> 85;
                    case 232 -> 77;
                    case 233 -> 106;
                    case 234 -> 220;
                    case 235 -> 119;
                    case 236 -> 217;
                    case 237 -> 243;
                    case 238 -> 198;
                    case 239 -> 37;
                    case 240 -> 247;
                    case 241 -> 124;
                    case 242 -> 228;
                    case 243 -> 46;
                    case 244 -> 31;
                    case 245 -> 214;
                    case 246 -> 235;
                    case 247 -> 82;
                    case 248 -> 68;
                    case 249 -> 143;
                    case 250 -> 21;
                    case 251 -> 121;
                    case 252 -> 174;
                    case 253 -> 236;
                    case 254 -> 169;
                    default -> 130;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 68330040892790L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "bTA\t^yS;\te^R\u0003\u0013;N'\u0018";
                    var5_4 = "bTA\t^yS;\te^R\u0003\u0013;N'\u0018".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 81;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 88;
                                    break;
                                }
                                case 1: {
                                    v11 = 96;
                                    break;
                                }
                                case 2: {
                                    v11 = 98;
                                    break;
                                }
                                case 3: {
                                    v11 = 54;
                                    break;
                                }
                                case 4: {
                                    v11 = 106;
                                    break;
                                }
                                case 5: {
                                    v11 = 68;
                                    break;
                                }
                                default: {
                                    v11 = 49;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 86299672324497L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "3{\u001d*\u00199A\u00045e\u00110\n9z\u001a0\u0015;Y\u0013{\u0013\t9z\u001a0\u0015;Y\u001fq\r>|\u0007=\u001f6C\u001fv\u00007\u001e?";
                    var5_4 = "3{\u001d*\u00199A\u00045e\u00110\n9z\u001a0\u0015;Y\u0013{\u0013\t9z\u001a0\u0015;Y\u001fq\r>|\u0007=\u001f6C\u001fv\u00007\u001e?".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 62;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0000@\"\u0014 \u000fs\u0006\u0000@\"\u0014,\u0005";
                        var5_4 = "\u0000@\"\u0014 \u000fs\u0006\u0000@\"\u0014,\u0005".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 7;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 68;
                                break;
                            }
                            case 1: {
                                v15 = 43;
                                break;
                            }
                            case 2: {
                                v15 = 74;
                                break;
                            }
                            case 3: {
                                v15 = 96;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 102;
                                break;
                            }
                            default: {
                                v15 = 19;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 19737574147272L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-2095547160 - -10244, -2095547160 - -22538, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 127118444693112L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "!\u00f3Ae\u00fd\u0003\u009c\u00f4B\u0005\u0012\u009c\u0001L\u0016\r\u00fa\u00d3*\u00ef\u0086\u00d2\f\u00e9\u00e0\u00da\u00c7YP\u0010\u00c9J\u008b7\u008d\\F\u0005`\u00c347\u00c8\u00c5.F\u0005\u00fa\u0083\u001c\u00af\u00b53\u00af\f\u00a7)\u00dd\u00db|\u00e1Z\u00a2\u00f82\u00974\u00e9g&\u008d\u00f1\u00a5:\u00d2X\u0094\u0017\u00aa/\u00ee@\u008c,#r\u0088\u00c2\u00a9\u00c9\u00fb@U\u0003T\u00de)\u00d3aB\u00ea\u00f7\u00f2f";
                    var4_3 = "!\u00f3Ae\u00fd\u0003\u009c\u00f4B\u0005\u0012\u009c\u0001L\u0016\r\u00fa\u00d3*\u00ef\u0086\u00d2\f\u00e9\u00e0\u00da\u00c7YP\u0010\u00c9J\u008b7\u008d\\F\u0005`\u00c347\u00c8\u00c5.F\u0005\u00fa\u0083\u001c\u00af\u00b53\u00af\f\u00a7)\u00dd\u00db|\u00e1Z\u00a2\u00f82\u00974\u00e9g&\u008d\u00f1\u00a5:\u00d2X\u0094\u0017\u00aa/\u00ee@\u008c,#r\u0088\u00c2\u00a9\u00c9\u00fb@U\u0003T\u00de)\u00d3aB\u00ea\u00f7\u00f2f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 30;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "8,\u00e5\u00ab\u0010\u009f\u00a5-L\u0096\u00e1\u00cd\"\u00ca#\u00f7LI\u00f3<\u009a\u0001q\u00e9\u009eLsM\u00c8\u00b9\u00e4\u00c3K6\u0089\\\u0083\u00b7\"\u0093x\u001d\u008c\u001b\u00bcl\u00df\u0016vu\u009c\u0003g\u0093\u00aca\u0089Ab\t\u00c2l\u0092.\u00fc\u00d8T;\b\u008c\u009f*!9\u0004\u00a5k6\u00c4\u00d9\u00a5\n\r\u008cy\u00eb)\u00df\"Z\u009b\u00dcV";
                        var4_3 = "8,\u00e5\u00ab\u0010\u009f\u00a5-L\u0096\u00e1\u00cd\"\u00ca#\u00f7LI\u00f3<\u009a\u0001q\u00e9\u009eLsM\u00c8\u00b9\u00e4\u00c3K6\u0089\\\u0083\u00b7\"\u0093x\u001d\u008c\u001b\u00bcl\u00df\u0016vu\u009c\u0003g\u0093\u00aca\u0089Ab\t\u00c2l\u0092.\u00fc\u00d8T;\b\u008c\u009f*!9\u0004\u00a5k6\u00c4\u00d9\u00a5\n\r\u008cy\u00eb)\u00df\"Z\u009b\u00dcV".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 12;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 44;
                                break;
                            }
                            case 1: {
                                v15 = 2;
                                break;
                            }
                            case 2: {
                                v15 = 21;
                                break;
                            }
                            case 3: {
                                v15 = 99;
                                break;
                            }
                            case 4: {
                                v15 = 23;
                                break;
                            }
                            case 5: {
                                v15 = 24;
                                break;
                            }
                            default: {
                                v15 = 31;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2024) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 96;
                    case 1 -> 214;
                    case 2 -> 118;
                    case 3 -> 215;
                    case 4 -> 6;
                    case 5 -> 173;
                    case 6 -> 245;
                    case 7 -> 204;
                    case 8 -> 185;
                    case 9 -> 174;
                    case 10 -> 46;
                    case 11 -> 238;
                    case 12 -> 119;
                    case 13 -> 84;
                    case 14 -> 255;
                    case 15 -> 147;
                    case 16 -> 98;
                    case 17 -> 125;
                    case 18 -> 234;
                    case 19 -> 200;
                    case 20 -> 143;
                    case 21 -> 40;
                    case 22 -> 193;
                    case 23 -> 105;
                    case 24 -> 80;
                    case 25 -> 249;
                    case 26 -> 197;
                    case 27 -> 108;
                    case 28 -> 57;
                    case 29 -> 241;
                    case 30 -> 247;
                    case 31 -> 26;
                    case 32 -> 62;
                    case 33 -> 190;
                    case 34 -> 171;
                    case 35 -> 228;
                    case 36 -> 99;
                    case 37 -> 21;
                    case 38 -> 243;
                    case 39 -> 140;
                    case 40 -> 12;
                    case 41 -> 5;
                    case 42 -> 110;
                    case 43 -> 117;
                    case 44 -> 154;
                    case 45 -> 235;
                    case 46 -> 219;
                    case 47 -> 222;
                    case 48 -> 198;
                    case 49 -> 229;
                    case 50 -> 189;
                    case 51 -> 176;
                    case 52 -> 47;
                    case 53 -> 167;
                    case 54 -> 58;
                    case 55 -> 100;
                    case 56 -> 85;
                    case 57 -> 103;
                    case 58 -> 206;
                    case 59 -> 88;
                    case 60 -> 7;
                    case 61 -> 207;
                    case 62 -> 66;
                    case 63 -> 175;
                    case 64 -> 86;
                    case 65 -> 226;
                    case 66 -> 151;
                    case 67 -> 30;
                    case 68 -> 22;
                    case 69 -> 159;
                    case 70 -> 11;
                    case 71 -> 78;
                    case 72 -> 199;
                    case 73 -> 253;
                    case 74 -> 101;
                    case 75 -> 122;
                    case 76 -> 59;
                    case 77 -> 184;
                    case 78 -> 13;
                    case 79 -> 137;
                    case 80 -> 27;
                    case 81 -> 120;
                    case 82 -> 246;
                    case 83 -> 10;
                    case 84 -> 134;
                    case 85 -> 68;
                    case 86 -> 3;
                    case 87 -> 34;
                    case 88 -> 136;
                    case 89 -> 37;
                    case 90 -> 131;
                    case 91 -> 250;
                    case 92 -> 240;
                    case 93 -> 150;
                    case 94 -> 15;
                    case 95 -> 187;
                    case 96 -> 28;
                    case 97 -> 25;
                    case 98 -> 205;
                    case 99 -> 201;
                    case 100 -> 179;
                    case 101 -> 4;
                    case 102 -> 43;
                    case 103 -> 89;
                    case 104 -> 52;
                    case 105 -> 32;
                    case 106 -> 53;
                    case 107 -> 149;
                    case 108 -> 244;
                    case 109 -> 24;
                    case 110 -> 83;
                    case 111 -> 116;
                    case 112 -> 115;
                    case 113 -> 156;
                    case 114 -> 112;
                    case 115 -> 39;
                    case 116 -> 107;
                    case 117 -> 8;
                    case 118 -> 181;
                    case 119 -> 139;
                    case 120 -> 106;
                    case 121 -> 79;
                    case 122 -> 41;
                    case 123 -> 164;
                    case 124 -> 217;
                    case 125 -> 144;
                    case 126 -> 192;
                    case 127 -> 124;
                    case 128 -> 163;
                    case 129 -> 72;
                    case 130 -> 152;
                    case 131 -> 216;
                    case 132 -> 38;
                    case 133 -> 14;
                    case 134 -> 203;
                    case 135 -> 16;
                    case 136 -> 237;
                    case 137 -> 92;
                    case 138 -> 170;
                    case 139 -> 2;
                    case 140 -> 23;
                    case 141 -> 61;
                    case 142 -> 158;
                    case 143 -> 208;
                    case 144 -> 194;
                    case 145 -> 138;
                    case 146 -> 45;
                    case 147 -> 239;
                    case 148 -> 1;
                    case 149 -> 232;
                    case 150 -> 177;
                    case 151 -> 224;
                    case 152 -> 188;
                    case 153 -> 252;
                    case 154 -> 111;
                    case 155 -> 160;
                    case 156 -> 33;
                    case 157 -> 153;
                    case 158 -> 133;
                    case 159 -> 162;
                    case 160 -> 109;
                    case 161 -> 20;
                    case 162 -> 196;
                    case 163 -> 44;
                    case 164 -> 114;
                    case 165 -> 50;
                    case 166 -> 248;
                    case 167 -> 29;
                    case 168 -> 127;
                    case 169 -> 97;
                    case 170 -> 123;
                    case 171 -> 71;
                    case 172 -> 31;
                    case 173 -> 161;
                    case 174 -> 211;
                    case 175 -> 178;
                    case 176 -> 60;
                    case 177 -> 223;
                    case 178 -> 251;
                    case 179 -> 231;
                    case 180 -> 0;
                    case 181 -> 63;
                    case 182 -> 225;
                    case 183 -> 55;
                    case 184 -> 69;
                    case 185 -> 75;
                    case 186 -> 9;
                    case 187 -> 90;
                    case 188 -> 169;
                    case 189 -> 220;
                    case 190 -> 65;
                    case 191 -> 182;
                    case 192 -> 56;
                    case 193 -> 73;
                    case 194 -> 221;
                    case 195 -> 218;
                    case 196 -> 17;
                    case 197 -> 77;
                    case 198 -> 54;
                    case 199 -> 157;
                    case 200 -> 132;
                    case 201 -> 146;
                    case 202 -> 70;
                    case 203 -> 210;
                    case 204 -> 48;
                    case 205 -> 155;
                    case 206 -> 145;
                    case 207 -> 102;
                    case 208 -> 113;
                    case 209 -> 19;
                    case 210 -> 195;
                    case 211 -> 121;
                    case 212 -> 135;
                    case 213 -> 213;
                    case 214 -> 186;
                    case 215 -> 172;
                    case 216 -> 180;
                    case 217 -> 227;
                    case 218 -> 42;
                    case 219 -> 49;
                    case 220 -> 209;
                    case 221 -> 64;
                    case 222 -> 141;
                    case 223 -> 166;
                    case 224 -> 165;
                    case 225 -> 212;
                    case 226 -> 51;
                    case 227 -> 148;
                    case 228 -> 74;
                    case 229 -> 183;
                    case 230 -> 93;
                    case 231 -> 67;
                    case 232 -> 202;
                    case 233 -> 81;
                    case 234 -> 126;
                    case 235 -> 95;
                    case 236 -> 94;
                    case 237 -> 87;
                    case 238 -> 254;
                    case 239 -> 76;
                    case 240 -> 18;
                    case 241 -> 128;
                    case 242 -> 130;
                    case 243 -> 230;
                    case 244 -> 104;
                    case 245 -> 91;
                    case 246 -> 233;
                    case 247 -> 142;
                    case 248 -> 191;
                    case 249 -> 82;
                    case 250 -> 242;
                    case 251 -> 129;
                    case 252 -> 35;
                    case 253 -> 168;
                    case 254 -> 36;
                    default -> 236;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 11001986990820L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1719245190 - -22131, -1719245190 - -7130, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 37099427443195L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.s();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-500032050 + -19931, 500032050 + 29747, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 119483694920145L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "j\u00f6\u00c5\u00f2X\u0003 \u00c2\u00da";
                var4_3 = "j\u00f6\u00c5\u00f2X\u0003 \u00c2\u00da".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 14;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 27;
                                break;
                            }
                            case 1: {
                                v11 = 49;
                                break;
                            }
                            case 2: {
                                v11 = 12;
                                break;
                            }
                            case 3: {
                                v11 = 32;
                                break;
                            }
                            case 4: {
                                v11 = 19;
                                break;
                            }
                            case 5: {
                                v11 = 8;
                                break;
                            }
                            default: {
                                v11 = 44;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7E09) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 21;
                    case 1 -> 203;
                    case 2 -> 172;
                    case 3 -> 165;
                    case 4 -> 233;
                    case 5 -> 144;
                    case 6 -> 211;
                    case 7 -> 212;
                    case 8 -> 30;
                    case 9 -> 227;
                    case 10 -> 70;
                    case 11 -> 248;
                    case 12 -> 182;
                    case 13 -> 14;
                    case 14 -> 75;
                    case 15 -> 206;
                    case 16 -> 96;
                    case 17 -> 246;
                    case 18 -> 161;
                    case 19 -> 84;
                    case 20 -> 106;
                    case 21 -> 195;
                    case 22 -> 200;
                    case 23 -> 23;
                    case 24 -> 204;
                    case 25 -> 69;
                    case 26 -> 217;
                    case 27 -> 13;
                    case 28 -> 91;
                    case 29 -> 129;
                    case 30 -> 123;
                    case 31 -> 109;
                    case 32 -> 247;
                    case 33 -> 62;
                    case 34 -> 66;
                    case 35 -> 19;
                    case 36 -> 173;
                    case 37 -> 152;
                    case 38 -> 199;
                    case 39 -> 234;
                    case 40 -> 140;
                    case 41 -> 207;
                    case 42 -> 253;
                    case 43 -> 215;
                    case 44 -> 17;
                    case 45 -> 0;
                    case 46 -> 124;
                    case 47 -> 43;
                    case 48 -> 178;
                    case 49 -> 85;
                    case 50 -> 26;
                    case 51 -> 177;
                    case 52 -> 236;
                    case 53 -> 88;
                    case 54 -> 61;
                    case 55 -> 79;
                    case 56 -> 164;
                    case 57 -> 64;
                    case 58 -> 135;
                    case 59 -> 134;
                    case 60 -> 142;
                    case 61 -> 169;
                    case 62 -> 89;
                    case 63 -> 108;
                    case 64 -> 150;
                    case 65 -> 254;
                    case 66 -> 226;
                    case 67 -> 157;
                    case 68 -> 188;
                    case 69 -> 118;
                    case 70 -> 147;
                    case 71 -> 112;
                    case 72 -> 184;
                    case 73 -> 244;
                    case 74 -> 249;
                    case 75 -> 170;
                    case 76 -> 176;
                    case 77 -> 245;
                    case 78 -> 36;
                    case 79 -> 117;
                    case 80 -> 131;
                    case 81 -> 190;
                    case 82 -> 130;
                    case 83 -> 12;
                    case 84 -> 20;
                    case 85 -> 151;
                    case 86 -> 100;
                    case 87 -> 242;
                    case 88 -> 237;
                    case 89 -> 29;
                    case 90 -> 4;
                    case 91 -> 137;
                    case 92 -> 225;
                    case 93 -> 33;
                    case 94 -> 148;
                    case 95 -> 104;
                    case 96 -> 243;
                    case 97 -> 45;
                    case 98 -> 201;
                    case 99 -> 250;
                    case 100 -> 136;
                    case 101 -> 111;
                    case 102 -> 8;
                    case 103 -> 128;
                    case 104 -> 221;
                    case 105 -> 42;
                    case 106 -> 197;
                    case 107 -> 39;
                    case 108 -> 213;
                    case 109 -> 44;
                    case 110 -> 81;
                    case 111 -> 222;
                    case 112 -> 133;
                    case 113 -> 208;
                    case 114 -> 58;
                    case 115 -> 113;
                    case 116 -> 251;
                    case 117 -> 167;
                    case 118 -> 238;
                    case 119 -> 141;
                    case 120 -> 107;
                    case 121 -> 162;
                    case 122 -> 74;
                    case 123 -> 41;
                    case 124 -> 180;
                    case 125 -> 156;
                    case 126 -> 120;
                    case 127 -> 146;
                    case 128 -> 49;
                    case 129 -> 3;
                    case 130 -> 155;
                    case 131 -> 171;
                    case 132 -> 47;
                    case 133 -> 67;
                    case 134 -> 143;
                    case 135 -> 46;
                    case 136 -> 145;
                    case 137 -> 187;
                    case 138 -> 34;
                    case 139 -> 68;
                    case 140 -> 115;
                    case 141 -> 53;
                    case 142 -> 56;
                    case 143 -> 205;
                    case 144 -> 63;
                    case 145 -> 210;
                    case 146 -> 52;
                    case 147 -> 192;
                    case 148 -> 235;
                    case 149 -> 97;
                    case 150 -> 60;
                    case 151 -> 18;
                    case 152 -> 191;
                    case 153 -> 139;
                    case 154 -> 11;
                    case 155 -> 40;
                    case 156 -> 9;
                    case 157 -> 77;
                    case 158 -> 239;
                    case 159 -> 158;
                    case 160 -> 154;
                    case 161 -> 179;
                    case 162 -> 1;
                    case 163 -> 78;
                    case 164 -> 50;
                    case 165 -> 28;
                    case 166 -> 6;
                    case 167 -> 55;
                    case 168 -> 166;
                    case 169 -> 231;
                    case 170 -> 232;
                    case 171 -> 119;
                    case 172 -> 90;
                    case 173 -> 193;
                    case 174 -> 114;
                    case 175 -> 22;
                    case 176 -> 2;
                    case 177 -> 65;
                    case 178 -> 101;
                    case 179 -> 214;
                    case 180 -> 35;
                    case 181 -> 138;
                    case 182 -> 181;
                    case 183 -> 122;
                    case 184 -> 220;
                    case 185 -> 185;
                    case 186 -> 241;
                    case 187 -> 252;
                    case 188 -> 99;
                    case 189 -> 10;
                    case 190 -> 86;
                    case 191 -> 224;
                    case 192 -> 121;
                    case 193 -> 92;
                    case 194 -> 174;
                    case 195 -> 160;
                    case 196 -> 98;
                    case 197 -> 27;
                    case 198 -> 103;
                    case 199 -> 223;
                    case 200 -> 76;
                    case 201 -> 87;
                    case 202 -> 83;
                    case 203 -> 32;
                    case 204 -> 102;
                    case 205 -> 230;
                    case 206 -> 5;
                    case 207 -> 198;
                    case 208 -> 71;
                    case 209 -> 255;
                    case 210 -> 59;
                    case 211 -> 168;
                    case 212 -> 186;
                    case 213 -> 229;
                    case 214 -> 159;
                    case 215 -> 16;
                    case 216 -> 15;
                    case 217 -> 116;
                    case 218 -> 153;
                    case 219 -> 219;
                    case 220 -> 218;
                    case 221 -> 54;
                    case 222 -> 202;
                    case 223 -> 25;
                    case 224 -> 127;
                    case 225 -> 196;
                    case 226 -> 51;
                    case 227 -> 80;
                    case 228 -> 126;
                    case 229 -> 163;
                    case 230 -> 105;
                    case 231 -> 94;
                    case 232 -> 216;
                    case 233 -> 72;
                    case 234 -> 209;
                    case 235 -> 125;
                    case 236 -> 240;
                    case 237 -> 7;
                    case 238 -> 194;
                    case 239 -> 149;
                    case 240 -> 228;
                    case 241 -> 183;
                    case 242 -> 37;
                    case 243 -> 38;
                    case 244 -> 48;
                    case 245 -> 110;
                    case 246 -> 93;
                    case 247 -> 175;
                    case 248 -> 31;
                    case 249 -> 24;
                    case 250 -> 82;
                    case 251 -> 132;
                    case 252 -> 189;
                    case 253 -> 73;
                    case 254 -> 95;
                    default -> 57;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

