/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.impl.TSSymbolImpl;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.compiler.OutdatedTypeCheckerIdException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/completion/TSSymbolExpensiveRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "baseRenderer", "Lcom/intellij/lang/javascript/completion/JSLookupElementRenderer;", "symbol", "Lcom/intellij/javascript/types/TSSymbol;", "psiDeclarations", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/lang/javascript/completion/JSLookupElementRenderer;Lcom/intellij/javascript/types/TSSymbol;Ljava/util/List;)V", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "putInsertHandlerKeys", "psiDeclaration", "computeTypeAndTail", "Lcom/intellij/lang/javascript/completion/JSLookupUtilImpl$TypeAndTail;", "fetchTypeText", "", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTSSymbolLookupElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSSymbolLookupElement.kt\ncom/intellij/lang/javascript/completion/TSSymbolExpensiveRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n1#2:100\n23#3:101\n*S KotlinDebug\n*F\n+ 1 TSSymbolLookupElement.kt\ncom/intellij/lang/javascript/completion/TSSymbolExpensiveRenderer\n*L\n94#1:101\n*E\n"})
final class TSSymbolExpensiveRenderer
extends LookupElementRenderer<LookupElement> {
    @NotNull
    private final JSLookupElementRenderer baseRenderer;
    @NotNull
    private final TSSymbol symbol;
    @NotNull
    private final List<PsiElement> psiDeclarations;

    public TSSymbolExpensiveRenderer(@NotNull JSLookupElementRenderer baseRenderer, @NotNull TSSymbol symbol2, @NotNull List<? extends PsiElement> psiDeclarations) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseRenderer), (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(psiDeclarations, (String)"psiDeclarations");
        this.baseRenderer = baseRenderer;
        this.symbol = symbol2;
        this.psiDeclarations = psiDeclarations;
    }

    public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
        JSLookupUtilImpl.TypeAndTail typeAndTail;
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        element2.renderElement(presentation);
        PsiElement psiDeclaration = (PsiElement)CollectionsKt.singleOrNull(this.psiDeclarations);
        this.putInsertHandlerKeys(element2, psiDeclaration);
        Icon icon2 = icon = this.psiDeclarations.size() > 1 ? JSLookupUtilImpl.SEVERAL_DEFINITIONS_ICON : JSLookupUtilImpl.getLookupElementIcon(psiDeclaration);
        if (icon != null) {
            presentation.setIcon(icon);
        }
        if ((typeAndTail = this.computeTypeAndTail(psiDeclaration)) != null) {
            JSLookupElementRenderer.renderTypeAndTail(this.baseRenderer, presentation, typeAndTail, psiDeclaration, false);
        }
    }

    private final void putInsertHandlerKeys(LookupElement element2, PsiElement psiDeclaration) {
        JSFunction jSFunction = psiDeclaration instanceof JSFunction ? (JSFunction)psiDeclaration : null;
        if (jSFunction == null) {
            return;
        }
        JSFunction psiDeclaration2 = jSFunction;
        JSLookupElementInfo.FunctionType functionType = JSLookupElementInfo.calcFunctionType((PsiElement)psiDeclaration2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)functionType), (String)"calcFunctionType(...)");
        JSLookupElementInfo.FunctionType functionType2 = functionType;
        JSInsertHandler.ForcedCompleteFunctionType type2 = switch (WhenMappings.$EnumSwitchMapping$0[functionType2.ordinal()]) {
            case 1 -> JSInsertHandler.ForcedCompleteFunctionType.WITH_PARAMETERS;
            case 2 -> JSInsertHandler.ForcedCompleteFunctionType.EMPTY_PARAMETERS;
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (type2 != null) {
            element2.putUserData(JSInsertHandler.FORCED_COMPLETE_FUNCTION, (Object)type2);
        }
        JSFunction jSFunction2 = JSPsiImplUtils.getPossibleFunction((PsiElement)((PsiElement)psiDeclaration2));
        if (jSFunction2 == null) {
            return;
        }
        JSFunction possibleFunction = jSFunction2;
        JSLookupUtilImpl.JSLookupElementFunctionData possibleFunctionData = new JSLookupUtilImpl.JSLookupElementFunctionData((JSFunctionItem)possibleFunction, false, false);
        element2.putUserData(JSLookupUtilImpl.POSSIBLE_FUNCTION_DATA_KEY, (Object)possibleFunctionData);
    }

    private final JSLookupUtilImpl.TypeAndTail computeTypeAndTail(PsiElement psiDeclaration) {
        String string;
        String string2 = this.fetchTypeText();
        if (string2 == null) {
            return null;
        }
        String typeText = string2;
        PsiElement psiElement = psiDeclaration;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            string = JSLookupUtilImpl.getPackageLocationString(it);
        } else {
            string = null;
        }
        String location = string;
        return new JSLookupUtilImpl.TypeAndTail(typeText, null, location);
    }

    private final String fetchTypeText() {
        String string;
        try {
            TSSymbol tSSymbol = this.symbol;
            TSSymbolImpl tSSymbolImpl = tSSymbol instanceof TSSymbolImpl ? (TSSymbolImpl)tSSymbol : null;
            string = tSSymbolImpl != null ? tSSymbolImpl.getTypeText() : null;
        }
        catch (OutdatedTypeCheckerIdException e) {
            TSSymbolExpensiveRenderer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TSSymbolExpensiveRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to fetch type text for symbol: " + this.symbol.getEscapedName(), (Throwable)e);
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSLookupElementInfo.FunctionType.values().length];
            try {
                nArray[JSLookupElementInfo.FunctionType.FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLookupElementInfo.FunctionType.FUNCTION_NO_ARGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLookupElementInfo.FunctionType.NOT_FUNCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

