/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeInspectionVisitor
extends JSElementVisitor {
    @NotNull
    protected final ProblemsHolder myHolder;
    @Nullable
    protected final DialectOptionHolder myFileDialect;

    public JSTypeInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        PsiFile file = holder.getFile();
        this.myFileDialect = file instanceof JSFile ? DialectDetector.dialectOfElement((PsiElement)file) : null;
    }

    @NotNull
    protected DialectOptionHolder dialectOfElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (this.myFileDialect != null) {
            DialectOptionHolder dialectOptionHolder = this.myFileDialect;
            if (dialectOptionHolder == null) {
                JSTypeInspectionVisitor.$$$reportNull$$$0(2);
            }
            return dialectOptionHolder;
        }
        DialectOptionHolder ofElement = DialectDetector.dialectOfElement((PsiElement)element2);
        DialectOptionHolder dialectOptionHolder = ofElement == null ? DialectOptionHolder.OTHER : ofElement;
        if (dialectOptionHolder == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(3);
        }
        return dialectOptionHolder;
    }

    protected boolean isAcceptable(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(4);
        }
        DialectOptionHolder dialect = this.dialectOfElement(element2);
        return !dialect.isTypeScript && !dialect.isFlow;
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> this.checkFunctionDeclaration(node));
    }

    public void visitJSExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        super.visitJSExpression(expression);
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expression, (JSExpectedTypeKind)JSExpectedTypeKind.TYPE_CHECKING);
        if (expectedType == null || expectedType instanceof JSAnyType || expectedType instanceof JSVoidType) {
            return;
        }
        this.getTypeChecker((PsiElement)expression).checkExpressionIsAssignableToTypeAndReportError(expression, expectedType.copyWithStrict(true), "javascript.type.is.not.assignable.to.type", expectedType.getSourceElement(), true);
    }

    public final void visitJSCallExpression(@NotNull JSCallExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(7);
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> this.forCallExpression(node));
    }

    protected boolean forCallExpression(JSCallExpression node) {
        super.visitJSCallExpression(node);
        if (!this.isAcceptable((PsiElement)node)) {
            return false;
        }
        return this.checkIsCallable(node);
    }

    protected boolean checkIsCallable(@NotNull JSCallExpression node) {
        PsiElement function;
        boolean isProperty;
        JSType promiseArg;
        PsiElement resolvedElement;
        ResolveResult[] resolveResults;
        JSExpression methodExpression;
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(8);
        }
        if ((methodExpression = node.getMethodExpression()) instanceof JSSuperExpression) {
            return true;
        }
        ResolveResult[] resolveResultArray = resolveResults = methodExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpression).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
        if (this.skipForActionScript(node, methodExpression, resolveResults)) {
            return true;
        }
        boolean hasCallablePromise = false;
        boolean isNullableCallable = false;
        JSType jsType = JSResolveUtil.getExpressionJSType((JSExpression)methodExpression);
        PsiElement psiElement = resolvedElement = resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        if (methodExpression instanceof JSReferenceExpression && resolvedElement != null) {
            jsType = JSTypeGuardEvaluator.applyToExpressionType((JSType)jsType, (JSExpression)methodExpression, (PsiElement)resolvedElement, (JSEvaluateContext)new JSEvaluateContext(methodExpression.getContainingFile()));
        }
        if (resolvedElement instanceof JSParameter && ((JSParameter)resolvedElement).getJSType() == null && !DialectDetector.isTypeScript((PsiElement)resolvedElement)) {
            jsType = null;
        }
        if (jsType == null || !jsType.isSourceStrict() || jsType instanceof JSGenericParameterType && DialectDetector.isJavaScript((PsiElement)node) || this.getFunctionSignatureChecker((PsiElement)node).isCallableType(node.isNewExpression(), jsType, (PsiElement)node)) {
            boolean isAbstractClass = JSTypeInspectionVisitor.isAbstractClass(jsType);
            if (isAbstractClass) {
                this.getNonEmptyTypeChecker((PsiElement)node).registerProblem((PsiElement)(methodExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpression).getReferenceNameElement() : methodExpression), JavaScriptBundle.message((String)"javascript.abstract.class.can.not.be.instantiated.message", (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
                return false;
            }
            return true;
        }
        if (jsType instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType((JSType)jsType) && (promiseArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)((JSGenericTypeImpl)jsType), t -> true, (boolean)false)) != null && this.getFunctionSignatureChecker((PsiElement)node).isCallableType(node.isNewExpression(), promiseArg, (PsiElement)node)) {
            hasCallablePromise = true;
        }
        if (!node.isNewExpression()) {
            JSType nonNullableType = JSTypeUtils.removeNullableComponents((JSType)jsType);
            if (this.getFunctionSignatureChecker((PsiElement)node).isCallableType(false, nonNullableType, (PsiElement)node)) {
                if (node.isElvis()) {
                    return true;
                }
                isNullableCallable = true;
            }
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        JSArgumentList argumentList = node.getArgumentList();
        boolean bl = isProperty = resolveResults.length == 1 && (function = resolveResults[0].getElement()) instanceof JSFunction && ((JSFunction)function).isGetProperty();
        if (argumentList != null && isProperty) {
            fixes.add(JSFixFactory.getInstance().removeASTNodeFix("javascript.term.does.not.evaluate.to.function2.fix", (PsiElement)argumentList));
        }
        boolean hasLineBreakBeforeArgs = false;
        if (argumentList != null) {
            PsiElement sibling = argumentList.getPrevSibling();
            while (sibling instanceof PsiComment || sibling instanceof PsiWhiteSpace) {
                if (sibling instanceof PsiWhiteSpace && sibling.getText().contains("\n")) {
                    hasLineBreakBeforeArgs = true;
                    break;
                }
                sibling = sibling.getPrevSibling();
            }
        }
        if (hasCallablePromise) {
            fixes.add(JSFixFactory.getInstance().createInsertAwaitFix(node.getMethodExpression(), false));
        }
        if (isNullableCallable) {
            JSReferenceChecker checker = JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(new JSReferenceProblemReporter(this.myHolder));
            checker.addSurroundWithTypeGuardFix(methodExpression, fixes, TypeScriptTypeGuardFixHelper.CALL_PROP);
        }
        String key = hasLineBreakBeforeArgs ? "javascript.term.does.not.evaluate.to.function.line.break" : (isProperty ? "javascript.term.does.not.evaluate.to.function2" : (isNullableCallable ? "javascript.term.does.not.evaluate.to.function.nullable" : "javascript.term.does.not.evaluate.to.function"));
        this.getNonEmptyTypeChecker((PsiElement)node).registerProblem((PsiElement)(methodExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpression).getReferenceNameElement() : methodExpression), JavaScriptBundle.message((String)key, (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), (LocalQuickFix[])ContainerUtil.toArray(fixes, LocalQuickFix[]::new));
        return false;
    }

    private boolean skipForActionScript(@NotNull JSCallExpression node, JSExpression methodExpression, ResolveResult[] resolveResults) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (!DialectDetector.isActionScript((PsiElement)node)) {
            return false;
        }
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return true;
        }
        for (ResolveResult result2 : resolveResults) {
            PsiElement element2 = result2.getElement();
            if (element2 == null || this.getFunctionSignatureChecker((PsiElement)node).processMethodExpressionResolveResult(node, (JSReferenceExpression)methodExpression, element2, JSTypeUtils.getTypeOfElement((PsiElement)element2))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAbstractClass(@Nullable JSType jsType) {
        if (jsType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)jsType).resolveType();
            for (PsiElement declaration : info.getDeclarations()) {
                if (!(declaration instanceof JSClass) || !JSPsiImplUtils.hasModifier((JSAttributeListOwner)((JSClass)declaration), (JSAttributeList.ModifierType)JSAttributeList.ModifierType.ABSTRACT)) continue;
                return true;
            }
        }
        return false;
    }

    protected JSTypeChecker getNonEmptyTypeChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(10);
        }
        return JSAnalysisHandlersFactory.forElement(context2).getTypeChecker(this.myHolder);
    }

    protected JSTypeChecker getTypeChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(11);
        }
        return this.getNonEmptyTypeChecker(context2);
    }

    @NotNull
    protected JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(12);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context2).getFunctionSignatureChecker(this.myHolder);
        if (jSFunctionSignatureChecker == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(13);
        }
        return jSFunctionSignatureChecker;
    }

    public void visitJSConditionalExpression(@NotNull JSConditionalExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(14);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSConditionalExpression(node);
        ValidateTypesUtil.checkTypesInConditionalExpr(node, this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(15);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSPrefixExpression(node);
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPostfixExpression(@NotNull JSPostfixExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(16);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSPostfixExpression(node);
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSProperty(@NotNull JSProperty node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(17);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSProperty(node);
        PsiElement parent = node.getParent();
        if (parent instanceof JSObjectLiteralExpression && JSPsiImplUtils.isArgumentOfCallWithName((JSExpression)((JSExpression)parent), (int)1, (String[])new String[]{"Object", "defineProperties"})) {
            return;
        }
        String type2 = JSDocumentationUtils.findType((PsiElement)node);
        JSExpression value = node.getValue();
        if (type2 != null && value != null) {
            JSType jsType = JSTypeParser.createType((Project)node.getProject(), (String)type2, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)node, (boolean)true));
            if (node instanceof JSOptionalOwner && ((JSOptionalOwner)node).isOptional()) {
                jsType = JSTypeGuardUtil.wrapWithUndefined((JSType)jsType, null);
            }
            this.getTypeChecker((PsiElement)node).checkExpressionIsAssignableToTypeAndReportError(value, jsType, "javascript.initializer.type.mismatch", (PsiElement)node, true);
        }
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(18);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSReturnStatement(node);
        this.getNonEmptyTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)node);
    }

    public void visitJSVariable(@NotNull JSVariable node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(19);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSVariable(node);
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.getNonEmptyTypeChecker((PsiElement)node).checkExpressionIsAssignableToVariable(node, initializer, "javascript.initializer.type.mismatch");
    }

    public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
        JSType rType;
        boolean ecma;
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(20);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSBinaryExpression(node);
        JSTypeChecker checker = this.getTypeChecker((PsiElement)node);
        IElementType sign = node.getOperationSign();
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        boolean bl = ecma = holder != null && holder.isECMA4;
        if (ecma && (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || JSTokenTypes.SHIFT_OPERATIONS.contains(sign) || sign == JSTokenTypes.MINUS)) {
            JSType numberType = JSNamedType.createType((String)"Number", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)lOperand, (boolean)true), (JSContext)JSContext.INSTANCE);
            checker.checkExpressionIsAssignableToTypeAndReportError(lOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            checker.checkExpressionIsAssignableToTypeAndReportError(rOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            return;
        }
        if (sign == JSTokenTypes.AS_KEYWORD || sign == JSTokenTypes.IS_KEYWORD) {
            if (rOperand instanceof JSReferenceExpression) {
                PsiElement resolve2;
                ResolveResult[] results = ((JSReferenceExpression)rOperand).multiResolve(false);
                if (results.length > 0 && ((resolve2 = results[0].getElement()) instanceof JSVariable || resolve2 instanceof JSFunction)) {
                    checker.checkIfProperTypeReference(rOperand);
                }
            } else {
                checker.checkIfProperTypeReference(rOperand);
            }
        } else if (sign == JSTokenTypes.IN_KEYWORD && lOperand instanceof JSReferenceExpression && JSUtils.isPrivateBrandCheckReference((JSReferenceExpression)((JSReferenceExpression)lOperand)) && !JSTypeUtils.isPrivateBrandCheckAllowed((JSType)(rType = JSResolveUtil.getExpressionJSType((JSExpression)rOperand)), (JSElement)rOperand)) {
            checker.registerProblem((PsiElement)rOperand, JavaScriptBundle.message((String)"typescript.validation.incorrect.rhs.in.private.brand", (Object[])new Object[]{rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), null, new LocalQuickFix[0]);
        }
        if (DialectDetector.isFlow((PsiElement)node)) {
            ValidateTypesUtil.checkTypesInComparison(node, checker);
        }
    }

    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(21);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSAssignmentExpression(node);
        ValidateTypesUtil.checkTypesInAssignment(node, this.getNonEmptyTypeChecker((PsiElement)node));
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(22);
        }
        if (function.isSetProperty()) {
            JSFunction getter;
            PsiElement element2;
            JSParameterListElement[] params;
            JSParameterList parameterList = function.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length == 1 && (element2 = JSResolveUtil.findParent((PsiElement)function)) instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element2) && (getter = ((JSClass)element2).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                JSType retType = getter.getReturnType();
                JSType setterType = params[0].getJSType();
                this.validateSetter(function, getter, params[0], setterType, retType);
            }
        }
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(23);
        }
        this.checkGetterAndSetter(function);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(24);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSFunctionExpression(node);
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)node);
        if (returnExpression != null) {
            this.getNonEmptyTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)returnExpression);
        }
        this.checkGetterAndSetter((JSFunction)node);
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(25);
        }
        if (getter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(26);
        }
        if (!(this.isAny(setterType) || this.isAny(retType) || JSTypeUtils.areTypesCompatible((JSType)setterType, (JSType)retType, null, (PsiElement)setter))) {
            PsiElement typeElement = param.getTypeElement();
            this.getTypeChecker((PsiElement)setter).registerProblem((PsiElement)(typeElement != null ? typeElement : param), JavaScriptBundle.message((String)"javascript.validation.message.set.method.type.is.different.from.getter", (Object[])new Object[]{retType != null ? retType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)setter), new LocalQuickFix[0]);
        }
    }

    public void visitJSForInStatement(@NotNull JSForInStatement node) {
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(27);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSForInStatement(node);
        this.getTypeChecker((PsiElement)node).checkTypesInForIn(node);
    }

    public void visitJSYieldExpression(@NotNull JSYieldExpression expression) {
        if (expression == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(28);
        }
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        super.visitJSYieldExpression(expression);
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)expression);
        if (optionHolder == null || !optionHolder.isECMA6 && !optionHolder.isTypeScript) {
            return;
        }
        JSExpression subExpression = expression.getExpression();
        if (subExpression == null) {
            return;
        }
        PsiElement containerParent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, TypeScriptModule.class, JSFunction.class, ES6Decorator.class});
        if (!(containerParent instanceof JSFunction)) {
            return;
        }
        JSFunction function = (JSFunction)containerParent;
        JSType expressionType = JSResolveUtil.getExpressionJSType((JSExpression)subExpression);
        ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)subExpression);
        JSTypeChecker typeChecker = this.getTypeChecker((PsiElement)expression);
        if (expression.isIterable() && !this.isPossiblyIterableType(expressionType) && !this.isPossiblyIterableType(expressionType.substitute())) {
            typeChecker.registerProblem((PsiElement)subExpression, JavaScriptBundle.message((String)"javascript.validation.generators.yield.not.iterable", (Object[])new Object[0]), null, new LocalQuickFix[0]);
            return;
        }
        JSType returnType2 = function.getReturnType();
        if (!function.hasExplicitlyDeclaredReturnType()) {
            return;
        }
        JSType expressionComponentType = expression.isIterable() && expressionType != null ? JSTypeUtils.getIterableComponentType((JSType)expressionType) : expressionType;
        JSType componentType = JSTypeUtils.getIterableComponentType((JSType)returnType2);
        if (componentType != null && expressionComponentType != null) {
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)subExpression, () -> {
                if (!componentType.isDirectlyAssignableType(expressionComponentType, context2)) {
                    typeChecker.registerProblem((PsiElement)subExpression, JavaScriptBundle.message((String)"javascript.validation.generators.yield.not.assignable.to.return", (Object[])new Object[]{componentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionComponentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), null, new LocalQuickFix[0]);
                }
            });
        }
    }

    @Contract(value="null -> true")
    public boolean isPossiblyIterableType(@Nullable JSType expressionType) {
        return expressionType == null || this.isAny(expressionType) || JSTypeUtils.getIterableComponentType((JSType)expressionType) != null;
    }

    protected boolean isAny(@Nullable JSType type2) {
        if (this.myFileDialect != null && this.myFileDialect.isECMA4) {
            return type2 instanceof JSAnyType;
        }
        return !JSTypeUtils.isRestrictiveType((JSType)type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dialectOfElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfElement";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitJSExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitJSCallExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIsCallable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipForActionScript";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyTypeChecker";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitJSConditionalExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPrefixExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPostfixExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitJSProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBinaryExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAssignmentExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterAndSetter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForInStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitJSYieldExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 13 -> new IllegalStateException(string);
        };
    }
}

