/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.ultimate.JavaProfilerOptions;
import com.intellij.profiler.ultimate.snapshots.SnapshotFolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "Lcom/intellij/profiler/ultimate/JavaProfilerOptions;", "name", "", "resultSnapshot", "Lcom/intellij/profiler/SnapshotFile;", "<init>", "(Ljava/lang/String;Lcom/intellij/profiler/SnapshotFile;)V", "getName", "()Ljava/lang/String;", "getResultSnapshot", "()Lcom/intellij/profiler/SnapshotFile;", "startCommand", "", "startSettings", "toString", "Companion", "intellij.profiler.ultimate"})
public final class RecordingConfiguration
implements JavaProfilerOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final SnapshotFile resultSnapshot;
    @NotNull
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss");

    private RecordingConfiguration(String name, SnapshotFile resultSnapshot) {
        this.name = name;
        this.resultSnapshot = resultSnapshot;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public SnapshotFile getResultSnapshot() {
        return this.resultSnapshot;
    }

    @NotNull
    public final List<String> startCommand(@Nullable String startSettings) {
        Object[] objectArray = new String[]{"name=\"" + this.name + "\"", "settings=\"" + startSettings + "\"", "dumponexit=true", "filename=\"" + this.getResultSnapshot().getDumpFile() + "\""};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String toString() {
        return "RecordingConfiguration(name='" + this.name + "', resultSnapshot=" + this.getResultSnapshot() + ")";
    }

    public /* synthetic */ RecordingConfiguration(String name, SnapshotFile resultSnapshot, DefaultConstructorMarker $constructor_marker) {
        this(name, resultSnapshot);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration$Companion;", "", "<init>", "()V", "format", "Ljava/text/SimpleDateFormat;", "create", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "name", "", "filename", "project", "Lcom/intellij/openapi/project/Project;", "sanitizeName", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJFRProfilerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerProcess.kt\ncom/intellij/profiler/ultimate/jfr/RecordingConfiguration$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,210:1\n975#2:211\n1046#2,3:212\n*S KotlinDebug\n*F\n+ 1 JFRProfilerProcess.kt\ncom/intellij/profiler/ultimate/jfr/RecordingConfiguration$Companion\n*L\n49#1:211\n49#1:212,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecordingConfiguration create(@NotNull String name, @NotNull String filename, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            long time = System.currentTimeMillis();
            SnapshotFile snapshotFile = SnapshotFolder.INSTANCE.tryCreateFile(filename, time, "jfr", project);
            return new RecordingConfiguration(this.sanitizeName(name + " " + format.format(new Date(time))), snapshotFile, null);
        }

        public static /* synthetic */ RecordingConfiguration create$default(Companion companion, String string, String string2, Project project, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            return companion.create(string, string2, project);
        }

        /*
         * WARNING - void declaration
         */
        private final String sanitizeName(String name) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = name;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                int it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf((char)(Character.isLetterOrDigit((char)it) || it == 95 ? it : 95)));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

