/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.quic.QuicClientStreamTransportKt;
import com.intellij.platform.split.connection.network.quic.QuicStreamTransport;
import com.intellij.platform.split.connection.network.quic.QuicTimeoutException;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.intellij.platform.split.connection.network.quic.QuicheCommon;
import com.intellij.platform.split.connection.network.quic.QuicheConfig;
import com.intellij.platform.split.connection.network.quic.QuicheSockAddrKt;
import com.intellij.platform.split.connection.network.quic.SockAddrI;
import com.intellij.platform.split.connection.u.F;
import com.intellij.platform.split.connection.u.O;
import com.intellij.platform.split.connection.u.X;
import com.intellij.platform.split.connection.u.j;
import com.intellij.platform.split.connection.u.r;
import com.intellij.platform.split.connection.u.z;
import com.jetbrains.quiche.stubs.quiche_recv_info;
import com.jetbrains.quiche.stubs.quiche_send_info;
import com.jetbrains.rd.platform.codeWithMe.util.ThreadUtil;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0014\u0010\"\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport;", "Lcom/intellij/platform/split/connection/network/quic/QuicStreamTransport;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "localSocket", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "peer", "Ljava/net/InetSocketAddress;", "hostName", "", "idleTimeout", "Ljava/time/Duration;", "QuicClientStreamTransport", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;Ljava/net/InetSocketAddress;Ljava/lang/String;Ljava/time/Duration;)V", "name", "getName", "()Ljava/lang/String;", "connection", "Lcom/sun/jna/ptr/PointerByReference;", "myConnectionState", "Lcom/intellij/platform/split/connection/u/O;", "socketReceivedDatagrams", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Pair;", "", "receivedQueue", "Ljava/util/concurrent/BlockingDeque;", "getReceivedQueue", "()Ljava/util/concurrent/BlockingDeque;", "toSendQueue", "getToSendQueue", "wakeupQueue", "", "getWakeupQueue", "connected", "getConnected", "()Lcom/intellij/platform/split/connection/u/O;", "localSockAddress", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "peerSockAddr", "quicConnection", "quicThread", "", "addToSendQueue", "arr", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nQuicClientStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n67#2,4:310\n67#2,4:314\n67#2,4:318\n67#2,4:322\n67#2,4:326\n67#2,4:330\n67#2,4:334\n67#2,4:338\n67#2,4:342\n67#2,4:346\n67#2,4:350\n67#2,4:354\n67#2,4:358\n67#2,4:362\n67#2,4:366\n*S KotlinDebug\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n*L\n92#1:310,4\n128#1:314,4\n147#1:318,4\n162#1:322,4\n199#1:326,4\n222#1:330,4\n239#1:334,4\n251#1:338,4\n264#1:342,4\n269#1:346,4\n277#1:350,4\n280#1:354,4\n77#1:358,4\n83#1:362,4\n96#1:366,4\n*E\n"})
public final class QuicClientStreamTransport
extends QuicStreamTransport {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IDatagramSocketWrapper localSocket;
    @NotNull
    private final InetSocketAddress peer;
    @NotNull
    private final String hostName;
    @NotNull
    private final Duration idleTimeout;
    @NotNull
    private final String name;
    @NotNull
    private final PointerByReference connection;
    @NotNull
    private final O myConnectionState;
    @NotNull
    private final LinkedBlockingQueue<Pair<InetSocketAddress, byte[]>> socketReceivedDatagrams;
    @NotNull
    private final BlockingDeque<byte[]> receivedQueue;
    @NotNull
    private final BlockingDeque<byte[]> toSendQueue;
    @NotNull
    private final BlockingDeque<Boolean> wakeupQueue;
    @NotNull
    private final SockAddrI localSockAddress;
    @NotNull
    private final SockAddrI peerSockAddr;
    private static final String[] c;
    private static final String[] d;

    public QuicClientStreamTransport(@NotNull Lifetime lifetime, @NotNull IDatagramSocketWrapper localSocket, @NotNull InetSocketAddress peer, @NotNull String hostName, @NotNull Duration idleTimeout) {
        block8: {
            boolean bl;
            block10: {
                block9: {
                    boolean bl2;
                    boolean bl3;
                    Object object;
                    long l2;
                    block6: {
                        block7: {
                            l2 = 118877327605624L;
                            Intrinsics.checkNotNullParameter((Object)lifetime, (String)QuicClientStreamTransport.b(-1222752030 + -((char)-20878), 1222752030 + 29448, (int)l2));
                            Intrinsics.checkNotNullParameter((Object)localSocket, (String)QuicClientStreamTransport.b(-1222752030 + -((char)-20879), -1222752030 + -((char)-26507), (int)l2));
                            Intrinsics.checkNotNullParameter((Object)peer, (String)QuicClientStreamTransport.b(-1222752030 + -((char)-20880), 1222752030 + (char)-24046, (int)l2));
                            Intrinsics.checkNotNullParameter((Object)hostName, (String)QuicClientStreamTransport.b(-1222752030 + -((char)-20881), -1222752030 + -29898, (int)l2));
                            Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)QuicClientStreamTransport.b(-1222752030 + -((char)-20882), -1222752030 + -((char)-20926), (int)l2));
                            this.lifetime = lifetime;
                            this.localSocket = localSocket;
                            this.peer = peer;
                            this.hostName = hostName;
                            this.idleTimeout = idleTimeout;
                            this.name = QuicClientStreamTransport.b(-1222752030 + -((char)-20883), -1222752030 + -32414, (int)l2) + this.peer + ")";
                            this.myConnectionState = new O();
                            this.socketReceivedDatagrams = new LinkedBlockingQueue();
                            this.receivedQueue = new LinkedBlockingDeque();
                            this.toSendQueue = new LinkedBlockingDeque();
                            boolean bl4 = QuicStreamTransport.u();
                            this.wakeupQueue = new LinkedBlockingDeque();
                            InetSocketAddress inetSocketAddress = this.localSocket.getLocalAddress();
                            Intrinsics.checkNotNull((Object)inetSocketAddress);
                            this.localSockAddress = QuicheSockAddrKt.getQuicheSockAddr(inetSocketAddress);
                            this.peerSockAddr = QuicheSockAddrKt.getQuicheSockAddr(this.peer);
                            SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)this.lifetime, (arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$0(this, arg_0, arg_1));
                            this.localSocket.adviseOnSpecificAddressPackets(this.lifetime, this.peer, (Function1<? super byte[], Unit>)((Function1)arg_0 -> QuicClientStreamTransport._init_$lambda$1(this, arg_0)));
                            this.localSocket.adviseOnRemainingPackets(this.lifetime, (Function2<? super InetSocketAddress, ? super byte[], Unit>)((Function2)(arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$2(this, arg_0, arg_1)));
                            this.getWakeupQueue().add(true);
                            this.connection = this.quicConnection();
                            object = QuicClientStreamTransportKt.access$getLogger$p();
                            boolean bl5 = false;
                            bl3 = bl4;
                            try {
                                bl2 = object.isTraceEnabled();
                                if (bl3) break block6;
                                if (!bl2) break block7;
                            }
                            catch (RuntimeException runtimeException) {
                                throw QuicClientStreamTransport.a(runtimeException);
                            }
                            Logger logger = object;
                            boolean bl6 = false;
                            logger.trace(this.getName() + QuicClientStreamTransport.b(-1222752030 + -((char)-20884), 1222752030 + (char)-14742, (int)l2));
                        }
                        bl2 = false;
                    }
                    object = ThreadsKt.thread$default((boolean)bl2, (boolean)true, null, (String)(QuicClientStreamTransport.b(-1222752030 + -((char)-20885), -1222752030 + -32698, (int)l2) + this.peer), (int)10, () -> QuicClientStreamTransport._init_$lambda$4(this), (int)5, null);
                    try {
                        try {
                            this.lifetime.onTermination(() -> QuicClientStreamTransport._init_$lambda$5((Thread)object, this));
                            if (j.u() != null) break block8;
                            if (!bl3) break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            throw QuicClientStreamTransport.a(runtimeException);
                        }
                        bl = false;
                        break block10;
                    }
                    catch (RuntimeException runtimeException) {
                        throw QuicClientStreamTransport.a(runtimeException);
                    }
                }
                bl = true;
            }
            QuicStreamTransport.u(bl);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getReceivedQueue() {
        return this.receivedQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getToSendQueue() {
        return this.toSendQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<Boolean> getWakeupQueue() {
        return this.wakeupQueue;
    }

    @NotNull
    public O getConnected() {
        return this.myConnectionState;
    }

    private final PointerByReference quicConnection() {
        QuicheConfig quicheConfig;
        long l2 = 112642167054139L;
        byte[] byArray = Random.Default.nextBytes(16);
        QuicheConfig quicheConfig2 = quicheConfig = new QuicheConfig();
        boolean bl = false;
        quicheConfig2.setCommonSensibleOptions(this.idleTimeout);
        String[] stringArray = new String[]{QuicClientStreamTransport.b(1940229210 - 21023, -1940229210 - -15320, (int)l2), QuicClientStreamTransport.b(1940229210 - 21024, -1940229210 - -13462, (int)l2)};
        quicheConfig2.setSupportedProtocols(stringArray);
        QuicheConfig quicheConfig3 = quicheConfig;
        PointerByReference pointerByReference = Quiche.INSTANCE.getLibrary().quiche_connect(this.hostName, byArray, new NativeSize((long)byArray.length), this.localSockAddress.getQuicheSockAddr(), this.localSockAddress.getNativeSize(), this.peerSockAddr.getQuicheSockAddr(), this.peerSockAddr.getNativeSize(), quicheConfig3.getPointer());
        Intrinsics.checkNotNullExpressionValue((Object)pointerByReference, (String)QuicClientStreamTransport.b(1940229210 - 21025, 1940229210 - 20291, (int)l2));
        return pointerByReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void quicThread() {
        block145: {
            block138: {
                block109: {
                    var1_1 = 131811104170723L;
                    var4_2 = new Memory(512L);
                    var3_3 = QuicStreamTransport.u();
                    try {
                        var5_4 = ByteBuffer.allocate(65536);
                        var6_8 = ByteBuffer.allocate(1);
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24022, 1442163210 - 27864, (int)var1_1));
                        block94: while (O.u.I(this.myConnectionState)) {
                            block129: {
                                block128: {
                                    block126: {
                                        block127: {
                                            block123: {
                                                block124: {
                                                    block121: {
                                                        block154: {
                                                            block122: {
                                                                block152: {
                                                                    block117: {
                                                                        block118: {
                                                                            block119: {
                                                                                block120: {
                                                                                    block115: {
                                                                                        block116: {
                                                                                            block114: {
                                                                                                block113: {
                                                                                                    block112: {
                                                                                                        block149: {
                                                                                                            block148: {
                                                                                                                block110: {
                                                                                                                    block111: {
                                                                                                                        block108: {
                                                                                                                            var7_10 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                                                            var8_11 = false;
                                                                                                                            if (var3_3) break block108;
                                                                                                                            try {
                                                                                                                                block146: {
                                                                                                                                    v0 = var7_10;
                                                                                                                                    if (var3_3) break block109;
                                                                                                                                    break block146;
                                                                                                                                    catch (IOException v1) {
                                                                                                                                        throw QuicClientStreamTransport.a(v1);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (!v0.isTraceEnabled()) break block108;
                                                                                                                            }
                                                                                                                            catch (IOException v2) {
                                                                                                                                throw QuicClientStreamTransport.a(v2);
                                                                                                                            }
                                                                                                                            var20_45 = var7_10;
                                                                                                                            var9_13 = false;
                                                                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24029, -1442163210 - -31467, (int)var1_1) + Quiche.INSTANCE.getLibrary().quiche_conn_timeout_as_millis(this.connection) + QuicClientStreamTransport.b(1442163210 - (char)-24028, -1442163210 - -13652, (int)var1_1));
                                                                                                                        }
                                                                                                                        var7_9 = Quiche.INSTANCE.getLibrary().quiche_conn_timeout_as_nanos(this.connection);
                                                                                                                        v3 = var7_9;
                                                                                                                        if (var3_3) break block110;
                                                                                                                        try {
                                                                                                                            block147: {
                                                                                                                                if (v3 >= 0L) break block111;
                                                                                                                                break block147;
                                                                                                                                catch (IOException v4) {
                                                                                                                                    throw QuicClientStreamTransport.a(v4);
                                                                                                                                }
                                                                                                                            }
                                                                                                                            v3 = 1000000000L;
                                                                                                                            break block110;
                                                                                                                        }
                                                                                                                        catch (IOException v5) {
                                                                                                                            throw QuicClientStreamTransport.a(v5);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    v3 = var7_9;
                                                                                                                }
                                                                                                                var9_12 = v3;
                                                                                                                this.getWakeupQueue().poll(var9_12, TimeUnit.NANOSECONDS);
                                                                                                                if (var3_3) break block112;
                                                                                                                if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) ** GOTO lbl71
                                                                                                                break block148;
                                                                                                                catch (IOException v6) {
                                                                                                                    throw QuicClientStreamTransport.a(v6);
                                                                                                                }
                                                                                                            }
                                                                                                            v7 = O.u;
                                                                                                            if (var3_3) break block113;
                                                                                                            break block149;
                                                                                                            catch (IOException v8) {
                                                                                                                throw QuicClientStreamTransport.a(v8);
                                                                                                            }
                                                                                                        }
                                                                                                        try {
                                                                                                            block150: {
                                                                                                                if (v7.I(this.myConnectionState)) ** GOTO lbl80
                                                                                                                break block150;
                                                                                                                catch (IOException v9) {
                                                                                                                    throw QuicClientStreamTransport.a(v9);
                                                                                                                }
                                                                                                            }
                                                                                                            QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24027, -1442163210 - -24965, (int)var1_1) + this.myConnectionState.u() + QuicClientStreamTransport.b(1442163210 - (char)-24026, 1442163210 - (char)-27088, (int)var1_1) + RLifetimeKt.isAlive((Lifetime)this.lifetime));
                                                                                                        }
                                                                                                        catch (IOException v10) {
                                                                                                            throw QuicClientStreamTransport.a(v10);
                                                                                                        }
                                                                                                    }
                                                                                                    try {
                                                                                                        if (!var3_3) break;
lbl80:
                                                                                                        // 3 sources

                                                                                                        while (true) {
                                                                                                            v7 = this.socketReceivedDatagrams.poll();
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    catch (IOException v11) {
                                                                                                        throw QuicClientStreamTransport.a(v11);
                                                                                                    }
                                                                                                }
                                                                                                try {
                                                                                                    if (v7 != null) break block114;
                                                                                                    break block115;
                                                                                                }
                                                                                                catch (IOException v12) {
                                                                                                    throw QuicClientStreamTransport.a(v12);
                                                                                                }
                                                                                            }
                                                                                            var11_15 = v13;
                                                                                            var12_20 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                            var13_23 = false;
                                                                                            try {
                                                                                                if (var3_3 || !var12_20.isTraceEnabled()) break block116;
                                                                                            }
                                                                                            catch (IOException v14) {
                                                                                                throw QuicClientStreamTransport.a(v14);
                                                                                            }
                                                                                            var20_45 = var12_20;
                                                                                            var14_27 = false;
                                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24049, -1442163210 - -18615, (int)var1_1) + IPrintableKt.printToString((Object)var11_15.getFirst()) + QuicClientStreamTransport.b(1442163210 - (char)-24048, -1442163210 - -25088, (int)var1_1) + QuicheCommon.INSTANCE.toNativeSize(((byte[])var11_15.getSecond()).length));
                                                                                        }
                                                                                        var12_20 = new quiche_recv_info(this.peerSockAddr.getQuicheSockAddr(), this.peerSockAddr.size(), this.localSockAddress.getQuicheSockAddr(), this.localSockAddress.size());
                                                                                        var13_22 /* !! */  = Quiche.INSTANCE.getLibrary().quiche_conn_recv(this.connection, ByteBuffer.wrap((byte[])var11_15.getSecond()), QuicheCommon.INSTANCE.toNativeSize(((byte[])var11_15.getSecond()).length), (quiche_recv_info)var12_20);
                                                                                        var14_28 = var13_22 /* !! */ .longValue();
                                                                                        QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(1442163210 - (char)-24047, -1442163210 - -((char)-30783), (int)var1_1), var14_28);
                                                                                        if (!var3_3) ** continue;
                                                                                    }
                                                                                    try {
                                                                                        Quiche.INSTANCE.getLibrary().quiche_conn_on_timeout(this.connection);
                                                                                        v15 = Intrinsics.areEqual((Object)this.myConnectionState.u(), (Object)F.v);
                                                                                        if (var3_3) break block117;
                                                                                        if (!v15) break block118;
                                                                                    }
                                                                                    catch (IOException v16) {
                                                                                        throw QuicClientStreamTransport.a(v16);
                                                                                    }
                                                                                    var11_16 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_established(this.connection));
                                                                                    var12_20 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                    var13_24 = false;
                                                                                    try {
                                                                                        v15 = var12_20.isTraceEnabled();
                                                                                        if (var3_3) break block119;
                                                                                        if (!v15) break block120;
                                                                                    }
                                                                                    catch (IOException v17) {
                                                                                        throw QuicClientStreamTransport.a(v17);
                                                                                    }
                                                                                    var20_45 = var12_20;
                                                                                    var14_29 = false;
                                                                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24046, -1442163210 - -26474, (int)var1_1) + var11_16);
                                                                                }
                                                                                v15 = var11_16;
                                                                            }
                                                                            if (var3_3) break block117;
                                                                            try {
                                                                                block151: {
                                                                                    if (!v15) break block118;
                                                                                    break block151;
                                                                                    catch (IOException v18) {
                                                                                        throw QuicClientStreamTransport.a(v18);
                                                                                    }
                                                                                }
                                                                                this.myConnectionState.I(z.v);
                                                                            }
                                                                            catch (IOException v19) {
                                                                                throw QuicClientStreamTransport.a(v19);
                                                                            }
                                                                        }
                                                                        v15 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_closed(this.connection));
                                                                    }
                                                                    try {
                                                                        if (var3_3) break block121;
                                                                        if (v15) {
                                                                        }
                                                                        ** GOTO lbl195
                                                                    }
                                                                    catch (IOException v20) {
                                                                        throw QuicClientStreamTransport.a(v20);
                                                                    }
                                                                    var11_17 = this.myConnectionState.u();
                                                                    v15 = Intrinsics.areEqual((Object)var11_17, (Object)z.v);
                                                                    if (var3_3) break block122;
                                                                    if (!v15) ** GOTO lbl175
                                                                    break block152;
                                                                    catch (IOException v21) {
                                                                        throw QuicClientStreamTransport.a(v21);
                                                                    }
                                                                }
                                                                try {
                                                                    block153: {
                                                                        this.myConnectionState.I(X.v);
                                                                        if (!var3_3) break;
                                                                        break block153;
                                                                        catch (IOException v22) {
                                                                            throw QuicClientStreamTransport.a(v22);
                                                                        }
                                                                    }
                                                                    v15 = Intrinsics.areEqual((Object)var11_17, (Object)F.v);
                                                                }
                                                                catch (IOException v23) {
                                                                    throw QuicClientStreamTransport.a(v23);
                                                                }
                                                            }
                                                            if (var3_3) break block121;
                                                            if (!v15) ** GOTO lbl195
                                                            break block154;
                                                            catch (IOException v24) {
                                                                throw QuicClientStreamTransport.a(v24);
                                                            }
                                                        }
                                                        try {
                                                            block155: {
                                                                this.myConnectionState.I(new r(new QuicTimeoutException(QuicClientStreamTransport.b(1442163210 - (char)-24053, -1442163210 - -26845, (int)var1_1))));
                                                                if (!var3_3) break;
                                                                break block155;
                                                                catch (IOException v25) {
                                                                    throw QuicClientStreamTransport.a(v25);
                                                                }
                                                            }
                                                            v15 = O.u.u(this.myConnectionState);
                                                        }
                                                        catch (IOException v26) {
                                                            throw QuicClientStreamTransport.a(v26);
                                                        }
                                                    }
                                                    try {
                                                        if (var3_3) break block123;
                                                        if (!v15) break block124;
                                                    }
                                                    catch (IOException v27) {
                                                        throw QuicClientStreamTransport.a(v27);
                                                    }
                                                    var11_18 = Quiche.INSTANCE.getLibrary().quiche_conn_readable(this.connection);
                                                    try {
                                                        block125: {
                                                            block96: while (true) {
                                                                var12_20 = new LongByReference();
                                                                if (!QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_stream_iter_next(var11_18, (LongByReference)var12_20))) break block124;
                                                                var13_25 = Quiche.INSTANCE.getLibrary().quiche_conn_stream_recv(this.connection, var12_20.getValue(), var5_4, QuicheCommon.INSTANCE.toNativeSize(var5_4.capacity()), var6_8).longValue();
                                                                QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(1442163210 - (char)-24052, 1442163210 - (char)-27804, (int)var1_1), var13_25);
                                                                do {
                                                                    var15_33 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                    var16_38 = false;
                                                                    v28 = var15_33.isTraceEnabled();
                                                                    if (!var3_3) {
                                                                        if (v28) {
                                                                            var20_45 = var15_33;
                                                                            var17_40 = false;
                                                                            var21_46 = var13_25;
                                                                            var23_47 = var12_20.getValue();
                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24051, 1442163210 - 15893, (int)var1_1) + var23_47 + " " + var21_46 + QuicClientStreamTransport.b(1442163210 - (char)-24050, 1442163210 - 30100, (int)var1_1));
                                                                        }
                                                                        this.getReceivedQueue().add(Arrays.copyOf(var5_4.array(), (int)var13_25));
                                                                        v28 = QuicheCommon.INSTANCE.toBoolean(var6_8.get(0));
                                                                    }
                                                                    if (!v28) continue block96;
                                                                    QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24041, 1442163210 - 14148, (int)var1_1));
                                                                    var15_34 = Quiche.INSTANCE.getLibrary().quiche_conn_close(this.connection, QuicheCommon.INSTANCE.toByte(true), 0L, Pointer.NULL, QuicheCommon.INSTANCE.toNativeSize(0));
                                                                } while (var3_3);
                                                                break;
                                                            }
                                                            if (var3_3) break block124;
                                                            try {
                                                                block156: {
                                                                    if (var15_34 >= 0) break block125;
                                                                    break block156;
                                                                    catch (IOException v29) {
                                                                        throw QuicClientStreamTransport.a(v29);
                                                                    }
                                                                }
                                                                QuicClientStreamTransportKt.access$getLogger$p().warn(QuicClientStreamTransport.b(1442163210 - (char)-24040, 1442163210 - (char)-31224, (int)var1_1) + QuicheCommon.INSTANCE.getQuicheErrorName(var15_34));
                                                            }
                                                            catch (IOException v30) {
                                                                throw QuicClientStreamTransport.a(v30);
                                                            }
                                                        }
                                                        this.myConnectionState.I(X.v);
                                                    }
                                                    finally {
                                                        Quiche.INSTANCE.getLibrary().quiche_stream_iter_free(var11_18);
                                                    }
                                                }
                                                v15 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_established(this.connection));
                                            }
                                            var11_14 = v15;
                                            var12_19 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_in_early_data(this.connection));
                                            var13_22 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                            var14_30 = false;
                                            try {
                                                v31 = var13_22 /* !! */ .isTraceEnabled();
                                                if (var3_3) break block126;
                                                if (!v31) break block127;
                                            }
                                            catch (IOException v32) {
                                                throw QuicClientStreamTransport.a(v32);
                                            }
                                            var20_45 = var13_22 /* !! */ ;
                                            var15_35 = false;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24039, 1442163210 - (char)-32142, (int)var1_1) + var11_14 + QuicClientStreamTransport.b(1442163210 - (char)-24038, 1442163210 - (char)-24085, (int)var1_1) + var12_19);
                                        }
                                        try {
                                            if (var3_3) break block128;
                                            v31 = var11_14;
                                        }
                                        catch (IOException v33) {
                                            throw QuicClientStreamTransport.a(v33);
                                        }
                                    }
                                    if (v31) break block128;
                                    try {
                                        block157: {
                                            v34 = var12_19;
                                            if (var3_3) ** GOTO lbl381
                                            break block157;
                                            catch (IOException v35) {
                                                throw QuicClientStreamTransport.a(v35);
                                            }
                                        }
                                        if (!v34) break block129;
                                    }
                                    catch (IOException v36) {
                                        throw QuicClientStreamTransport.a(v36);
                                    }
                                }
                                while (true) {
                                    block136: {
                                        block137: {
                                            block134: {
                                                block135: {
                                                    block131: {
                                                        block132: {
                                                            block133: {
                                                                block130: {
                                                                    try {
                                                                        if (this.getToSendQueue().poll() != null) break block130;
                                                                        break block129;
                                                                    }
                                                                    catch (IOException v37) {
                                                                        throw QuicClientStreamTransport.a(v37);
                                                                    }
                                                                }
                                                                var13_22 /* !! */  = (Logger)v38;
                                                                var14_31 = Quiche.INSTANCE.getLibrary().quiche_conn_stream_send(this.connection, 4L, (byte[])var13_22 /* !! */ , QuicheCommon.INSTANCE.toNativeSize(((Logger)var13_22 /* !! */ ).length), QuicheCommon.INSTANCE.toByte(false));
                                                                var15_36 = var14_31.longValue();
                                                                try {
                                                                    v39 = QuicheCommon.INSTANCE.isQuicheErrDone(var15_36);
                                                                    if (var3_3) break block131;
                                                                    if (v39 != 0) {
                                                                    }
                                                                    ** GOTO lbl329
                                                                }
                                                                catch (IOException v40) {
                                                                    throw QuicClientStreamTransport.a(v40);
                                                                }
                                                                var17_41 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                var18_43 = 0;
                                                                try {
                                                                    if (var3_3) break block132;
                                                                    if (!var17_41.isTraceEnabled()) break block133;
                                                                }
                                                                catch (IOException v41) {
                                                                    throw QuicClientStreamTransport.a(v41);
                                                                }
                                                                var20_45 = var17_41;
                                                                var19_44 = false;
                                                                var20_45.trace(QuicClientStreamTransport.b(1442163210 - (char)-24045, -1442163210 - -18823, (int)var1_1) + ((Logger)var13_22 /* !! */ ).length + ")");
                                                            }
                                                            this.addToSendQueue((byte[])var13_22 /* !! */ );
                                                        }
                                                        try {
                                                            if (!var3_3) break block129;
lbl329:
                                                            // 2 sources

                                                            QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(1442163210 - (char)-24044, 1442163210 - 25948, (int)var1_1), var15_36);
                                                            cfr_temp_0 = var15_36 - (long)((Logger)var13_22 /* !! */ ).length;
                                                            v39 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                                                        }
                                                        catch (IOException v42) {
                                                            throw QuicClientStreamTransport.a(v42);
                                                        }
                                                    }
                                                    try {
                                                        if (var3_3) break block134;
                                                        if (v39 <= 0) break block135;
                                                    }
                                                    catch (IOException v43) {
                                                        throw QuicClientStreamTransport.a(v43);
                                                    }
                                                    var25_53 = ((Logger)var13_22 /* !! */ ).length;
                                                    var26_54 = var15_36;
                                                    throw new IOException(QuicClientStreamTransport.b(1442163210 - (char)-24043, 1442163210 - 28794, (int)var1_1) + var26_54 + QuicClientStreamTransport.b(1442163210 - (char)-24042, -1442163210 - -23105, (int)var1_1) + var25_53 + ")");
                                                }
                                                cfr_temp_1 = var15_36 - (long)((Logger)var13_22 /* !! */ ).length;
                                                v39 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                                            }
                                            if (v39 >= 0) continue;
                                            var17_41 = QuicClientStreamTransportKt.access$getLogger$p();
                                            var18_43 = 0;
                                            try {
                                                v44 = var17_41.isTraceEnabled();
                                                if (var3_3) break block136;
                                                if (!v44) break block137;
                                            }
                                            catch (IOException v45) {
                                                throw QuicClientStreamTransport.a(v45);
                                            }
                                            var20_45 = var17_41;
                                            var19_44 = false;
                                            var28_48 = ((Logger)var13_22 /* !! */ ).length;
                                            var29_49 = var15_36;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24001, 1442163210 - 13392, (int)var1_1) + var29_49 + QuicClientStreamTransport.b(1442163210 - (char)-24000, 1442163210 - 14309, (int)var1_1) + var28_48 + ")");
                                        }
                                        this.addToSendQueue(ArraysKt.copyOfRange((byte[])var13_22 /* !! */ , (int)((int)var15_36), (int)((Logger)var13_22 /* !! */ ).length));
                                        cfr_temp_2 = var15_36 - 0L;
                                        v44 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                                    }
                                    if (!v44) break;
                                }
                                if (!var3_3) {
                                }
                            }
                            while (true) {
                                block143: {
                                    block141: {
                                        block142: {
                                            block139: {
                                                block140: {
                                                    var5_4.rewind();
                                                    var13_22 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                                    var14_30 = false;
                                                    v34 = var13_22 /* !! */ .isTraceEnabled();
lbl381:
                                                    // 2 sources

                                                    if (v34) {
                                                        var20_45 = var13_22 /* !! */ ;
                                                        var15_37 = false;
                                                        try {
                                                            v46 = this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-23999, 1442163210 - 18753, (int)var1_1) + var5_4.capacity() + QuicClientStreamTransport.b(1442163210 - (char)-23998, 1442163210 - 31109, (int)var1_1) + IPrintableKt.printToString((Object)var5_4);
                                                            v0 = var20_45;
                                                            if (var3_3) break block138;
                                                            v0.trace(v46);
                                                        }
                                                        catch (IOException v47) {
                                                            throw QuicClientStreamTransport.a(v47);
                                                        }
                                                    }
                                                    var13_22 /* !! */  = new quiche_send_info((Pointer)var4_2);
                                                    var14_26 = Quiche.INSTANCE.getLibrary().quiche_conn_send(this.connection, var5_4, QuicheCommon.INSTANCE.toNativeSize(var5_4.capacity()), (quiche_send_info)var13_22 /* !! */ );
                                                    var15_32 = var14_26.longValue();
                                                    var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                                    var18_43 = 0;
                                                    try {
                                                        v48 = var17_39 /* !! */ .isTraceEnabled();
                                                        if (var3_3) break block139;
                                                        if (!v48) break block140;
                                                    }
                                                    catch (IOException v49) {
                                                        throw QuicClientStreamTransport.a(v49);
                                                    }
                                                    var20_45 = var17_39 /* !! */ ;
                                                    var19_44 = false;
                                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24005, -1442163210 - -23443, (int)var1_1) + var15_32 + QuicClientStreamTransport.b(1442163210 - (char)-24004, -1442163210 - -13362, (int)var1_1));
                                                }
                                                v48 = QuicheCommon.INSTANCE.isQuicheErrDone(var15_32);
                                            }
                                            if (var3_3) break block141;
                                            try {
                                                block158: {
                                                    if (!v48) break block142;
                                                    break block158;
                                                    catch (IOException v50) {
                                                        throw QuicClientStreamTransport.a(v50);
                                                    }
                                                }
                                                if (!var3_3) continue block94;
                                            }
                                            catch (IOException v51) {
                                                throw QuicClientStreamTransport.a(v51);
                                            }
                                        }
                                        QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(1442163210 - (char)-24003, 1442163210 - (char)-31373, (int)var1_1), var15_32);
                                        var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                        var18_43 = 0;
                                        v48 = var17_39 /* !! */ .isTraceEnabled();
                                    }
                                    try {
                                        if (!var3_3) {
                                            if (!v48) break block143;
                                        }
                                        ** GOTO lbl454
                                    }
                                    catch (IOException v52) {
                                        throw QuicClientStreamTransport.a(v52);
                                    }
                                    var20_45 = var17_39 /* !! */ ;
                                    var19_44 = false;
                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24002, -1442163210 - -27204, (int)var1_1) + var15_32 + QuicClientStreamTransport.b(1442163210 - (char)-23993, 1442163210 - 30900, (int)var1_1));
                                }
                                try {
                                    block144: {
                                        var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                        var18_43 = 0;
                                        try {
                                            if (var3_3) break block144;
                                            v48 = var17_39 /* !! */ .isTraceEnabled();
                                        }
                                        catch (IOException v53) {
                                            throw QuicClientStreamTransport.a(v53);
                                        }
lbl454:
                                        // 2 sources

                                        if (v48) {
                                            var20_45 = var17_39 /* !! */ ;
                                            var19_44 = false;
                                            var31_50 = IPrintableKt.printToString((Object)this.peer);
                                            var32_51 = IPrintableKt.printToString((Object)this.localSocket.getLocalAddress());
                                            var33_52 = var15_32;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-23992, 1442163210 - 24102, (int)var1_1) + var33_52 + QuicClientStreamTransport.b(1442163210 - (char)-23991, -1442163210 - -12730, (int)var1_1) + var32_51 + QuicClientStreamTransport.b(1442163210 - (char)-23990, 1442163210 - 14956, (int)var1_1) + var31_50);
                                        }
                                    }
                                    v54 = var5_4.array();
                                    Intrinsics.checkNotNullExpressionValue((Object)v54, (String)QuicClientStreamTransport.b(1442163210 - (char)-23997, -1442163210 - -26265, (int)var1_1));
                                    var17_39 /* !! */  = (Logger)v54;
                                    var18_43 = (int)var15_32;
                                    v55 = Arrays.copyOf((byte[])var17_39 /* !! */ , var18_43);
                                    Intrinsics.checkNotNullExpressionValue((Object)v55, (String)QuicClientStreamTransport.b(1442163210 - (char)-23996, 1442163210 - 21637, (int)var1_1));
                                    this.localSocket.send(v55, this.peer);
                                    continue;
                                }
                                catch (IOException var17_42) {
                                    QuicClientStreamTransportKt.access$getLogger$p().warn(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-23995, -1442163210 - -((char)-31252), (int)var1_1) + var17_42.getMessage(), (Throwable)var17_42);
                                    if (var3_3) break block94;
                                    continue;
                                }
                                break;
                            }
                        }
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                    }
                    catch (InterruptedException var5_5) {
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24017, 1442163210 - 17296, (int)var1_1));
                        break block145;
                    }
                    catch (Throwable var5_6) {
                        QuicClientStreamTransportKt.access$getLogger$p().warn(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24015, 1442163210 - 18361, (int)var1_1) + var5_6.getMessage(), var5_6);
                        this.myConnectionState.I(new r(var5_6));
                        {
                            catch (Throwable var5_7) {
                                throw var5_7;
                            }
                        }
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                        var4_2.clear();
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24016, 1442163210 - (char)-24434, (int)var1_1));
                        break block145;
                    }
                    finally {
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                        var4_2.clear();
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-24016, 1442163210 - (char)-24434, (int)var1_1));
                    }
                    var4_2.clear();
                    v0 = QuicClientStreamTransportKt.access$getLogger$p();
                }
                v46 = this.getName() + QuicClientStreamTransport.b(1442163210 - (char)-23994, 1442163210 - 20770, (int)var1_1);
            }
            v0.info(v46);
        }
    }

    private final void addToSendQueue(byte[] arr) {
        this.getToSendQueue().addFirst(arr);
        this.getWakeupQueue().add(true);
    }

    private static final Unit _init_$lambda$0(QuicClientStreamTransport this$0, Maybe previous, j current) {
        long l2 = 119055747035441L;
        Intrinsics.checkNotNullParameter((Object)previous, (String)QuicClientStreamTransport.b(746443650 - (char)-16520, -746443650 - -((char)-18218), (int)l2));
        Intrinsics.checkNotNullParameter((Object)current, (String)QuicClientStreamTransport.b(746443650 - (char)-16523, -746443650 - -((char)-27403), (int)l2));
        QuicClientStreamTransportKt.access$getLogger$p().info(this$0.u((j)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(QuicClientStreamTransport this$0, byte[] datagramBytes) {
        block2: {
            boolean bl;
            block3: {
                long l2 = 83117090570964L;
                Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)QuicClientStreamTransport.b(-883542870 - -((char)-3265), 883542870 - (char)-7222, (int)l2));
                Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
                boolean bl2 = QuicStreamTransport.I();
                boolean bl3 = false;
                try {
                    bl = logger.isTraceEnabled();
                    if (!bl2) break block2;
                    if (!bl) break block3;
                }
                catch (RuntimeException runtimeException) {
                    throw QuicClientStreamTransport.a(runtimeException);
                }
                Logger logger2 = logger;
                boolean bl4 = false;
                logger2.trace(this$0.getName() + QuicClientStreamTransport.b(-883542870 - -((char)-3264), -883542870 - -((char)-7385), (int)l2) + IPrintableKt.printToString((Object)this$0.peer) + QuicClientStreamTransport.b(-883542870 - -((char)-3263), -883411800 + -((char)-6193), (int)l2) + datagramBytes.length);
            }
            this$0.socketReceivedDatagrams.add((Pair<InetSocketAddress, byte[]>)TuplesKt.to((Object)this$0.peer, (Object)datagramBytes));
            bl = this$0.getWakeupQueue().add(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(QuicClientStreamTransport this$0, InetSocketAddress address, byte[] datagramBytes) {
        block2: {
            long l2 = 24431437991046L;
            Intrinsics.checkNotNullParameter((Object)address, (String)QuicClientStreamTransport.b(-1663933650 + -((char)-1672), -1664064720 - -((char)-16593), (int)l2));
            boolean bl = QuicStreamTransport.u();
            Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)QuicClientStreamTransport.b(-1663933650 + -((char)-1673), -1663933650 + -((char)-5953), (int)l2));
            boolean bl2 = bl;
            Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
            boolean bl3 = false;
            try {
                if (bl2 || !logger.isTraceEnabled()) break block2;
            }
            catch (RuntimeException runtimeException) {
                throw QuicClientStreamTransport.a(runtimeException);
            }
            Logger logger2 = logger;
            boolean bl4 = false;
            logger2.trace(this$0.getName() + QuicClientStreamTransport.b(-1663933650 + -((char)-1670), 1664064720 - (char)-22594, (int)l2) + IPrintableKt.printToString((Object)address) + QuicClientStreamTransport.b(-1663933650 + -((char)-1675), -1664064720 - -((char)-24741), (int)l2) + datagramBytes.length);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(QuicClientStreamTransport this$0) {
        this$0.quicThread();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Thread $quicThread, QuicClientStreamTransport this$0) {
        block2: {
            boolean bl;
            block3: {
                long l2 = 131056980227192L;
                Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
                boolean bl2 = false;
                boolean bl3 = QuicStreamTransport.I();
                try {
                    bl = logger.isTraceEnabled();
                    if (!bl3) break block2;
                    if (!bl) break block3;
                }
                catch (RuntimeException runtimeException) {
                    throw QuicClientStreamTransport.a(runtimeException);
                }
                Logger logger2 = logger;
                boolean bl4 = false;
                logger2.trace(this$0.getName() + QuicClientStreamTransport.b(-348121920 + -17269, 348121920 + 20704, (int)l2));
            }
            ThreadUtil.INSTANCE.gracefullyJoinThread($quicThread);
            bl = this$0.myConnectionState.u(X.v);
        }
        return Unit.INSTANCE;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[60];
                var3_1 = 0;
                var2_2 = "\u009de\u00a6\u00bd\u00a7$O\u00c4\u000bi\u00f2=\u008di\u009c\u008f\u00a8U\u00ed\u00e8\u0004\u0094\u0085\u001b;\b\u00e3Y\u00f8\u00ed\u00e1\u0015\u00fa\u00eb\u000b\u00cd\u00b5\u0003\u000bx\u00f2\u0090\u001e\u00f0\u00ed\u00d8\u001b\u00de\u00b5{:\u0082\u001c4\u00a0O\u00acd\u00bb\u0011\r\u00fc\u00be34\u00b9\u00b9\u00edJ\"\u0096=\u0001\\\u0015`k\u00ce\u0005\u00fc\u00aa\u00e6\u00a0\u00b2\u0005\u00bc|\u0096\u001f\u00f3\u00f1\u00a0\u0086\u00b9\u00be\u00b6\u0010\u0091Y\u0092\u00a7\u00bf\u008f\u0090\u00f1\u00b3j\u0086]\u00cc\t\u00b3\u00b6\u0005\u0006\u00c4\u001a\u00c5Q\bv\u009cM)\u00d1X\u00f2e\u0013\u00f0h\u00ba\u0085\u00d6\u00e9\u00cc\u00f6\u000f-=\u00ceTH\u00cc\u0090\b\u00e7n\u0013S\u00f7\u00b4b;\"\u00e6H\u0016\u00cf\u0015X9ob5\u00f4u\u00fc\u001b\u0088*\u00ee\u00e7\\*,E\u0017\u0083\u00a1RvT\u0013\u00ef\u009e\u00ac\u00c7\u00cbG=\u000e\u008d\u0003\u00d9\u00ad\u0003\u001d\u00f6f:\u00d5\u001ad\u00df!\u0095\u00a5\u00bee\u0004\u0014\u0089\u00e4\u00b3\u00d8\u00ec\u00ad9;\u0099\u00e0\u00ed\u0010\u0083\u0096\u0088O\u0018_j\u00ed^\u0093\u0017\u000f\u000eW\u00ee\u0091\u00aa\u00e02\u001c\u00e7\u00d7\f\u00ea\u00d4\u00e4\u00d1sx\u000e\u00de|\u00df._\u0016P\u00a1\u00ce\u00a6$\u00aa/\u0015v\u0090i\u009e\u00fe_\u00e9\u00a3\u00deD\u00e1\u009a\u0092\u00db\u001fV\u00ed\u0013\u00d7&\u00a3\u009a\u00fc\u0096L\u00bd\u0088\u00e2\u0082\u001c\u00d6\u00f8\u0093\u00f7\u00dd\u00feG\u00ad\u0090\u00d4\u00d2\u000f E\u0018\u0098\t\u009c\u00f5C,\u001c\u00fb\u00c8?A\u0010H\u00bd\u00ad?4\u00be\u0090\u001c\u0084pL_k\u0016S0\u0019!\u0012\u00c7@\u00e9{yE'\u00d6\u0012\u00b7\u00cc\u00bcm\u00f0\u009d\u00feN\u0090kK\u00a9\u001a87!\u00d0(\u00eb\u0089\u0005\u00dc|\u009d\u00c7b\u001e\u001e\u0003d\u00ed\u00a3\u00a2W,\u001c7\u00bfF{%\u0007\u00c9\u009a\u00cf(\u0091\u00f9\u009b\u00a1@Z\u0019\u0084\u00c2<1F+r\u00d8\"\u0095%D\u00c8\u00b5\u0095\u00edt\u0017\u00fdn\u001bE\u00e2\u00f1J\u00f5\u00dfM'\u00f8\u0007\u00f3\u00ee\u00ac\u0012\u0001\u00fd\u00a1B\n\u00ba\u001a\r\u00eer\u0096O\u0087z\u00b0\u00demeVZ\u00b7\u0088\u001a\u00d7N\t\u00f7]\u00f0y\u00d1\u00bb\u00fa\u0006q\u0014\u00e1\u00e8\u00a2\u00a7-\u0000\u00f2\u00c6w+\u00d0\u0019\u0014\u00f1M\u00aai\u00c5I\u00b9\u00f6B\u0097\u0000\t\u00e6\b\u00f1\u0001\u00e5\u00fe\u00acp\u001a\tl\u00db\u00a8i%\u00e6\u00a2/\u0088\u008e\u00e2@[\u00d0\u00d3\u0019\u00a3n\u00d0E\u009b\u00f1e\u00f5:M\u009b\u00f8\u0080\u00eb\u0011\u00a2WY\u00ebN\u00ea\u00fb^U\u00e7 M\u0004j\u00a2XKMMNp\u0098O\u00e6\u0005\u0000\u008b\u0007k\u00ef\u0098\u0086\u00cf\u00e1\u00f3-\u0094\u0004\u0092\u0099\u001eR;&?C\u008d\t\u000e\u00aa\u00c1^0\u00f3}\u00b2p\u00bc\u00afg\u0001I\u00a7\u00b8\u0012!k\u00c2\u0017\u0091\u0017[8\u0007\u00d0\u0011\u0085T\u0000\u00c7\u008d\u0007-\u00ff\\\u007f\u0003n9\u00a4\u00fc\u009cy\u008a\u00e6\u00ee\u00bb:\u00ddIc|)\u00f30\u00a5\u00bcE\u00b3\u00deI\u0092\u00fck\u00f2\u009a^\u00f6C\u00fa\u00b1\u00b5j\u00c4\u0012T\u008c\u00d8\u0017\u00b9|\u0093\u0007\u00f3\u00b9h\u00fc\u009bl\u00af\u00dc\u0016w\u00cc<V\u0013u\u00e2SN\u008aU\u00b2\u009ac6\u00f9\u00d6\u0090D\u0014\u00c0C\u00f4(\u001f\u00e7+%\u00e7\u00ee\u00d3LW_s\u00b6\u0012\u00a4#I\u0013\u0013\u00ef\u00b7P=\u00a3S\u00a72\u00ffy%\u0017w\u0099E\u00df\u00e8j\u00ff\u0089 f\u0088\u00ea\u0092j\u00da\u008e\u00c9\u00cd[\u00a3\u00b2\u0015\u00ae\u00a8\u00d2\u00fd\u00172S\u0004\u009aB\u00ff9:xf\u00ee\u0012C\u00ed\u00c9\u001e\u0005\u00e8\u001f4k]\u0000\u0087\u00f1X\u00a6\u001b\u009f\u00d1{\u00fd\u00a0\u00d5\u008a\u0000\u0094\b\u0094IS\u00c5*9\u00a7\u00aaA\u0001\u00d5\u00f7\u00a2j2\u00fa\u000f\u007f\u00e1\u009e\u00e2M\u00ec\u0001(\u00c5tY\u001b\u000b\u00f4u\u0092wd\u009c\u00d3O\u00b4\u00f2\u00eb\u0094o\u00ab#n3\u00aci\u0017P\u00b5\u00ff\b\u00a5\u0096-%\u00a5\u0005\u00da@6Tu\u00b6GVk\u00b6-WGg\u001e6\u00e3yU\u00a7q\u0099\u0002\u00c2\u00e8\u00c0\rS\u0013\u00e2\u00a5\u0093\u00de\u00ecaX$\r\u00cc`uL/kh+\u00ecACV\u00c3[{]s+\u00e6\u00e4\u0085\u00f5{\u00b8\u009c\u00cb\u00f8\u008a\u008eV\tr\u00bd`<a\u00b1\u00cc'#\u0018\u001f\u0092M\u00c7\u00d2\u0087\u00ba\u00a4Z\u00e0\bE\rg\u00cbr\u00c3\u0091$#\u0096|\u000bdn4\u00b0\u00d1\u00e3\u0084&\u0007]\u0017\u00abC\u001b\u0088\u001fQb\u00c8\u0099\u00ce\u001eR\u009e\u0007\u009a\u0006{\u00bd\u00a5\u00a5\u008d\u0006TSE\u00006\u00ba\u0010\u0087\u0097Tz\u000b\u0016w\tx\u00d2\u00d3\u000b\u0099\u009c!s\t\u0095IaN,0/D+\u0014\u00a8\u00ee\u00da\u00b7\u00c5L}\u0081\u00a9x\u00d2\u00c2\u00c6\u0098\u0090\u0015\u00fe{\u0018.\ts\u0004\u00bd\u00e7\u00b7\u0005\\\u00e2E\b\u00046O\u00acw/1\u00b9\u0004\u00a5^<S\n\u0081\n\u009d,[\u00d3?\u0018oS\u000b\u0087:\u001d\u008c?\u0092E\u00b7\u00e6\u00a1.\u001c\\\u00a1Rz\u000e\u0016\u009fD7\u0094\u00a5\u0092\u0004\u00df\u00ea\u0099%\u00c0U\u0081\u0094.b@\u00e9\u008f\u00b6^\u0010W\u00ea4\u00c1+V\u00e4\u00c6_\u0007\u001f`\u0000\f\u0019\u00cd\u001d\u00e8\u00cf\u00c3e\u00d5\u00c2;T\u00b0Yy*z\u00d6\u000fK\u009a\u00d0\u00b4Dp\u00a3s \u00d6\u0012\u00a0\"\u00da\u0010\u00a7\u00f9*\u00a3\u00e8\u001a\u009cOP6\u00feF<\u00c8\u009eU\u0013<\u009cY\u000f\u0086\u008fQ\u00fd\u00eaq\u00c7\u0091\u00b4\u00a3\u00e0\u00ac\u00a4\u001d\u00ba\b\u00e1\u00d6\u00b5\u00a0\u00bb\u00f0j\u008e\u0007HN\u00e6P(k\u0094\r\u00fd+\u00b1y\u0006#\u0006T\u0082\u00a1\u001e\u00aay\u0016H\u008c\u00da\u00daZ\u000e\u00d8\u0081\u008aK\u00f9\u0081\u0011:)x^\u00a30\u0082{\u0093\tI\u00e1\u00f9\u00aeK\u00ab\"5\u001c\u0007C\u007f\u00d3EZ\u00d4\u00dd\r\u00fe\u00ea\u00d1A\n$\u0087\u00b4\u00b2\u00bd\u0018)\u00b9";
                var4_3 = "\u009de\u00a6\u00bd\u00a7$O\u00c4\u000bi\u00f2=\u008di\u009c\u008f\u00a8U\u00ed\u00e8\u0004\u0094\u0085\u001b;\b\u00e3Y\u00f8\u00ed\u00e1\u0015\u00fa\u00eb\u000b\u00cd\u00b5\u0003\u000bx\u00f2\u0090\u001e\u00f0\u00ed\u00d8\u001b\u00de\u00b5{:\u0082\u001c4\u00a0O\u00acd\u00bb\u0011\r\u00fc\u00be34\u00b9\u00b9\u00edJ\"\u0096=\u0001\\\u0015`k\u00ce\u0005\u00fc\u00aa\u00e6\u00a0\u00b2\u0005\u00bc|\u0096\u001f\u00f3\u00f1\u00a0\u0086\u00b9\u00be\u00b6\u0010\u0091Y\u0092\u00a7\u00bf\u008f\u0090\u00f1\u00b3j\u0086]\u00cc\t\u00b3\u00b6\u0005\u0006\u00c4\u001a\u00c5Q\bv\u009cM)\u00d1X\u00f2e\u0013\u00f0h\u00ba\u0085\u00d6\u00e9\u00cc\u00f6\u000f-=\u00ceTH\u00cc\u0090\b\u00e7n\u0013S\u00f7\u00b4b;\"\u00e6H\u0016\u00cf\u0015X9ob5\u00f4u\u00fc\u001b\u0088*\u00ee\u00e7\\*,E\u0017\u0083\u00a1RvT\u0013\u00ef\u009e\u00ac\u00c7\u00cbG=\u000e\u008d\u0003\u00d9\u00ad\u0003\u001d\u00f6f:\u00d5\u001ad\u00df!\u0095\u00a5\u00bee\u0004\u0014\u0089\u00e4\u00b3\u00d8\u00ec\u00ad9;\u0099\u00e0\u00ed\u0010\u0083\u0096\u0088O\u0018_j\u00ed^\u0093\u0017\u000f\u000eW\u00ee\u0091\u00aa\u00e02\u001c\u00e7\u00d7\f\u00ea\u00d4\u00e4\u00d1sx\u000e\u00de|\u00df._\u0016P\u00a1\u00ce\u00a6$\u00aa/\u0015v\u0090i\u009e\u00fe_\u00e9\u00a3\u00deD\u00e1\u009a\u0092\u00db\u001fV\u00ed\u0013\u00d7&\u00a3\u009a\u00fc\u0096L\u00bd\u0088\u00e2\u0082\u001c\u00d6\u00f8\u0093\u00f7\u00dd\u00feG\u00ad\u0090\u00d4\u00d2\u000f E\u0018\u0098\t\u009c\u00f5C,\u001c\u00fb\u00c8?A\u0010H\u00bd\u00ad?4\u00be\u0090\u001c\u0084pL_k\u0016S0\u0019!\u0012\u00c7@\u00e9{yE'\u00d6\u0012\u00b7\u00cc\u00bcm\u00f0\u009d\u00feN\u0090kK\u00a9\u001a87!\u00d0(\u00eb\u0089\u0005\u00dc|\u009d\u00c7b\u001e\u001e\u0003d\u00ed\u00a3\u00a2W,\u001c7\u00bfF{%\u0007\u00c9\u009a\u00cf(\u0091\u00f9\u009b\u00a1@Z\u0019\u0084\u00c2<1F+r\u00d8\"\u0095%D\u00c8\u00b5\u0095\u00edt\u0017\u00fdn\u001bE\u00e2\u00f1J\u00f5\u00dfM'\u00f8\u0007\u00f3\u00ee\u00ac\u0012\u0001\u00fd\u00a1B\n\u00ba\u001a\r\u00eer\u0096O\u0087z\u00b0\u00demeVZ\u00b7\u0088\u001a\u00d7N\t\u00f7]\u00f0y\u00d1\u00bb\u00fa\u0006q\u0014\u00e1\u00e8\u00a2\u00a7-\u0000\u00f2\u00c6w+\u00d0\u0019\u0014\u00f1M\u00aai\u00c5I\u00b9\u00f6B\u0097\u0000\t\u00e6\b\u00f1\u0001\u00e5\u00fe\u00acp\u001a\tl\u00db\u00a8i%\u00e6\u00a2/\u0088\u008e\u00e2@[\u00d0\u00d3\u0019\u00a3n\u00d0E\u009b\u00f1e\u00f5:M\u009b\u00f8\u0080\u00eb\u0011\u00a2WY\u00ebN\u00ea\u00fb^U\u00e7 M\u0004j\u00a2XKMMNp\u0098O\u00e6\u0005\u0000\u008b\u0007k\u00ef\u0098\u0086\u00cf\u00e1\u00f3-\u0094\u0004\u0092\u0099\u001eR;&?C\u008d\t\u000e\u00aa\u00c1^0\u00f3}\u00b2p\u00bc\u00afg\u0001I\u00a7\u00b8\u0012!k\u00c2\u0017\u0091\u0017[8\u0007\u00d0\u0011\u0085T\u0000\u00c7\u008d\u0007-\u00ff\\\u007f\u0003n9\u00a4\u00fc\u009cy\u008a\u00e6\u00ee\u00bb:\u00ddIc|)\u00f30\u00a5\u00bcE\u00b3\u00deI\u0092\u00fck\u00f2\u009a^\u00f6C\u00fa\u00b1\u00b5j\u00c4\u0012T\u008c\u00d8\u0017\u00b9|\u0093\u0007\u00f3\u00b9h\u00fc\u009bl\u00af\u00dc\u0016w\u00cc<V\u0013u\u00e2SN\u008aU\u00b2\u009ac6\u00f9\u00d6\u0090D\u0014\u00c0C\u00f4(\u001f\u00e7+%\u00e7\u00ee\u00d3LW_s\u00b6\u0012\u00a4#I\u0013\u0013\u00ef\u00b7P=\u00a3S\u00a72\u00ffy%\u0017w\u0099E\u00df\u00e8j\u00ff\u0089 f\u0088\u00ea\u0092j\u00da\u008e\u00c9\u00cd[\u00a3\u00b2\u0015\u00ae\u00a8\u00d2\u00fd\u00172S\u0004\u009aB\u00ff9:xf\u00ee\u0012C\u00ed\u00c9\u001e\u0005\u00e8\u001f4k]\u0000\u0087\u00f1X\u00a6\u001b\u009f\u00d1{\u00fd\u00a0\u00d5\u008a\u0000\u0094\b\u0094IS\u00c5*9\u00a7\u00aaA\u0001\u00d5\u00f7\u00a2j2\u00fa\u000f\u007f\u00e1\u009e\u00e2M\u00ec\u0001(\u00c5tY\u001b\u000b\u00f4u\u0092wd\u009c\u00d3O\u00b4\u00f2\u00eb\u0094o\u00ab#n3\u00aci\u0017P\u00b5\u00ff\b\u00a5\u0096-%\u00a5\u0005\u00da@6Tu\u00b6GVk\u00b6-WGg\u001e6\u00e3yU\u00a7q\u0099\u0002\u00c2\u00e8\u00c0\rS\u0013\u00e2\u00a5\u0093\u00de\u00ecaX$\r\u00cc`uL/kh+\u00ecACV\u00c3[{]s+\u00e6\u00e4\u0085\u00f5{\u00b8\u009c\u00cb\u00f8\u008a\u008eV\tr\u00bd`<a\u00b1\u00cc'#\u0018\u001f\u0092M\u00c7\u00d2\u0087\u00ba\u00a4Z\u00e0\bE\rg\u00cbr\u00c3\u0091$#\u0096|\u000bdn4\u00b0\u00d1\u00e3\u0084&\u0007]\u0017\u00abC\u001b\u0088\u001fQb\u00c8\u0099\u00ce\u001eR\u009e\u0007\u009a\u0006{\u00bd\u00a5\u00a5\u008d\u0006TSE\u00006\u00ba\u0010\u0087\u0097Tz\u000b\u0016w\tx\u00d2\u00d3\u000b\u0099\u009c!s\t\u0095IaN,0/D+\u0014\u00a8\u00ee\u00da\u00b7\u00c5L}\u0081\u00a9x\u00d2\u00c2\u00c6\u0098\u0090\u0015\u00fe{\u0018.\ts\u0004\u00bd\u00e7\u00b7\u0005\\\u00e2E\b\u00046O\u00acw/1\u00b9\u0004\u00a5^<S\n\u0081\n\u009d,[\u00d3?\u0018oS\u000b\u0087:\u001d\u008c?\u0092E\u00b7\u00e6\u00a1.\u001c\\\u00a1Rz\u000e\u0016\u009fD7\u0094\u00a5\u0092\u0004\u00df\u00ea\u0099%\u00c0U\u0081\u0094.b@\u00e9\u008f\u00b6^\u0010W\u00ea4\u00c1+V\u00e4\u00c6_\u0007\u001f`\u0000\f\u0019\u00cd\u001d\u00e8\u00cf\u00c3e\u00d5\u00c2;T\u00b0Yy*z\u00d6\u000fK\u009a\u00d0\u00b4Dp\u00a3s \u00d6\u0012\u00a0\"\u00da\u0010\u00a7\u00f9*\u00a3\u00e8\u001a\u009cOP6\u00feF<\u00c8\u009eU\u0013<\u009cY\u000f\u0086\u008fQ\u00fd\u00eaq\u00c7\u0091\u00b4\u00a3\u00e0\u00ac\u00a4\u001d\u00ba\b\u00e1\u00d6\u00b5\u00a0\u00bb\u00f0j\u008e\u0007HN\u00e6P(k\u0094\r\u00fd+\u00b1y\u0006#\u0006T\u0082\u00a1\u001e\u00aay\u0016H\u008c\u00da\u00daZ\u000e\u00d8\u0081\u008aK\u00f9\u0081\u0011:)x^\u00a30\u0082{\u0093\tI\u00e1\u00f9\u00aeK\u00ab\"5\u001c\u0007C\u007f\u00d3EZ\u00d4\u00dd\r\u00fe\u00ea\u00d1A\n$\u0087\u00b4\u00b2\u00bd\u0018)\u00b9".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 122;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ad\u0092\u00d8\u00a7\u00a4\u001f\u00b9\u001d\u0018f\u0017\u009e>\u00e9\u00b1\u00ed7\u00fe\u00d6\u00d1\u00b3\u00a0\u0098\u001e\u00f7\u00a2\u00c9\u001c\u009d&Z\u001b\u00fa4\u00f3\u0089\u001f\u001c\u00d1\u00d0\bR\u00d3\u0086U\u00861/\u0086W\u00b7\u00c3\f\"R\u0013\u001d\u001b\u0083U*\u0010\u0004\u0016d\u00f3\u00de_\u00eda\u00e0%E\u009f\u00ff\u00f9Q\u00fe\u00ba\u0011\u001b\u00e3y\u00a3\u0081\u00f5";
                    var4_3 = "\u00ad\u0092\u00d8\u00a7\u00a4\u001f\u00b9\u001d\u0018f\u0017\u009e>\u00e9\u00b1\u00ed7\u00fe\u00d6\u00d1\u00b3\u00a0\u0098\u001e\u00f7\u00a2\u00c9\u001c\u009d&Z\u001b\u00fa4\u00f3\u0089\u001f\u001c\u00d1\u00d0\bR\u00d3\u0086U\u00861/\u0086W\u00b7\u00c3\f\"R\u0013\u001d\u001b\u0083U*\u0010\u0004\u0016d\u00f3\u00de_\u00eda\u00e0%E\u009f\u00ff\u00f9Q\u00fe\u00ba\u0011\u001b\u00e3y\u00a3\u0081\u00f5".length();
                    var1_4 = 33;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 103;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 29;
                            break;
                        }
                        case 1: {
                            v15 = 59;
                            break;
                        }
                        case 2: {
                            v15 = 4;
                            break;
                        }
                        case 3: {
                            v15 = 98;
                            break;
                        }
                        case 4: {
                            v15 = 24;
                            break;
                        }
                        case 5: {
                            v15 = 74;
                            break;
                        }
                        default: {
                            v15 = 26;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        QuicClientStreamTransport.c = var5;
        QuicClientStreamTransport.d = new String[60];
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFA508) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 244;
                case 1 -> 11;
                case 2 -> 36;
                case 3 -> 12;
                case 4 -> 172;
                case 5 -> 180;
                case 6 -> 120;
                case 7 -> 201;
                case 8 -> 206;
                case 9 -> 146;
                case 10 -> 73;
                case 11 -> 117;
                case 12 -> 219;
                case 13 -> 233;
                case 14 -> 179;
                case 15 -> 216;
                case 16 -> 130;
                case 17 -> 142;
                case 18 -> 93;
                case 19 -> 48;
                case 20 -> 211;
                case 21 -> 4;
                case 22 -> 95;
                case 23 -> 103;
                case 24 -> 149;
                case 25 -> 195;
                case 26 -> 139;
                case 27 -> 123;
                case 28 -> 194;
                case 29 -> 224;
                case 30 -> 18;
                case 31 -> 225;
                case 32 -> 42;
                case 33 -> 210;
                case 34 -> 100;
                case 35 -> 164;
                case 36 -> 148;
                case 37 -> 214;
                case 38 -> 28;
                case 39 -> 125;
                case 40 -> 119;
                case 41 -> 26;
                case 42 -> 113;
                case 43 -> 49;
                case 44 -> 199;
                case 45 -> 27;
                case 46 -> 255;
                case 47 -> 246;
                case 48 -> 251;
                case 49 -> 61;
                case 50 -> 243;
                case 51 -> 184;
                case 52 -> 189;
                case 53 -> 218;
                case 54 -> 183;
                case 55 -> 34;
                case 56 -> 237;
                case 57 -> 252;
                case 58 -> 163;
                case 59 -> 230;
                case 60 -> 112;
                case 61 -> 24;
                case 62 -> 205;
                case 63 -> 89;
                case 64 -> 159;
                case 65 -> 56;
                case 66 -> 25;
                case 67 -> 104;
                case 68 -> 2;
                case 69 -> 3;
                case 70 -> 29;
                case 71 -> 0;
                case 72 -> 97;
                case 73 -> 41;
                case 74 -> 8;
                case 75 -> 30;
                case 76 -> 46;
                case 77 -> 107;
                case 78 -> 215;
                case 79 -> 192;
                case 80 -> 135;
                case 81 -> 78;
                case 82 -> 231;
                case 83 -> 96;
                case 84 -> 132;
                case 85 -> 82;
                case 86 -> 240;
                case 87 -> 68;
                case 88 -> 136;
                case 89 -> 193;
                case 90 -> 1;
                case 91 -> 55;
                case 92 -> 23;
                case 93 -> 35;
                case 94 -> 109;
                case 95 -> 156;
                case 96 -> 174;
                case 97 -> 60;
                case 98 -> 137;
                case 99 -> 16;
                case 100 -> 10;
                case 101 -> 43;
                case 102 -> 19;
                case 103 -> 222;
                case 104 -> 37;
                case 105 -> 134;
                case 106 -> 204;
                case 107 -> 76;
                case 108 -> 98;
                case 109 -> 32;
                case 110 -> 162;
                case 111 -> 154;
                case 112 -> 67;
                case 113 -> 72;
                case 114 -> 190;
                case 115 -> 83;
                case 116 -> 33;
                case 117 -> 108;
                case 118 -> 254;
                case 119 -> 114;
                case 120 -> 77;
                case 121 -> 152;
                case 122 -> 79;
                case 123 -> 94;
                case 124 -> 141;
                case 125 -> 209;
                case 126 -> 161;
                case 127 -> 241;
                case 128 -> 64;
                case 129 -> 115;
                case 130 -> 245;
                case 131 -> 128;
                case 132 -> 116;
                case 133 -> 126;
                case 134 -> 111;
                case 135 -> 74;
                case 136 -> 39;
                case 137 -> 175;
                case 138 -> 167;
                case 139 -> 127;
                case 140 -> 47;
                case 141 -> 14;
                case 142 -> 52;
                case 143 -> 234;
                case 144 -> 87;
                case 145 -> 208;
                case 146 -> 145;
                case 147 -> 226;
                case 148 -> 85;
                case 149 -> 15;
                case 150 -> 176;
                case 151 -> 70;
                case 152 -> 213;
                case 153 -> 236;
                case 154 -> 90;
                case 155 -> 71;
                case 156 -> 160;
                case 157 -> 110;
                case 158 -> 81;
                case 159 -> 203;
                case 160 -> 86;
                case 161 -> 186;
                case 162 -> 249;
                case 163 -> 181;
                case 164 -> 118;
                case 165 -> 212;
                case 166 -> 92;
                case 167 -> 17;
                case 168 -> 187;
                case 169 -> 124;
                case 170 -> 21;
                case 171 -> 122;
                case 172 -> 185;
                case 173 -> 178;
                case 174 -> 59;
                case 175 -> 177;
                case 176 -> 247;
                case 177 -> 150;
                case 178 -> 6;
                case 179 -> 5;
                case 180 -> 99;
                case 181 -> 129;
                case 182 -> 188;
                case 183 -> 102;
                case 184 -> 121;
                case 185 -> 84;
                case 186 -> 220;
                case 187 -> 63;
                case 188 -> 182;
                case 189 -> 165;
                case 190 -> 105;
                case 191 -> 147;
                case 192 -> 191;
                case 193 -> 20;
                case 194 -> 155;
                case 195 -> 144;
                case 196 -> 44;
                case 197 -> 202;
                case 198 -> 53;
                case 199 -> 57;
                case 200 -> 131;
                case 201 -> 253;
                case 202 -> 250;
                case 203 -> 38;
                case 204 -> 223;
                case 205 -> 168;
                case 206 -> 196;
                case 207 -> 198;
                case 208 -> 238;
                case 209 -> 13;
                case 210 -> 40;
                case 211 -> 31;
                case 212 -> 235;
                case 213 -> 242;
                case 214 -> 50;
                case 215 -> 157;
                case 216 -> 91;
                case 217 -> 66;
                case 218 -> 9;
                case 219 -> 101;
                case 220 -> 106;
                case 221 -> 45;
                case 222 -> 158;
                case 223 -> 221;
                case 224 -> 227;
                case 225 -> 143;
                case 226 -> 228;
                case 227 -> 173;
                case 228 -> 54;
                case 229 -> 171;
                case 230 -> 229;
                case 231 -> 69;
                case 232 -> 88;
                case 233 -> 133;
                case 234 -> 151;
                case 235 -> 248;
                case 236 -> 217;
                case 237 -> 166;
                case 238 -> 80;
                case 239 -> 51;
                case 240 -> 239;
                case 241 -> 153;
                case 242 -> 7;
                case 243 -> 197;
                case 244 -> 65;
                case 245 -> 232;
                case 246 -> 169;
                case 247 -> 22;
                case 248 -> 62;
                case 249 -> 140;
                case 250 -> 200;
                case 251 -> 58;
                case 252 -> 138;
                case 253 -> 207;
                case 254 -> 170;
                default -> 75;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            QuicClientStreamTransport.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }
}

