/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiElement;

public final class CountingNodeIterator
extends NodeIterator {
    private int index;
    private final int max;
    private final NodeIterator delegate;

    public CountingNodeIterator(int _max, NodeIterator _iterator) {
        this.max = _max;
        this.delegate = _iterator;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.max && this.delegate.hasNext();
    }

    @Override
    public PsiElement current() {
        if (this.index < this.max) {
            return this.delegate.current();
        }
        return null;
    }

    @Override
    public void advance() {
        ++this.index;
        this.delegate.advance();
    }

    @Override
    public void rewind() {
        if (this.index > 0) {
            --this.index;
            this.delegate.rewind();
        }
    }

    @Override
    public void reset() {
        this.index = 0;
        this.delegate.reset();
    }
}

