/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.thirdparty.CapitalizationStrategy;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessorsInfo {
    public static final AccessorsInfo DEFAULT = new AccessorsInfo(false, false, false, false, CapitalizationStrategy.defaultValue(), new String[0]);
    private static final String CHAIN_VALUE = "chain";
    private static final String FLUENT_VALUE = "fluent";
    private static final String MAKE_FINAL_VALUE = "makeFinal";
    private static final String PREFIX_VALUE = "prefix";
    private final boolean fluent;
    private final boolean chain;
    private final boolean makeFinal;
    private final CapitalizationStrategy capitalizationStrategy;
    private final boolean doNotUseIsPrefix;
    private final String[] prefixes;

    private AccessorsInfo(boolean fluentValue, boolean chainValue, boolean makeFinal, boolean doNotUseIsPrefix, CapitalizationStrategy capitalizationStrategy, String ... prefixes) {
        this.fluent = fluentValue;
        this.chain = chainValue;
        this.makeFinal = makeFinal;
        this.doNotUseIsPrefix = doNotUseIsPrefix;
        this.capitalizationStrategy = capitalizationStrategy;
        this.prefixes = null == prefixes ? ArrayUtil.EMPTY_STRING_ARRAY : prefixes;
    }

    @NotNull
    public static AccessorsInfo build(boolean fluentValue, boolean chainValue, boolean makeFinal, boolean doNotUseIsPrefix, CapitalizationStrategy capitalizationStrategy, String ... prefixes) {
        return new AccessorsInfo(fluentValue, chainValue, makeFinal, doNotUseIsPrefix, capitalizationStrategy, prefixes);
    }

    @NotNull
    private static AccessorsInfo buildAccessorsInfo(@Nullable PsiClass psiClass, @Nullable Boolean chainDeclaredValue, @Nullable Boolean fluentDeclaredValue, @Nullable Boolean makeFinalDeclaredValue, @NotNull Collection<String> prefixDeclared) {
        CapitalizationStrategy capitalizationStrategy;
        boolean doNotUseIsPrefix;
        String[] prefixes;
        boolean makeFinal;
        boolean isChained;
        boolean isFluent;
        if (prefixDeclared == null) {
            AccessorsInfo.$$$reportNull$$$0(0);
        }
        if (null != psiClass) {
            ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
            isFluent = null == fluentDeclaredValue ? configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ACCESSORS_FLUENT, psiClass) : fluentDeclaredValue.booleanValue();
            isChained = null == chainDeclaredValue ? configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ACCESSORS_CHAIN, psiClass) : chainDeclaredValue.booleanValue();
            makeFinal = null == makeFinalDeclaredValue ? configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ACCESSORS_MAKE_FINAL, psiClass) : makeFinalDeclaredValue.booleanValue();
            prefixes = prefixDeclared.isEmpty() ? ArrayUtil.toStringArray(configDiscovery.getMultipleValueLombokConfigProperty(ConfigKey.ACCESSORS_PREFIX, psiClass)) : ArrayUtil.toStringArray(prefixDeclared);
            doNotUseIsPrefix = configDiscovery.getBooleanLombokConfigProperty(ConfigKey.GETTER_NO_IS_PREFIX, psiClass);
            String capitalizationStrategyValue = configDiscovery.getStringLombokConfigProperty(ConfigKey.ACCESSORS_JAVA_BEANS_SPEC_CAPITALIZATION, psiClass);
            capitalizationStrategy = CapitalizationStrategy.convertValue(capitalizationStrategyValue);
        } else {
            isFluent = null != fluentDeclaredValue && fluentDeclaredValue != false;
            isChained = null != chainDeclaredValue && chainDeclaredValue != false;
            makeFinal = null != makeFinalDeclaredValue && makeFinalDeclaredValue != false;
            prefixes = ArrayUtil.toStringArray(prefixDeclared);
            doNotUseIsPrefix = false;
            capitalizationStrategy = CapitalizationStrategy.defaultValue();
        }
        boolean isChainDeclaredOrImplicit = isChained || isFluent && null == chainDeclaredValue;
        return AccessorsInfo.build(isFluent, isChainDeclaredOrImplicit, makeFinal, doNotUseIsPrefix, capitalizationStrategy, prefixes);
    }

    private static AccessorsValues collectValues(@NotNull PsiAnnotation accessorsAnnotation) {
        if (accessorsAnnotation == null) {
            AccessorsInfo.$$$reportNull$$$0(1);
        }
        Boolean chainDeclaredValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(accessorsAnnotation, CHAIN_VALUE);
        Boolean fluentDeclaredValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(accessorsAnnotation, FLUENT_VALUE);
        Boolean makeFinalDeclaredValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(accessorsAnnotation, MAKE_FINAL_VALUE);
        Collection<String> prefixes = PsiAnnotationUtil.getAnnotationValues(accessorsAnnotation, PREFIX_VALUE, String.class, List.of());
        return new AccessorsValues(chainDeclaredValue, fluentDeclaredValue, makeFinalDeclaredValue, prefixes);
    }

    private static AccessorsInfo buildFrom(@Nullable PsiClass psiClass, AccessorsValues values) {
        return AccessorsInfo.buildAccessorsInfo(psiClass, values.chainDeclaredValue, values.fluentDeclaredValue, values.makeFinalDeclaredValue, values.prefixes);
    }

    @NotNull
    public static AccessorsInfo buildFor(@NotNull PsiField psiField) {
        if (psiField == null) {
            AccessorsInfo.$$$reportNull$$$0(2);
        }
        AccessorsValues fieldAccessorsValues = AccessorsInfo.getAccessorsValues(psiField);
        AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiField.getContainingClass());
        AccessorsValues combinedAccessorValues = fieldAccessorsValues.combine(classAccessorsValues);
        PsiClass containingClass = psiField.getContainingClass();
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFrom(containingClass, combinedAccessorValues);
        if (accessorsInfo == null) {
            AccessorsInfo.$$$reportNull$$$0(3);
        }
        return accessorsInfo;
    }

    @NotNull
    public static AccessorsInfo buildFor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AccessorsInfo.$$$reportNull$$$0(4);
        }
        AccessorsValues resultAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFrom(psiClass, resultAccessorsValues);
        if (accessorsInfo == null) {
            AccessorsInfo.$$$reportNull$$$0(5);
        }
        return accessorsInfo;
    }

    @NotNull
    private static AccessorsValues getAccessorsValues(@NotNull PsiField psiField) {
        if (psiField == null) {
            AccessorsInfo.$$$reportNull$$$0(6);
        }
        AccessorsValues accessorsValues = new AccessorsValues();
        PsiAnnotation accessorsFieldAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.experimental.Accessors");
        if (null != accessorsFieldAnnotation) {
            accessorsValues = AccessorsInfo.collectValues(accessorsFieldAnnotation);
        }
        AccessorsValues accessorsValues2 = accessorsValues;
        if (accessorsValues2 == null) {
            AccessorsInfo.$$$reportNull$$$0(7);
        }
        return accessorsValues2;
    }

    @NotNull
    public static AccessorsValues getAccessorsValues(@Nullable PsiClass psiClass) {
        AccessorsValues resultAccessorsValues = new AccessorsValues();
        for (PsiClass containingClass = psiClass; null != containingClass; containingClass = containingClass.getContainingClass()) {
            PsiAnnotation accessorsClassAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)containingClass, "lombok.experimental.Accessors");
            if (null == accessorsClassAnnotation) continue;
            AccessorsValues classAccessorsValues = AccessorsInfo.collectValues(accessorsClassAnnotation);
            resultAccessorsValues = resultAccessorsValues.combine(classAccessorsValues);
        }
        AccessorsValues accessorsValues = resultAccessorsValues;
        if (accessorsValues == null) {
            AccessorsInfo.$$$reportNull$$$0(8);
        }
        return accessorsValues;
    }

    @NotNull
    public static AccessorsInfo buildFor(@NotNull PsiField psiField, AccessorsValues classAccessorsValues) {
        if (psiField == null) {
            AccessorsInfo.$$$reportNull$$$0(9);
        }
        AccessorsValues fieldAccessorsValues = AccessorsInfo.getAccessorsValues(psiField);
        AccessorsValues combinedAccessorValues = fieldAccessorsValues.combine(classAccessorsValues);
        PsiClass containingClass = psiField.getContainingClass();
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFrom(containingClass, combinedAccessorValues);
        if (accessorsInfo == null) {
            AccessorsInfo.$$$reportNull$$$0(10);
        }
        return accessorsInfo;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public AccessorsInfo withFluent(boolean fluentValue) {
        if (this.fluent == fluentValue) {
            return this;
        }
        return AccessorsInfo.build(fluentValue, this.chain, this.makeFinal, this.doNotUseIsPrefix, this.capitalizationStrategy, this.prefixes);
    }

    public boolean isChain() {
        return this.chain;
    }

    public boolean isMakeFinal() {
        return this.makeFinal;
    }

    public boolean isDoNotUseIsPrefix() {
        return this.doNotUseIsPrefix;
    }

    public CapitalizationStrategy getCapitalizationStrategy() {
        return this.capitalizationStrategy;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public boolean acceptsFieldName(String fieldName) {
        return null != this.removePrefix(fieldName);
    }

    @Nullable
    public String removePrefix(String fieldName) {
        if (this.prefixes.length == 0) {
            return fieldName;
        }
        for (String prefix : this.prefixes) {
            if (prefix.isEmpty()) {
                return fieldName;
            }
            int lengthOfPrefix = prefix.length();
            if (fieldName.length() <= lengthOfPrefix || !fieldName.startsWith(prefix)) continue;
            char charAfterPrefix = fieldName.charAt(lengthOfPrefix);
            if (Character.isLetter(prefix.charAt(lengthOfPrefix - 1)) && Character.isLowerCase(charAfterPrefix)) continue;
            return Character.toLowerCase(charAfterPrefix) + fieldName.substring(lengthOfPrefix + 1);
        }
        return null;
    }

    @NotNull
    public String removePrefixWithDefault(String fieldName) {
        String newName = this.removePrefix(fieldName);
        String string = null != newName ? newName : fieldName;
        if (string == null) {
            AccessorsInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixDeclared";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsAnnotation";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/AccessorsInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/AccessorsInfo";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorsValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removePrefixWithDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAccessorsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildFor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorsValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }

    public record AccessorsValues(Boolean chainDeclaredValue, Boolean fluentDeclaredValue, Boolean makeFinalDeclaredValue, Collection<String> prefixes) {
        private AccessorsValues() {
            this(null, null, null, Collections.emptyList());
        }

        private AccessorsValues combine(AccessorsValues defaults) {
            Boolean combinedChain = this.chainDeclaredValue;
            Boolean combinedFluent = this.fluentDeclaredValue;
            Boolean combinedMakeFinal = this.makeFinalDeclaredValue;
            Collection<String> combinedPrefixes = this.prefixes;
            if (combinedChain == null && null != defaults.chainDeclaredValue) {
                combinedChain = defaults.chainDeclaredValue;
            }
            if (combinedFluent == null && null != defaults.fluentDeclaredValue) {
                combinedFluent = defaults.fluentDeclaredValue;
            }
            if (combinedMakeFinal == null && null != defaults.makeFinalDeclaredValue) {
                combinedMakeFinal = defaults.makeFinalDeclaredValue;
            }
            if (combinedPrefixes.isEmpty() && !defaults.prefixes.isEmpty()) {
                combinedPrefixes = defaults.prefixes;
            }
            return new AccessorsValues(combinedChain, combinedFluent, combinedMakeFinal, combinedPrefixes);
        }
    }
}

