/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.util.NameTemplate;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TemplateEditorWithHelp
extends JBTextField {
    @Nls
    private final String myHintText;
    private final NameTemplate myDefaultTemplate;
    private final String myShortcutHelp;

    public TemplateEditorWithHelp(@NotNull NameTemplate defaultTemplate) {
        if (defaultTemplate == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(0);
        }
        this.myDefaultTemplate = defaultTemplate;
        this.myHintText = TemplateEditorWithHelp.createHint(defaultTemplate);
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        this.myShortcutHelp = shortcuts.length == 0 ? "" : "\n" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " for help";
        new DumbAwareAction(SqlBundle.message((String)"sql.template.editor.help", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TemplateEditorWithHelp.this.showHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/sql/common/impl/formatter/settings/TemplateEditorWithHelp$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)this));
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TemplateEditorWithHelp.this.updateExample();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/sql/common/impl/formatter/settings/TemplateEditorWithHelp$2", "textChanged"));
            }
        });
    }

    @Nls
    @NotNull
    private static String createHint(@NotNull NameTemplate template) {
        if (template == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(1);
        }
        @Nls StringBuilder sb = new StringBuilder();
        sb.append(DatabaseBundle.message((String)"sql.code.generation.template.can.contain", (Object[])new Object[0])).append("<ul>");
        for (NameTemplate.Placeholder placeholder : template.allowed) {
            sb.append("<li><b>").append(placeholder.text).append("</b> - ").append((String)placeholder.desc.get()).append(";</li>");
        }
        sb.append("</ul>");
        sb.append(DatabaseBundle.message((String)"sql.code.generation.template.example", (Object[])new Object[0])).append(" ").append(template.template);
        String string = sb.toString();
        if (string == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void showHint() {
        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createInformationLabel((String)this.myHintText)).setFillColor(HintUtil.getInformationColor()).setHideOnClickOutside(true).setHideOnAction(true).setClickHandler(new ActionListener(this){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/sql/common/impl/formatter/settings/TemplateEditorWithHelp$3", "actionPerformed"));
            }
        }, true).createBalloon().show(RelativePoint.getSouthWestOf((JComponent)((Object)this)), Balloon.Position.below);
    }

    private void updateExample() {
        String tip = SqlBundle.message((String)"sql.template.editor.example.name", (Object[])new Object[]{NameTemplate.example((String)this.getText(), (NameTemplate.Placeholder[])this.myDefaultTemplate.allowed) + this.myShortcutHelp});
        this.setToolTipText(tip);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/TemplateEditorWithHelp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/TemplateEditorWithHelp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

