/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 137582059132122L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1371778620 - -32587, -1371778620 - -18894, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1371778620 - -32586, -1371778620 - -((char)-21710), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 55409626779199L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.u();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-253751520 - -((char)-17208), -253751520 - -((char)-12109), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-253751520 - -((char)-17207), 253751520 - (char)-22719, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-253751520 - -((char)-17202), -253751520 - -((char)-26238), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 31360002880333L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.u();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1848349140 - 23351, 1848349140 - 18161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1848349140 - 23350, 1848349140 - 27193, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1848349140 - 23349, -1848349140 - -((char)-31327), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1848349140 - 23364, -1848349140 - -25775, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1848349140 - 23363, -1848349140 - -31151, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1848349140 - 23362, -1848349140 - -7275, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1848349140 - 23364, -1848349140 - -25775, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1848349140 - 23361, -1848349140 - -29357, (int)l2));
            if (ActionTimestamp.I()) {
                SshAgentIpcService.u(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 72728605016481L;
                    actionTimestampArray = SshAgentIpcService.u();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    ActionTimestamp[] actionTimestampArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 47016959623245L;
                            ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.u();
                            this.assertConnectionThread();
                            actionTimestampArray = actionTimestampArray2;
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (actionTimestampArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(47316270 + (char)-30618, -47316270 + -((char)-5349), (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30617, -47316270 + -((char)-13212), (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30616, 47316270 + (char)-2084, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(47316270 + (char)-30618, -47316270 + -((char)-5349), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30615, 47316270 + (char)-23888, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (actionTimestampArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(47316270 + (char)-30618, -47316270 + -((char)-5349), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30630, -47316270 + -((char)-1947), (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30629, 47316270 + (char)-19266, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30616, 47316270 + (char)-2084, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(47316270 + (char)-30618, -47316270 + -((char)-5349), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(47316270 + (char)-30622, -47316270 + -((char)-24329), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(47316270 + (char)-30628, 47316270 + (char)-22086, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 103811211445691L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1851888030 + -27517, -1851888030 + -19107, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 5194198226943L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1582801320 - -29256, -1582801320 - -21415, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u0087\u00b9P\u008f\u0013\u00b2@\u00dd\u00bfA\u0084Y\u009e{7\u00be\u0091*\u001e\u0014I\u00bf\u0089I3\u00a89\u001b\u0012\u009f\u00f4VRco6w\u00fd\u00c5.";
                                        var4_3 = "\u0087\u00b9P\u008f\u0013\u00b2@\u00dd\u00bfA\u0084Y\u009e{7\u00be\u0091*\u001e\u0014I\u00bf\u0089I3\u00a89\u001b\u0012\u009f\u00f4VRco6w\u00fd\u00c5.".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 52;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 55;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 36;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 32;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 14;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 88;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 32;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 77;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFC75E) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 208;
                                            case 1 -> 90;
                                            case 2 -> 206;
                                            case 3 -> 190;
                                            case 4 -> 35;
                                            case 5 -> 135;
                                            case 6 -> 170;
                                            case 7 -> 162;
                                            case 8 -> 1;
                                            case 9 -> 157;
                                            case 10 -> 71;
                                            case 11 -> 22;
                                            case 12 -> 77;
                                            case 13 -> 207;
                                            case 14 -> 140;
                                            case 15 -> 105;
                                            case 16 -> 120;
                                            case 17 -> 196;
                                            case 18 -> 16;
                                            case 19 -> 102;
                                            case 20 -> 244;
                                            case 21 -> 235;
                                            case 22 -> 60;
                                            case 23 -> 125;
                                            case 24 -> 141;
                                            case 25 -> 181;
                                            case 26 -> 193;
                                            case 27 -> 113;
                                            case 28 -> 142;
                                            case 29 -> 47;
                                            case 30 -> 173;
                                            case 31 -> 250;
                                            case 32 -> 138;
                                            case 33 -> 61;
                                            case 34 -> 230;
                                            case 35 -> 147;
                                            case 36 -> 112;
                                            case 37 -> 45;
                                            case 38 -> 64;
                                            case 39 -> 150;
                                            case 40 -> 189;
                                            case 41 -> 177;
                                            case 42 -> 57;
                                            case 43 -> 168;
                                            case 44 -> 129;
                                            case 45 -> 54;
                                            case 46 -> 94;
                                            case 47 -> 238;
                                            case 48 -> 36;
                                            case 49 -> 76;
                                            case 50 -> 67;
                                            case 51 -> 123;
                                            case 52 -> 56;
                                            case 53 -> 29;
                                            case 54 -> 234;
                                            case 55 -> 12;
                                            case 56 -> 2;
                                            case 57 -> 3;
                                            case 58 -> 241;
                                            case 59 -> 209;
                                            case 60 -> 252;
                                            case 61 -> 183;
                                            case 62 -> 246;
                                            case 63 -> 180;
                                            case 64 -> 202;
                                            case 65 -> 0;
                                            case 66 -> 92;
                                            case 67 -> 97;
                                            case 68 -> 223;
                                            case 69 -> 161;
                                            case 70 -> 253;
                                            case 71 -> 96;
                                            case 72 -> 213;
                                            case 73 -> 214;
                                            case 74 -> 220;
                                            case 75 -> 247;
                                            case 76 -> 224;
                                            case 77 -> 72;
                                            case 78 -> 245;
                                            case 79 -> 110;
                                            case 80 -> 233;
                                            case 81 -> 23;
                                            case 82 -> 82;
                                            case 83 -> 58;
                                            case 84 -> 115;
                                            case 85 -> 134;
                                            case 86 -> 70;
                                            case 87 -> 221;
                                            case 88 -> 237;
                                            case 89 -> 139;
                                            case 90 -> 5;
                                            case 91 -> 197;
                                            case 92 -> 154;
                                            case 93 -> 114;
                                            case 94 -> 143;
                                            case 95 -> 203;
                                            case 96 -> 116;
                                            case 97 -> 239;
                                            case 98 -> 103;
                                            case 99 -> 200;
                                            case 100 -> 79;
                                            case 101 -> 122;
                                            case 102 -> 74;
                                            case 103 -> 236;
                                            case 104 -> 65;
                                            case 105 -> 159;
                                            case 106 -> 191;
                                            case 107 -> 185;
                                            case 108 -> 88;
                                            case 109 -> 11;
                                            case 110 -> 155;
                                            case 111 -> 83;
                                            case 112 -> 174;
                                            case 113 -> 164;
                                            case 114 -> 148;
                                            case 115 -> 9;
                                            case 116 -> 78;
                                            case 117 -> 149;
                                            case 118 -> 145;
                                            case 119 -> 25;
                                            case 120 -> 151;
                                            case 121 -> 226;
                                            case 122 -> 117;
                                            case 123 -> 165;
                                            case 124 -> 52;
                                            case 125 -> 33;
                                            case 126 -> 13;
                                            case 127 -> 232;
                                            case 128 -> 119;
                                            case 129 -> 243;
                                            case 130 -> 240;
                                            case 131 -> 178;
                                            case 132 -> 26;
                                            case 133 -> 249;
                                            case 134 -> 19;
                                            case 135 -> 32;
                                            case 136 -> 91;
                                            case 137 -> 144;
                                            case 138 -> 169;
                                            case 139 -> 53;
                                            case 140 -> 195;
                                            case 141 -> 109;
                                            case 142 -> 49;
                                            case 143 -> 30;
                                            case 144 -> 204;
                                            case 145 -> 251;
                                            case 146 -> 73;
                                            case 147 -> 27;
                                            case 148 -> 248;
                                            case 149 -> 163;
                                            case 150 -> 133;
                                            case 151 -> 101;
                                            case 152 -> 69;
                                            case 153 -> 228;
                                            case 154 -> 128;
                                            case 155 -> 95;
                                            case 156 -> 231;
                                            case 157 -> 171;
                                            case 158 -> 20;
                                            case 159 -> 8;
                                            case 160 -> 89;
                                            case 161 -> 217;
                                            case 162 -> 66;
                                            case 163 -> 17;
                                            case 164 -> 106;
                                            case 165 -> 80;
                                            case 166 -> 86;
                                            case 167 -> 255;
                                            case 168 -> 34;
                                            case 169 -> 152;
                                            case 170 -> 62;
                                            case 171 -> 201;
                                            case 172 -> 167;
                                            case 173 -> 81;
                                            case 174 -> 188;
                                            case 175 -> 137;
                                            case 176 -> 184;
                                            case 177 -> 212;
                                            case 178 -> 219;
                                            case 179 -> 227;
                                            case 180 -> 146;
                                            case 181 -> 211;
                                            case 182 -> 210;
                                            case 183 -> 24;
                                            case 184 -> 42;
                                            case 185 -> 87;
                                            case 186 -> 43;
                                            case 187 -> 136;
                                            case 188 -> 118;
                                            case 189 -> 121;
                                            case 190 -> 7;
                                            case 191 -> 85;
                                            case 192 -> 176;
                                            case 193 -> 15;
                                            case 194 -> 175;
                                            case 195 -> 254;
                                            case 196 -> 68;
                                            case 197 -> 55;
                                            case 198 -> 39;
                                            case 199 -> 108;
                                            case 200 -> 166;
                                            case 201 -> 124;
                                            case 202 -> 187;
                                            case 203 -> 186;
                                            case 204 -> 46;
                                            case 205 -> 229;
                                            case 206 -> 10;
                                            case 207 -> 31;
                                            case 208 -> 75;
                                            case 209 -> 158;
                                            case 210 -> 37;
                                            case 211 -> 242;
                                            case 212 -> 179;
                                            case 213 -> 225;
                                            case 214 -> 127;
                                            case 215 -> 205;
                                            case 216 -> 50;
                                            case 217 -> 216;
                                            case 218 -> 99;
                                            case 219 -> 51;
                                            case 220 -> 126;
                                            case 221 -> 100;
                                            case 222 -> 218;
                                            case 223 -> 59;
                                            case 224 -> 132;
                                            case 225 -> 84;
                                            case 226 -> 192;
                                            case 227 -> 48;
                                            case 228 -> 4;
                                            case 229 -> 18;
                                            case 230 -> 199;
                                            case 231 -> 6;
                                            case 232 -> 111;
                                            case 233 -> 38;
                                            case 234 -> 14;
                                            case 235 -> 41;
                                            case 236 -> 44;
                                            case 237 -> 182;
                                            case 238 -> 107;
                                            case 239 -> 172;
                                            case 240 -> 131;
                                            case 241 -> 130;
                                            case 242 -> 28;
                                            case 243 -> 63;
                                            case 244 -> 104;
                                            case 245 -> 21;
                                            case 246 -> 93;
                                            case 247 -> 153;
                                            case 248 -> 215;
                                            case 249 -> 222;
                                            case 250 -> 98;
                                            case 251 -> 160;
                                            case 252 -> 194;
                                            case 253 -> 198;
                                            case 254 -> 40;
                                            default -> 156;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (actionTimestampArray != null) break block32;
                            if (!ActionTimestamp.I()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.u(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 39909800602813L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.u();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4122), 964413060 + (char)-2877, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4126), 964544130 - (char)-1705, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4099), 964413060 + (char)-4471, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4122), 964413060 + (char)-2877, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4126), 964544130 - (char)-1705, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-964544130 - -((char)-4098), 964413060 + (char)-16442, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 87416015533516L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.u();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-546168690 - -20350, 546168690 - 14757, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-546168690 - -20353, 546168690 - 11989, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 133801485503177L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.u();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = actionTimestampArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369355260 - -14604, 369355260 - 3273, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-369355260 - -14608, 369355260 - 16029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369355260 - -14599, -369355260 - -18328, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-369355260 - -14608, 369355260 - 16029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369355260 - -14606, -369355260 - -10634, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369355260 - -14604, 369355260 - 3273, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-369355260 - -14608, 369355260 - 16029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369355260 - -14592, 369355260 - 24346, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369355260 - -14604, 369355260 - 3273, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-369355260 - -14608, 369355260 - 16029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369355260 - -14593, 369355260 - 14590, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369355260 - -14604, 369355260 - 3273, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-369355260 - -14608, 369355260 - 16029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369355260 - -14594, 369355260 - 11231, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 99443123553076L;
                    Object object = this.lock;
                    actionTimestampArray = SshAgentIpcService.u();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24287), 1745721330 + (char)-17188, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24283), 1745721330 + (char)-30032, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24300), -1745721330 + -((char)-24252), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24303), -1745721330 + -((char)-13547), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24287), 1745721330 + (char)-17188, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24283), 1745721330 + (char)-30032, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24302), -1745721330 + -31390, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24287), 1745721330 + (char)-17188, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24283), 1745721330 + (char)-30032, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24305), -1745721330 + -((char)-30634), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24287), 1745721330 + (char)-17188, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24283), 1745721330 + (char)-30032, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24304), -1745721330 + -32158, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24287), 1745721330 + (char)-17188, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24283), 1745721330 + (char)-30032, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24243), 1745721330 + (char)-12418, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1745721330 + -((char)-24242), -1745721330 + -30363, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00cd\u009f\u0089\u00d3\u00d6\u00bc@m\u0014\u00c0\u0019\u0010\u00e4\u001b\u00d2V\u00baY\u009c%w\u0001\u00d3e\u00d6g\u000b\u0019\u008f\u0006vp\u00fe.RB\u0018\u00d0\u00fer(\u00d5\u008e\u008d\u00f1\u00ea\u0088\\\u0085Hr\u001e`\u00a1\u00b4\u00ef\u00e5\u00f4\t\u0017\u00eb\t^I=oW\u00f9\u00c5W\u00df\u0005\u00fb\u00edO\u009d~\bH^9\u009a\u0092\u00b3\u00cen\u0014\u00ddn\u00cb\u0091\rt\u00a1\u00f9\u00c9)\u009cu|0qG\u00f7\u00ea\u00f2\u00f1\u0005\u00b1\u0017\u0006\u00c2W\u001e\u00e4z\u00b9\u000b=.2\u009f\u00b8Q]9$\u00c51\u00f2\u00a5w\u00bdi\u0012\u00b7\u00c7\u00f1\u00a1\u007f\u00c5\b)\u00a9\u0010\u0091\u00f6\u00f3_#\u0096\u0007qc>\u00ab)\u00fc\u0092\u0085\u0087\t|\u00e3\u00af+VV\u00c3=\u00f1\u0010\u0007\u00aa!\u00d4y\u00e7L_\n\u00fb\u0086\u0091Y\u00851e?1\\\u000b\u00cff\u00bf\u00dc\u00c1\u0014K\u008d\u0081\u0081$\u00b8\u00f7Q\u00b2^\u0014\u00e0J\u00e2(\u0015\u00ac^\u00c6m&\u0014\u0093\u00e9C\u00c1\u00d7\u00bd/\u00c5\u000fY\u00fe>\u008d\u0098\u0093\u0016\u00cb\u00d4=\u00ca\u00b72@\u0095\u00ec\u00b7\u0012\u0098?T\u00a1\u00f9\b\u00d2XjZ\u00f8\u00ab\u0083m\f\f@\u00a1B\u009c\u00ca\u00e1F\u0096\u0090G\u00f8FV\u0098\u00eaY\u00f5\u00a9\u00cc*3\u0011\u00f9\f\u0099\u009d\u00a4\u00e6.\u00f7\u00b1\u0013\u000f\u00f8\u001cL\u00fc\u000b\u00909\u000b\u00f0\u00e2u\u000b)_\u00bb\u00b4\u00efO\u00d3\u009bp\u00ed\u00a7<S\u00d6\u00ae+iS\u0097\u00ee\u00d2\u0018\u00a5\u0099O\u00cb(\r*\u008ep\u00ee\u0094E\u00da\u00ec\u00ce\u001f\u00aa\u00e2p\u0018\u0004L\u0015\u00d3\\\u00d8\u00c1\b\u00b7\u00feH$\u00f1EJ\u00e5'\u00a6\u00b6x\u00ee\u009e;\u00f8\u00ebF\u00fc\u000bW\u0080\u00caZ\u00f1\u00c9L&#\u0090\u00fb\u0015\u001a\u00dbc2\u00c3\u00ac\u00e6\u00f7HJ^\u0091\u00faa\u00fc\u0081\u009ce:\u0098\u001f)\u0018\u0093&6\u00ce\u0089Lkw\u00cf\u00a4\u00ea\u001f\u00a8\u00c3\u00eb\u00df4Tl\u0014\u00ef\u0016I\u0095\u00f1\u0083m\u00d3\u0000yU\u0086\u0088\u0088\u0002P\u00c5X?\u00da\u0007\u009dl\u009c\u00d3\u00bdh\u00b9\u0007\u000ep\u008a<\u0098z\u000b(\u00c7\u000e\u0091\u00a4\u0088\u00b1rK\u00c0\u001cx\u00a6\u00a7\u00a0\u0096ir\u00c9O\u0090\u0016N9\u00b6\u00e0\u00b2\u009b~\u00e7\u0002$\f\u00d6\u00c8\u001c\u00a7x\f\u00ce\u00f5\u000f\u00d9\u00f6\u001c\u0092\u00d1\u001b\u00fc\u00dddCM\u001c\u00a1\u00a3\u00c8\"TO\u00af\u00ad\u00ff\u00faj\u0005\u00b3\u0002<S\u000f\u0093\u00a5B\u00f8(:\u00ad3\u00d7R\u001e\u008eO-d\"\u0013\u00e50;\u00d7\u000e\u008e6\u00f6\u008a\u008c\u0018W\u00bd\u0011O\u00e3\u009dx\u0099\u001b7\u00e6\u00c6\u0095qN}+\u0003\u001a,6\u00d1\u00daX}\u00efee\u0098\u00e3E;\u00ea\u00e8\u00bc\u00b4\ne\u001dH\u00ed\u00b4\u00a5\u0016|\u00c5\u0092\u0018\u0099[\u0013/\u00ca\u00a5+\b\u00d7\u00b7t\u001cc\u00cc\u00f2\u009e\u00cd\u0018\u00f6N\u00e9\u00d4!\u008b)\u00c8\u0000<D\u008d\u00c7$\u00a2z\u00f6\u0005\u00cd/EZ-\u0092\u0099\"\u001c\u00e0\u00f1\u00c1\u0086\u001a\u009a\u00ef\u00ec\rl\u0019I\u00af\u00d5x=\u0090\u0006@G\u00d9\t\u0099f\u0013\u0085\u00cbL&%\u00f0";
                var4_3 = "\u00cd\u009f\u0089\u00d3\u00d6\u00bc@m\u0014\u00c0\u0019\u0010\u00e4\u001b\u00d2V\u00baY\u009c%w\u0001\u00d3e\u00d6g\u000b\u0019\u008f\u0006vp\u00fe.RB\u0018\u00d0\u00fer(\u00d5\u008e\u008d\u00f1\u00ea\u0088\\\u0085Hr\u001e`\u00a1\u00b4\u00ef\u00e5\u00f4\t\u0017\u00eb\t^I=oW\u00f9\u00c5W\u00df\u0005\u00fb\u00edO\u009d~\bH^9\u009a\u0092\u00b3\u00cen\u0014\u00ddn\u00cb\u0091\rt\u00a1\u00f9\u00c9)\u009cu|0qG\u00f7\u00ea\u00f2\u00f1\u0005\u00b1\u0017\u0006\u00c2W\u001e\u00e4z\u00b9\u000b=.2\u009f\u00b8Q]9$\u00c51\u00f2\u00a5w\u00bdi\u0012\u00b7\u00c7\u00f1\u00a1\u007f\u00c5\b)\u00a9\u0010\u0091\u00f6\u00f3_#\u0096\u0007qc>\u00ab)\u00fc\u0092\u0085\u0087\t|\u00e3\u00af+VV\u00c3=\u00f1\u0010\u0007\u00aa!\u00d4y\u00e7L_\n\u00fb\u0086\u0091Y\u00851e?1\\\u000b\u00cff\u00bf\u00dc\u00c1\u0014K\u008d\u0081\u0081$\u00b8\u00f7Q\u00b2^\u0014\u00e0J\u00e2(\u0015\u00ac^\u00c6m&\u0014\u0093\u00e9C\u00c1\u00d7\u00bd/\u00c5\u000fY\u00fe>\u008d\u0098\u0093\u0016\u00cb\u00d4=\u00ca\u00b72@\u0095\u00ec\u00b7\u0012\u0098?T\u00a1\u00f9\b\u00d2XjZ\u00f8\u00ab\u0083m\f\f@\u00a1B\u009c\u00ca\u00e1F\u0096\u0090G\u00f8FV\u0098\u00eaY\u00f5\u00a9\u00cc*3\u0011\u00f9\f\u0099\u009d\u00a4\u00e6.\u00f7\u00b1\u0013\u000f\u00f8\u001cL\u00fc\u000b\u00909\u000b\u00f0\u00e2u\u000b)_\u00bb\u00b4\u00efO\u00d3\u009bp\u00ed\u00a7<S\u00d6\u00ae+iS\u0097\u00ee\u00d2\u0018\u00a5\u0099O\u00cb(\r*\u008ep\u00ee\u0094E\u00da\u00ec\u00ce\u001f\u00aa\u00e2p\u0018\u0004L\u0015\u00d3\\\u00d8\u00c1\b\u00b7\u00feH$\u00f1EJ\u00e5'\u00a6\u00b6x\u00ee\u009e;\u00f8\u00ebF\u00fc\u000bW\u0080\u00caZ\u00f1\u00c9L&#\u0090\u00fb\u0015\u001a\u00dbc2\u00c3\u00ac\u00e6\u00f7HJ^\u0091\u00faa\u00fc\u0081\u009ce:\u0098\u001f)\u0018\u0093&6\u00ce\u0089Lkw\u00cf\u00a4\u00ea\u001f\u00a8\u00c3\u00eb\u00df4Tl\u0014\u00ef\u0016I\u0095\u00f1\u0083m\u00d3\u0000yU\u0086\u0088\u0088\u0002P\u00c5X?\u00da\u0007\u009dl\u009c\u00d3\u00bdh\u00b9\u0007\u000ep\u008a<\u0098z\u000b(\u00c7\u000e\u0091\u00a4\u0088\u00b1rK\u00c0\u001cx\u00a6\u00a7\u00a0\u0096ir\u00c9O\u0090\u0016N9\u00b6\u00e0\u00b2\u009b~\u00e7\u0002$\f\u00d6\u00c8\u001c\u00a7x\f\u00ce\u00f5\u000f\u00d9\u00f6\u001c\u0092\u00d1\u001b\u00fc\u00dddCM\u001c\u00a1\u00a3\u00c8\"TO\u00af\u00ad\u00ff\u00faj\u0005\u00b3\u0002<S\u000f\u0093\u00a5B\u00f8(:\u00ad3\u00d7R\u001e\u008eO-d\"\u0013\u00e50;\u00d7\u000e\u008e6\u00f6\u008a\u008c\u0018W\u00bd\u0011O\u00e3\u009dx\u0099\u001b7\u00e6\u00c6\u0095qN}+\u0003\u001a,6\u00d1\u00daX}\u00efee\u0098\u00e3E;\u00ea\u00e8\u00bc\u00b4\ne\u001dH\u00ed\u00b4\u00a5\u0016|\u00c5\u0092\u0018\u0099[\u0013/\u00ca\u00a5+\b\u00d7\u00b7t\u001cc\u00cc\u00f2\u009e\u00cd\u0018\u00f6N\u00e9\u00d4!\u008b)\u00c8\u0000<D\u008d\u00c7$\u00a2z\u00f6\u0005\u00cd/EZ-\u0092\u0099\"\u001c\u00e0\u00f1\u00c1\u0086\u001a\u009a\u00ef\u00ec\rl\u0019I\u00af\u00d5x=\u0090\u0006@G\u00d9\t\u0099f\u0013\u0085\u00cbL&%\u00f0".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 127;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0016n\u00c6\u00a8\u00f3{\u00ca\u0014\u0086\u0001\u00bb\u0012\u00d9\u009f\u00a5WL\u00fb\u0088\u00f5\u00c1\u00d27\u001dN\u00d4\u00d5A\u00fb\u0014\u00919\u001b\u00c1[W\u007f+]\u008f\u00844\u0014\u009a\u00e6\u00de6+\u0012\u00aa";
                    var4_3 = "\u0016n\u00c6\u00a8\u00f3{\u00ca\u0014\u0086\u0001\u00bb\u0012\u00d9\u009f\u00a5WL\u00fb\u0088\u00f5\u00c1\u00d27\u001dN\u00d4\u00d5A\u00fb\u0014\u00919\u001b\u00c1[W\u007f+]\u008f\u00844\u0014\u009a\u00e6\u00de6+\u0012\u00aa".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 126;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 101;
                            break;
                        }
                        case 1: {
                            v15 = 103;
                            break;
                        }
                        case 2: {
                            v15 = 2;
                            break;
                        }
                        case 3: {
                            v15 = 125;
                            break;
                        }
                        case 4: {
                            v15 = 25;
                            break;
                        }
                        case 5: {
                            v15 = 81;
                            break;
                        }
                        default: {
                            v15 = 7;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC5D5) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 118;
                case 1 -> 220;
                case 2 -> 191;
                case 3 -> 16;
                case 4 -> 121;
                case 5 -> 150;
                case 6 -> 35;
                case 7 -> 160;
                case 8 -> 27;
                case 9 -> 143;
                case 10 -> 233;
                case 11 -> 83;
                case 12 -> 21;
                case 13 -> 13;
                case 14 -> 201;
                case 15 -> 192;
                case 16 -> 229;
                case 17 -> 17;
                case 18 -> 169;
                case 19 -> 26;
                case 20 -> 234;
                case 21 -> 99;
                case 22 -> 103;
                case 23 -> 152;
                case 24 -> 41;
                case 25 -> 197;
                case 26 -> 113;
                case 27 -> 0;
                case 28 -> 199;
                case 29 -> 128;
                case 30 -> 104;
                case 31 -> 154;
                case 32 -> 75;
                case 33 -> 184;
                case 34 -> 76;
                case 35 -> 133;
                case 36 -> 172;
                case 37 -> 43;
                case 38 -> 245;
                case 39 -> 81;
                case 40 -> 236;
                case 41 -> 189;
                case 42 -> 141;
                case 43 -> 18;
                case 44 -> 155;
                case 45 -> 231;
                case 46 -> 126;
                case 47 -> 149;
                case 48 -> 163;
                case 49 -> 22;
                case 50 -> 162;
                case 51 -> 144;
                case 52 -> 240;
                case 53 -> 178;
                case 54 -> 115;
                case 55 -> 215;
                case 56 -> 90;
                case 57 -> 224;
                case 58 -> 176;
                case 59 -> 70;
                case 60 -> 34;
                case 61 -> 158;
                case 62 -> 131;
                case 63 -> 58;
                case 64 -> 61;
                case 65 -> 249;
                case 66 -> 55;
                case 67 -> 207;
                case 68 -> 53;
                case 69 -> 127;
                case 70 -> 179;
                case 71 -> 177;
                case 72 -> 68;
                case 73 -> 211;
                case 74 -> 254;
                case 75 -> 156;
                case 76 -> 170;
                case 77 -> 46;
                case 78 -> 195;
                case 79 -> 146;
                case 80 -> 174;
                case 81 -> 159;
                case 82 -> 110;
                case 83 -> 204;
                case 84 -> 36;
                case 85 -> 51;
                case 86 -> 119;
                case 87 -> 31;
                case 88 -> 73;
                case 89 -> 222;
                case 90 -> 183;
                case 91 -> 80;
                case 92 -> 235;
                case 93 -> 102;
                case 94 -> 74;
                case 95 -> 194;
                case 96 -> 11;
                case 97 -> 135;
                case 98 -> 14;
                case 99 -> 82;
                case 100 -> 49;
                case 101 -> 206;
                case 102 -> 56;
                case 103 -> 186;
                case 104 -> 84;
                case 105 -> 39;
                case 106 -> 239;
                case 107 -> 117;
                case 108 -> 208;
                case 109 -> 32;
                case 110 -> 52;
                case 111 -> 89;
                case 112 -> 69;
                case 113 -> 209;
                case 114 -> 223;
                case 115 -> 47;
                case 116 -> 100;
                case 117 -> 40;
                case 118 -> 120;
                case 119 -> 1;
                case 120 -> 203;
                case 121 -> 54;
                case 122 -> 213;
                case 123 -> 180;
                case 124 -> 98;
                case 125 -> 60;
                case 126 -> 71;
                case 127 -> 122;
                case 128 -> 134;
                case 129 -> 2;
                case 130 -> 3;
                case 131 -> 139;
                case 132 -> 86;
                case 133 -> 45;
                case 134 -> 157;
                case 135 -> 10;
                case 136 -> 67;
                case 137 -> 93;
                case 138 -> 132;
                case 139 -> 238;
                case 140 -> 72;
                case 141 -> 151;
                case 142 -> 246;
                case 143 -> 125;
                case 144 -> 96;
                case 145 -> 107;
                case 146 -> 200;
                case 147 -> 105;
                case 148 -> 38;
                case 149 -> 251;
                case 150 -> 33;
                case 151 -> 20;
                case 152 -> 91;
                case 153 -> 62;
                case 154 -> 66;
                case 155 -> 227;
                case 156 -> 242;
                case 157 -> 225;
                case 158 -> 108;
                case 159 -> 193;
                case 160 -> 140;
                case 161 -> 109;
                case 162 -> 214;
                case 163 -> 5;
                case 164 -> 95;
                case 165 -> 190;
                case 166 -> 212;
                case 167 -> 205;
                case 168 -> 4;
                case 169 -> 130;
                case 170 -> 112;
                case 171 -> 187;
                case 172 -> 166;
                case 173 -> 114;
                case 174 -> 129;
                case 175 -> 9;
                case 176 -> 23;
                case 177 -> 123;
                case 178 -> 37;
                case 179 -> 57;
                case 180 -> 97;
                case 181 -> 79;
                case 182 -> 94;
                case 183 -> 243;
                case 184 -> 185;
                case 185 -> 226;
                case 186 -> 232;
                case 187 -> 244;
                case 188 -> 7;
                case 189 -> 168;
                case 190 -> 202;
                case 191 -> 167;
                case 192 -> 19;
                case 193 -> 219;
                case 194 -> 63;
                case 195 -> 50;
                case 196 -> 221;
                case 197 -> 181;
                case 198 -> 228;
                case 199 -> 252;
                case 200 -> 85;
                case 201 -> 216;
                case 202 -> 182;
                case 203 -> 165;
                case 204 -> 188;
                case 205 -> 253;
                case 206 -> 248;
                case 207 -> 171;
                case 208 -> 44;
                case 209 -> 218;
                case 210 -> 164;
                case 211 -> 64;
                case 212 -> 65;
                case 213 -> 101;
                case 214 -> 92;
                case 215 -> 161;
                case 216 -> 116;
                case 217 -> 217;
                case 218 -> 153;
                case 219 -> 25;
                case 220 -> 198;
                case 221 -> 88;
                case 222 -> 250;
                case 223 -> 175;
                case 224 -> 148;
                case 225 -> 29;
                case 226 -> 124;
                case 227 -> 15;
                case 228 -> 87;
                case 229 -> 147;
                case 230 -> 145;
                case 231 -> 241;
                case 232 -> 48;
                case 233 -> 59;
                case 234 -> 42;
                case 235 -> 142;
                case 236 -> 28;
                case 237 -> 237;
                case 238 -> 173;
                case 239 -> 30;
                case 240 -> 6;
                case 241 -> 255;
                case 242 -> 196;
                case 243 -> 106;
                case 244 -> 247;
                case 245 -> 136;
                case 246 -> 8;
                case 247 -> 12;
                case 248 -> 24;
                case 249 -> 111;
                case 250 -> 78;
                case 251 -> 77;
                case 252 -> 138;
                case 253 -> 230;
                case 254 -> 210;
                default -> 137;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 137885725849475L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-95812170 - -((char)-30350), 95812170 - 31564, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 99478857672260L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.u();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1174780410 + (char)-6924, -1174911480 - -((char)-16645), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1174780410 + (char)-6925, 1174911480 - (char)-2350, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1174780410 + (char)-6926, -1174780410 + -((char)-2370), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "X\u00b2\u0011\u0099p\u00f4\u001a\u0080\u0010\u001c}h\u00c1\u00e5DQ\u00cf\t\u00c3\t#\u00a9]\u00cb\u00de";
                    var4_3 = "X\u00b2\u0011\u0099p\u00f4\u001a\u0080\u0010\u001c}h\u00c1\u00e5DQ\u00cf\t\u00c3\t#\u00a9]\u00cb\u00de".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 15;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "H\u00d3\u008c*,50\u0082\u0094l\u00fdW\u00d5\u0099q-\u000b\u00a1\u0081xTog\u0018%N\u0082\u00ff=\u007f\u00ff\u00c3\u0082\u0010\u001d\u00f3~\u001er\u00d0\u00a7\u009f\u008b\u00b97\u009c)\u00b2\u00dc\u00d3$\u00c3Y\u00cd\u0098po\u008e\u00b3";
                        var4_3 = "H\u00d3\u008c*,50\u0082\u0094l\u00fdW\u00d5\u0099q-\u000b\u00a1\u0081xTog\u0018%N\u0082\u00ff=\u007f\u00ff\u00c3\u0082\u0010\u001d\u00f3~\u001er\u00d0\u00a7\u009f\u008b\u00b97\u009c)\u00b2\u00dc\u00d3$\u00c3Y\u00cd\u0098po\u008e\u00b3".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 19;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 51;
                                break;
                            }
                            case 2: {
                                v15 = 117;
                                break;
                            }
                            case 3: {
                                v15 = 102;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 83;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF8AB) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 171;
                    case 1 -> 193;
                    case 2 -> 53;
                    case 3 -> 254;
                    case 4 -> 68;
                    case 5 -> 26;
                    case 6 -> 250;
                    case 7 -> 194;
                    case 8 -> 92;
                    case 9 -> 233;
                    case 10 -> 48;
                    case 11 -> 186;
                    case 12 -> 173;
                    case 13 -> 77;
                    case 14 -> 21;
                    case 15 -> 54;
                    case 16 -> 190;
                    case 17 -> 253;
                    case 18 -> 137;
                    case 19 -> 65;
                    case 20 -> 66;
                    case 21 -> 18;
                    case 22 -> 20;
                    case 23 -> 148;
                    case 24 -> 114;
                    case 25 -> 192;
                    case 26 -> 153;
                    case 27 -> 161;
                    case 28 -> 74;
                    case 29 -> 33;
                    case 30 -> 222;
                    case 31 -> 58;
                    case 32 -> 98;
                    case 33 -> 55;
                    case 34 -> 6;
                    case 35 -> 134;
                    case 36 -> 156;
                    case 37 -> 90;
                    case 38 -> 67;
                    case 39 -> 11;
                    case 40 -> 151;
                    case 41 -> 61;
                    case 42 -> 206;
                    case 43 -> 34;
                    case 44 -> 211;
                    case 45 -> 205;
                    case 46 -> 73;
                    case 47 -> 216;
                    case 48 -> 236;
                    case 49 -> 255;
                    case 50 -> 32;
                    case 51 -> 121;
                    case 52 -> 214;
                    case 53 -> 124;
                    case 54 -> 10;
                    case 55 -> 191;
                    case 56 -> 175;
                    case 57 -> 251;
                    case 58 -> 109;
                    case 59 -> 102;
                    case 60 -> 169;
                    case 61 -> 56;
                    case 62 -> 72;
                    case 63 -> 7;
                    case 64 -> 71;
                    case 65 -> 14;
                    case 66 -> 12;
                    case 67 -> 177;
                    case 68 -> 95;
                    case 69 -> 107;
                    case 70 -> 96;
                    case 71 -> 4;
                    case 72 -> 9;
                    case 73 -> 149;
                    case 74 -> 197;
                    case 75 -> 146;
                    case 76 -> 230;
                    case 77 -> 170;
                    case 78 -> 180;
                    case 79 -> 101;
                    case 80 -> 178;
                    case 81 -> 116;
                    case 82 -> 130;
                    case 83 -> 247;
                    case 84 -> 70;
                    case 85 -> 59;
                    case 86 -> 8;
                    case 87 -> 117;
                    case 88 -> 139;
                    case 89 -> 126;
                    case 90 -> 104;
                    case 91 -> 111;
                    case 92 -> 155;
                    case 93 -> 57;
                    case 94 -> 154;
                    case 95 -> 167;
                    case 96 -> 244;
                    case 97 -> 3;
                    case 98 -> 19;
                    case 99 -> 246;
                    case 100 -> 243;
                    case 101 -> 202;
                    case 102 -> 37;
                    case 103 -> 225;
                    case 104 -> 47;
                    case 105 -> 113;
                    case 106 -> 144;
                    case 107 -> 23;
                    case 108 -> 46;
                    case 109 -> 60;
                    case 110 -> 119;
                    case 111 -> 63;
                    case 112 -> 200;
                    case 113 -> 185;
                    case 114 -> 120;
                    case 115 -> 152;
                    case 116 -> 103;
                    case 117 -> 204;
                    case 118 -> 196;
                    case 119 -> 147;
                    case 120 -> 108;
                    case 121 -> 78;
                    case 122 -> 135;
                    case 123 -> 93;
                    case 124 -> 36;
                    case 125 -> 226;
                    case 126 -> 127;
                    case 127 -> 25;
                    case 128 -> 195;
                    case 129 -> 182;
                    case 130 -> 184;
                    case 131 -> 122;
                    case 132 -> 51;
                    case 133 -> 16;
                    case 134 -> 128;
                    case 135 -> 183;
                    case 136 -> 44;
                    case 137 -> 64;
                    case 138 -> 118;
                    case 139 -> 79;
                    case 140 -> 140;
                    case 141 -> 132;
                    case 142 -> 88;
                    case 143 -> 229;
                    case 144 -> 5;
                    case 145 -> 81;
                    case 146 -> 215;
                    case 147 -> 165;
                    case 148 -> 207;
                    case 149 -> 174;
                    case 150 -> 15;
                    case 151 -> 189;
                    case 152 -> 158;
                    case 153 -> 218;
                    case 154 -> 22;
                    case 155 -> 242;
                    case 156 -> 172;
                    case 157 -> 91;
                    case 158 -> 115;
                    case 159 -> 136;
                    case 160 -> 2;
                    case 161 -> 245;
                    case 162 -> 49;
                    case 163 -> 181;
                    case 164 -> 85;
                    case 165 -> 252;
                    case 166 -> 138;
                    case 167 -> 145;
                    case 168 -> 84;
                    case 169 -> 45;
                    case 170 -> 29;
                    case 171 -> 232;
                    case 172 -> 100;
                    case 173 -> 106;
                    case 174 -> 208;
                    case 175 -> 50;
                    case 176 -> 235;
                    case 177 -> 231;
                    case 178 -> 159;
                    case 179 -> 203;
                    case 180 -> 237;
                    case 181 -> 123;
                    case 182 -> 131;
                    case 183 -> 27;
                    case 184 -> 97;
                    case 185 -> 187;
                    case 186 -> 239;
                    case 187 -> 110;
                    case 188 -> 99;
                    case 189 -> 142;
                    case 190 -> 217;
                    case 191 -> 24;
                    case 192 -> 227;
                    case 193 -> 76;
                    case 194 -> 213;
                    case 195 -> 240;
                    case 196 -> 219;
                    case 197 -> 201;
                    case 198 -> 221;
                    case 199 -> 87;
                    case 200 -> 40;
                    case 201 -> 212;
                    case 202 -> 248;
                    case 203 -> 89;
                    case 204 -> 228;
                    case 205 -> 141;
                    case 206 -> 220;
                    case 207 -> 129;
                    case 208 -> 199;
                    case 209 -> 105;
                    case 210 -> 1;
                    case 211 -> 164;
                    case 212 -> 75;
                    case 213 -> 168;
                    case 214 -> 249;
                    case 215 -> 133;
                    case 216 -> 143;
                    case 217 -> 43;
                    case 218 -> 163;
                    case 219 -> 0;
                    case 220 -> 13;
                    case 221 -> 176;
                    case 222 -> 41;
                    case 223 -> 209;
                    case 224 -> 62;
                    case 225 -> 39;
                    case 226 -> 83;
                    case 227 -> 31;
                    case 228 -> 28;
                    case 229 -> 69;
                    case 230 -> 157;
                    case 231 -> 17;
                    case 232 -> 112;
                    case 233 -> 150;
                    case 234 -> 179;
                    case 235 -> 160;
                    case 236 -> 198;
                    case 237 -> 224;
                    case 238 -> 234;
                    case 239 -> 94;
                    case 240 -> 162;
                    case 241 -> 166;
                    case 242 -> 82;
                    case 243 -> 30;
                    case 244 -> 35;
                    case 245 -> 238;
                    case 246 -> 38;
                    case 247 -> 241;
                    case 248 -> 52;
                    case 249 -> 80;
                    case 250 -> 210;
                    case 251 -> 86;
                    case 252 -> 42;
                    case 253 -> 188;
                    case 254 -> 125;
                    default -> 223;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 15495454886172L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = ">~pTA\r#g\t9tc^\fO>{2";
                    var5_4 = ">~pTA\r#g\t9tc^\fO>{2".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 63;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 106;
                                    break;
                                }
                                case 1: {
                                    v11 = 36;
                                    break;
                                }
                                case 2: {
                                    v11 = 61;
                                    break;
                                }
                                case 3: {
                                    v11 = 5;
                                    break;
                                }
                                case 4: {
                                    v11 = 27;
                                    break;
                                }
                                case 5: {
                                    v11 = 94;
                                    break;
                                }
                                default: {
                                    v11 = 47;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 135147876878220L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\t\u0007dG|e?\u0004\u000f\u0019h]\n\u0003\u0006c]pg')\u0007j\t\u0003\u0006c]pg'%\r\r\u0004\u0000~Pzj=%\nyZ{c";
                    var5_4 = "\t\u0007dG|e?\u0004\u000f\u0019h]\n\u0003\u0006c]pg')\u0007j\t\u0003\u0006c]pg'%\r\r\u0004\u0000~Pzj=%\nyZ{c".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 77;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\b\u000eiKwa?\u0006\b\u000eiK{k";
                        var5_4 = "\b\u000eiKwa?\u0006\b\u000eiK{k".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 70;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 13;
                                break;
                            }
                            case 1: {
                                v15 = 36;
                                break;
                            }
                            case 2: {
                                v15 = 64;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 88;
                                break;
                            }
                            case 5: {
                                v15 = 73;
                                break;
                            }
                            default: {
                                v15 = 30;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 82727098430837L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1733269680 + -((char)-5229), -1733269680 + -((char)-4812), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 133442990436490L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "5\u0094\u00c9\u00b0\u00de\u0003(\b\u00de\u0005\u00bbx>\u00e9\u00c3\r\u00a25+\n\u0094\u00af(\u000bF\u008c*\u00a1,\u0010\u008b\u001e\u00c9\u0084\u00f7\u00ebo\u00beg\u00be\u00ed\u00aa2\u0010<\u00de\u0005\u0099\u00d5z\\K3\u00b55\u00ee7\u00c6\u00d9y\u00ec\u00d8\t\u0091u{\u00ba9\u00946\u00ca\u00c1\u008cZ\u00bav\u0093\u00ebxq\u00d2\u00c6)\u00f6\u00ae\u001b\u00f8\u0089\u00ea\u0082\u0099\u0010+\u00c8\u00fd\u00ea>_\u00ba\u00e1P\u00e5\u00e8\u0006";
                    var4_3 = "5\u0094\u00c9\u00b0\u00de\u0003(\b\u00de\u0005\u00bbx>\u00e9\u00c3\r\u00a25+\n\u0094\u00af(\u000bF\u008c*\u00a1,\u0010\u008b\u001e\u00c9\u0084\u00f7\u00ebo\u00beg\u00be\u00ed\u00aa2\u0010<\u00de\u0005\u0099\u00d5z\\K3\u00b55\u00ee7\u00c6\u00d9y\u00ec\u00d8\t\u0091u{\u00ba9\u00946\u00ca\u00c1\u008cZ\u00bav\u0093\u00ebxq\u00d2\u00c6)\u00f6\u00ae\u001b\u00f8\u0089\u00ea\u0082\u0099\u0010+\u00c8\u00fd\u00ea>_\u00ba\u00e1P\u00e5\u00e8\u0006".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 78;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "+\u00bd{V\u0007\u0017\u00d7\u0087\u00d6?}<\u0086d\f\u00f6L\u00ff\u00d0\u00161\u00803Im\u008c\u00f1\u009a\\t\u00e6\u00c1\u00df\u008a\u00d4\u000f\u001fM\n\u0018\u0081\u00a3w\u00fbS\u00cb\u00f6\u001e\u009c\u00b0\u00f6+\u0091B\u008e\u0094\t\u00c8\u00e2\u0083\u0006\u00c1\u00c5_!fT8\u00f4#\u00c4\u00e8\u00da\u00da\u00af%\u00d1\u00e2\u00a4\u00d3\u0012\u009f\u0007\u00f1\u00fcs\tw\u00f2\u00b3N%\u00db";
                        var4_3 = "+\u00bd{V\u0007\u0017\u00d7\u0087\u00d6?}<\u0086d\f\u00f6L\u00ff\u00d0\u00161\u00803Im\u008c\u00f1\u009a\\t\u00e6\u00c1\u00df\u008a\u00d4\u000f\u001fM\n\u0018\u0081\u00a3w\u00fbS\u00cb\u00f6\u001e\u009c\u00b0\u00f6+\u0091B\u008e\u0094\t\u00c8\u00e2\u0083\u0006\u00c1\u00c5_!fT8\u00f4#\u00c4\u00e8\u00da\u00da\u00af%\u00d1\u00e2\u00a4\u00d3\u0012\u009f\u0007\u00f1\u00fcs\tw\u00f2\u00b3N%\u00db".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 1;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 113;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 110;
                                break;
                            }
                            case 4: {
                                v15 = 52;
                                break;
                            }
                            case 5: {
                                v15 = 34;
                                break;
                            }
                            default: {
                                v15 = 71;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCEC8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 154;
                    case 1 -> 238;
                    case 2 -> 103;
                    case 3 -> 138;
                    case 4 -> 167;
                    case 5 -> 1;
                    case 6 -> 215;
                    case 7 -> 3;
                    case 8 -> 144;
                    case 9 -> 228;
                    case 10 -> 78;
                    case 11 -> 91;
                    case 12 -> 112;
                    case 13 -> 79;
                    case 14 -> 93;
                    case 15 -> 249;
                    case 16 -> 12;
                    case 17 -> 20;
                    case 18 -> 231;
                    case 19 -> 197;
                    case 20 -> 115;
                    case 21 -> 180;
                    case 22 -> 62;
                    case 23 -> 193;
                    case 24 -> 162;
                    case 25 -> 195;
                    case 26 -> 135;
                    case 27 -> 172;
                    case 28 -> 89;
                    case 29 -> 203;
                    case 30 -> 211;
                    case 31 -> 71;
                    case 32 -> 17;
                    case 33 -> 222;
                    case 34 -> 168;
                    case 35 -> 109;
                    case 36 -> 131;
                    case 37 -> 218;
                    case 38 -> 99;
                    case 39 -> 189;
                    case 40 -> 46;
                    case 41 -> 173;
                    case 42 -> 122;
                    case 43 -> 129;
                    case 44 -> 26;
                    case 45 -> 34;
                    case 46 -> 57;
                    case 47 -> 174;
                    case 48 -> 31;
                    case 49 -> 213;
                    case 50 -> 208;
                    case 51 -> 233;
                    case 52 -> 59;
                    case 53 -> 80;
                    case 54 -> 98;
                    case 55 -> 83;
                    case 56 -> 165;
                    case 57 -> 252;
                    case 58 -> 65;
                    case 59 -> 148;
                    case 60 -> 36;
                    case 61 -> 246;
                    case 62 -> 157;
                    case 63 -> 179;
                    case 64 -> 187;
                    case 65 -> 58;
                    case 66 -> 113;
                    case 67 -> 188;
                    case 68 -> 43;
                    case 69 -> 198;
                    case 70 -> 16;
                    case 71 -> 123;
                    case 72 -> 214;
                    case 73 -> 10;
                    case 74 -> 132;
                    case 75 -> 9;
                    case 76 -> 28;
                    case 77 -> 232;
                    case 78 -> 166;
                    case 79 -> 127;
                    case 80 -> 223;
                    case 81 -> 184;
                    case 82 -> 186;
                    case 83 -> 41;
                    case 84 -> 53;
                    case 85 -> 207;
                    case 86 -> 237;
                    case 87 -> 139;
                    case 88 -> 160;
                    case 89 -> 60;
                    case 90 -> 136;
                    case 91 -> 128;
                    case 92 -> 35;
                    case 93 -> 55;
                    case 94 -> 219;
                    case 95 -> 42;
                    case 96 -> 87;
                    case 97 -> 235;
                    case 98 -> 119;
                    case 99 -> 75;
                    case 100 -> 199;
                    case 101 -> 201;
                    case 102 -> 126;
                    case 103 -> 143;
                    case 104 -> 158;
                    case 105 -> 221;
                    case 106 -> 171;
                    case 107 -> 202;
                    case 108 -> 2;
                    case 109 -> 141;
                    case 110 -> 77;
                    case 111 -> 8;
                    case 112 -> 140;
                    case 113 -> 63;
                    case 114 -> 116;
                    case 115 -> 95;
                    case 116 -> 73;
                    case 117 -> 169;
                    case 118 -> 175;
                    case 119 -> 102;
                    case 120 -> 25;
                    case 121 -> 216;
                    case 122 -> 159;
                    case 123 -> 54;
                    case 124 -> 104;
                    case 125 -> 24;
                    case 126 -> 0;
                    case 127 -> 164;
                    case 128 -> 247;
                    case 129 -> 254;
                    case 130 -> 69;
                    case 131 -> 44;
                    case 132 -> 110;
                    case 133 -> 118;
                    case 134 -> 217;
                    case 135 -> 96;
                    case 136 -> 245;
                    case 137 -> 170;
                    case 138 -> 242;
                    case 139 -> 38;
                    case 140 -> 51;
                    case 141 -> 107;
                    case 142 -> 121;
                    case 143 -> 134;
                    case 144 -> 177;
                    case 145 -> 70;
                    case 146 -> 153;
                    case 147 -> 176;
                    case 148 -> 227;
                    case 149 -> 239;
                    case 150 -> 84;
                    case 151 -> 52;
                    case 152 -> 147;
                    case 153 -> 40;
                    case 154 -> 22;
                    case 155 -> 94;
                    case 156 -> 18;
                    case 157 -> 14;
                    case 158 -> 240;
                    case 159 -> 182;
                    case 160 -> 178;
                    case 161 -> 6;
                    case 162 -> 204;
                    case 163 -> 220;
                    case 164 -> 253;
                    case 165 -> 106;
                    case 166 -> 15;
                    case 167 -> 114;
                    case 168 -> 244;
                    case 169 -> 190;
                    case 170 -> 124;
                    case 171 -> 250;
                    case 172 -> 47;
                    case 173 -> 21;
                    case 174 -> 183;
                    case 175 -> 155;
                    case 176 -> 11;
                    case 177 -> 82;
                    case 178 -> 185;
                    case 179 -> 27;
                    case 180 -> 86;
                    case 181 -> 243;
                    case 182 -> 105;
                    case 183 -> 210;
                    case 184 -> 241;
                    case 185 -> 191;
                    case 186 -> 145;
                    case 187 -> 49;
                    case 188 -> 196;
                    case 189 -> 142;
                    case 190 -> 137;
                    case 191 -> 30;
                    case 192 -> 133;
                    case 193 -> 88;
                    case 194 -> 125;
                    case 195 -> 48;
                    case 196 -> 209;
                    case 197 -> 74;
                    case 198 -> 163;
                    case 199 -> 5;
                    case 200 -> 251;
                    case 201 -> 50;
                    case 202 -> 229;
                    case 203 -> 81;
                    case 204 -> 39;
                    case 205 -> 92;
                    case 206 -> 146;
                    case 207 -> 248;
                    case 208 -> 206;
                    case 209 -> 45;
                    case 210 -> 85;
                    case 211 -> 181;
                    case 212 -> 224;
                    case 213 -> 100;
                    case 214 -> 149;
                    case 215 -> 29;
                    case 216 -> 56;
                    case 217 -> 19;
                    case 218 -> 67;
                    case 219 -> 97;
                    case 220 -> 101;
                    case 221 -> 32;
                    case 222 -> 33;
                    case 223 -> 61;
                    case 224 -> 192;
                    case 225 -> 68;
                    case 226 -> 225;
                    case 227 -> 230;
                    case 228 -> 64;
                    case 229 -> 236;
                    case 230 -> 23;
                    case 231 -> 37;
                    case 232 -> 226;
                    case 233 -> 72;
                    case 234 -> 194;
                    case 235 -> 151;
                    case 236 -> 108;
                    case 237 -> 152;
                    case 238 -> 111;
                    case 239 -> 76;
                    case 240 -> 13;
                    case 241 -> 130;
                    case 242 -> 205;
                    case 243 -> 156;
                    case 244 -> 212;
                    case 245 -> 255;
                    case 246 -> 120;
                    case 247 -> 7;
                    case 248 -> 4;
                    case 249 -> 234;
                    case 250 -> 200;
                    case 251 -> 117;
                    case 252 -> 66;
                    case 253 -> 90;
                    case 254 -> 150;
                    default -> 161;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 79977860219799L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1274262540 - -((char)-7011), -1274262540 - -((char)-3692), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 77280729104090L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.u();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1382526360 + -17547, -1382526360 - -9190, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 57253151565593L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "''\fk\u0095\u0003Rz\u00f4";
                var4_3 = "''\fk\u0095\u0003Rz\u00f4".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 62;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 2;
                                break;
                            }
                            case 1: {
                                v11 = 39;
                                break;
                            }
                            case 2: {
                                v11 = 121;
                                break;
                            }
                            case 3: {
                                v11 = 119;
                                break;
                            }
                            case 4: {
                                v11 = 127;
                                break;
                            }
                            case 5: {
                                v11 = 104;
                                break;
                            }
                            default: {
                                v11 = 66;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF306) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 195;
                    case 1 -> 107;
                    case 2 -> 197;
                    case 3 -> 232;
                    case 4 -> 221;
                    case 5 -> 68;
                    case 6 -> 82;
                    case 7 -> 18;
                    case 8 -> 90;
                    case 9 -> 24;
                    case 10 -> 194;
                    case 11 -> 201;
                    case 12 -> 219;
                    case 13 -> 175;
                    case 14 -> 173;
                    case 15 -> 20;
                    case 16 -> 164;
                    case 17 -> 239;
                    case 18 -> 30;
                    case 19 -> 4;
                    case 20 -> 105;
                    case 21 -> 200;
                    case 22 -> 204;
                    case 23 -> 15;
                    case 24 -> 81;
                    case 25 -> 85;
                    case 26 -> 242;
                    case 27 -> 165;
                    case 28 -> 33;
                    case 29 -> 202;
                    case 30 -> 240;
                    case 31 -> 236;
                    case 32 -> 41;
                    case 33 -> 6;
                    case 34 -> 238;
                    case 35 -> 55;
                    case 36 -> 153;
                    case 37 -> 233;
                    case 38 -> 118;
                    case 39 -> 216;
                    case 40 -> 134;
                    case 41 -> 83;
                    case 42 -> 142;
                    case 43 -> 40;
                    case 44 -> 223;
                    case 45 -> 108;
                    case 46 -> 149;
                    case 47 -> 249;
                    case 48 -> 22;
                    case 49 -> 84;
                    case 50 -> 158;
                    case 51 -> 218;
                    case 52 -> 123;
                    case 53 -> 198;
                    case 54 -> 174;
                    case 55 -> 138;
                    case 56 -> 39;
                    case 57 -> 251;
                    case 58 -> 169;
                    case 59 -> 66;
                    case 60 -> 243;
                    case 61 -> 154;
                    case 62 -> 191;
                    case 63 -> 25;
                    case 64 -> 93;
                    case 65 -> 225;
                    case 66 -> 27;
                    case 67 -> 166;
                    case 68 -> 0;
                    case 69 -> 53;
                    case 70 -> 37;
                    case 71 -> 246;
                    case 72 -> 101;
                    case 73 -> 211;
                    case 74 -> 135;
                    case 75 -> 57;
                    case 76 -> 51;
                    case 77 -> 62;
                    case 78 -> 59;
                    case 79 -> 183;
                    case 80 -> 210;
                    case 81 -> 26;
                    case 82 -> 254;
                    case 83 -> 121;
                    case 84 -> 150;
                    case 85 -> 10;
                    case 86 -> 132;
                    case 87 -> 180;
                    case 88 -> 42;
                    case 89 -> 147;
                    case 90 -> 128;
                    case 91 -> 224;
                    case 92 -> 212;
                    case 93 -> 161;
                    case 94 -> 67;
                    case 95 -> 73;
                    case 96 -> 109;
                    case 97 -> 9;
                    case 98 -> 193;
                    case 99 -> 160;
                    case 100 -> 133;
                    case 101 -> 1;
                    case 102 -> 170;
                    case 103 -> 244;
                    case 104 -> 231;
                    case 105 -> 131;
                    case 106 -> 52;
                    case 107 -> 102;
                    case 108 -> 152;
                    case 109 -> 111;
                    case 110 -> 119;
                    case 111 -> 61;
                    case 112 -> 2;
                    case 113 -> 136;
                    case 114 -> 178;
                    case 115 -> 16;
                    case 116 -> 71;
                    case 117 -> 48;
                    case 118 -> 185;
                    case 119 -> 17;
                    case 120 -> 129;
                    case 121 -> 137;
                    case 122 -> 79;
                    case 123 -> 168;
                    case 124 -> 248;
                    case 125 -> 205;
                    case 126 -> 8;
                    case 127 -> 19;
                    case 128 -> 47;
                    case 129 -> 46;
                    case 130 -> 206;
                    case 131 -> 214;
                    case 132 -> 167;
                    case 133 -> 245;
                    case 134 -> 103;
                    case 135 -> 199;
                    case 136 -> 222;
                    case 137 -> 28;
                    case 138 -> 63;
                    case 139 -> 226;
                    case 140 -> 209;
                    case 141 -> 89;
                    case 142 -> 106;
                    case 143 -> 78;
                    case 144 -> 113;
                    case 145 -> 130;
                    case 146 -> 54;
                    case 147 -> 114;
                    case 148 -> 163;
                    case 149 -> 237;
                    case 150 -> 148;
                    case 151 -> 23;
                    case 152 -> 116;
                    case 153 -> 49;
                    case 154 -> 179;
                    case 155 -> 125;
                    case 156 -> 13;
                    case 157 -> 91;
                    case 158 -> 60;
                    case 159 -> 213;
                    case 160 -> 120;
                    case 161 -> 252;
                    case 162 -> 11;
                    case 163 -> 110;
                    case 164 -> 157;
                    case 165 -> 151;
                    case 166 -> 159;
                    case 167 -> 230;
                    case 168 -> 56;
                    case 169 -> 229;
                    case 170 -> 38;
                    case 171 -> 99;
                    case 172 -> 97;
                    case 173 -> 208;
                    case 174 -> 122;
                    case 175 -> 96;
                    case 176 -> 98;
                    case 177 -> 141;
                    case 178 -> 215;
                    case 179 -> 143;
                    case 180 -> 3;
                    case 181 -> 35;
                    case 182 -> 124;
                    case 183 -> 65;
                    case 184 -> 100;
                    case 185 -> 36;
                    case 186 -> 255;
                    case 187 -> 187;
                    case 188 -> 190;
                    case 189 -> 70;
                    case 190 -> 75;
                    case 191 -> 241;
                    case 192 -> 186;
                    case 193 -> 92;
                    case 194 -> 74;
                    case 195 -> 207;
                    case 196 -> 45;
                    case 197 -> 5;
                    case 198 -> 182;
                    case 199 -> 112;
                    case 200 -> 156;
                    case 201 -> 29;
                    case 202 -> 69;
                    case 203 -> 139;
                    case 204 -> 250;
                    case 205 -> 72;
                    case 206 -> 162;
                    case 207 -> 253;
                    case 208 -> 21;
                    case 209 -> 117;
                    case 210 -> 188;
                    case 211 -> 31;
                    case 212 -> 86;
                    case 213 -> 94;
                    case 214 -> 234;
                    case 215 -> 172;
                    case 216 -> 64;
                    case 217 -> 228;
                    case 218 -> 76;
                    case 219 -> 140;
                    case 220 -> 87;
                    case 221 -> 176;
                    case 222 -> 43;
                    case 223 -> 144;
                    case 224 -> 32;
                    case 225 -> 247;
                    case 226 -> 220;
                    case 227 -> 177;
                    case 228 -> 115;
                    case 229 -> 227;
                    case 230 -> 95;
                    case 231 -> 7;
                    case 232 -> 44;
                    case 233 -> 203;
                    case 234 -> 50;
                    case 235 -> 235;
                    case 236 -> 126;
                    case 237 -> 88;
                    case 238 -> 181;
                    case 239 -> 184;
                    case 240 -> 77;
                    case 241 -> 196;
                    case 242 -> 12;
                    case 243 -> 189;
                    case 244 -> 192;
                    case 245 -> 34;
                    case 246 -> 155;
                    case 247 -> 58;
                    case 248 -> 217;
                    case 249 -> 171;
                    case 250 -> 145;
                    case 251 -> 14;
                    case 252 -> 146;
                    case 253 -> 127;
                    case 254 -> 104;
                    default -> 80;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

