/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J\u0015\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0015\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\f\u001a\u00020\tH\u0016J\u0015\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\f\u001a\u00020\tH\u0016J\u001f\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bH\u0016J\u0015\u0010\u0013\u001a\u000f\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0015\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0018H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "", "<init>", "()V", "getMultipleFileMergeDescription", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMergeWindowTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "file", "getLeftPanelTitle", "getCenterPanelTitle", "getRightPanelTitle", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getMultipleFileDialogTitle", "getColumnNames", "", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "getTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "DiffEditorTitleCustomizerList", "intellij.platform.vcs"})
@ApiStatus.OverrideOnly
public class MergeDialogCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DiffEditorTitleCustomizerList DEFAULT_CUSTOMIZER_LIST = new DiffEditorTitleCustomizerList(null, null, null);

    @RequiresBackgroundThread
    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return "";
    }

    @NotNull
    public String getMergeWindowTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new Object[]{FileUtil.toSystemDependentName((String)file.getPresentableUrl())};
        String string = VcsBundle.message((String)"multiple.file.merge.request.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getLeftPanelTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getCenterPanelTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (revisionNumber != null) {
            Object[] objectArray = new Object[]{revisionNumber.asString()};
            String string2 = DiffBundle.message((String)"merge.version.title.their.with.revision", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    @NotNull
    public String getMultipleFileDialogTitle() {
        String string = VcsBundle.message((String)"multiple.file.merge.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public List<String> getColumnNames() {
        return null;
    }

    @NotNull
    public DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DEFAULT_CUSTOMIZER_LIST;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$Companion;", "", "<init>", "()V", "DEFAULT_CUSTOMIZER_LIST", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "getDEFAULT_CUSTOMIZER_LIST", "()Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "intellij.platform.vcs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiffEditorTitleCustomizerList getDEFAULT_CUSTOMIZER_LIST() {
            return DEFAULT_CUSTOMIZER_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "", "leftTitleCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "centerTitleCustomizer", "rightTitleCustomizer", "<init>", "(Lcom/intellij/diff/DiffEditorTitleCustomizer;Lcom/intellij/diff/DiffEditorTitleCustomizer;Lcom/intellij/diff/DiffEditorTitleCustomizer;)V", "getLeftTitleCustomizer", "()Lcom/intellij/diff/DiffEditorTitleCustomizer;", "getCenterTitleCustomizer", "getRightTitleCustomizer", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs"})
    public static final class DiffEditorTitleCustomizerList {
        @Nullable
        private final DiffEditorTitleCustomizer leftTitleCustomizer;
        @Nullable
        private final DiffEditorTitleCustomizer centerTitleCustomizer;
        @Nullable
        private final DiffEditorTitleCustomizer rightTitleCustomizer;

        public DiffEditorTitleCustomizerList(@Nullable DiffEditorTitleCustomizer leftTitleCustomizer, @Nullable DiffEditorTitleCustomizer centerTitleCustomizer, @Nullable DiffEditorTitleCustomizer rightTitleCustomizer) {
            this.leftTitleCustomizer = leftTitleCustomizer;
            this.centerTitleCustomizer = centerTitleCustomizer;
            this.rightTitleCustomizer = rightTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer getLeftTitleCustomizer() {
            return this.leftTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer getCenterTitleCustomizer() {
            return this.centerTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer getRightTitleCustomizer() {
            return this.rightTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component1() {
            return this.leftTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component2() {
            return this.centerTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component3() {
            return this.rightTitleCustomizer;
        }

        @NotNull
        public final DiffEditorTitleCustomizerList copy(@Nullable DiffEditorTitleCustomizer leftTitleCustomizer, @Nullable DiffEditorTitleCustomizer centerTitleCustomizer, @Nullable DiffEditorTitleCustomizer rightTitleCustomizer) {
            return new DiffEditorTitleCustomizerList(leftTitleCustomizer, centerTitleCustomizer, rightTitleCustomizer);
        }

        public static /* synthetic */ DiffEditorTitleCustomizerList copy$default(DiffEditorTitleCustomizerList diffEditorTitleCustomizerList, DiffEditorTitleCustomizer diffEditorTitleCustomizer, DiffEditorTitleCustomizer diffEditorTitleCustomizer2, DiffEditorTitleCustomizer diffEditorTitleCustomizer3, int n, Object object) {
            if ((n & 1) != 0) {
                diffEditorTitleCustomizer = diffEditorTitleCustomizerList.leftTitleCustomizer;
            }
            if ((n & 2) != 0) {
                diffEditorTitleCustomizer2 = diffEditorTitleCustomizerList.centerTitleCustomizer;
            }
            if ((n & 4) != 0) {
                diffEditorTitleCustomizer3 = diffEditorTitleCustomizerList.rightTitleCustomizer;
            }
            return diffEditorTitleCustomizerList.copy(diffEditorTitleCustomizer, diffEditorTitleCustomizer2, diffEditorTitleCustomizer3);
        }

        @NotNull
        public String toString() {
            return "DiffEditorTitleCustomizerList(leftTitleCustomizer=" + this.leftTitleCustomizer + ", centerTitleCustomizer=" + this.centerTitleCustomizer + ", rightTitleCustomizer=" + this.rightTitleCustomizer + ")";
        }

        public int hashCode() {
            int result = this.leftTitleCustomizer == null ? 0 : this.leftTitleCustomizer.hashCode();
            result = result * 31 + (this.centerTitleCustomizer == null ? 0 : this.centerTitleCustomizer.hashCode());
            result = result * 31 + (this.rightTitleCustomizer == null ? 0 : this.rightTitleCustomizer.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiffEditorTitleCustomizerList)) {
                return false;
            }
            DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = (DiffEditorTitleCustomizerList)other;
            if (!Intrinsics.areEqual((Object)this.leftTitleCustomizer, (Object)diffEditorTitleCustomizerList.leftTitleCustomizer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.centerTitleCustomizer, (Object)diffEditorTitleCustomizerList.centerTitleCustomizer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rightTitleCustomizer, (Object)diffEditorTitleCustomizerList.rightTitleCustomizer);
        }
    }
}

