/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism.plain;

import zmq.Msg;
import zmq.Options;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;

public class PlainClientMechanism
extends Mechanism {
    private State state = State.SENDING_HELLO;

    public PlainClientMechanism(SessionBase session, Options options) {
        super(session, null, options);
    }

    @Override
    public int nextHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state.ordinal()) {
            case 0: {
                rc = this.produceHello(msg);
                if (rc != 0) break;
                this.state = State.WAITING_FOR_WELCOME;
                break;
            }
            case 2: {
                rc = this.produceInitiate(msg);
                if (rc != 0) break;
                this.state = State.WAITING_FOR_READY;
                break;
            }
            default: {
                rc = 35;
            }
        }
        return rc;
    }

    @Override
    public int processHandshakeCommand(Msg msg) {
        int rc;
        int dataSize = msg.size();
        if (dataSize >= 8 && this.compare(msg, "WELCOME", true)) {
            rc = this.processWelcome(msg);
        } else if (dataSize >= 6 && this.compare(msg, "READY", true)) {
            rc = this.processReady(msg);
        } else if (dataSize >= 6 && this.compare(msg, "ERROR", true)) {
            rc = this.processError(msg);
        } else {
            System.out.println("PLAIN Client I: invalid handshake command");
            rc = 156384820;
        }
        return rc;
    }

    @Override
    public Mechanism.Status status() {
        if (this.state == State.READY) {
            return Mechanism.Status.READY;
        }
        if (this.state == State.ERROR_COMMAND_RECEIVED) {
            return Mechanism.Status.ERROR;
        }
        return Mechanism.Status.HANDSHAKING;
    }

    @Override
    public int zapMsgAvailable() {
        return 0;
    }

    private int produceHello(Msg msg) {
        String plainUsername = this.options.plainUsername;
        assert (plainUsername.length() < 256);
        String plainPassword = this.options.plainPassword;
        assert (plainPassword.length() < 256);
        msg.putShortString("HELLO");
        msg.putShortString(plainUsername);
        msg.putShortString(plainPassword);
        return 0;
    }

    private int processWelcome(Msg msg) {
        if (this.state != State.WAITING_FOR_WELCOME) {
            return 156384820;
        }
        if (msg.size() != 8) {
            return 156384820;
        }
        this.state = State.SENDING_INITIATE;
        return 0;
    }

    private int produceInitiate(Msg msg) {
        msg.putShortString("INITIATE");
        String socketType = this.socketType();
        this.addProperty(msg, "Socket-Type", socketType);
        if (this.options.type == 3 || this.options.type == 5 || this.options.type == 6) {
            this.addProperty(msg, "Identity", this.options.identity);
        }
        return 0;
    }

    private int processReady(Msg msg) {
        if (this.state != State.WAITING_FOR_READY) {
            return 156384820;
        }
        int rc = this.parseMetadata(msg, 6, false);
        if (rc == 0) {
            this.state = State.READY;
        }
        return rc;
    }

    private int processError(Msg msg) {
        if (this.state != State.WAITING_FOR_WELCOME && this.state != State.WAITING_FOR_READY) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        this.state = State.ERROR_COMMAND_RECEIVED;
        return this.parseErrorMessage(msg);
    }

    private static enum State {
        SENDING_HELLO,
        WAITING_FOR_WELCOME,
        SENDING_INITIATE,
        WAITING_FOR_READY,
        ERROR_COMMAND_RECEIVED,
        READY;

    }
}

