/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentSymbol;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspSymbolKindCustomizer;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.navigation.LspNavigationUtilKt;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "psiFile", "Lcom/intellij/psi/PsiFile;", "symbol", "Lorg/eclipse/lsp4j/DocumentSymbol;", "LspDocumentSymbolTreeElement", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/psi/PsiFile;Lorg/eclipse/lsp4j/DocumentSymbol;)V", "getValue", "getChildren", "", "()[Lcom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspStructureViewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspStructureViewFactory.kt\ncom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,179:1\n1563#2:180\n1634#2,3:181\n37#3,2:184\n*S KotlinDebug\n*F\n+ 1 LspStructureViewFactory.kt\ncom/intellij/platform/lsp/impl/documentSymbol/LspDocumentSymbolTreeElement\n*L\n149#1:180\n149#1:181,3\n149#1:184,2\n*E\n"})
public final class LspDocumentSymbolTreeElement
implements StructureViewTreeElement {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final DocumentSymbol symbol;

    public LspDocumentSymbolTreeElement(@NotNull LspServerImpl lspServer, @NotNull PsiFile psiFile, @NotNull DocumentSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.lspServer = lspServer;
        this.psiFile = psiFile;
        this.symbol = symbol;
    }

    @NotNull
    public DocumentSymbol getValue() {
        return this.symbol;
    }

    @NotNull
    public LspDocumentSymbolTreeElement[] getChildren() {
        LspDocumentSymbolTreeElement[] lspDocumentSymbolTreeElementArray;
        block4: {
            block3: {
                lspDocumentSymbolTreeElementArray = this.symbol.getChildren();
                if (lspDocumentSymbolTreeElementArray == null) break block3;
                Iterable iterable = (Iterable)lspDocumentSymbolTreeElementArray;
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl3 = false;
                for (Object t3 : iterable2) {
                    DocumentSymbol documentSymbol = (DocumentSymbol)t3;
                    Collection collection2 = collection;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)documentSymbol);
                    collection2.add(new LspDocumentSymbolTreeElement(this.lspServer, this.psiFile, documentSymbol));
                }
                Collection collection3 = (List)collection;
                boolean bl5 = false;
                collection = collection3;
                lspDocumentSymbolTreeElementArray = collection.toArray(new LspDocumentSymbolTreeElement[0]);
                if (lspDocumentSymbolTreeElementArray != null) break block4;
            }
            lspDocumentSymbolTreeElementArray = new LspDocumentSymbolTreeElement[]{};
        }
        return lspDocumentSymbolTreeElementArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)new ColoredItemPresentation(this){
            final /* synthetic */ LspDocumentSymbolTreeElement this$0;
            {
                this.this$0 = $receiver;
            }

            public String getPresentableText() {
                return LspDocumentSymbolTreeElement.access$getSymbol$p(this.this$0).getName();
            }

            public String getLocationString() {
                return LspDocumentSymbolTreeElement.access$getSymbol$p(this.this$0).getDetail();
            }

            public Icon getIcon(boolean unused) {
                LspSymbolKindCustomizer lspSymbolKindCustomizer = LspDocumentSymbolTreeElement.access$getLspServer$p(this.this$0).getDescriptor().getLspCustomization().getSymbolKindCustomizer();
                SymbolKind symbolKind = LspDocumentSymbolTreeElement.access$getSymbol$p(this.this$0).getKind();
                Intrinsics.checkNotNullExpressionValue((Object)symbolKind, (String)"getKind(...)");
                return lspSymbolKindCustomizer.getIcon(symbolKind);
            }

            public TextAttributesKey getTextAttributesKey() {
                List list = LspDocumentSymbolTreeElement.access$getSymbol$p(this.this$0).getTags();
                boolean bl2 = (list != null ? list.contains(SymbolTag.Deprecated) : false) || LspDocumentSymbolTreeElement.access$getSymbol$p(this.this$0).getDeprecated() != false;
                return bl2 ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
            }
        };
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile = this.psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Position position = this.symbol.getSelectionRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        LspNavigationUtilKt.navigateToLspPosition(virtualFile, project, position, requestFocus);
    }

    public static final /* synthetic */ DocumentSymbol access$getSymbol$p(LspDocumentSymbolTreeElement $this) {
        return $this.symbol;
    }

    public static final /* synthetic */ LspServerImpl access$getLspServer$p(LspDocumentSymbolTreeElement $this) {
        return $this.lspServer;
    }
}

